import { Component, Inject, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { UsermanagementService } from '../usermanagement.service';

@Component({
  selector: 'app-suspended-services',
  templateUrl: './suspended-services.component.html',
  styleUrls: ['./suspended-services.component.css']
})
export class SuspendedServicesComponent implements OnInit {
  featureServiceData: any = [];
  idaccount: any ='';
  accountService: any = [];
  allServiceData: any = [];
  responseMessage: any = "";
  errMessage: any = "";
  Allchecked: boolean = false;
  checkcount: number = 0;
  mainForm: any = [];
  pushed: boolean = false;

  constructor(public data:UsermanagementService,@Inject(MAT_DIALOG_DATA) public ddata: any,public fb: FormBuilder, public dialogRef: MatDialogRef<SuspendedServicesComponent>) { }

  ngOnInit(): void {
    this.featureServiceData = this.ddata.serviceData;
    this.idaccount = this.ddata.idaccount;
    this.data.getfeatureServiceById(this.idaccount).subscribe(res => {
      this.accountService = res.data;
      if(this.accountService.length > 0){
        this.featureServiceData.forEach(element1 => {
          this.accountService.forEach(element2 => {
            if(element1.fs_id == element2.fs_id){
              element1['idaccount'] = element2.idaccount;
              element1['as_status'] = element2.as_status; 
              if(element1.as_status == 1){
                this.checkcount = this.checkcount+1;
              }
            }
          });
        });
        if(this.checkcount == this.featureServiceData.length){
          this.Allchecked = true;
        }
      }
      else{
        this.featureServiceData.forEach((element:any,index:any) => {
          element['idaccount'] = this.idaccount;
          element['as_status'] = 0;
        });
      }
    });
  }
 
  onClose() {
    this.dialogRef.close(-1);
  }

   onSelectAllService(event:any){
    this.mainForm = [];
    this.featureServiceData.forEach((element:any,index:any) => {
      if(event.target.checked == true){
        if(element.as_status == 0){
          element.as_status = 1;
          let payLoad = {
            as_status: element.as_status,
            fs_id: element.fs_id,
            idaccount : element.idaccount
          }
          this.mainForm.push(payLoad);
        }
       
        if(index == this.featureServiceData.length-1){
          this.Allchecked = true;
        }
      }
      else{
        if(element.as_status == 1){
          element.as_status = 0;
          let payLoad = {
            as_status: element.as_status,
            fs_id: element.fs_id,
            idaccount : element.idaccount
          }
          this.mainForm.push(payLoad);
        }
        if(index == this.featureServiceData.length-1){
          this.Allchecked = false;
        }
      }
    });
  }

  onSelectService(event:any , fs_id:any){ 
    this.checkcount = 0;
    this.pushed = false;
    this.accountService.forEach((element:any) => {
      if(element.as_status == 1){
        this.checkcount = this.checkcount+1;
      }
      if(fs_id == element.fs_id){
        if(event.target.checked == true){
          if(this.mainForm.length === 0){
            element.as_status = 1;
            this.mainForm.push(element);
          }
          else{
            this.mainForm.forEach((ele:any,index:any) => {
              if(ele.fs_id == fs_id){
                this.mainForm.splice(index, 1);
              }
              else{
                if(this.pushed == false){
                  element.as_status = 1;
                  this.mainForm.push(element);
                  this.pushed = true;
                }  
              }
            });
          }
          this.checkcount = this.checkcount+1;
        }
        else{
          if(this.mainForm.length === 0){
            element.as_status = 0;
            this.mainForm.push(element);
          }
          else{
            this.mainForm.forEach((ele:any,index:any) => {
              if(ele.fs_id == fs_id){
                this.mainForm.splice(index, 1);
              }
              else{
                if(this.pushed == false){
                  element.as_status = 0;
                  this.mainForm.push(element);
                  this.pushed = true;
                }  
              }
            });
          }
          this.Allchecked = false;
          this.checkcount = this.checkcount-1;
        }
      } 
    });
    if(this.checkcount == this.featureServiceData.length){
      this.Allchecked = true;
    }
  }

  submitSuspend(){
    this.data.updateSuspendedService(this.mainForm).subscribe(res => {
      if (res.status == 200) {
        this.responseMessage = res.message; 
        this.mainForm = [];
        this.dialogRef.close({status:res.status,message:res.message});
      }
      else{
        this.mainForm = [];
        this.errMessage = res.message;
        this.dialogRef.close({status:res.status,message:res.message});
      }
    });
  }
}
