import { FormBuilder, FormGroup, Validators } from "@angular/forms";

// inbound : user
export interface usermanagement {
    iduser: number,
    idaccount: number,
    first_name: string,
    last_name: string,
    email: string,
    user_name: string
    contact_number: string,
    password: string,
    type: number,
    tariff1: number,
    tariff2: number,
    profile_pic: string,
    status: string,
    service: number,
    credit_limit: number,
    isEmailVerify: boolean;
    isMobileVerify: boolean;
    isAddress: boolean;
    customerType:string;
    address1:string;
    address2:string;
    city:string;
    state:string;
    postal_code:any;
    country:string;
    title:string;
    businessName:string;
    ein:any;
    website:string;
    groupExmpt_number:any;
    reseller_id:any;
}

export interface HTTPusermanagement {
    iduser: number,
    idaccount: number,
    first_name: string,
    last_name: string,
    email: string,
    user_name: string
    contact_number: string,
    password: string,
    type: number,
    tariff1: number,
    tariff2: number,
    profile_pic: string,
    status: string,
    service: number,
    credit_limit: number,
    isEmailVerify: boolean;
    isMobileVerify: boolean;
    isAddress: boolean;
    customerType:string;
    address1:string;
    address2:string;
    city:string;
    state:string;
    postal_code:any;
    country:string;
    title:string;
    businessName:string;
    ein:any;
    website:string;
    groupExmpt_number:any;
    reseller_id:any;
}

export class usermanagementForm implements HTTPusermanagement {
    iduser: number;
    idaccount: number;
    first_name: string;
    last_name: string;
    email: string;
    user_name: string
    contact_number: string;
    password: string;
    type: number;
    tariff1: number;
    tariff2: number;
    profile_pic: string;
    status: string;
    service: number;
    credit_limit: number;
    isEmailVerify: boolean;
    isMobileVerify: boolean;
    isAddress: boolean;
    customerType:string;
    address1:string;
    address2:string;
    city:string;
    state:string;
    postal_code:any;
    country:string;
    title:string;
    businessName:string;
    ein:any;
    website:string;
    groupExmpt_number:any;
    reseller_id:any;

    constructor(data: usermanagement) {
        if (data == null) { 
            this.idaccount = -1;
            this.iduser = -1;
            this.first_name = "";
            this.last_name = "";
            this.email = "";
            this.user_name = "";
            this.contact_number = "";
            this.password = "";
            this.type = 0;
            this.profile_pic = "";
            this.tariff1 = -1;
            this.tariff2 = -1;
            this.status = "";
            this.service = -1;
            this.credit_limit = 0;
            this.isEmailVerify = false;
            this.isMobileVerify = false;
            this.isAddress = false;
            this.customerType = "";
            this.address1 = "";
            this.address2 = "";
            this.city = "";
            this.state = "";
            this.postal_code = "";
            this.country = "";
            this.title = "";
            this.businessName = "";
            this.ein = "";
            this.website = "";
            this.groupExmpt_number = "";
            this.reseller_id="";
        }
        else {
            this.idaccount = data.idaccount;
            this.iduser = data.iduser;
            this.first_name = data.first_name;
            this.last_name = data.last_name;
            this.email = data.email;
            this.user_name = data.user_name;
            this.contact_number = data.contact_number;
            this.password = data.password;
            this.type = data.type;
            this.profile_pic = data.profile_pic;
            this.tariff1 = data.tariff1;
            this.tariff2 = data.tariff2;
            this.status = data.status;
            this.service = data.service;
            this.credit_limit = data.credit_limit;
            this.isEmailVerify = data.isEmailVerify;
            this.isMobileVerify = data.isMobileVerify;
            this.isAddress = data.isAddress;
            this.customerType = data.customerType;
            this.address1 = data.address1;
            this.address2 = data.address2;
            this.city = data.city;
            this.state = data.state;
            this.postal_code = data.postal_code;
            this.country = data.country;
            this.title = data.title;
            this.businessName = data.businessName;
            this.ein = data.ein;
            this.website = data.website;
            this.groupExmpt_number = data.groupExmpt_number;
            this.reseller_id = data.reseller_id
        }
    }

    public makeform(fb: FormBuilder): FormGroup {
        const urlRegex = /^(?:http(s)?:\/\/)?[\w.-]+(?:\.[\w\.-]+)+[\w\-\._~:/?#[\]@!\$&'\(\)\*\+,;=.]+$/;
        return fb.group({
            first_name: [this.first_name, [Validators.required,Validators.pattern("^[a-zA-Z][a-zA-Z '-]*$")]],
            last_name: [this.last_name, [Validators.required,Validators.pattern("^[a-zA-Z][a-zA-Z '-]*$")]],
            email: [this.email, [Validators.required,
            Validators.pattern("^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}$")]],
            user_name: [this.user_name, [Validators.required, 
                Validators.pattern(/^([A-z0-9!@#$%^&*().,<>{}[\]<>?_`~=+\-|;:\'\"\/])*[^\s]\1*$/)]],
            contact_number: [this.contact_number, [Validators.required]],
            password: [this.password, [Validators.required, Validators.minLength(8)]],
            type: [this.type],
            profile_pic: [this.profile_pic],
            tariff1: [this.tariff1],
            tariff2: [this.tariff2],
            status: [this.status],
            service: [this.service],
            credit_limit: [this.credit_limit,[Validators.required, Validators.max(500000)]],
            isEmailVerify: [this.isEmailVerify],
            isMobileVerify: [this.isMobileVerify],
            isAddress: [this.isAddress],
            customerType : [this.customerType],
            address1 : [this.address1],
            address2 : [this.address2],
            city : [this.city],
            state : [this.state],
            postal_code : [this.postal_code],
            country : [this.country],
            title : [this.title],
            businessName : [this.businessName],
            ein : [this.ein],
            website : [this.website, [Validators.pattern(urlRegex)]],
            groupExmpt_number : [this.groupExmpt_number],
            reseller_id : [this.reseller_id]
        });
    }

    public saveForm(fg: FormGroup): boolean {
        if (fg.valid) {
            this.first_name = fg.get("first_name").value;
            this.last_name = fg.get("last_name").value;
            this.email = fg.get("email").value;
            this.user_name = fg.get("user_name").value;
            this.contact_number = fg.get("contact_number").value;
            this.password = fg.get("password").value;
            this.type = fg.get("type").value;
            this.profile_pic = fg.get("profile_pic").value;
            this.tariff1 = fg.get("tariff1").value;
            this.tariff2 = fg.get("tariff2").value;
            this.status = fg.get("status").value;
            this.service = fg.get("service").value;
            this.credit_limit = fg.get("credit_limit").value,
            this.isEmailVerify = fg.get("isEmailVerify").value;
            this.isMobileVerify = fg.get("isMobileVerify").value;
            this.isAddress = fg.get("isAddress").value;
            this.customerType = fg.get("customerType").value;
            this.address1 = fg.get("address1").value;
            this.address2 = fg.get("address2").value;
            this.city = fg.get("city").value;
            this.state = fg.get("state").value;
            this.postal_code = fg.get("postal_code").value;
            this.country = fg.get("country").value;
            this.title = fg.get("title").value;
            this.businessName = fg.get("businessName").value;
            this.ein = fg.get("ein").value;;
            this.website = fg.get("website").value;
            this.groupExmpt_number = fg.get("groupExmpt_number").value;
            this.reseller_id = fg.get("reseller_id").value;
            return true;
        }
        else {
            return false;
        }
    }
}
// inbound : supplier
export interface supplieruser {
    first_name: string,
    last_name: string,
    email: string,
    user_name: string
    contact_number: string,
    password: string,
    type: string,
    tariff1: number,
    tariff2: number,
    status: string,
    service: number,
}

export interface HTTPsupplieruser {
    first_name: string,
    last_name: string,
    email: string,
    user_name: string
    contact_number: string,
    password: string,
    type: string,
    tariff1: number,
    tariff2: number,
    status: string,
    service: number
}

export class supplieruserForm implements HTTPsupplieruser {
    first_name: string;
    last_name: string;
    email: string;
    user_name: string
    contact_number: string;
    password: string;
    type: string;
    tariff1: number;
    tariff2: number;
    status: string;
    service: number;

    constructor(data: supplieruser) {
        if (data == null) {
            this.first_name = "";
            this.last_name = "";
            this.email = "";
            this.user_name = "";
            this.contact_number = "";
            this.password = "";
            this.type = "";
            this.tariff1 = -1;
            this.tariff2 = -1;
            this.status = "";
            this.service = -1;
        }
        else {
            this.first_name = data.first_name;
            this.last_name = data.last_name;
            this.email = data.email;
            this.user_name = data.user_name;
            this.contact_number = data.contact_number;
            this.password = data.password;
            this.type = data.type;
            this.tariff1 = data.tariff1;
            this.tariff2 = data.tariff2;
            this.status = data.status;
            this.service = data.service;
        }
    }

    public makeform(fb: FormBuilder): FormGroup {
        return fb.group({
            first_name: [this.first_name, [Validators.required, Validators.pattern("^[a-zA-Z][a-zA-Z '-]*$")]],
            last_name: [this.last_name, [Validators.required, Validators.pattern("^[a-zA-Z][a-zA-Z '-]*$")]],
            email: [this.email, [Validators.required]],
            user_name: [this.user_name, [Validators.required, Validators.pattern(/^([A-z0-9!@#$%^&*().,<>{}[\]<>?_`~=+\-|;:\'\"\/])*[^\s]\1*$/)]],
            contact_number: [this.contact_number, [Validators.required, Validators.minLength(7), Validators.maxLength(8)]],
            password: [this.password, [Validators.required, Validators.minLength(5)]],
            //type:[this.type],
            type: 3,
            tariff1: [],
            tariff2: [],
            status: [],
            service: []
        });
    }

    public saveForm(fg: FormGroup): boolean {
        if (fg.valid) {
            this.first_name = fg.get("first_name").value;
            this.last_name = fg.get("last_name").value;
            this.email = fg.get("email").value;
            this.user_name = fg.get("user_name").value;
            this.contact_number = fg.get("contact_number").value;
            this.password = fg.get("password").value;
            this.type = fg.get("type").value;
            this.tariff1 = fg.get("tariff1").value,
                this.tariff2 = fg.get("tariff2").value,
                this.status = fg.get("status").value,
                this.service = fg.get("service").value
            return true;
        }
        else {
            return false;
        }
    }
}


// supplier form
export interface supplier {
    first_name: string,
    last_name: string,
    phone: string,
    user_name: string,
    password: string,
    status: string
}

export interface HTTPsupplier {
    first_name: string,
    last_name: string,
    phone: string,
    user_name: string,
    password: string,
    status: string
}

export class supplierForm implements HTTPsupplier {
    first_name: string;
    last_name: string;
    phone: string;
    user_name: string;
    password: string;
    status: string;

    constructor(data: supplier) {
        if (data == null) {
            this.first_name = "";
            this.last_name = "";
            this.phone = "";
            this.user_name = "";
            this.password = "";
            this.status = "";
        }
        else {
            this.first_name = data.first_name;
            this.last_name = data.last_name;
            this.phone = data.phone;
            this.user_name = data.user_name;
            this.password = data.password;
            this.status = data.status;
        }
    }

    public makeform(fb: FormBuilder): FormGroup {
        return fb.group({
            first_name: [this.first_name, Validators.required],
            last_name: [this.last_name, Validators.required],
            phone: [this.phone, Validators.pattern(new RegExp("[0-9 ]{12}"))],
            user_name: [this.user_name, Validators.required],
            password: [this.password, Validators.required],
            status: [this.status]

        });
    }

    public saveForm(fg: FormGroup): boolean {
        if (fg.valid) {
            this.password = fg.get("password").value;
            this.last_name = fg.get("last_name").value;
            this.phone = fg.get("phone").value;
            this.user_name = fg.get("user_name").value;
            this.password = fg.get("password").value;
            this.status = fg.get("status").value;
            return true;
        }
        else {
            return false;
        }
    }
}

// DID form
export interface didupload {
    did: string,

}

export interface HTTPdidupload {
    did: string,

}

export class didForm implements HTTPdidupload {
    did: string;

    constructor(data: didupload) {
        if (data == null) {
            this.did = "";

        }
        else {
            this.did = data.did;

        }
    }

    public makeform(fb: FormBuilder): FormGroup {
        return fb.group({
            did: [this.did, [Validators.required]],
        });
    }

    public saveForm(fg: FormGroup): boolean {
        if (fg.valid) {
            this.did = fg.get("did").value;

            return true;
        }
        else {
            return false;
        }
    }
}



// itegratedsolutions
export interface itegratedsolutions {
    api_key: string,
    api_secret: string,
    account_id: string,
    token_generate: string,
}

export interface HTTPitegratedsolutions {
    api_key: string,
    api_secret: string,
    account_id: string,
    token_generate: string,

}

export class intgratedsolutionsForm implements HTTPitegratedsolutions {
    api_key: string;
    api_secret: string;
    account_id: string;
    token_generate: string;


    constructor(data: itegratedsolutions) {
        if (data == null) {
            this.api_key = "";
            this.api_secret = "";
            this.account_id = "";
            this.token_generate = "";
        }
        else {
            this.api_key = data.api_key;
            this.api_secret = data.api_secret;
            this.account_id = data.account_id;
            this.token_generate = data.token_generate;
        }
    }

    public makeform(fb: FormBuilder): FormGroup {
        return fb.group({
            api_key: [this.api_key, [Validators.required]],
            api_secret: [this.api_secret, [Validators.required]],
            account_id: [this.account_id, [Validators.required]],
            token_generate: [this.token_generate,],

        });
    }

    public saveForm(fg: FormGroup): boolean {
        if (fg.valid) {
            this.api_key = fg.get("api_key").value;
            this.api_secret = fg.get("api_secret").value;
            this.account_id = fg.get("account_id").value;
            this.token_generate = fg.get("token_generate").value;

            return true;
        }
        else {
            return false;
        }
    }
}






// inbound : preference
export interface preference {
    preference1: string,
    preference2: string,
    preference3: string,
    preference4: string,
    // preference5:string,
}

export interface HTTPpreference {
    preference1: string,
    preference2: string,
    preference3: string,
    preference4: string,
    // preference5:string,
}

export class preferenceForm implements HTTPpreference {
    preference1: string;
    preference2: string;
    preference3: string;
    preference4: string;
    // preference5:string;


    constructor(data: preference) {
        if (data == null) {
            this.preference1 = "";
            this.preference2 = "";
            this.preference3 = "";
            this.preference4 = "";
            // this.preference5="";
        }
        else {
            this.preference1 = data.preference1;
            this.preference2 = data.preference2;
            this.preference3 = data.preference3;
            this.preference4 = data.preference4;
            // this.preference5 = data.preference5;
        }
    }

    public makeform(fb: FormBuilder): FormGroup {
        return fb.group({
            preference1: [this.preference1],
            preference2: [this.preference2],
            preference3: [this.preference3],
            preference4: [this.preference4],
            // preference5:[this.preference5],
        });
    }

    public saveForm(fg: FormGroup): boolean {
        if (fg.valid) {
            this.preference1 = fg.get("preference1").value;
            this.preference2 = fg.get("preference2").value;
            this.preference3 = fg.get("preference3").value;
            this.preference4 = fg.get("preference4").value;
            // this.preference5 = fg.get("preference5").value;
            return true;
        }
        else {
            return false;
        }
    }
}


// number search
export interface numbersearch {
    number_url: string,
    type_data: string,
    api_key: string,
    order_search: string,
    type_data1: string,
    params_key: string,

}

export interface HTTPnumbersearch {
    number_url: string,
    type_data: string,
    api_key: string,
    order_search: string,
    type_data1: string,
    params_key: string,

}

export class numbersearchForm implements HTTPnumbersearch {
    number_url: string;
    type_data: string;
    api_key: string;
    order_search: string;
    type_data1: string;
    params_key: string;



    constructor(data: numbersearch) {
        if (data == null) {
            this.number_url = "";
            this.type_data = "";
            this.api_key = "";
            this.order_search = "";
            this.type_data1 = "";
            this.params_key = "";
        }
        else {
            this.number_url = data.number_url;
            this.type_data = data.type_data;
            this.api_key = data.api_key;
            this.order_search = data.order_search;
            this.type_data1 = data.type_data1;
            this.params_key = data.params_key;
        }
    }

    public makeform(fb: FormBuilder): FormGroup {
        return fb.group({
            number_url: [this.number_url,],
            type_data: [this.type_data,],
            api_key: [this.api_key,],
            order_search: [this.order_search,],
            type_data1: [this.type_data1,],
            params_key: [this.params_key,],

        });
    }

    public saveForm(fg: FormGroup): boolean {
        if (fg.valid) {
            this.number_url = fg.get("number_url").value;
            this.type_data = fg.get("type_data").value;
            this.api_key = fg.get("api_key").value;
            this.order_search = fg.get("order_search").value;
            this.type_data1 = fg.get("type_data1").value;
            this.params_key = fg.get("params_key").value;
            return true;
        }
        else {
            return false;
        }
    }
}


//Order number
export interface ordernumber {
    number_url: string,
    type_data: string,
    api_key: string,
    order_search: string,
    type_data1: string,
    params_key: string,

}

export interface HTTPordernumber {

    order_search: string,
    type_data1: string,
    // params_key:string,

}

export class ordernumberForm implements HTTPordernumber {


    order_search: string;
    type_data1: string;
    // params_key:string;



    constructor(data: ordernumber) {
        if (data == null) {

            this.order_search = "";
            this.type_data1 = "";
            // this.params_key="";



        }
        else {


            this.order_search = data.order_search;
            this.type_data1 = data.type_data1;
            // this.params_key = data.params_key;



        }
    }

    public makeform(fb: FormBuilder): FormGroup {
        return fb.group({

            order_search: [this.order_search,],
            type_data1: [this.type_data1,],
            // params_key:[this.params_key,],

        });
    }

    public saveForm(fg: FormGroup): boolean {
        if (fg.valid) {

            this.order_search = fg.get("order_search").value;
            this.type_data1 = fg.get("type_data1").value;
            // this.params_key = fg.get("params_key").value;



            return true;
        }
        else {
            return false;
        }
    }
}




// Whitelabel :
export interface whitelabel {

    brand_name: string,
    domain: string,
    custom_css: string,
    custom_logo: string
    email: string,
    support_phone: string,
    support_url: string,
    header_logo: string,
    navbar: string,
    sidebar: string,
    ssl_certificate: string,
    ssl_key: string,


}

export interface HTTPwhitelabel {

    brand_name: string,
    domain: string,
    custom_css: string,
    custom_logo: string
    email: string,
    support_phone: string,
    support_url: string,
    header_logo: string,
    navbar: string,
    sidebar: string,
    ssl_certificate: string,
    ssl_key: string,

}

export class whitelabelForm implements HTTPwhitelabel {
    brand_name: string;
    domain: string;
    custom_css: string;
    custom_logo: string
    email: string;
    support_phone: string;
    support_url: string;
    header_logo: string;
    navbar: string;
    sidebar: string;
    ssl_certificate: string;
    ssl_key: string;


    constructor(data: whitelabel) {
        if (data == null) {

            this.brand_name = "";
            this.domain = "";
            this.custom_css = "";
            this.custom_logo = "";
            this.email = "";
            this.support_phone = "";
            this.support_url = "";
            this.header_logo = "";
            this.navbar = "";
            this.sidebar = "";
            this.ssl_certificate = "";
            this.ssl_key = "";

        }
        else {

            this.brand_name = data.brand_name;
            this.domain = data.domain;
            this.custom_css = data.custom_css;
            this.custom_logo = data.custom_logo;
            this.email = data.email;
            this.support_phone = data.support_phone;
            this.support_url = data.support_url;
            this.header_logo = data.header_logo;
            this.navbar = data.navbar;
            this.sidebar = data.sidebar;
            this.ssl_certificate = data.ssl_certificate;
            this.ssl_key = data.ssl_key;

        }
    }

    public makeform(fb: FormBuilder): FormGroup {
        return fb.group({
            brand_name: [this.brand_name, [Validators.required]],
            domain: [this.domain, [Validators.required]],
            custom_css: [this.custom_css, [Validators.required,
            ]],
            custom_logo: [this.custom_logo, [Validators.required]],
            email: [this.email, [Validators.required]],
            support_phone: [this.support_phone, [Validators.required]],
            support_url: [this.support_url, [Validators.required]],
            header_logo: [this.support_phone, [Validators.required]],
            navbar: [this.navbar, [Validators.required]],
            sidebar: [this.sidebar, [Validators.required]],

            ssl_certificate: [this.ssl_certificate, [Validators.required]],
            ssl_key: [this.ssl_key, [Validators.required]],


        });
    }

    public saveForm(fg: FormGroup): boolean {
        if (fg.valid) {
            this.brand_name = fg.get("brand_name").value;
            this.domain = fg.get("domain").value;
            this.custom_css = fg.get("custom_css").value;
            this.custom_logo = fg.get("custom_logo").value;
            this.email = fg.get("email").value;
            this.support_phone = fg.get("support_phone").value;
            this.support_url = fg.get("support_url").value;

            this.header_logo = fg.get("header_logo").value;
            this.navbar = fg.get("navbar").value;
            this.sidebar = fg.get("sidebar").value;

            this.ssl_certificate = fg.get("ssl_certificate").value;
            this.ssl_key = fg.get("ssl_key").value;


            return true;
        }
        else {
            return false;
        }
    }
}
