import { CUSTOM_ELEMENTS_SCHEMA, NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { UsermanagementComponent } from './usermanagement/usermanagement.component'
import { UsermanagementRoutingModule } from './usermanagement-routing.module';
import { Ng2SearchPipeModule } from 'ng2-search-filter';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { FormsModule } from '@angular/forms';
import { ReactiveFormsModule } from '@angular/forms';
import { NgxPaginationModule } from 'ngx-pagination';
import { SupplieruserComponent } from './supplieruser/supplieruser.component';
import { AddParamsComponent } from './usermanagement/addparams/addparams.component';
import { ItegratedsolutionsComponent } from './itegratedsolutions/itegratedsolutions.component';
import { PreferenceComponent } from './preference/preference.component';
import { AdddialogComponent } from './usermanagement/adddialog/adddialog.component';
import { MatDialogModule } from '@angular/material/dialog';
import { RatesComponent } from './rates/rates.component';
import { ParamTitle, UserType } from './users.pipe';
import { TierComponent } from './tier/tier.component';
import { UserprofileComponent } from './profile/userprofile/userprofile.component';
import { UsersettingComponent } from './profile/usersetting/usersetting.component';
import { MyratesComponent } from './myrates/myrates.component';
import { SharedModule } from '../shared/shared.module';
import { BillingModule } from '../billing/billing.module';
import { MatSlideToggleModule } from '@angular/material/slide-toggle';
import { MatExpansionModule } from '@angular/material/expansion';
import { MatTooltipModule } from '@angular/material/tooltip';
import { DashboardModule } from '../dashboards/dashboard.module';
import { CustomerrateComponent } from './customerrate/customerrate.component';
import { DemoMaterialModule } from '../demo-material-module';
import { EdituserComponent } from './edituser/edituser.component';
import { SubusersComponent } from './subusers/subusers.component';
import { ListpaymentComponent } from '../billing/listpayment/listpayment.component';
import { NgMultiSelectDropDownModule } from 'ng-multiselect-dropdown';
import { OtpverifyComponent } from './profile/otpverify/otpverify.component';
import { VerifyprofileComponent } from './profile/verifyprofile/verifyprofile.component';
import { PasswordComponent } from './profile/password/password.component';
import { PaymentComponent } from './profile/payment/payment.component';
import { BillingService } from '../billing/billing.service';
import { AddressComponent } from './profile/address/address.component';
import { BalanceComponent } from './profile/balance/balance.component';
import { FormatTimePipe } from './profile/otpverify/dateformat';
import { FloorDecimal2 } from './decimal.pipe';
import { PaymentMethodComponent } from './profile/payment-method/payment-method.component';
import { DeleteuserComponent } from './deleteuser/deleteuser.component';
import { PendingToReleaseComponent } from './pending-to-release/pending-to-release.component';
import { OrderPipe } from './orderPipe.pipe';
import { DomainBlockerComponent } from './domain-blocker/domain-blocker.component';
import { CreditCardAuthComponent } from './credit-card-auth/credit-card-auth.component';
import { AccountActionComponent } from './account-action/account-action.component';
import { NewAccountComponent } from './new-account/new-account.component';
import { SuspendedUserComponent } from './suspended-user/suspended-user.component';
import { SuspendedServicesComponent } from './suspended-services/suspended-services.component';


@NgModule({
  declarations: [TierComponent, UsermanagementComponent, SupplieruserComponent,
    AddParamsComponent, ItegratedsolutionsComponent, UserprofileComponent, UsersettingComponent,
    PreferenceComponent, AdddialogComponent, RatesComponent, UserType, ParamTitle, MyratesComponent,
    CustomerrateComponent, EdituserComponent, SubusersComponent, ListpaymentComponent, OtpverifyComponent,
    VerifyprofileComponent, PasswordComponent, PaymentComponent, AddressComponent, BalanceComponent,
    FormatTimePipe, FloorDecimal2, PaymentMethodComponent, DeleteuserComponent, PendingToReleaseComponent, OrderPipe, DomainBlockerComponent,CreditCardAuthComponent, AccountActionComponent, NewAccountComponent, SuspendedUserComponent, SuspendedServicesComponent
  ],

  imports: [
    CommonModule,
    UsermanagementRoutingModule,
    Ng2SearchPipeModule,
    NgbModule,
    MatSlideToggleModule,
    FormsModule,
    MatExpansionModule,
    MatDialogModule,
    ReactiveFormsModule,
    NgxPaginationModule,
    SharedModule,
    BillingModule,
    DashboardModule,
    MatTooltipModule,
    DemoMaterialModule,
    NgMultiSelectDropDownModule.forRoot(),
  ],
  schemas: [CUSTOM_ELEMENTS_SCHEMA],
  exports: [
    RatesComponent,
    PreferenceComponent
  ],
  entryComponents: [AdddialogComponent],
  providers: [BillingService, OrderPipe]
})
export class UsermanagementModule { }
