import { Injectable } from '@angular/core';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { HttpClient, HttpHeaders } from '@angular/common/http';

@Injectable({
  providedIn: 'root'
})
export class VoltLoginService {

  constructor(public http: HttpClient) { }

  @LoaderEnabled()
  logintoVolt(data: any): Observable<any> {
    const apiURL = environment.SERVER + 'logintoVolt';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.put(apiURL, data, { headers: httpHeaders });
  }
}
