import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormControl, Validators } from '@angular/forms';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { AgentserviceService } from '../agentservice.service';

@Component({
  selector: 'app-mapagents',
  templateUrl: './mapagents.component.html',
  styleUrls: ['./mapagents.component.css']
})

export class MapagentsComponent implements OnInit {
     
  agentList = [];
  selectedItems = [];
  groupSetting: IDropdownSettings = {};
  agentSetting: IDropdownSettings = {};
  groups: any = [];
  submitted: boolean = false;
  isDisable: boolean = true;
  groupData: any = {};
	responseMessage: any = "";
  selected: any = [];
  isEditMode: boolean = false;
  mapForm: any;
  errMessage = "";

  constructor(private data: AgentserviceService, private fb: FormBuilder){}

  ngOnInit() {
    this.mapForm = this.fb.group({
      group: new FormControl('', [Validators.required]),
      agents: new FormControl('', [Validators.required])
    })

    this.data.getGroups().subscribe(res => {
      this.groups = res.data;
    }, err => {
      this.responseMessage = err.message;
      setTimeout(()=>{
        this.responseMessage= "";
      }, 5000);
    });

    this.data.getAgents().subscribe(res => {
      this.agentList = res.data;
    }, err => {
      this.responseMessage = err.message;
      setTimeout(()=>{
        this.responseMessage= "";
      }, 5000);
    });

    this.groupSetting = {
      singleSelection: true,
      idField: 'group_key',
      textField: 'group_name',
      itemsShowLimit: 3,
      allowSearchFilter: true
    };

    this.agentSetting = {
      singleSelection: false,
      idField: 'name',
      textField: 'full_name',
      selectAllText: 'Select All',
      unSelectAllText: 'UnSelect All',
      itemsShowLimit: 3,
      allowSearchFilter: true
    };
  }

  onGroupSelected(e){
      this.isDisable = false;
      this.data.getTierMapping(this.selected[0].group_name).subscribe(res => {
        if(res.status == 200){
          this.selectedItems = res.data;
          if(res.data.length > 0){
             this.isEditMode = false;
          }
          else{
             this.isEditMode = true;
          }
        }
        else{
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          });
        }
      }, err => {
        this.responseMessage = err.message;
        this.responseMessage=err;
        setTimeout(()=>{
          this.responseMessage= "";
        }, 5000);

      })
  }

  onMapping(){
    this.submitted = true;
    if(this.mapForm.invalid){
      return;
    }
    else{
      // if(this.isEditMode){
        // let groupMap = { agents: this.selectedItems, group: this.selected[0]  };
        // this.data.updateMapping(groupMap).subscribe(res => {
        //   this.responseMessage = res.message;
        //   setTimeout(()=>{
        //     this.responseMessage= "";
        //   }, 5000);
        // }, error => {
        //   this.responseMessage=error;
        //   setTimeout(()=>{
        //     this.responseMessage= "";
        //   }, 5000);
        // })
      // }
      // else{
        let groupMap = { agents: this.selectedItems, group: this.selected[0] };
        this.data.saveMapping(groupMap).subscribe(res => {
          if(res.status == 201){
            this.responseMessage = res.message;
            setTimeout(()=>{
              this.responseMessage= "";
            }, 5000);
          }       
          else{
            this.errMessage = res.errMessage;
            setTimeout(() => {
              this.errMessage = "";
            });
          }
        }, error =>{
          this.responseMessage = error.message;
          setTimeout(()=>{
            this.responseMessage= "";
          }, 5000); 
        });
      // }
    }
  }
}
