import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { MatDialog, MatDialogRef } from '@angular/material/dialog';
import { ApiService } from '../api.service';
import { TokensComponent } from '../tokens/tokens.component';


@Component({
  selector: 'app-addtoken',
  templateUrl: './addtoken.component.html',
  styleUrls: ['./addtoken.component.css']
})
export class AddtokenComponent implements OnInit {
  tokenForm: FormGroup;
  public submitted: boolean = false;
	responseMessage = "";
	dangMessage = "";
  errMessage ="";
  users: any;
  userType: number;
  session: any;


  constructor(private data: ApiService, public fb: FormBuilder, public dialog: MatDialogRef<TokensComponent>) { }

  ngOnInit() {

    let session$ = sessionStorage.getItem("isLoggedIn");
    this.session = JSON.parse(session$);
    this.userType = this.session.type;
    
    this.data.subCustomers().subscribe((result: any) => {
        this.users = result.data;
    }, err => {
      console.log(err.message);
    });

    this.tokenForm = this.fb.group({
      name: ['', [Validators.required]],
      account: [''],
      user: ['', [Validators.required]],
      idtariff: [''],
      status: ['']
    });

    this.tokenForm.patchValue({
      account: this.session.idaccount,
      user: this.session.iduser,
      idtariff: this.session.idtariff,
      status: this.session.status
    });

  }

  onTokenSave(){
    this.submitted = true;
    if(this.tokenForm.value.user == '' && this.userType== 2){
      return false;
    }
    else{
      if(this.tokenForm.invalid){
        return;
      }
      else{
        this.data.saveToken(this.tokenForm.value).subscribe(res => {
          if(res.data){
            this.responseMessage = res.message;
            setTimeout(()=>{
              this.responseMessage = "";
            }, 5000);
            this.dialog.close(res.message);
          }
          else{
            this.dangMessage = res.message;
            setTimeout(()=>{
              this.dangMessage = "";
            }, 5000);
          }
        }, err => {
          this.responseMessage = err.message;
          setTimeout(()=>{
            this.responseMessage= "";
          }, 5000);
        });
      }
    }
  }

   onSelectUser(e){
    let iduser = e.target.value;
    let selectedUser = this.users.find(x => x.iduser == iduser);
    this.tokenForm.patchValue({
        user: selectedUser.iduser,
        idtariff: selectedUser.idtariff,
        status: selectedUser.status,
        account: selectedUser.idaccount,
    });
  }

  onReset() {
    this.submitted = false;
    if(this.userType == 2){
      this.tokenForm.get('user').setValue('');
      this.tokenForm.get('name').setValue('');
    }
    else{
      this.tokenForm.reset({
        account: this.session.idaccount,
        user: this.session.iduser,
        idtariff: this.session.idtariff,
        status: this.session.status
      });
    }
  }
}
