import { Component } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { AppComponentClass } from '../../shared/service/AppComponent.class';
import { MatSnackBar } from '@angular/material/snack-bar';
import { Router, ActivatedRoute } from '@angular/router';
import { BillingService } from '../billing.service';

@Component({
  selector: 'app-listpayment',
  templateUrl: './listpayment.component.html',
  styleUrls: ['./listpayment.component.css']
})

export class ListpaymentComponent extends AppComponentClass<any, any> {

  isLinear = false;
  billingAddressForm: FormGroup;
  paymentForm: FormGroup;
  public status: boolean = false;
  public public_key: string;
  public secret_key: string;
  public key: number;
  public ptype: number;
  public isapply: boolean = true;
  isLoggedIn: any;
  paymentHandler:any;
  amount: any = 2;
  balance: any;
  responseMessage: any;
  show: boolean = false;
  submitted: boolean = false;
  globalListener: any;
  mode: boolean = false;

  constructor(protected data: BillingService, protected router: Router,
                private route: ActivatedRoute, public fb: FormBuilder,
                protected msg: MatSnackBar,
                ) {
    super(data, router, fb);
  }

  ngOnInit(): void  {


    this.billingAddressForm = this.fb.group({
      idbilling_address: [],
      amount: [this.amount, [Validators.required,
        Validators.min(1),
        Validators.max(99999),
        Validators.pattern(/^[0-9]*$/)
        ]],
      customer_id: [''],
      first_name: ['', Validators.required],
      last_name: ['', Validators.required],
      contact: ['', Validators.required],
      email:['', [Validators.required,
        Validators.pattern("^[a-z0-9._%+-]+@[a-z0-9.-]+\\.[a-z]{2,4}$")]],
      address1: ['', Validators.required],
      address2: ['', Validators.required],
      city: ['', Validators.required],
      state: ['', Validators.required],
      postal_code: ['', Validators.required],
      country: ['', Validators.required],
      currentDateTime: []
    });

    this.data.getBalance().subscribe(response => {
      if(response.data.length > 0){
        this.balance = response.data[0].balance;
        // this.ngRedux.dispatch({type: UPDATE_BALANCE, balance: response.data[0].balance});
        if(response.data[0].customer_id != null || response.data[0].customer_id != undefined) {
          this.billingAddressForm.patchValue({
            customer_id: response.data[0].customer_id
          });
           this.mode = true;
        }
        else{
          this.mode = false;
        }
      }
    }, err => {
      this.responseMessage = err.message;
      setTimeout(()=>{
        this.responseMessage= "";
      }, 5000);
    });
    
    this.data.getBillingAddress().subscribe(response => {
      const billData = response.data[0];
      if(billData == undefined){
        this.show = true;
      }
      if(billData){
        this.billingAddressForm.patchValue({
          idbilling_address: billData.idbilling_address,
          first_name: billData.first_name,
          last_name: billData.last_name,
          contact: billData.contact,
          email:  billData.email,
          address1: billData.address1,
          address2: billData.address2,
          city: billData.city,
          state: billData.state,
          postal_code: billData.postal_code,
          country: billData.country
        })
      }
    })

    this.public_key =  "pk_live_51IqNoTHctGmIUGyOROlXjgUmZVuhBjY0P20Qdjvkj2VjGAtw6hMSgjKAeRTBvIzAy2ve5fdowNNrHunxEvbZvHoG00EDvNsHFw";
    // this.public_key = "pk_test_51HAL9TGdXmhCeqBz5vaDpVgeJxRy0fBZcPGQ9elq2Yv9ZvCBJyOg3np8q8F7irmZZkh9S5DCaJkNYPil9O8Qmk2K007mIj9HFy";

    this.isLoggedIn = JSON.parse(sessionStorage.getItem("isLoggedIn"));

    this.invokeStripe();
  }

  onCheck(event){
    this.show = event.target.checked;
  }

  getAmount(e){
      this.amount = e.target.value;
      
      this.billingAddressForm.patchValue({
        amount: this.amount
      });
  }

  paymentSubmit() {
    this.submitted = true;
    if(this.billingAddressForm.invalid){
      return ;
    }
    else{
      this.billingAddressForm.patchValue({
        amount: this.amount,
        currentDateTime :this.current_datetime()
      });
      this.openCheckout(this.billingAddressForm.value);
    }
  }


  openCheckout(billingData){
    const paymentHandler = (<any>window).StripeCheckout.configure({
      key: this.public_key,
      locale: 'auto',
      token: (stripeToken: any) => {
        if(this.show){
          if(this.billingAddressForm.value.idbilling_address == undefined || this.billingAddressForm.value.idbilling_address == ''){
            this.data.addBillingAddress(this.billingAddressForm.value).subscribe(response => {
              // this.responseMessage = response.message;
              // setTimeout(()=>{
              //   this.responseMessage= "";
              // }, 5000);
            }, err => {
              this.responseMessage = err.message;
              setTimeout(()=>{
                this.responseMessage= "";
              }, 5000);
            });
          }
          else{
               this.data.updateBillingAddress(this.billingAddressForm.value).subscribe(response => {
              //  this.responseMessage = response.message;
              //   setTimeout(()=>{
              //     this.responseMessage= "";
              //   }, 5000);
              }, err => {
                this.responseMessage = err.message;
                setTimeout(()=>{
                  this.responseMessage= "";
                }, 5000);
              });
          }
        }
        if(this.mode){
          this.data.updateBalance(JSON.stringify({pdata: billingData})).subscribe(response => {
            this.responseMessage = response.message;
            setTimeout(()=>{
              this.responseMessage= "";
               window.location.reload();
            }, 5000);
            // this.ngRedux.dispatch({type: UPDATE_BALANCE, balance: this.amount});
            //this.ngOnInit();
          }, err => {
            this.responseMessage = err.message;
            setTimeout(()=>{
              this.responseMessage= "";
            }, 5000);
          });
        }
        else{
          this.data.addBalance(JSON.stringify({pdata: billingData, token: stripeToken})).subscribe(response => {
            this.responseMessage = response.message;
            setTimeout(()=>{
              this.responseMessage= "";
              window.location.reload();
            }, 5000);
            // this.ngRedux.dispatch({type: UPDATE_BALANCE, balance: this.amount});
          }, err => {
            this.responseMessage = err.message;
            setTimeout(()=>{
              this.responseMessage= "";
            }, 5000);
          });
        }
      }
    
    });

    paymentHandler.open({
      name: 'Signalmash',
      description: 'Signalmash',
      amount: this.amount * 100
    });
  }

  invokeStripe() {
    if(!window.document.getElementById('stripe-script')) {
      const script = window.document.createElement("script");
      script.id = "stripe-script";
      script.type = "text/javascript";
      script.src = "https://checkout.stripe.com/checkout.js";
      script.onload = () => {
        this.paymentHandler = (<any>window).StripeCheckout.configure({
          key: this.public_key,
          locale: 'auto',
          token: (stripeToken: any) => {
            alert('Payment has been successfull!');
          }
        });
      }
      window.document.body.appendChild(script);
    }
  }

  current_datetime () {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let  minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second;
  }

}
