import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { AddbrandComponent } from './addbrand/addbrand.component';
import { AddcampaignComponent } from './addcampaign/addcampaign.component';
import { BrandComponent } from './brand/brand.component';
import { CampaignComponent } from './campaign/campaign.component';
import { CnpCampaignComponent } from './cnp-campaign/cnp-campaign.component';
import { CnpSettingComponent } from './cnp-setting/cnp-setting.component';
import { RegistercampaignComponent } from './registercampaign/registercampaign.component';


const routes: Routes = [
  {
    path: '',
    children: [
        {
            path: '',
            component: CampaignComponent,
            data: {
                title: 'Campaign',
                urls: [
                    {
                        title: 'A2P Campaign',
                        url: '/dashboards/dashboard'
                    },
                    {
                        title: 'Campaign'
                    }
                ]
            }
        },
        {
          path: 'brand-details',
          component: BrandComponent,
          data: {
              title: 'Campaign',
              urls: [
                  {
                      title: 'Campaign',
                      
                  },
                  {
                      title: 'Brand Details'
                  }
              ]
          }
      },

      {
        path: 'add-brand',
        component: AddbrandComponent,
        data: {
            title: 'Brand',
            urls: [
                {
                    title: 'Campaign',
                    
                },
                {
                    title: 'Add Brand'
                }
            ]
        }
    },

    {
        path: 'add-brand/:register',
        component: AddbrandComponent,
        data: {
            title: 'Brand',
            urls: [
                {
                    title: 'Campaign',
                    
                },
                {
                    title: 'Register Brand'
                }
            ]
        }
    },
    {
        path: 'app-cnp-campaign',
        component: CnpCampaignComponent,
        data: {
            title: 'CNP Campaign',
            urls: [
                {
                    title: 'CNP Campaign',
                    
                },
                {
                    title: 'CNP Campaign'
                }
            ]
        }
    },

    {
        path: 'app-cnp-setting',
        component: CnpSettingComponent,
        data: {
            title: 'CNP Setting',
            urls: [
                {
                    title: 'CNP Setting',
                    
                },
                {
                    title: 'CNP Setting'
                }
            ]
        }
    },


    {
        path: 'add-campaign/:id',
        component: AddcampaignComponent,
        data: {
            title: 'Campaign',
            urls: [
                {
                    title: 'Campaign',
                    
                },
                {
                    title: 'Add Campaign'
                }
            ]
        }
    },

    {
        path: 'register-campaign/:id',
        component: RegistercampaignComponent,
        data: {
            title: 'Campaign',
            urls: [
                {
                    title: 'Campaign',
                    
                },
                {
                    title: 'Add Campaign'
                }
            ]
        }
    },

    {
        path: 'campaigns/:id',
        component: CampaignComponent,
        data: {
            title: 'Campaign',
            urls: [
                {
                    title: 'Campaign',
                    
                },
                {
                    title: 'Add Campaign'
                }
            ]
        }
    },
  ]
}
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class CampaignRoutingModule { }
