import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { FederalService } from '../federal.service';
import { environment } from 'src/environments/environment';
import * as pdfMake from 'pdfmake/build/pdfmake.js';
import * as pdfFonts from 'pdfmake/build/vfs_fonts.js';
import { HttpClient, HttpRequest } from '@angular/common/http';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { DOCUMENT,Location } from '@angular/common';



pdfMake.vfs = pdfFonts.pdfMake.vfs;
(pdfMake as any).vfs = pdfFonts.pdfMake.vfs;

@Component({
  selector: 'app-federal-pdf',
  templateUrl: './federal-pdf.component.html',
  styleUrls: ['./federal-pdf.component.css']
})
export class FederalPdfComponent implements OnInit {
  errMessage: any = "";
  responseMessage: any = "";
  FederalPDF: any = [];
  sesiduser: any;
  idaccount: any;
  iduser: any;
  username: any;
  urliduser: any;
  urlidaccount: any;
  ques1: any;
  ans1: string;
  ans2: string;
  federalStatus: any;
  kyc_status: any ='';
  kyc_color: any;
  federal_status: any ="";
  federal_color: any ="";
  usertype: any;
  show_federal_status: any;

  constructor(public data: FederalService, public fb: FormBuilder, private location:Location,protected userSerive: UsermanagementService,public router: Router, public _http: HttpClient, private route: ActivatedRoute) { }

  ngOnInit(): void {
    let isLoggedIn = sessionStorage.getItem("isLoggedIn");
    this.sesiduser = JSON.parse(isLoggedIn);
    this.idaccount = this.sesiduser.idaccount;
    this.iduser = this.sesiduser.iduser;
    this.username = this.sesiduser.username;
    this.usertype = this.sesiduser.type;
    let idu: any;
    let ida: any;
    this.route.paramMap.subscribe((params: ParamMap) => {
      let userData = params.get('id');
      let splitUser = userData.split('-');

      idu = splitUser[0];
      ida = splitUser[1];
    })

    if(idu && idu !== undefined && idu !== null && ida && ida !== undefined && ida !== null) {
      this.urliduser = idu;
      this.urlidaccount = ida;
      this.getUserDetailForAdmin();
    }
    else{
      this.urliduser = this.iduser;
      this.urlidaccount = this.idaccount;
      this.getUserDetail();
    }
    this.getAllData(this.urliduser, this.urlidaccount);
    // setTimeout(() => {
    //   this.generatePDF();
    // }, 5000);
   
  }
  getUserDetail(){
    this.userSerive.getSingleUsers().subscribe(res => {

      // To Federal Status
      this.federalStatus = res.data1[0].federal_status;   

      this.kyc_status = res.data1[0].kyc_verify_status;     
      switch(this.kyc_status){
        case 0 : this.kyc_status = "Unverified"; this.kyc_color ="rgb(236 41 52)"; break;
        case 1 : this.kyc_status = "Verified"; this.kyc_color ="#2aab5b"; break;
        case 2 : this.kyc_status = "Verification Pending"; this.kyc_color ="#e6b125"; break;
        case 3 : this.kyc_status = "Reject"; this.kyc_color ="rgb(236 41 52)"; break;
      }

      // To Federal Status
      this.federal_status = res.data1[0].federal_status;
      switch(this.federal_status){
        case 0 : this.show_federal_status = "Inactive"; this.federal_color ="rgb(236 41 52)"; break;
        case 1 : this.show_federal_status = "Active"; this.federal_color ="#2aab5b"; break;
        case 2 : this.show_federal_status = "Pending to Active"; this.federal_color ="#e6b125"; break;
        case 3 : this.show_federal_status = "Reject"; this.federal_color ="rgb(236 41 52)"; break;
        case 4 : this.show_federal_status = "Cancel"; this.federal_color ="rgb(236 41 52)"; break;
      }
      if(this.federal_status==0 || this.federal_status==3 || this.federal_status==4)
      {
        this.router.navigate(['/federal/federal'])
            .then(() => {
              location.reload();
            })
      }
    })
  }
  getUserDetailForAdmin()
  {
      this.userSerive.getSingleUsersForAdmin(this.urliduser).subscribe(res => {
          // To Federal Status
      this.federalStatus = res.data1[0].federal_status;   

      this.kyc_status = res.data1[0].kyc_verify_status;     
      switch(this.kyc_status){
        case 0 : this.kyc_status = "Unverified"; this.kyc_color ="rgb(236 41 52)"; break;
        case 1 : this.kyc_status = "Verified"; this.kyc_color ="#2aab5b"; break;
        case 2 : this.kyc_status = "Verification Pending"; this.kyc_color ="#e6b125"; break;
        case 3 : this.kyc_status = "Reject"; this.kyc_color ="rgb(236 41 52)"; break;
      }

      // To Federal Status
      this.federal_status = res.data1[0].federal_status;
      switch(this.federal_status){
        case 0 : this.show_federal_status = "Inactive"; this.federal_color ="rgb(236 41 52)"; break;
        case 1 : this.show_federal_status = "Active"; this.federal_color ="#2aab5b"; break;
        case 2 : this.show_federal_status = "Pending to Active"; this.federal_color ="#e6b125"; break;
        case 3 : this.show_federal_status = "Reject"; this.federal_color ="rgb(236 41 52)"; break;
        case 4 : this.show_federal_status = "Cancel"; this.federal_color ="rgb(236 41 52)"; break;
      }
      if(this.federal_status==0 || this.federal_status==3 || this.federal_status==4)
      {
        this.router.navigate(['/federal/federal'])
            .then(() => {
              location.reload();
            })
      }
      })
  }
public getAllData(iduser,idaccount) {
    this.data.getFederalPdf({ iduser: iduser, idaccount: idaccount }).subscribe(res => {
      if (res.status == 200) {
        this.FederalPDF = res.data;
        this.FederalPDF.forEach((element)=>{
          if (element.question) {
            this.ques1 = element; 
            if (this.ques1.answer1 == '1') {
              this.ans1 = 'Yes'
            } else {
              this.ans1 = 'N/A'
            }
            if (this.ques1.answer2 == '1') {
              this.ans2 = 'Yes'
            } else {
              this.ans2 = 'N/A'
            }
          }
        })
        

      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    });
  }



  generatePDF() {
    var target = environment.SERVER + "savefederalpdf";
    var _http = this._http
    let payload = JSON.stringify({
      //type: 'kyc_pdf',
      //name: this.username,
      idaccount: this.urlidaccount,
      iduser: this.urliduser,
      federal_status: this.federal_status
    })
    const documentDefinition = {
      // watermark:
      //   { text: 'Federal', color: 'blue', opacity: 0.2, bold: true, italics: false },
      content: [
        {
          columns: [
            {
              image: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAhoAAACOCAYAAAB30aFaAAAACXBIWXMAAAsSAAALEgHS3X78AAAgAElEQVR4nO2dv04by9/G9/x0GipzJCS64EOLMA43gNNBFUeUIOFcQcwVxFxBzBXESKFEMRV0mBsgYESbY9MhIb1xRZlXkzxDNs6uPTM7szu7fj6SdXSS2B7v7sw88/371/fv3wNCCCGEEBf8j1eVEEIIIa6g0CCEEEKIMyg0CCGEEOIMCg1CCCGEOINCgxBCCCHOoNAghBBCiDMoNAghhBDijL95aX/n6WyxNuGvv81tPVxnMS5CCCEkj8xcwS4IiTJeUlRsGHzUKAgCITq+4b/iNaAQIYQQQn5RaKHxdLY4DzEhX2spffVlEAQ98Zrbeuil9J2EEEKIdxROaDydLQpLRT0IgkaKwmIap0EQdCE8Bp6MiRBCCHFOIYSGp+IiDik6unNbD9/8HCIhhBBih1wLDcRbNIMgeO3BcHQZQXC0aOUghBBSVHIpNGDBELEPSx4MxwaXEByM5yCEEFIocmvReDpbHBRIaEgoOAghhBSKPBfsankwBtuINNuLp7PFHqw2hBBCSK7Je4xGEa0aYQ5h4WDQKCGEkFzirdB43FwXFovqwvlVPe7fPJ0tiiyTjxa/9lLh38ynnNkigkYbc1sP3RS/kxBCCLGCd0LjcXO9GgRBJ7SZv1k4v4rdZJ/OFq81N/4RAkkTV/OMqDJqUmFUlVMIDlo3CCGE5AavhMbj5noTsRel0B8PF86vYuMVsNlfTPhYKSxSKZj1dLZYheioOxAeQ4gNBosSQgjJBV4IjcfN9XlYMeLqYbxdOL/qxL1fBE9GbOpHKIqVmcsBJdBlITGbouNgbuuhiMGwhBBCCkbmQiPCVRKFqlVjCIuId1U3kUXSQIGxksJbpkFXCiGEEO/JVGhAZPQUN95pVo1qXjqnIoi1ZSFj5ka4aSg2CCGE+EpmQuNxc103Y0TEWpQXzq8Ks6laEhwjiA22pyeEEOIdmRTsMhAZAaweTUdDyoS5rYfO3NaDcKkcQDCYIK5LD0GohBBCiFekLjQMRYakUEJDgsDOKuIuTKDYIIQQ4iWpCo2EIuMGaaOFRKTdzm09iAyVN4bWDYoNQggh3pFajEZCkXG4cH5VSGtGFEiL7RqmxDJmgxBCiDekIjQeN9fFSf2zwVt/lN+eVBm0yDydLQqXynvD61Z1XZyMEEIImYZzoaGZwhrmBiJjpk/mT2eLddQZMbl+TH0lhBCSKU5jNFDx01Rk1GZdZAQ/Yze6iE3RjdtYg/uFEEIIyQzXwaBdA5FxtHB+VS1SvYykIN6iDAGmwwbcL4QQQkgmOBMaj5vrbYNgRiEyGo6GlGvgAqkZiI33cL8QQgghqeMkRuNxc31aR9UoKDIUQEZKz6A1fpnxGoQQQtLGukUDcRm6sQGnFBlqhCwbQ423lRivQQghJAtcuE50MyRu0NWUKAKxUdcMEBXxGjNTi4QQQogfWHWdGLhMvGyU9uLT13mUBC/jJRBjFEGZ3+53l73Ihgm1x1eFLhRCCCGpYltoDDQ7kb70JYX1xaevZfRSqSnEP4wQJyHcEd373eXMNm5YKT5ovOUUpc4JIYQQ51gTGo+b67pVLPcXzq/aWd/iF5++CsuFSYZMmCPR7v1+dzmTSpxPZ4tC8LzWeMurua2HnsMh5YLVSqWOey/F8aG4j7f9Pi0+hBBiCStCAwGgA43YDBH8mempGu4RIY7eWfzYTAQHMlGuNaxJN3NbDzPdfG21UolzOx3d9vuMGSJ/sFqptOFSfea23y9so0fiH6uVSkMxprF52+97U/DSVjBoW0NkjLIO/oSbpGdZZAj2xIb/4tPXVIMuEXOhc03Xns4WZ30zjbtHeymPg+SHKiyf4RchaVKOeAajXvM+3ZXEQuNxc72suTg3sgz+hKvkWrMOhQ5CcH148enrNb4rFeAKOdT4rlmvGBo7EVcrFbbaJ4QQS9iwaOhsWJdZdmINWTJ0y6KbIITMlxefvqa5obc0Ul6XZtyqESd2Rz6ZHAkhJO8kEhom1oysrhdiMkx6ryTlPawbZbdf8+xC0XHbzLJVI06UzbqlhxBCrJLUoqEjHA4Xzq8yycoALYfukmmsIXbDeQDs3NaDKJh2qfjPl1CLY+aA1UL89lMUjRPX7M1tv595JhQhhBSJvxP+FtXT8yjLkyJiJWwHfuoiLCmfX3z6eni/u+w6WLSlUcirCXfSzAGxwZoihBDiEGOLxuPmekPDDdHOuPqnT6fUd3ClOIsKRmCoqlXj9dPZonO3DiGEkNkkietE1W0yynKjR2yESRqa2Kj3RXErvN4gq0OnmVkcwpUycJyVomNBmvVUV0IIIY4wcp0gCFR18+5mbM3QdVMIYVS/312OcieIYNLmi09faxBPSWI+hDWoJ2pu3O8udxJ8TiTCqvF0tjhULOLVYBAkIYQQF5haNHT82llvYDpjFSKjFiMynhF/f7+7XIXFQ6eD6jhCbHx0mAKr+rkiKJS1IwghhFjHVGiomtovs8w0gdtEp8lbXacz6/3uchuV2k7NRviMSIHtOojb6GoIIbpPCCGEWEfbdQK3iarLwLpLQBOdIMfLaZaMKNC5tY7U1U6COh2v4Uqp2+qVIupqoOGaSq2TuoGbyRmozjmPFNQoxL0a3Pb7xtcq9B3P3Pb71jJwViuVeZSt/uN7UDBMiNrraU3cQp8TZuJvRy+X375vWiEyXI9yxHcFGOsgy2JmKtdT5f6tVirliLVh6n0wJeb7xom8P3hvLXRfwr/7Gr+7l2T8eFbi5tvzd9icGxpjq2JM82O/X45l4rii5ngEU+eG4jjl/Im63wO8lOe9bULzJ3w9w/R05pEOJjEaqnUXRjhRZ4lOjYhEAav3u8tdBHd2EnSCfa63YSJ6YugoCg3hPinPbT1kZoFCN1X5mibY3uM9v7Xs15y8UV17/9If+S+wMTTxG5SsaauVyg3uUydm/NWIdOWDKa6x8X9/GTUfsMk0FK+5vN5djNX5xoPFUTaSmnrAWa1UAvzWzoTnoRHRafqVwzTvqO8b5/n+aPxm+ezKuSAsq21FsaV635+/I617rziHVMel0pk7cm4ojFNnvfpjDKuVyhDPXM9g7dIZp7zP0zp8P48xdE1bSQ5zEhPXiWrMQy/jIFBdEp/UhCXifne5hk3AFPHAXrz49NWKKwOprqqZMpnUlBCL3mqlIq7/Z4giHatQCRPoYxAE/7daqXSwUKUKfoO41v+hZouOy05sJh9C43feECk03gvNa17Cv78Q73fVF0ZcA3EtxDXBtdEJvN7A8zBYrVRyFeS8Wqk0cfLV/c0B5oG8L5FzIMF9D8bufdf2cxq657pzaPyZdFqEUAiM1UplYLhehVnC+8Nrl7X5FBrnRwWRMY68pv/ZWJNMhIbqTczamqGFzdbu97vLLaTDJgkUFUGitlxPqqeP1KuEYiO4sFi1VU6OdkobtlwcLxJYssLsYYN05sZCu3Mb4xXv/2J7rDiBDSx00i3hxHudg0Z54jnqQmAkbZMg7ss1TtzPWLzvATauga3rirHauOcbjoVQFwJD5yChyh7mk411v21xnHtJ77WW0HjcXK9qTIJcCQ3bvUiEKwUb902Cj9mzVNxL9V6kKjQwoaaZlE155/oZxMS7dtBa/kcHYEsLzjNYKK8dVMm1NlZ8zkfLPYmEiO2Nb7yesWZw6pyEuH4/TsgO73sJG2OidQOHjc+W7/lrzE0r6zpES8/yPYrDxphtt9soYQ4ZiQ1di4bql9zkzG0SuNhkkcFSS5iVYqO4l6pFo5RWlVAs+nEb9BDF0YTf/N/bfv+v8CsIgpdBELxVKKDmLBgZE6435cRwAzfaH78DfyZ+w9EEy9eeZbHRnbAAnYYK1P0bGuc/+LP9KdVm95JaNvBbJ4k2+VwIa+HLiOu5P2Gu/WgB4LnYsE0pFAPgss9T13QDcnzYWLJxog+JjLR6Zfnq7jMWG7rBoKpf4EvvjJ7GQ9xwsTGFslLaCU4UJbSc30dKrRbIPtlXiL5OBUzcuGu9P62xGSLEZUxNEw9+c2yTurzt950IjZDIiDuBHU0LogoFrUn/Zx3mzvHP3NOYd5OIM5dPHCsC1ORm1YbvPy7gWVg2eiYR/FNEhhAYzdt+P9ZChespxziP5yFq7ndmrLdPKYUNsoRnV+uwBmFq2xrogjQbcl5mkd2jQQlzSGtNKrrQ0FnwNkQAposqncFPwSEqil7HbCaqfIBlowkBo8zc1oNP/V7iorTfmogDbGwNmGDlJujyVBCXxiw2xIbuQoHNvAP/bzti8XWxyP2ogGswViFIahOEge0N5wgiQ/l5x79tIeixO3avSimZv2eNDRFbozp/4W754Ps1grBOsyFnHoKX13TudWDgOlENIsos1z4MNmOd3iRtl/1HIGJqCYNE95ACm+dKnlHm68OkFgixCd72++L6vnJ1KoCYidr4hZukmuR7xQZ52+834FJxyY8KuAnH2oAIGGdDx7SKhTxucRXWrYZp2h9+XzlhnBRRR8l1NsWiqcIIbrzLhGupCrquNuneO4h4TRuv79aMMFqCSNmi8bi5rmp2H2VZDTSCroYilf1HajoVQnUQn4vA0yQ+vyW4Ug6Q4ZI3ouJArAVuOhQZ5RhzvNy4rcQlCcGFzdrVSapuqfBWM8Y61dAo/tayad0aR9wTnJ7T9LHbQtYD6YVdW3g2GpaejxtYoaK+Q9e1IU66ZYW6C02D2IlL1Mn445nAvJTPnM2A0kBDaNzAmjl1XoXu33idEJdr+ShUW+a39RHzo6lp6VsSv0N1HdGxaKieUrywZoTQdRnIeAhnN11YWtArJepEqIMoXT5Ak7c8EbXg+/bcRBH3TNRtF9u57febGq3+dTiyJcSkiyLir5QWZ2wQURtZYutWGIyznsLp1ybCmiPEa2d84xaLO56PVwl/k/iO6oTvaBh8x8R7H4qfUWUEC2Ut7pmAJbOFA0zSNXUclX1viIOG0hom799tv1+G9XLo2JohrkkZ3/nHd4g/u+336wYlGZRrPekIDVWLhk/WDFkfw+Thk5u4sx4g97vLNszkSyjw1cuh4AjjRaBqHKGAzXEOHC4QLjZH2/U5ohb/JcUaBlEiZeTiZIeN1Kc4pUm8nRYQHfyy3FUNnxFX3zFtDVKqQAuGOu7IkOvxUPHzVVAZay+Be08GVrraZ5Tdjwi21rnXyi5SFxYNr4QGaBlOxiUUzhKCo+Wg6ZmM20h6MglkoRqMtWm7Lohlok7qvoukqAVy5HLzwuJg8/OPHFhevsXEQKisF1HCre2qFDNOvb5bNQ50rDmGAkrLYqT5HdPWHZ2Yh7pJ+WtYe5I2utQhUbwcBJKLffNURUyOjWWgIfSVC7+Z9DqZRuwigRN3LdSoJ7DY0yMWYdWAK8Q0ynkJvnmxgf+o/265kmgPwZ2T6hyosoTfKTJUhrKBD96req2vdbNaNBlEPKRtpEb6KFSDGCHkrD9BCJt1BlwVMLuOeG4nbjjwU0edFl1bHTopZxHoYvL7dZ8RE4uR6ndMW79U4wAOEsYRyeqySWM2RgqfsYaCaK1JKdgZYGq97NjOCDJtEz+JSQ9HDQ/rZ5TCFSfw7ziFd3ESd5JNgfoTSf13z/XfRXlwm1YDCJeaZR/jEib2e7wuFF+uM1qiFtMSyib72q4+6po4X1QgvGxlTbiKg4kShyYn29OUhJuvGP1+PCOq2XVpfEckmhVEEwlOmTKe5DOA6pxZQ0G4byh/3nTdc2UKp6aHNlw7pfgw1d+oIzRcXjS5IX5AIKYT8z9iImxt5NYFB4JEG6hwmCVOJwhOKlH3QYiNj6IRkEgj9aw/RdRJLa1UNCsCwTNrUdSccR4QjGfPV/dJkudJ9d6m8R1xqK6Ttlx8NoSG7mGiFNrLRM+V71jPeljT6ik1fUw6l6zORRcWDRtI878Ly4FNsRGEBEfbVgwHrC8vk54gPKc5YcGXrqovoRNCC50nvQkaTeH0LbEhEHyrJRE1p3Ml3ByQZFyq703yHUmfd9V13FZWlI37bMNquQRXsbTm/wfx0XZ4mEp6Da2ubb4KjTBhy4GtjdyF1eAdepJYiepHHY9qykFNqYFNWqWYUink/rlAO+VByDyZldUjb0Wg8tZ7yCVFvBaqvymJaE1LoNm0vCVKEYcV8MDecJ5Zwp7xJY3W9lmTB6Eh2bO8kUurgc0No4QgTCuVO+FKMclvzgUQGzVMZJ3f95urDVaPTkomSeKOtDYyLy0aaVSF9DjY2luQrWS7PkcY2do+j8UXlciT0AhCG3nPhjtFWA1QOGvf8ka+hlgTK+4UtJx3UYwmc5DaJYvtHBi6i56DdGHpSENw5K3KZB5Iyy3mdc0W4h8TSu7b5D36HRWOvAkNyQb6fVhp+QzrhouN/B1KmtuybshKfS4qRmaKFByolvcvxN+RgfB4jewV5y6VFONFZmVjTMsilec+QUQPa3MHYuON49i51yJ2w+HnZ4KO0PDNrylOsZ9txW443MjXbImNADU37neXa44FR6b3GiWF26hoJ0rn/oXfqyo+SnCp2NxQTItS2aDQ/tsQFG4ksDWvcBCwankUdTJwGHpjeBBS4V3R3MA6QsPXSO29HGzksn+KtQ0jNM5/UXLX5gPv3b1GPf5n8YHf/XbKPbJ5Moi6JlYsapPAglNEN03U9UxLuNHtlQ2q64qtWjrO5icEx/hadGixo6ztVgGZ4sJ1ksXpS1oNrD1YjgRH13ZBMlHo6353uXm/u1xGcOs+MlUK3RobVo8O2sLHBfVuWCwAFhWol0ZxMV8LmCUlK+Hm/DtILMrFryxZI1PZrENrURPN34Ql5Z8xK6yu+CiUe89FCfJJdEILdhWvmkHL4CikK8Vq63SUSK/BGqHbSneckhQbLkp8IyX2evwkb2BJyUMn1WdEvvyEVuB1i4V7Po79WUmk2Or2E1DFoNNlnogSbqptxpNAoZER4r6uVioqJb0DlEk3vlcQlJlZrpBR1ws/5xBPLcU9ZGaFRk+x1n3sBUKZbbmIPN8AZJA0sKgmrU3/HlaDhs3NHIJDZru0Ytpbq7CE96e2gaTRTyZrxMRGetjnsaFYmbD4/KOI+95CjxYX4qxjYT54CTadm4jNoOXKijOhLT1Jj67iPXhtKuJxn62WmodwMe7SGvwqICYqg/YUGpIVat67cJ1oB7HA/C8alc2H+vMn4XVIFFgFY23ANGZayOWd591Vc0lMQyMb1jJJlKVMLAgd2xkoYpFNaD3LA1GbwZ7DjKHCRfPnEB0B8EHX9QmR0bW5UWNui3HL1ghJ53quLMY2UBYaC+dXqqfiROYqtE2vWqjGtoYUWCcxI8hSaSEQyCQeoqgm8cxwnW4Kk/5hxF+t2TxB4fRktXuip3RifNfWG5/hmhZduHkPipLprJcfVYvxQZREdRJOirS0l2DVv0ZVYu3DItYoFfFUqPYTuhYNpR//uLme6ERiYROXlNAh1tmmDgtH1aAGR1GD/KaCxkIu7kmUqLQdFNuKmQfC1HudNC0N12Xc/VNIYIaOsjKIWA2bwq3qedfWWUN37oeL8TXQ86iK/9bQM2SAGCqrLoeYOKnnXlyY81P7MIl1ISSEVMZYKKuHrtBQDdKylWoqN/Gk1g1RTdTpQmPQrK3kytriM5iMbZhFe5bzxaPEm9UJi82xHnMSX8NpR9u8ioWqF2PJKFz5eQmqwkaJwT08H4msVFjce0WNdckjsGqYZPK9hpgQPY++4L8XKIxo00UaZlrc4NpYH6bveG7Dr+9ClGDsquMsVIVQXaGh6j6xuoHCuvEq4YK7hx4kLs3rTU2T18wJDVwjOdk2TDfmcXACjjKNW5+wCOqqxTyP0rw6gMk3ti00xEULp7GLmACxmxmILWjEXMuNJFVeUWHR+imXWCFOrHtDgqyvjbGXLqOiCQ3d9FbV06H1DVRkTiCAsqsQsRvHGhqz1ZAKanuM3158+tqKSIOMI5UUppWTnTIUtQr/3G0fO6kMig13fOLKjbmJOv8dneZSU1LGbmICRBMzllIbtZHJ/it7GKf886HGqeYSC3Kh43lwLZsx82YJVV6FtbA9LbsHm0Mdz0TUdR5iDXln7xcQXZDFVYNlwldsZEGa0EiS3eIjroTG0uPmennh/MpqPjzSVUVNi3aChaKEjJQmAk+tIj7zxaevqkIjrVLIqsJv6EpkKPC8MSPX/hqb+Lex524eAq2sUIPFaRwMNkjp/1cVv6oi41AUAAp+FymFRRQ8wu+Mmzvy2RjiuRjgufiG52Eez8Ok+zCCCGEtDQ/A/HkLi51XVqcMa9gcuTocZYmW6wTCQdU14Gwyi0qYSIM1Nb2Jh/ojBIsLfGt6pnovnNbbQNZGWeH6lLBhvEfMwkXo9Rl/vjdl037rqLbFb6AqYM1SWnaAa/NSioxZQogNBRfpEu79ezwLF3hG3k8RGcIFVUvjmSDq4J7HuSFtkORz0w4gPkLjtsJhUkdDdTNyesFgjUj6gL5Dy/nCNllaOdmZ10jrc17YC11aaw67IA6xUae6SKAEsWy2dKr59hECiV+hhLHKZlgo06oEbrOywTWcxCFFhr/gvti+5wGSCIwOk1inmmhvYHtc44j5/6aoIiMwFBqqZp014T4x+HxlEGdRTpjCKFvO24yX8Em46FiWUjPZjXVBtDGRh1hYqlluKPhd9bGOswewVMjXKf5sH6JoHg2a4oRe1PNU2E0Ti3wd1y/Js3EqrUNF83kXjbF7ntQiLK2CiVtRiLUE43LRvHKEdaBcRHdJGJNeJzqn3rrriHnEbVSRvpqkLLjorrp/v7ucaLywjvjUHVJVaNxkEZ+BCdaFT7SGV1Ux5uFSxnL4OFEhHGxYiQrV90AVef0QRCxjK6oT/PkytufHM+W4ZwpxAO55LRQ4XlNcT2WQb8fFQQPPUhNB69WxtUontfZGPqNFFxdh/vr+/bv2mx4317uK5vjhwvlVaqW2X3z62tDI+IjjEn1SjBYpZJ2o9IQRHCLexAma2Sb7d9vH3qVRIjL9N3SyUorAaqXybXxzhcVkZol4Lq5ptSguoftdDVn4ZDBw5vc+NL7yWBsOOcaZW7fCmAoNnQ39lUb58sSgCFbSWvfiZNTStW7AmjHQ+O63LjJfJCsnOzqi59+77WOeAD0DC9jF2KiGcDsRQoj3mDZV0zH5WGvZroJs626hdPkHBIoqma0hMnQrEDoTYAgCVbWW3FBkeEtUgNjMnowIIfnDSGgsnF990yi3veE6KHQcBInWLAQZbiB2ozOp2yqsKD3N2IwbU/eMInUN0cOulpqgv4LTyq4T2prPjG+XEJJ/TIJBJTrBl620m4ghSLSesLiXZA8lzG9CRaQkdcPgT9ebu6olqXDlbl2DKpbimXq3Wqkc2IhujyHKrTacpSAyQkj+MYrRkDxurg80Im5fLpxfZZKShyBRn6rPic29DDFknZWTnaZGm/Gju+3jme0kqwusDOMdGC9RNtiahQq9W6KEvEthQwgh1jGN0ZDoLHiZmedDxb1stww3pelQZMxr3hduWnpEBRqHm8MlbRNfRhfXKJExpMgghOSNREJj4fyqo1GZU8RqZNZjIBS3odPK3QWXLjNNIBxULTenDALVJk4wy+Zw/4nmcKI9uY7oQJfXDtKR42qIsEcHISR3JHKdBD/dJzoplKKoShXBpJmRoStFiLKqqyDQlZOdqmY3xFd328fMYNBEiAiN52c41gAsjMy5VylO9jbtsuqEEGIDG0JDt3bE4cL5VeYNo5BFotN1MylCZDhpTy9ZOdm51ghMvbzbPnaaNVFkUB2wncLzI56bJkUGISSvJI3RkKmuOn7jd4+b65lvcMKqcL+7XEO/CVedAyVpiIyWZvbLzHUHtQl6IMiura5ify7Ru4UigxCSWxJbNCSaGSheuFAksG60Nbqc6iB+a92xyNB1mTDTxDKoqdHQrF8Sh6j/0p7lksWEkOJgU2iIBfazxltOF86vvApuQ+GtlkVz+CFKmTsTVMgyudYQeT/iRBgE6o5Q06WqQgyGbAR2HWq2xJ4dhJDCYE1oBD/FRk9zk95fOL/yriolBEczgYVDZLa0XVoxJCsnO6oN7iQHd9vHTJEkhBCSCraFRlQxo2mk2nRNB7hU6qGWwJN+16VsT+24tPgzmk3TAvQ0mcmW44QQQrLBqtAIfooNnaqUgQyUzKpqqA5onDa+UQ/SEhZhVk52TFriv7zbPvb+OhNCCCkO1oVGYOZCGSE4lHEDCqyc7OjGwwR0mRBCCMmCxOmtMTQ0U0aFS6KLmhxkAsgw0U13vKHIIIQQkgVOhAYsE7rpk6IGRI9iIx6IjJ5mDMyIpasJIYRkhSuLhhAbIjDyQPNtQmwMHjfXGbA4BmIyvhjUaGgwlZUQQkhWOInRCPO4ua6bfhnkKUA0DQwDPwX7d9vH3qUPE0IImR2cWTRCNAxKNItT+5fHzfWZr165crLTMRQZRxQZhBBCssa5RSMwa7wWRhS/avpSrjwtVk52yqjLodO/RMKGaYQQQrwgDYuGbLxWM2xetocg0ZmJ20D6qk4n1jA3DP4khBDiC6lYNCQQC7pZE2EOFs6vCpumib4lnQSlz4XIqN1tH7NXBiGEEC9IxaIhQXCnqWUjwHsLCQI+BxQZhBBCikSqFg1JAsuGt31RTFk52bHRMZYigxBCiJdkIjSCXw3YdIIdLxfOrwpj0UDxrVYCC4bkR7AsRQYhhBAfyUxoBL+yUbqKp/mJ1oyVkx2Rytn2vTiVJQuG5PBu+7hpZ2SEEEKIfTIVGpLHzXUhEt5N+CcTrRkrJzvhjrGiXXvnbvtYtx+IMxDkKWIwxDiXLHzPCFYMb34jIYQQEoUXQiP4KTbERtyOidv4N66zKzbxqBodI1hLunfbx103o44H46rjldQ9EmYoPpPt3gkhhOQBb4RGEB+3cbRwfhVbIXTlZEe4Id4rfPwpAlCv77aPrQeUQlhUkRlTN6yBMY1T9C5hPAYhhJBc4JXQkDxurofFg4k1Q4UbFEWXYPUAAAFwSURBVMUa4L9i8x5Mi/FAEKf43jJeVbxsuETiGEFgpG6ZIYQQQpLgpdAIfqXAisZqsf06NKwZeYZZJYQQQnKLt0JjGugFcp2gyqjv3EBgFKpuCCGEkNni7xz/2lZBRYYI9mwxo4QQQkgRyKVFA9aM/zwYik1GyLpp001CCCGkKOTVoiE24gPUpci7VYMWDEIIIYUltzEaEjQja1iqtJkmp7BeMAaDEEJIYcm90JDAndJEDQuXqaZJuEEb+A7dI4QQQmaBwgiNMKh1IQtnZWnpGKFImKh/0fO9DwshhBBim0IKjXHQyEy+yg4tHkOk3PYgLFgmnBBCyEwzE0JjnFC5cFndU/6/pBoRZDpEFVGJjK34UVWUsRaEEELIn8yk0CCEEEJIOvyP15kQQgghrqDQIIQQQogzKDQIIYQQ4gwKDUIIIYQ4g0KDEEIIIc6g0CCEEEKIMyg0CCGEEOIMCg1CCCGEOINCgxBCCCFuCILg/wH1opTsvweDdwAAAABJRU5ErkJggg==',
              width: 155,
              height: 42,
            }
          ],
          columnGap: 50
        },
        {
          columns: [
            {
              width: '4%',
              text: '',
            },
            {
              width: '96%',
              text: 'REQUEST FOR REMOVAL OF FEDERAL DO NOT CALL REGISTRY FILTERING',
              style: 'mr',
            }
          ],
        },

        {
          columns: [
            {
              width: '100%',
              text: `\n${this.ques1.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.ans1}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.ques1.question_description1.replace(/<\/?p>/g, '')}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.ans2}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\nName : ${this.ques1.fullname}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '12%',
              text: '\n\nSignature : ',
            },
            {
              image: `${this.ques1.signature}`,
              width: 155,
              height: 42,
            },
          ],
        },
      ],
      styles: {
        header: {
          fontSize: 16,
          bold: true,
          color: '#0339fc'
        },
        header1: {
          fontSize: 13,
          bold: true,
          color: '#0339fc'
        },
        header2: {
          fontSize: 12,
          bold: true,
          color: '#0339fc'
        },
        column: {
          background: '#0339fc',

        },
        note: {
          margin: [0, 0, 0, 0],

        },
        note1: {
          fontSize: 10,
        },
        note2: {
          // fontSize: 12,
          margin: [0, 0, 0, 0],
          color: 'blue'
        },
        mr: {
          fontSize: 14,
          bold: true,
          color: '#0339fc',
          margin: [0, 18, 0, 0],
        },
        anotherStyle: {
          //italics: true,
          alignment: 'left',
          bold: 'true'
        },

      }
    };
    //pdfMake.createPdf(documentDefinition).download(`bhardwaj`);


    const pdfDocGenerator = pdfMake.createPdf(documentDefinition);
    pdfDocGenerator.getBlob((blob) => {
      const pdfBlob = new Blob([blob], { type: 'application/pdf' });
      const fd = new FormData();
      fd.append("UPLOAD", pdfBlob, 'pdf');
      fd.append('payload', payload)
      const req = new HttpRequest('POST', target, fd, {
        reportProgress: true
      });
      _http.request(req).subscribe((res: any) => {
      })
    });
  }

   /*Kyc Verify function*/
   verifyFederal() {
    let data = {
      idaccount: this.urlidaccount,
      iduser: this.urliduser,
      federal_status: 1
    }
    this.federal_status = 1
    this.data.federalVerify(data).subscribe((res) => {
      if (res.status == 201) {
        this.generatePDF();
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
          document.getElementById("verifyCloseBtn").click();
          this.location.back();
        }, 5000);
      
        // this.router.navigate(['user/new-account'])
        //   .then(() => {
        //     location.reload();
        //   })
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  rejectfederal() {
    let data = {
      idaccount: this.urlidaccount,
      iduser: this.urliduser,
      federal_status: 3
    }
    this.federal_status = 3;
    this.data.rejectFederalStatus(data).subscribe((res) => {
      if (res.status == 201) {
        this.generatePDF();
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
          document.getElementById("rejectCloseBtn").click();
          this.location.back();
        }, 5000);
       
        // this.router.navigate(['user/new-account'])
        //   .then(() => {
        //     location.reload();
        //   })
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }

    })
  }

  cancelFederal() {
    let data = {
      idaccount: this.urlidaccount,
      iduser: this.urliduser,
      federal_status: 4
    }
    this.federal_status = 4;
    this.data.cancelFederalStatus(data).subscribe((res) => {
      if (res.status == 201) {
        this.generatePDF();
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
          document.getElementById("cancelCloseBtn").click();
          this.location.back();
        }, 5000);
      
        // this.router.navigate(['user/new-account'])
        //   .then(() => {
        //     location.reload();
        //   })
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  backPage() {
    this.location.back();
    // this.router.navigate(['user/new-account'])
    //   .then(() => {
    //     location.reload(); 
    //   })

  }



}
