import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { Router } from '@angular/router';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { FederalService } from '../federal.service';

@Component({
  selector: 'app-federal',
  templateUrl: './federal.component.html',
  styleUrls: ['./federal.component.css']
})
export class FederalComponent implements OnInit {
  submitted2: boolean = false;
  app: any;
  canvas: any;
  urlData: any;
  showImage: any;
  FedrlQuestion: any = [];
  errMessage: any = "";
  responseMessage: any = "";
  FederalForm: FormGroup;
  hideQus: boolean = true;
  Errqus: string = '';
  FederalPDF: any = [];
  iduser: any;
  idaccount: any;
  sesiduser: any;
  checked1: number = 0;
  checked2: number = 0;
  sessionType: any;
  newUserStatus: any;
  disabled: boolean = false;
  kyc_status: any = '';
  kyc_color: any;
  federal_status: any = "";
  federal_color: any = "";
  counter: number = 5;
  countDownInterval: any = 0;
  constructor(public data: FederalService, public User: UsermanagementService, public fb: FormBuilder, public router: Router) { }

  ngOnInit(): void {
    let isLoggedIn = sessionStorage.getItem("isLoggedIn");
    this.sesiduser = JSON.parse(isLoggedIn);
    this.idaccount = this.sesiduser.idaccount;
    this.iduser = this.sesiduser.iduser;
    this.sessionType = this.sesiduser.type;
    this.newUserStatus = this.sesiduser.newUser_status;
    if (this.sesiduser.newUser_status == 0) {
      if (this.sesiduser.isEmailVerify == "true" && this.sesiduser.isMobileVerify == "true" && this.sesiduser.isAddress == "true" && this.sesiduser.isPlan == "true") {
        this.disabled = true;
      }
      else {
        this.disabled = false;
      }
    }
    if (this.sesiduser.newUser_status == 1) {
      if (this.sesiduser.isEmailVerify == "true" && this.sesiduser.isMobileVerify == "true" && this.sesiduser.isAddress == "true" && this.sesiduser.isPlan == "true" && this.sesiduser.isCard == "true") {
        this.disabled = true;
      }
      else {
        this.disabled = false;
      }
    }
    this.getUserDetail();
    this.FederalForm = this.fb.group({
      federal_question_1: ['', [Validators.required]],
      sub_federal_question_2: [''],
      fullname: ['', [Validators.required]],
      kyc_signature: ['', [Validators.required]],
    });

    this.data.getFedrlQuestion().subscribe(res => {
      if (res.status == 200) {
        this.FedrlQuestion = res.data;
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }



  async init() {
    this.app = document.getElementById('app');
    this.canvas = document.querySelector('canvas');
    const { left, top } = this.canvas.getBoundingClientRect();
    const context = this.canvas.getContext('2d');
    context.clearRect(0, 0, this.canvas.width, this.canvas.height);
    context.strokeStyle = '#222';
    context.lineCap = 'round';
    context.lineJoin = 'round';
    context.lineWidth = 4;
    let state = {
      drawing: false,
      dot: false,
      start: {
        x: null,
        y: null,
      },
      end: {
        x: null,
        y: null,
      },
    };

    this.canvas.addEventListener('mousedown', (e) => {
      state = {
        ...state,
        drawing: true,
        start: { x: e.clientX - left, y: e.clientY - top },
      };
    });

    this.canvas.addEventListener('mousemove', (e) => {
      state = { ...state, end: { x: e.clientX - left, y: e.clientY - top } };
    });

    this.canvas.addEventListener('mouseup', () => {
      state = { ...state, drawing: false };
    });

    this.canvas.addEventListener('mouseleave', () => {
      state = { ...state, drawing: false };
    });

    this.canvas.addEventListener('click', (e) => {
      if (state.dot) {
        const x = e.clientX - left;
        const y = e.clientY - top;
        context.beginPath();
        context.arc(x, y, 2, 0, Math.PI * 2);
        context.fill();
        context.closePath();
      }
    });

    (async function render() {
      if (state.drawing) {
        await context.beginPath();
        await context.moveTo(state.start.x, state.start.y);
        await context.lineTo(state.end.x, state.end.y);
        await context.stroke();
        const dx = await state.end.x - state.start.x;
        const dy = await state.end.y - state.start.y;
        let data = await Math.sqrt(dx * dx + dy * dy);
        if (data > 0) {
          state = { ...state, dot: true }
        }
        state = { ...state, start: { ...state.end } };

      }

      window.requestAnimationFrame(render);
    })();

    document.querySelector('.save').addEventListener('click', async () => {
      if (state.start.x != null && state.start.y != null) {
        const a = document.createElement('a');
        a.href = await this.canvas.toDataURL();
        this.urlData = a.href;
        await this.FederalForm.patchValue({ 'kyc_signature': this.urlData });
        document.getElementById("myModal").click();
        // a.innerText = 'Download';
        // a.setAttribute('download', 'canvas-drawing');
        // if(!this.app.innerHTML.includes('Download'))
        // {
        //   this.app.append(a);
        // }
      }
      else {
        this.urlData = '';
        await this.FederalForm.patchValue({ 'kyc_signature': '' });
        document.getElementById("myModal").click();
      }

    });
    document.querySelector('.clearData').addEventListener('click', () => {
      context.clearRect(0, 0, this.canvas.width, this.canvas.height);
      state = {
        drawing: false,
        dot: false,
        start: {
          x: null,
          y: null,
        },
        end: {
          x: null,
          y: null,
        },
      };

    })
    let element: HTMLElement = document.getElementById('auto_trigger') as HTMLElement;
    element.click();

  };
  showModel() {
    setTimeout(() => {
      this.init();
    }, 500);
  }

  changeStatus(check, Id, Qus) {
    this.FedrlQuestion.forEach(element => {
      if (Qus == 'QusOut') {
        if (check == 'Yes') {
          this.FederalForm.get(Id).setValue('1');
          this.FederalForm.get('sub_federal_question_2').setValue('');
          this.hideQus = false;
          this.Errqus = "Question is required";
          element['checked'] = 1;
        }
        else {
          this.FederalForm.get(Id).setValue('0');
          this.hideQus = true;
          this.Errqus = '';
          element['checked'] = 2;
          element['checked2'] = 0;
        }
      }
      if (Qus == 'QusIn') {
        this.Errqus = '';
        if (check == 'Yes') {
          this.FederalForm.get(Id).setValue('1');
          element['checked2'] = 1;
        }
        else {
          this.FederalForm.get(Id).setValue('0');
          element['checked2'] = 2;
        }
      }
    });
  }

  saveFederal() {
    if (this.FederalForm.invalid || this.Errqus !== '') {
      this.submitted2 = true;
      return;
    }
    else {
      this.data.saveFederal(this.FederalForm.value).subscribe(res => {
        if (res.status == 200) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
            this.router.navigate(['/account-message'])
            .then(() => {
              location.reload();
            });
          }, 5000);
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      })
    }
  }

  getUserDetail() {
    this.User.getSingleUsers().subscribe(res => {
      // To KYC Status
      this.kyc_status = res.data1[0].kyc_verify_status;
      switch (this.kyc_status) {
        case 0: this.kyc_status = "Unverified"; this.kyc_color = "rgb(236 41 52)"; break;
        case 1: this.kyc_status = "Verified"; this.kyc_color = "#2aab5b"; break;
        case 2: this.kyc_status = "Verification Pending"; this.kyc_color = "#e6b125"; break;
        case 3: this.kyc_status = "Reject"; this.kyc_color = "rgb(236 41 52)"; break;
      }
      if (this.kyc_status == 'Verified') {
        this.getFederalPdf();
      }
      else {
        this.countDownInterval = setInterval(() => {
          this.counter = this.counter - 1;
            if (this.counter === 0) {
              this.counter = 5;
              clearTimeout(this.countDownInterval);
              this.router.navigate(['/kyc/kyc']);
            }
        }, 1000);
      }
    })
  }

  getFederalPdf() {
    this.data.getFederalPdf({ iduser: this.iduser, idaccount: this.idaccount }).subscribe(res => {
      if (res.status == 200) {
        this.FederalPDF = res.data[0];
        this.FederalForm.patchValue({
          federal_question_1: this.FederalPDF.answer1,
          sub_federal_question_2: this.FederalPDF.answer2,
          fullname: this.FederalPDF.fullname,
          kyc_signature: this.FederalPDF.signature,
        });
        this.urlData = this.FederalPDF.signature;
        if (this.FederalPDF.answer1 == '1') {
          // this.checked1==1;
          this.FederalForm.get('federal_question_1').setValue('1');
          this.hideQus = false;
        } else {
          // this.checked1==0;
          this.FederalForm.get('federal_question_1').setValue('0')
          this.hideQus = true;
        }


        if (this.FederalPDF.answer2 == '1') {
          this.FederalForm.get('sub_federal_question_2').setValue('1')
          // this.checked2==1;
        } else {
          this.FederalForm.get('sub_federal_question_2').setValue('0')
          // this.checked2==0;
        }
        if (this.FederalPDF.federal_status !== 3 && this.FederalPDF.federal_status !== 4) {
          if (res.data.length > 0) {
            this.router.navigate(['/federal/federal-details'])
              .then(() => {
                location.reload();
              });
          }
        }
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    });
  }

}
