import { Component, OnInit } from '@angular/core';
import { AbstractControl, FormBuilder, FormGroup, ValidatorFn, Validators } from '@angular/forms';
import { InboundService } from '../inbound.service';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { calldetails, calldetailsForm } from '../inbound.class';
import { Router } from '@angular/router';
import { Observable } from 'rxjs';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';
import { formatDate } from '@angular/common';

declare var $: any;

@Component({
	selector: 'app-calldetailsrecord',
	templateUrl: './calldetailsrecord.component.html',
	styleUrls: ['./calldetailsrecord.component.css']

})

export class CalldetailsrecordComponent extends AppComponentClass<calldetails, calldetailsForm> {
	public show_filter: boolean = false;
	filter_2: boolean = false;
	editData?: Observable<any>;
	searchText = { count: 0 };
	filtre: string;
	label: Observable<any>;
	header: any;
	rowdata: any;
	p: number = 1;
	page = 1;
	count = 0;
	tableSize = 50;
	tableSizes = [50, 100, 150];
	filterTerm: string
	snackBar: any;
	public cdrForm: FormGroup;
	public summeryCdrForm: FormGroup;
	public submitted: boolean = false;
	filterCdr: any = [];
	singleCdr: any = [];
	username: any;
	userlist: any = [];
	isAdmin: Boolean = false;
	errMessage: any = "";
	responseMessage: any = "";
	EXCEL_TYPE = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8';
	EXCEL_EXTENSION = '.xlsx';
	userType: any;
	currentDate: Date;
	startdate: any;
	lastdate: any;
	filterSummaryCdr: any = [];
	exportfile: any = [];

	constructor(public data: InboundService, public router: Router, public fb: FormBuilder, private userService: UsermanagementService) {
		super(data, router, fb);

		let session = JSON.parse(sessionStorage.getItem("isLoggedIn"));
		this.userType = session.type;

	}

	ngOnInit(): void {
		this.currentDate = new Date();
		this.currentDate = new Date(this.currentDate.setDate(this.currentDate.getDate() - 1));
		const sValue = formatDate(this.currentDate, 'yyyy-MM-dd', 'en-US');
		this.startdate = sValue;

		this.lastdate = new Date(this.currentDate.setDate(this.currentDate.getDate() - 6));
		const lValue = formatDate(this.currentDate, 'yyyy-MM-dd', 'en-US');
		this.lastdate = lValue;

		this.userService.getUsers("main").subscribe(res => {
			this.userlist = res.data[0];
		}, err => {
			console.log(err.message);
		});

		let isLoggedIn = sessionStorage.getItem("isLoggedIn");
		let user = JSON.parse(isLoggedIn);
		this.username = user.username;
		if (user.type == '1') {
			this.isAdmin = true;
		}
		else {
			this.isAdmin = false;
		}

		this.cdrForm = this.fb.group({
			to_date: [this.current_datetime()],
			from_date: [this.startDate()],
			from_number: ['',],
			to_number: ['',],
			direction: [''],
			iduser: [''],
			fType: [''],
		}, {
			validator: Validators.compose([
				CalldetailsrecordComponent.dateLessThan('from_date', 'to_date', { 'from_date': true })
			])
		});
		this.summeryCdrForm = this.fb.group({
			to_date: [this.startdate, [Validators.required]],
			from_date: [this.lastdate, [Validators.required]],
			directionSummery: ['Both'],
			fType: [''],
			// Status: [''],
		}, {
			validator: Validators.compose([
				CalldetailsrecordComponent.dateLessThan('from_date', 'to_date', { 'from_date': true })
			])
		});

		this.summeryCdrForm.patchValue({
			to_date: this.startdate,
			from_date: this.lastdate
		})

		this.data.getCdr().subscribe((result) => {
			this.label = result[1];
			this.header = result[0].headers_details;
			this.rowdata = result[0].product_details;
			if (this.userType == 1 || this.userType == 2) {
				return this.header;
			}
			else {
				let idx = this.header.indexOf("Customer Name");
				this.header.splice(idx, 1);
			}
		});
		this.cdrForm.patchValue({
			fType:""
		})
		this.data.callDetailRecord(JSON.stringify(this.cdrForm.value)).subscribe(response => {
			if (response.status == 200) {
				this.filterCdr = response.data;
				$('#basic-datatables').DataTable().clear();
				$('#basic-datatables').DataTable().destroy();
				$.getScript('./assets/table.js');
			}
			else {
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});

		this.SummeryCdr();
	}

	onCdrFilter() {
		this.filterCdr = [];
		this.cdrForm.patchValue({
			fType:""
		})
		this.submitted = true;
		if (this.cdrForm.invalid) {
			return;
		}
		else {
			this.filterCdr = [];
			this.data.callDetailRecord(JSON.stringify(this.cdrForm.value)).subscribe(response => {
				if (response.status == 200) {
					this.filterCdr = response.data;
					$('#basic-datatables').DataTable().clear();
					$('#basic-datatables').DataTable().destroy();
					$.getScript('./assets/table.js');
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	// callDetailRec() {
	// 	this.data.callDetailRecord(JSON.stringify(this.cdrForm.value)).subscribe(response => {
	// 		if (response.status == 200) {
	// 			this.filterCdr = response.data;
	// 			$('#basic-datatables1').DataTable().clear();
	// 			$('#basic-datatables1').DataTable().destroy();
	// 			$.getScript('./assets/table.js');
	// 		}
	// 		else {
	// 			this.errMessage = response.message;
	// 			setTimeout(() => {
	// 				this.errMessage = "";
	// 			}, 5000);
	// 		}
	// 	});
	// }

	getSingleCdr(idcdr) {
		this.singleCdr = [];
		this.singleCdr = this.filterCdr.find(el => el.idcdr == idcdr);
	}

	exportFile(e: any) {
		this.exportfile = [];
		let fType = "filter";
		this.cdrForm.patchValue({
			fType:fType
		})
		this.summeryCdrForm.patchValue({
			fType:fType
		})
		if (e == 'call') {
			this.data.callDetailRecord(JSON.stringify(this.cdrForm.value)).subscribe(response => {
				if (response.status == 200) {
					this.exportfile = response.data;
					if(this.exportfile.length > 0){
						const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
						const workbook: XLSX.WorkBook = { Sheets: { 'CDR': worksheet }, SheetNames: ['CDR'] };
						const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
						this.saveAsExcelFile(excelBuffer, "CDR");
					}
					else{
						this.errMessage = "Record Not Found !";
						setTimeout(() => {
							this.errMessage =""
						}, 5000);
					}
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
		if (e == 'summery') {
			this.data.summeryCdrForm(JSON.stringify(this.summeryCdrForm.value)).subscribe(response => {
				if (response.status == 200) {
					this.exportfile = response.data;
					if(this.exportfile.length > 0){
						const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
						const workbook: XLSX.WorkBook = { Sheets: { 'CDR': worksheet }, SheetNames: ['CDR'] };
						const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
						this.saveAsExcelFile(excelBuffer, "CDR");
					}
					else{
						this.errMessage = "Record Not Found !";
						setTimeout(() => {
							this.errMessage =""
						}, 5000);
					}
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	private saveAsExcelFile(buffer: any, fileName: string): void {
		const data: Blob = new Blob([buffer], {
			type: this.EXCEL_TYPE
		});
		saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
	}


	startDate() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
		let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
		let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
		let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
		let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
		return year + '-' + month + "-" + "01";
	}

	current_datetime() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
		let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
		let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
		let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
		let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
		return year + '-' + month + "-" + day;
	}


	static dateLessThan(from_date: string, to_date: string, validatorField: { [key: string]: boolean }): ValidatorFn {
		return (c: AbstractControl): { [key: string]: boolean } | null => {
			const date1 = c.get(from_date).value;
			const date2 = c.get(to_date).value;
			if ((date1 !== null && date2 !== null) && date1 > date2) {
				return validatorField;
			}
			return null;
		};
	}
	showfilter() {
		if (this.show_filter == false) {
			this.show_filter = true;
		}
		else {
			this.show_filter = false;
		}

	}
	filter() {
		if (this.filter_2 == false) {
			this.filter_2 = true;
		}
		else {
			this.filter_2 = false;
		}

	}

	SummeryCdr() {
		this.summeryCdrForm.patchValue({
			fType:""
		})
		if (this.summeryCdrForm.invalid) {
			return false
		}
		else {
			this.data.summeryCdrForm(JSON.stringify(this.summeryCdrForm.value)).subscribe(response => {
				if (response.status == 200) {
					this.filterSummaryCdr = response.data;
					$('#basic-datatables1').DataTable().clear();
					$('#basic-datatables1').DataTable().destroy();
					$.getScript('./assets/table.js');
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	resetCdr() {
		this.submitted = false;
		// this.cdrForm.reset();
		this.ngOnInit();
		this.cdrForm.patchValue({
			from_date: this.startDate(),
			to_date: this.current_datetime(),
		})
		this.onCdrFilter();
	}

	resetSum() {
		this.submitted = false;
		this.summeryCdrForm.reset();
		this.summeryCdrForm.patchValue({
			from_date: this.lastdate,
			to_date: this.startdate
		})
		this.SummeryCdr();
	}
}