import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, FormControl, Validators} from '@angular/forms';
import { InboundService } from '../inbound.service'
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Router } from '@angular/router';

declare var $:any;
@Component({
  selector: 'app-uncompletecall',
  templateUrl: './uncompletecall.component.html',
  styleUrls: ['./uncompletecall.component.css']
})
export class UncompletecallComponent extends AppComponentClass<any, any> {
  p: number = 1;
	page = 1;
	count = 0;
	tableSize = 5;
	tableSizes = [ 5, 9, 12];
	filterTerm: string;
  header: any;
  listdata: any;
  uncompleteForm: FormGroup;
  public complete: any;
  public show: boolean = false;
  public show1: boolean = false;
  public hide: boolean = false;
  submitted: boolean;

  constructor(public fb: FormBuilder, public data: InboundService, public router: Router) {
    super(data, router, fb) 
    this.uncompleteForm = this.fb.group({
      from_date: ['', [Validators.required]],
      to_date: ['',[Validators.required]],
      from_ani: ['', [Validators.required]],
      to_did: ['', [Validators.required]],
      call_id: ['', [Validators.required]],
    })
  }

  ngOnInit(): void {
    this.data.getuncomplete().subscribe((result) => {
      this.complete = result[1] ;
      this.header = result[0].headers_details;
      // this.listdata = result[0].complete_details;
      console.log(result)
    });
  }

  get f() { return this.uncompleteForm.controls; };

  onsubmit() {
    if (this.uncompleteForm.valid) {
			this.data.getuncomplete().subscribe((result) => {
        this.header = result[0].headers_details;
        // this.listdata = result[0].complete_details;
        // console.log(result)
        // console.log(this.listdata)
        let data = this.uncompleteForm.value;
        this.data.callDetails(this.uncompleteForm.valid).subscribe(result=>{
          console.log(result)
        })
        this.hide = !this.hide
        console.log(data);
      });
      
		} else {
      return false;
    }    
  }

  toggle() {
    this.show = !this.show;

  }

  tablehide(){
    // this.show1 = !this.show1;
    this.hide = !this.hide
  }

  onTableSizeChange(event): void {
		this.tableSize = event.target.value;
		this.page = 1;
	
	
	  } 
	  
	  onTableDataChange(event){
		this.page = event;
		
	  } 
}
