import { Component, ViewChild } from '@angular/core';
import { InboundService } from '../inbound.service'
import { ActivatedRoute, Router } from '@angular/router';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { BehaviorSubject } from 'rxjs';
import { CapmaignserviceService } from 'src/app/campaign/capmaignservice.service';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';
declare var $: any;

@Component({
  selector: 'app-view-order',
  templateUrl: './view-order.component.html',
  styleUrls: ['./view-order.component.css']
})
export class ViewOrderComponent extends AppComponentClass<any, any> {
  filtre: string;
  searchText = { count: 0 };
  page = 1;
  field: any;
  header: any;
  count = 0;
  tableSize = 50;
  tableSizes = [50, 100, 150];
  filterTerm: string
  responseMessage: any = "";
  errMessage: any = "";
  dids: any = [];
  tab1$ = new BehaviorSubject<any>("");
  tab1 = this.tab1$.asObservable();
  tab1Value = "";
  tab2$ = new BehaviorSubject<any>("");
  tab2 = this.tab1$.asObservable();
  tab2Value = "";
  tab3$ = new BehaviorSubject<any>("");
  tab3 = this.tab1$.asObservable();
  tab3Value = "";
  connectionLists: any;
  iddid: any;
  connectionKey$ = new BehaviorSubject<any>("");
  connection = this.connectionKey$.asObservable();
  connectionValue = "";
  inboundKey$ = new BehaviorSubject<any>("");
  inbound = this.inboundKey$.asObservable();
  inboundValue = "";
  outboundKey$ = new BehaviorSubject("");
  outbound = this.outboundKey$.asObservable();
  outboundValue = "";
  campaigns: any = [];
  campaign = "";
  did: string = "";
  selectedDid: any = [];
  isChecked: Boolean = false;
  isSelected: Boolean = false;
  users: any = [];
  brandId: any = null;
  isCampaign: boolean = false;
  camp: any;
  uploadDid: FormGroup;
  file: File | any;
  fileView: any;
  upload: any;
  public submitted: boolean = false;
  isAdmin: boolean = false;
  username: any;
  filterForm: FormGroup;
  monthNameList: any = [];
  /* didList: any = []; */
  public show: boolean = false;
  EXCEL_TYPE = 'application/csv';
  EXCEL_EXTENSION = '.csv';

  DidProviders: any = [
    { name: "thinQ", value: "ThinQ" },
    { name: "inteliQ", value: "InteliQ" },
    { name: "teleapi", value: "Teleapi" },
    { name: "Peerless", value: "Peerless" },
    { name: "coreTel", value: "CoreTel" }
  ]
  NumberType: any = [
    { type: "Local Number", value: "NN" },
    { type: "Toll-Free Number", value: "TF" }
  ]
  CurrentUConn: any = []

  dIFlag: boolean = false
  dIFBtn: string = "Import DID"
  stateList: any;

  id_grouporder: any = 0
  OrdersList: any = []

  constructor(
    public data: InboundService,
    public router: Router,
    public fb: FormBuilder,
    private userService: UsermanagementService,
    private campService: CapmaignserviceService, private AcRoute: ActivatedRoute) {
    super(data, router, fb);
  }

  ngOnInit(): void {
    let id_grouporder: any = this.AcRoute.snapshot.paramMap.get('id')

    if (id_grouporder) {
      this.id_grouporder = id_grouporder

      // To load the order
      this.LoadOrder(this.id_grouporder)
    }
  }


  LoadOrder(id: any): void {
    this.OrdersList = [];
    this.data.ViewOrderHistory({
      id_grouporder: id
    }).subscribe(res => {
      if (res.error == 0) {
        this.OrdersList = res.data
        $.getScript('./assets/table.js')
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }


  vData: any = {}
  ViewOrder(data: any): void {
    if (data) {
      this.vData = data
    }
  }

  get UType(): any {
    return sessionStorage.getItem("type")
  }

}