import { formatDate } from '@angular/common';
// import { Component, OnInit } from '@angular/core';
import { Component, OnInit, ElementRef, Renderer2, ViewChild, ViewEncapsulation } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { Router, ActivatedRoute, ParamMap } from '@angular/router';
import { LOADIPHLPAPI } from 'node:dns';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { NewCamapignService } from '../new-camapign.service';
import { MatSnackBar } from '@angular/material/snack-bar';
import { environment } from 'src/environments/environment';
import { HttpClient, HttpRequest } from '@angular/common/http';
import { interval as observableInterval } from "rxjs";
import { takeWhile, scan, tap } from "rxjs/operators";
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
declare var $: any;
@Component({
	selector: 'app-new-brand-details',
	templateUrl: './new-brand-details.component.html',
	styleUrls: ['./new-brand-details.component.css']
	// encapsulation: ViewEncapsulation.None

})
export class NewBrandDetailsComponent extends AppComponentClass<any, any>{
	@ViewChild('toggleButton') toggleButton: ElementRef;
	@ViewChild('menu') menu: ElementRef;
	@ViewChild('menu1') menu1: ElementRef;
	@ViewChild('menu2') menu2: ElementRef;
	@ViewChild('menu3') menu3: ElementRef;
	@ViewChild('closeLegalName') closeLegalName : ElementRef;
	@ViewChild('closeBrand') closeBrand : ElementRef;
	@ViewChild('deleteBrand') deleteBrand : ElementRef;
	@ViewChild('resubmitBrands') resubmitBrands : ElementRef;
	@ViewChild('companyDetail') companyDetail : ElementRef;
	applyVettingForm: FormGroup;
	applyVettingFormPolitical: FormGroup
	importVettingForm: FormGroup;
	public show: boolean = false;
	menushow: boolean = false;
	public submittedaply: boolean = false;
	public submittedimp: boolean = false;
	brands: any = [];
	brandId: any;
	iduser: any;
	brandData: any = [];
	public Company: FormGroup;
	public ContactDetails: FormGroup;
	responseMessage: any;
	errMessage: any;
	brandRelationship: any = [];
	getOldID: string;
	brand: any;
	vettingData: any = [];
	entityType: any;
	brandsVetting: any = [];
	vettingClass: any = [];
	vettingProvider: any = [];
	vettingProviderOrPartner: any = [];
	vtngClass: any = [];
	vtngProvider: any = [];
	vetProvider: any[] = [];
	vettingText: any = '';
	vettingID: any;
	vettingTOKEN: any;
	companyDetails: FormGroup;
	brandDetails: any = [];
	submitted: boolean = false;
	chosenDun: string;
	campaign: any;
	Government: string;
	brandrel: any;
	brandVertical: any;
	stockexchange: any = [];
	selectpublic: boolean = false;
	chosenOrg: string = "";
	chosenOPT: string = "";
	Organization: any = [];
	Duns_giinData: any;
	States: any = [];
	country: { value: string; name: string; }[];
	mainForm: FormGroup;
	campaignFilter: FormGroup;
	useCase: any;
	taxExemptStatus: any = '';
	altBusinessIdType: any = [];
	campLen: any;
	userType: any;
	disappeared: boolean = false;
	flname: boolean = false;
	brandPolitical: any;
	localdata: any;
	pinPreference: any;
	getfecCommitteeTypeCode: any;
	us_States: any;
	singleVetClass: any = '';
	singleVetProvider: any = '';
	poli: any = '2';
	currentDate: Date;
	newDate: string;
	zipLength: any;
	Formvalid: boolean = false;
	chosenDunLimit: any;
	Solepop: boolean = false;
	Solepop2: boolean = false;
	hideEditBtn: boolean = true;
	BusinessIdType: any = '';
	altBusinessId: any = '';
	idstatUnvryfied: boolean = false;
	statusError: string;
	identitystatus: boolean = false;
	cnpStatus: string;
	hideEdit: boolean;
	DotDisable: boolean = false;
	bDstatus: any = 0;
	bResStatus: any = 0;
	menushowvetting: boolean = false;
	formcheck: FormGroup;
	menushowvetting1: boolean = false;
	menushowvetting2: boolean = false;
	vettingAppealCategory: any = [];
	chooseFile: File | any = [];
	file: File | any = [];
	public files: any = [];
	submitButtonDisabled = true;
	appealExplanation: any = '';
	selectedFile: File[] = [];
	fileUrl;
	appealCategory: any = [];
	checkcount: number = 0;
	appealRequest: FormGroup;
	brandAppeal: any = [];
	isLoading: boolean = false;
	brandAppealList: any = [];
	brandAppealFileList: any = [];
	Category: any = [];
	appealData: any;
	brandVettingAppeal: any = [];
	brandVetting_category: any;
	brandVetting_filename: any;
	brandVettingAppealFiles: any = [];
	brandVettingAppealKey: any;
	brandVettingAppealDetails: any;
	vettingevpId: any;
	brandEntityType: string = "";
	explanation: boolean = false;
	explanationvett: boolean = false;
	vettingDesc: any = [];
	VettingId: any = '';
	clickId: any = '';
	pdfURL: string;
	showForm: boolean;

	constructor(public data: NewCamapignService, public dialog: MatDialog, public router: Router, public fb: FormBuilder, private route: ActivatedRoute, private renderer: Renderer2, private _snackBar: MatSnackBar, public _http: HttpClient, protected userSerive: UsermanagementService) {
		super(data, router, fb);
		this.renderer.listen('window', 'click', (e: Event) => {
			if (this.menushow == true) {
				if (e.target !== this.toggleButton.nativeElement && e.target !== this.menu.nativeElement) {
					this.menushow = false;
				}
			}
		});

		this.renderer.listen('window', 'click', (e: any) => {
			if (this.clickId !== e.target.id) {
				this.brandsVetting.forEach(element => {
					if (element.vettingId == this.VettingId) {
						element['display'] = false;
					}
				});
			}
		});

		this.formcheck = this.fb.group({
			acceptTerms: false,
			Verify: false,
			Verify1: false,
			Verify2: false,
			Verify3: '',
			standardfile: '',
		});

		this.formcheck.valueChanges.subscribe(() => {
			this.submitButtonDisabled = !(
				this.formcheck.controls.acceptTerms.value ||
				this.formcheck.controls.Verify.value ||
				this.formcheck.controls.Verify1.value ||
				this.formcheck.controls.Verify2.value
			);
		});
	}
	viewEnhancedFile(data: any, type: any) {
		if (type == 'pdf') {
			const pdfModal = document.getElementById('modalPdfAppeal');
			let modalPdf = document.getElementById('modalPdf') as HTMLIFrameElement;
			modalPdf.src = data.filepath;
			$(pdfModal).modal('show');
		}
	}

	downloadEnhancedReporrt(e) {
		fetch(e.filepath).then(resp => resp.arrayBuffer()).then(resp => {
			const file = new Blob([resp], { type: 'application/pdf' });
			const fileURL = URL.createObjectURL(file);
			const link = document.createElement('a');
			link.href = fileURL;
			link.download = e.filepath.split('enhancedVettingReport/')[1];
			link.click();
		});
	}	

	ngOnInit(): void {
		this.menushow = false;
		this.menushowvetting1 = false;
		this.menushowvetting2 = false;
		this.menushowvetting = false;
		let session$ = sessionStorage.getItem("isLoggedIn");
		let session = JSON.parse(session$);
		this.userType = session.type;

		this.updateVettingForStatus();


		this.campLen = '';
		this.taxExemptStatus = "";
		this.campaignFilter = this.fb.group({
			usecase: [''],
			description: [],
			campaignId: []
		})

		const urlRegex = /^(?:http(s)?:\/\/)?[\w.-]+(?:\.[\w\.-]+)+[\w\-\._~:/?#[\]@!\$&'\(\)\*\+,;=.]+$/;
		this.companyDetails = this.fb.group({
			displayName: ['', [Validators.required]],
			entityType: ['', [Validators.required]],
			ein: [''],
			einIssuingCountry: [''],
			altBusinessIdType: [''],
			altBusinessId: [''],
			street: ['', [Validators.required]],
			city: ['', [Validators.required]],
			state: ['', [Validators.required]],
			postalCode: ['', [Validators.required]],
			country: ['', [Validators.required]],
			website: ['', [Validators.pattern(urlRegex)]],
			stockSymbol: [''],
			stockExchange: [''],
			vertical: ['', [Validators.required]],
			referenceId: [''],
			firstName: [''],
			lastName: [''],
			mobilePhone: ['']
		});

		this.Company = this.fb.group({
			companyName: ['', [Validators.required]]
		});

		this.ContactDetails = this.fb.group({
			email: ['', [Validators.required, Validators.pattern("^([A-Za-z0-9._%+-]+)@([A-Za-z0-9-]+\\.[A-Za-z]{2,4})(\\.[A-Za-z]{2,4})?$")]],
			phone: ['', [Validators.required, Validators.minLength(10), Validators.maxLength(11)]]
		});
		this.appealRequest = this.fb.group({
			taxid: new FormControl(false),
			nonProfit: new FormControl(false),
			government: new FormControl(false),
			explanationInput: new FormControl(''),
			fileInput: new FormControl('')
		});
		// my data
		this.data.getBrands().subscribe(res => {
			this.brandDetails = res[0].form_company_details1;
			this.brandPolitical = res[0].political;
		});

		this.data.getlegalOrg().subscribe(res => {
			this.Organization = res[0].legal_org;
		});
		this.data.stock_Exchange().subscribe(res => {
			this.stockexchange = res.data;
		});

		this.data.altBusinessIdType().subscribe(res => {
			//this.altBusinessIdType = res.data;
			this.altBusinessIdType = res.data.slice(1, 4);
		});

		this.country = [
			{ value: "US", name: "US" },
			{ value: "CA", name: "Canada" }
		]

		// if (this.brandData.country == "US") {
		// 	this.data.US_State().subscribe(res => {
		// 		this.States = res[0].US_State;
		// 	});
		// }
		// else {
		// this.data.CA_State().subscribe(res => {
		// 	this.States = res[0].CA_State;
		// 	console.log("canada",this.States);

		// });
		// }

		this.data.brandVertical().subscribe(res => {
			let tmp: any = [];
			Object.entries(res.data).forEach((ele: any) => {
				let t = ele[1];
				t["name"] = ele[0];
				tmp.push(t);
			});
			this.brandVertical = tmp;
		});

		this.applyVettingForm = this.fb.group({
			brandId: ['', [Validators.required]],
			vettingClass: ['', [Validators.required]],
			evpId: ['', [Validators.required]],
			price: [''],
			additionalRequestPayload: [''],
		});

		this.applyVettingFormPolitical = this.fb.group({
			displayName: [''],
			ein: [''],
			website: [''],
			street: [''],
			city: [''],
			state: [''],
			postalCode: [''],
			requestorFirstName: ['', [Validators.required]],
			requestorLastName: ['', [Validators.required]],
			phone: [''],
			email: [''],
			locale: ['', [Validators.required]],
			fecCommitteeTypeCode: [''],
			committeeId: ['', [Validators.required]],
			candidateType: ['', [Validators.required]],
			stateLocalCommitteeType: [''],
			localCommitteeState: [''],
			localCommitteeMunicipality: ['', [Validators.required]],
			tribalLocation: [''],
			filingUrl: ['', [Validators.required]],
			filingRecordUrlInstructions: [''],
			electionDate: [''],
			pinPreference: ['', [Validators.required]],
			filingemail: ['']
		});

		this.importVettingForm = this.fb.group({
			brandId: ['', [Validators.required]],
			evpId: ['', [Validators.required]],
			vettingId: ['', [Validators.required]],
			vettingToken: ['']
		});
		this.data.brandVettingClass().subscribe(res => {
			this.vettingClass = res.data.slice().reverse();
			this.vettingClass.forEach(element => {
				this.vtngClass.push({ "vettingClass": element.id, "displayName": element.displayName });
			});
		});

		this.data.brandVettingProvider().subscribe(res => {
			this.vettingProvider = res.data;
		});

		this.route.paramMap.subscribe((params: ParamMap) => {
			let data = params.get("brandId").split("-");
			this.brandId = data[0];
			this.iduser = data[1];
			this.cnpStatus = data[2];

		});


		if (this.cnpStatus == '1') {
			this.hideEdit = false;
		}
		else {
			this.hideEdit = true;
		}
		// get useCases
		this.data.getuseCases().subscribe(res => {
			this.useCase = res.data;
		});
		// list of brand's campaign
		this.brandsCampaign();
		this.getBrandRelationship();
		// detail of brand
		this.brandsDetail();
		this.getBrandAppeals();
		this.getBrandVettingAppealsInfo();

		this.data.getlocaldata().subscribe(res => {
			this.localdata = res[0].locale;
		});
		this.data.getpinPreference().subscribe(res => {
			this.pinPreference = res[0].pinPreference;
		});
		this.data.getfecCommitteeTypeCode().subscribe(res => {
			this.getfecCommitteeTypeCode = res[0].fecCommitteeTypeCode;
		});

		this.data.US_State().subscribe(res => {
			this.us_States = res[0].US_State;
		});
	}

	getBrandRelationship() {
		this.data.brandRelationship().subscribe(res => {
			if (res.status == 200) {
				this.brandRelationship = res.data;
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				});
			}
		});
	}

	getBrandAppeals() {
		let payLoad = JSON.stringify({
			brandId: this.brandId,
			iduser: this.iduser
		});
		this.data.getBranAppeal(payLoad).subscribe(res => {
			if (res.status == 200) {
				this.brandAppeal = res.data;
				$('#basic-datatabless13').dataTable().fnClearTable();
				$('#basic-datatabless13').dataTable().fnDraw();
				$('#basic-datatabless13').dataTable().fnDestroy();
				$.getScript('./assets/table.js');
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				});
			}
		});
	}


	updateVettingForStatus() {
		let brandDatas = JSON.stringify({
			brandId: this.brandId,
			iduser: this.iduser
		});

		this.data.updateVetting(brandDatas).subscribe(res => {
			if (res.status == 200) {
				this.setData(this.brandId, this.iduser);
			}
		});
	}
	brandsCampaign() {
		let brandData = JSON.stringify({
			brandId: this.brandId,
			iduser: this.iduser
		});
		$('#basic-datatables15').DataTable().clear();
		$('#basic-datatables15').DataTable().destroy();
		this.data.getCampaign(brandData).subscribe(res => {
			this.campaign = res.data;
			this.campLen = this.campaign.length
			$.getScript('./assets/table.js');
		})
	}
	brandsDetail() {
		let brandData = JSON.stringify({
			brandId: this.brandId,
			iduser: this.iduser
		});

		this.data.getBrandsDetail(brandData).subscribe(res => {
			this.brandData = res.data[0];
			if (this.brandData.altBusinessIdType && this.brandData.altBusinessIdType !== 'undefined' && this.brandData.altBusinessIdType !== 'null' && this.brandData.altBusinessIdType !== 'NONE') {
				this.BusinessIdType = this.brandData.altBusinessIdType;
			}
			else {
				this.BusinessIdType = '';
			}
			if (this.brandData.altBusinessId && this.brandData.altBusinessId !== 'undefined' && this.brandData.altBusinessId !== 'null' && this.brandData.altBusinessId !== 'string') {
				this.altBusinessId = this.brandData.altBusinessId;
			}
			else {
				this.altBusinessId = ''
			}

			if (this.brandData.entityType == 'SOLE_PROPRIETOR') {
				this.hideEditBtn = false;
				this.brandEntityType = "Sole Proprietor";
			}
			else if (this.brandData.entityType == 'PUBLIC_PROFIT') {
				this.brandEntityType = "Publicly Traded Company"
			}
			else if (this.brandData.entityType == 'PRIVATE_PROFIT') {
				this.brandEntityType = "Private Company";
			}
			else if (this.brandData.entityType == 'NON_PROFIT') {
				this.brandEntityType = "Non-Profit Organization";
			}
			else if (this.brandData.entityType == 'GOVERNMENT') {
				this.brandEntityType = "Government";
			}

			if (res.data.length > 0) {
				this.Solepop2 = true;
			}
			else {
				this.Solepop2 = false;
			}

			if (this.brandData.identityStatus == "" || this.brandData.identityStatus == null || this.brandData.identityStatus == 'PENDING') {
				this.DotDisable = true;
			}
			else {
				this.DotDisable = false;
			}

			if (this.brandData.identityStatus == 'UNVERIFIED' && this.brandData.entityType !== 'SOLE_PROPRIETOR') {
				this.idstatUnvryfied = true;
				this.Identitystatus();
			}
			if (this.brandData.entityType == 'SOLE_PROPRIETOR' && (!this.brandData.identityStatus || this.brandData.identityStatus == undefined || this.brandData.identityStatus == 'SELF_DECLARED')) {
				this.Solepop = true;
			}
			else {
				this.Solepop = false;
			}

			if (this.brandData == 'undefined' || this.brandData == '' || !this.brandData) {
				this.router.navigate(['/new-campaign/brand']);
			}
			this.entityType = this.brandData.entityType;

			if (this.brandData.entityType == 'SOLE_PROPRIETOR') {
				this.disappeared = true;
				this.flname = false;

				this.brandDetails.forEach(element => {
					if (element.ID == "taxId" || element.ID == "tax" || element.ID == "vertical") {
						let removeV: any = this.companyDetails.get(element.formControl);
						removeV.setValidators([]);
						removeV.updateValueAndValidity();
					}
					if (element.ID == "firstname" || element.ID == "lastname") {
						let flname: any = this.companyDetails.get(element.formControl);
						flname.setValidators([Validators.required]);
						flname.updateValueAndValidity();
					}
					if (element.ID == "MobilePhone") {
						let mobileno: any = this.companyDetails.get('mobilePhone');
						mobileno.setValidators([Validators.required, Validators.minLength(10), Validators.maxLength(11)]);
						mobileno.updateValueAndValidity();
					}
					if (element.ID == "refer") {
						let mobileno: any = this.companyDetails.get('referenceId');
						mobileno.setValidators([Validators.required]);
						mobileno.updateValueAndValidity();
					}
				});
			}
			else {
				this.disappeared = false;
				this.flname = true;

				this.brandDetails.forEach(element => {
					if (element.ID == "tax" || element.ID == "vertical") {
						let addV: any = this.companyDetails.get(element.formControl);
						addV.setValidators([Validators.required]);
						addV.updateValueAndValidity();
					}
					if (element.ID == "taxId") {
						let ein1: any = this.companyDetails.get('ein');
						ein1.setValidators([Validators.required, Validators.minLength(9), Validators.maxLength(9)]);
						ein1.updateValueAndValidity();
					}
					if (element.ID == "firstname" || element.ID == "lastname" || element.ID == "MobilePhone") {
						let fname: any = this.companyDetails.get(element.formControl);
						fname.setValidators([]);
						fname.updateValueAndValidity();
					}
					if (element.ID == "refer") {
						let mobileno: any = this.companyDetails.get('referenceId');
						mobileno.setValidators([]);
						mobileno.updateValueAndValidity();
					}
				})
			}

			/**
			* Vetting start
			*/
			this.getVettingCondition(this.brandData.entityType);
			this.setData(this.brandData.brandId, this.brandData.iduser);
			this.CompanyDetails();
			this.setContact();
			this.applyVettingPolitical();
			this.preDisableCompanydetails();
			this.changeCountry('');

			// this.brandrel = this.brandData.brand_relation
			// $('#' + this.brandrel).css('border', '2px solid #1269db', 'width', '50px');
			if (this.brandData.entityType == "GOVERNMENT") {
				this.Government = "True";
			}
			else {
				this.Government = "N/A";
			}

			//this.chosenDun =
			//this.taxExemptStatus = this.brandData.optionalAttributes == undefined ? 'N/A' : this.brandData.optionalAttributes == '{}' ? 'N/A' :JSON.parse(this.brandData.optionalAttributes).taxExemptStatus; 
			this.taxExemptStatus = this.brandData.optionalAttributes && JSON.parse(this.brandData.optionalAttributes).taxExemptStatus ? JSON.parse(this.brandData.optionalAttributes).taxExemptStatus : 'N/A';

		})
	}
	getBrandsDetail(brands: any) {
		this.router.navigate(['/new-campaign/register_campaign/' + this.brandData.brandId + '-' + this.brandData.iduser + '-' + this.brandData.brand_name.split(" ").join("_")])
	}

	Identitystatus() {
		this.data.getBrandFeedback(this.brandData.brandId).subscribe(res => {
			if (res.status == 200) {
				this.statusError = res.data.category[0].description;
				// console.log("feed",this.statusError);
			}
		})
	}

	showErr() {
		if (this.identitystatus == false) {
			this.identitystatus = true;
		}
		else {
			this.identitystatus = false
		}

	}

	filtershow() {
		if (this.show == false) {
			this.show = true;
		}
		else {
			this.show = false;
		}

	}

	showmenu() {
		this.menushow = !this.menushow;
	}

	showmenuVetting(vettingId: any, Id: any) {
		this.clickId = Id;
		this.VettingId = vettingId;
		this.brandsVetting.forEach(element => {
			if (element.vettingId == vettingId) {
				element['display'] = true;
			}
			else {
				element['display'] = false;
			}
		});
	}

	applyVettingPolitical() {
		this.currentDate = new Date();
		this.newDate = formatDate(this.currentDate, 'dd-MM-yyyy', 'en-US');
		this.applyVettingFormPolitical.patchValue({
			'displayName': this.brandData.brand_name,
			'ein': this.brandData.ein,
			'website': this.brandData.website,
			'street': this.brandData.address,
			'city': this.brandData.city,
			'state': this.brandData.state,
			'postalCode': this.brandData.postal_code,
			'requestorFirstName': this.brandData.firstName,
			'requestorLastName': this.brandData.lastName !== 'undefined' ? this.brandData.lastName : '',
			'phone': this.brandData.phone,
			'email': this.brandData.email,
			'localCommitteeState': this.brandData.state,
			'tribalLocation': this.brandData.country,
			'electionDate': this.newDate,
		});
	}
	// my fun
	CompanyDetails() {
		this.companyDetails.patchValue({
			'displayName': this.brandData.brand_name && this.brandData.brand_name !== "undefined" && this.brandData.brand_name !== undefined && this.brandData.brand_name !== "null" && this.brandData.brand_name !== null ? this.brandData.brand_name : '',
			'entityType': this.brandData.entityType && this.brandData.entityType !== "undefined" && this.brandData.entityType !== undefined && this.brandData.entityType !== "null" && this.brandData.entityType !== null ? this.brandData.entityType : '',
			'ein': this.brandData.ein && this.brandData.ein !== "undefined" && this.brandData.ein !== undefined && this.brandData.ein !== "null" && this.brandData.ein !== null ? this.brandData.ein : '',
			'einIssuingCountry': this.brandData.einIssuingCountry && this.brandData.einIssuingCountry !== "undefined" && this.brandData.einIssuingCountry !== undefined && this.brandData.einIssuingCountry !== "null" && this.brandData.einIssuingCountry !== null ? this.brandData.einIssuingCountry : '',
			'altBusinessId': this.brandData.altBusinessId && this.brandData.altBusinessId !== "undefined" && this.brandData.altBusinessId !== undefined && this.brandData.altBusinessId !== "null" && this.brandData.altBusinessId !== null ? this.brandData.altBusinessId : '',
			'altBusinessIdType': this.brandData.altBusinessIdType && this.brandData.altBusinessIdType !== "undefined" && this.brandData.altBusinessIdType !== undefined && this.brandData.altBusinessIdType !== "null" && this.brandData.altBusinessIdType !== null ? this.brandData.altBusinessIdType : '',
			'street': this.brandData.address && this.brandData.address !== "undefined" && this.brandData.address !== undefined && this.brandData.address !== "null" && this.brandData.address !== null ? this.brandData.address : '',
			'city': this.brandData.city && this.brandData.city !== " undefined" && this.brandData.city !== undefined && this.brandData.city !== "null" && this.brandData.city !== null ? this.brandData.city : '',
			'state': this.brandData.state,
			'postalCode': this.brandData.postal_code,
			'country': this.brandData.country,
			'website': this.brandData.website && this.brandData.website !== undefined && this.brandData.website !== "undefined" && this.brandData.website !== null && this.brandData.website !== "null" ? this.brandData.website : '',
			'stockSymbol': this.brandData.stockSymbol && this.brandData.stockSymbol !== "undefined" && this.brandData.stockSymbol !== undefined && this.brandData.stockSymbol !== "null" && this.brandData.stockSymbol !== null ? this.brandData.stockSymbol : '',
			'stockExchange': this.brandData.stockExchange && this.brandData.stockExchange !== "undefined" && this.brandData.stockExchange !== undefined && this.brandData.stockExchange !== "null" && this.brandData.stockExchange !== null ? this.brandData.stockExchange : '',
			'vertical': this.brandData.vertical_type && this.brandData.vertical_type !== "undefined" && this.brandData.vertical_type !== undefined && this.brandData.vertical_type !== "null" && this.brandData.vertical_type !== null ? this.brandData.vertical_type : '',
			'referenceId': this.brandData.referenceId && this.brandData.referenceId !== "undefined" && this.brandData.referenceId !== undefined && this.brandData.referenceId !== "null" && this.brandData.referenceId !== null ? this.brandData.referenceId : '',
			'firstName': this.brandData.firstName && this.brandData.firstName !== "undefined" && this.brandData.firstName !== undefined && this.brandData.firstName !== 'null' && this.brandData.firstName !== null ? this.brandData.firstName : '',
			'lastName': this.brandData.lastName && this.brandData.lastName !== "undefined" && this.brandData.lastName !== undefined && this.brandData.lastName !== 'null' && this.brandData.lastName !== null ? this.brandData.lastName : '',
			'mobilePhone': this.brandData.mobilePhone && this.brandData.mobilePhone !== "undefined" && this.brandData.mobilePhone !== undefined && this.brandData.mobilePhone !== "null" && this.brandData.mobilePhone !== null ? this.brandData.mobilePhone.split("+").join('') : ''
		});

		// this.ContactDetails.patchValue({ test
		// 	'email': this.brandData.email,
		// 	'phone': this.brandData.phone,
		// })
		// this.Company.patchValue({
		// 	companyName: this.brandData.company_name
		// })
		// this.mainForm.patchValue({
		// 	brandRelship: this.brandData.brand_relation,
		// })

		if (this.brandData.country == "US") {
			this.data.US_State().subscribe(res => {
				this.States = res[0].US_State;
			});
		}
		else {
			this.data.CA_State().subscribe(res => {
				this.States = res[0].CA_State;
			});
		}
	}
	OnSelectOrg() {
		if (this.chosenOrg == 'PUBLIC_PROFIT') {
			this.brandDetails.forEach(element => {
				if (element.ID == "stockex") {
					element.disable = 'false';
					this.companyDetails.controls["stockExchange"].setValidators([Validators.required]);
					this.companyDetails.patchValue({
						'stockExchange': this.brandData.stockExchange !== 'undefined' ? this.brandData.stockExchange : ''
					})
				}
				if (element.ID == "stock") {
					// element.readonly = false;
					this.companyDetails.get(element.formControl).enable();
					this.companyDetails.controls["stockSymbol"].setValidators([Validators.required,Validators.maxLength(10)]);
					this.companyDetails.patchValue({
						'stockSymbol': this.brandData.stockSymbol !== 'undefined' ? this.brandData.stockSymbol : ''
					})
				}
				if (element.ID == "entityType") {
					this.companyDetails.get(element.formControl).enable();
				}

				if (element.ID === "companyName" || element.ID == "displayName" || element.ID == "entityType" || element.ID == "countryreg" || element.ID == "taxId" || element.ID == "address" || element.ID == "city" || element.ID == "selectedState" || element.ID == "post" || element.ID == "vertical" || element.ID == "stock" || element.ID == "stockex") {
					if (element.label.indexOf("*") == -1) {
						element.label = element.label + ' *';
					}
				}
				else {
					if (element.label.indexOf("*") != -1) {
						element.label = element.label.slice(0, -1)
					}
				}

			});
		}
		else if (this.chosenOrg == 'NON_PROFIT' || this.chosenOrg == 'GOVERNMENT' || this.chosenOrg == 'PRIVATE_PROFIT') {
			if (this.chosenOrg == 'GOVERNMENT') {
				this.companyDetails.patchValue({
					country: "US",
					einIssuingCountry: "US"
				})
				this.data.US_State().subscribe(res => {
					this.States = res[0].US_State;
				});
			}
			this.brandDetails.forEach(element => {
				if (element.ID == "stockex") {
					element.disable = 'true';
					this.companyDetails.controls["stockExchange"].setValidators([]);
					this.companyDetails.patchValue({
						'stockExchange': ''
					})
				}
				if (element.ID == "stock") {
					// element.readonly = true;
					this.companyDetails.get(element.formControl).disable();
					this.companyDetails.controls["stockSymbol"].setValidators([]);
					this.companyDetails.patchValue({
						'stockSymbol': ''
					})
				}
				if (element.ID == "entityType") {
					this.companyDetails.get(element.formControl).enable();
				}

				if (element.ID === "companyName" || element.ID == "displayName" || element.ID == "entityType" || element.ID == "countryreg" || element.ID == "taxId" || element.ID == "address" || element.ID == "city" || element.ID == "selectedState" || element.ID == "post" || element.ID == "vertical") {
					if (element.label.indexOf("*") == -1) {
						element.label = element.label + ' *';
					}
				}
				else {
					if (element.label.indexOf("*") != -1) {
						element.label = element.label.slice(0, -1)
					}
				}
			});
		}
		else if (this.chosenOrg == 'SOLE_PROPRIETOR') {
			this.brandDetails.forEach(element => {
				if (element.ID == "stockex") {
					element.disable = 'true';
					this.companyDetails.controls["stockExchange"].setValidators([]);
					this.companyDetails.patchValue({
						'stockExchange': ''
					})
				}
				if (element.ID == "stock") {
					// element.readonly = true;
					this.companyDetails.get(element.formControl).disable();
					this.companyDetails.controls["stockSymbol"].setValidators([]);
					this.companyDetails.patchValue({
						'stockSymbol': ''
					})
				}
				if (element.ID == "entityType") {
					this.companyDetails.get(element.formControl).disable();
				}

				if (element.ID === "refer" || element.ID == "firstname" || element.ID == "lastname" || element.ID == "displayName" || element.ID == "entityType" || element.ID == "countryreg" || element.ID == "city" || element.ID == "selectedState" || element.ID == "post" || element.ID == "address") {
					if (element.label.indexOf("*") == -1) {
						element.label = element.label + ' *';
					}
				}
				else {
					if (element.label.indexOf("*") != -1) {
						element.label = element.label.slice(0, -1)
					}
				}
			});
		}
	}

	// previous disable company details form field
	preDisableCompanydetails() {
		// this.companyDetails.get("altBusinessId").disable();
		// this.companyDetails.get("referenceId").disable();
	}

	changeNumber() {
		this.brandDetails.forEach(element => {
			if (element.ID == "dunsnumber") {
				let Duns1: any = this.companyDetails.get(element.formControl);
				Duns1.setValidators([Validators.maxLength(50)]);
				Duns1.updateValueAndValidity();
			}
			if (this.chosenDun == 'DUNS') {
				if (element.ID == "dunsnumber") {
					element.label = 'DUNS Number';
					this.companyDetails.get(element.formControl).enable();
					// this.chosenDunLimit = 9;
					// let Duns1: any = this.companyDetails.get(element.formControl);
					// Duns1.setValidators([Validators.maxLength(9), Validators.minLength(9)]);
					// Duns1.updateValueAndValidity();
				}
			}
			else if (this.chosenDun == 'GIIN') {
				if (element.ID == "dunsnumber") {
					element.label = 'GIIN Number';
					this.companyDetails.get(element.formControl).enable();
					// this.chosenDunLimit = 19;
					// let Giin1: any = this.companyDetails.get(element.formControl);
					// Giin1.setValidators([Validators.required, Validators.maxLength(19), Validators.minLength(19)]);
					// Giin1.updateValueAndValidity();
				}
			}
			else if (this.chosenDun == 'LEI') {
				if (element.ID == "dunsnumber") {
					element.label = 'LEI Number';
					this.companyDetails.get(element.formControl).enable();
					// this.chosenDunLimit = 20;
					// let Lei1: any = this.companyDetails.get(element.formControl);
					// Lei1.setValidators([Validators.required, Validators.maxLength(20), Validators.minLength(20)]);
					// Lei1.updateValueAndValidity();
				}
			}
			else if (this.chosenDun == 'NONE') {
				if (element.ID == "dunsnumber") {
					element.label = 'NONE';
				}
			}
			else {
				if (element.ID == "dunsnumber") {
					element.label = 'DUNS or GIIN or LEI Number';
				}
			}
		});
	}

	changeCountry(event: any) {
		if (this.brandData.entityType != 'SOLE_PROPRIETOR') {
			this.companyDetails.patchValue({
				'einIssuingCountry': this.chosenOPT
			})
		}
		if (event.value) {
			this.submitted = true;
			this.States = [''];
			this.companyDetails.patchValue({
				state: '',
				ein: '',
				postalCode: '',
				city: '',
				street: ''
			});
		}
		if (this.chosenOPT == "US") {
			this.zipLength = 5;
			this.data.US_State().subscribe(res => {
				this.States = res[0].US_State;
			});

			this.brandDetails.forEach(element => {
				if (this.chosenOrg !== 'SOLE_PROPRIETOR') {
					if (element.ID == "taxId") {
						if (element.label.indexOf("*") == -1) {
							element.label = "EIN" + ' *';
						}
						else {
							element.label = "EIN" + ' *';
						}
					}
					if (element.ID == "tax") {
						if (element.label.indexOf("*") == -1) {
							element.label = "EIN Issuing Country" + ' *';
						}
						else {
							element.label = "EIN Issuing Country" + ' *';
						}
					}
				}
				else {
					if (element.ID == "taxId") {
						element.label = "Tax Number/ID/EIN";
					}
					if (element.ID == "tax") {
						element.label = "Tax Number/ID/EIN Issuing Country";
					}
				}
				if (element.ID == "selectedState") {
					if (element.label.indexOf("*") == -1) {
						element.label = "State" + ' *';
					}
					else {
						element.label = "State" + ' *';
					}
				}
				if (element.ID == "post") {
					if (element.label.indexOf("*") == -1) {
						element.label = "Zip Code" + ' *';
					}
					else {
						element.label = "Zip Code" + ' *';
					}
				}
			});
		}
		else if (this.chosenOPT == "CA") {
			this.zipLength = 7;
			this.data.CA_State().subscribe(res => {
				this.States = res[0].CA_State;
			});

			this.brandDetails.forEach(element => {
				if (element.ID == "taxId") {
					if (element.label.indexOf("*") == -1) {
						element.label = "Tax Number/ID/EIN" + ' *';
					}
					else {
						element.label = "Tax Number/ID/EIN" + ' *';
					}
				}
				if (element.ID == "tax") {
					if (element.label.indexOf("*") == -1) {
						element.label = "Tax Number/ID Issuing Country" + ' *';
					}
					else {
						element.label = "Tax Number/ID Issuing Country" + ' *';
					}
				}
				if (element.ID == "selectedState") {
					if (element.label.indexOf("*") == -1) {
						element.label = "State/Region" + ' *';
					}
					else {
						element.label = "State/Region" + ' *';
					}
				}
				if (element.ID == "post") {
					if (element.label.indexOf("*") == -1) {
						element.label = "Postal Code" + ' *';
					}
					else {
						element.label = "Postal Code" + ' *';
					}
				}
			});
		}
		this.PostalCode('');
	}

	PostalCode(event: any): boolean {
		this.zipLength = '';
		if (this.chosenOPT == "CA") {
			this.zipLength = 10;
			let Post: any = this.companyDetails.get("postalCode");
			Post.setValidators([Validators.required, Validators.maxLength(this.zipLength)]);
			Post.updateValueAndValidity();

			//   var regex = new RegExp("^[0-9a-zA-Z \b]+$");
			//   var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
			//   if (!regex.test(key)) {
			// 	// event.preventDefault();
			// 	return false;
			//   }
		}
		if (this.chosenOPT == "US") {
			this.zipLength = 5;
			let Post: any = this.companyDetails.get("postalCode");
			Post.setValidators([Validators.required, Validators.minLength(this.zipLength), Validators.maxLength(this.zipLength)]);
			Post.updateValueAndValidity();

			const charCode = (event.which) ? event.which : event.keyCode;
			if (charCode > 31 && (charCode < 48 || charCode > 57)) {
				return false;
			}
			return true;
		}
	}

	taxeinID(evt: any) {
		if (this.chosenOPT == "US") {
			var charCode = (evt.which) ? evt.which : evt.keyCode;
			if (charCode != 45 && charCode > 31 && (charCode < 48 || charCode > 57))
				return false;

			return true;
		}
		if (this.chosenOPT == "CA") {
			var charCode = (evt.which) ? evt.which : evt.keyCode;
			if (charCode != 45 && charCode > 31 && (charCode < 48 || charCode > 57) && (charCode < 65 || charCode > 90))
				return false;

			return true;
		}
	}

	mainSubmit(Formname: any) {
		if (this.companyDetails.value.entityType == "PRIVATE_PROFIT" || this.companyDetails.value.entityType == "NON_PROFIT" || this.companyDetails.value.entityType == "GOVERNMENT") {
			this.mainForm = this.fb.group({
				displayName: this.companyDetails.value.displayName,
				entityType: this.companyDetails.value.entityType,
				ein: this.companyDetails.value.ein,
				einIssuingCountry: this.companyDetails.value.einIssuingCountry,
				altBusinessId: this.companyDetails.value.altBusinessId,
				altBusinessIdType: this.companyDetails.value.altBusinessIdType ? this.companyDetails.value.altBusinessIdType : "NONE",
				street: this.companyDetails.value.street,
				city: this.companyDetails.value.city,
				state: this.companyDetails.value.state,
				postalCode: this.companyDetails.value.postalCode,
				country: this.companyDetails.value.country,
				website: this.companyDetails.value.website,
				vertical: this.companyDetails.value.vertical,
				referenceId: this.companyDetails.value.referenceId,
				email: this.ContactDetails.value.email,
				phone: this.ContactDetails.value.phone
			});
			if (Formname == "company") {
				this.mainForm.addControl('companyName', new FormControl(this.Company.value.companyName));
			}
		}
		else if (this.companyDetails.value.entityType == "PUBLIC_PROFIT") {
			this.mainForm = this.fb.group({
				displayName: this.companyDetails.value.displayName,
				entityType: this.companyDetails.value.entityType,
				ein: this.companyDetails.value.ein,
				einIssuingCountry: this.companyDetails.value.einIssuingCountry,
				altBusinessId: this.companyDetails.value.altBusinessId,
				altBusinessIdType: this.companyDetails.value.altBusinessIdType ? this.companyDetails.value.altBusinessIdType : "NONE",
				street: this.companyDetails.value.street,
				city: this.companyDetails.value.city,
				state: this.companyDetails.value.state,
				postalCode: this.companyDetails.value.postalCode,
				country: this.companyDetails.value.country,
				website: this.companyDetails.value.website,
				stockSymbol: this.companyDetails.value.stockSymbol,
				stockExchange: this.companyDetails.value.stockExchange,
				vertical: this.companyDetails.value.vertical,
				referenceId: this.companyDetails.value.referenceId,
				email: this.ContactDetails.value.email,
				phone: this.ContactDetails.value.phone
			});
			if (Formname == "company") {
				this.mainForm.addControl('companyName', new FormControl(this.Company.value.companyName));
			}
		}
		else {
			this.mainForm = this.fb.group({
				// company details
				displayName: this.companyDetails.value.displayName,
				entityType: this.companyDetails.value.entityType,
				ein: this.companyDetails.value.ein,
				einIssuingCountry: this.companyDetails.value.einIssuingCountry,
				// altBusinessId: this.companyDetails.value.altBusinessId,
				// altBusinessIdType: this.companyDetails.value.altBusinessIdType,
				street: this.companyDetails.value.street,
				city: this.companyDetails.value.city,
				state: this.companyDetails.value.state,
				postalCode: this.companyDetails.value.postalCode,
				country: this.companyDetails.value.country,
				website: this.companyDetails.value.website,
				// stockSymbol: this.companyDetails.value.stockSymbol,
				// stockExchange: this.companyDetails.value.stockExchange,
				vertical: this.companyDetails.value.vertical,
				mobilePhone: this.companyDetails.value.mobilePhone,
				referenceId: this.companyDetails.value.referenceId,
				// brandRelationship: this.brandrel,
				// contact details
				email: this.ContactDetails.value.email,
				phone: this.ContactDetails.value.phone,
				//company edit
				// companyName: this.Company.value.companyName,
				firstName: this.companyDetails.value.firstName,
				lastName: this.companyDetails.value.lastName,
				ipAddress: this.brandData.ipAddress,
			});
		}
		let payLoad: any = JSON.stringify({
			brandId: this.brandId,
			iduser: this.iduser,
			mainData: this.mainForm.value
		});
		if (Formname == "companyDetails" || Formname == "contact" || Formname == "company" || Formname == "companyContact") {
			if (Formname == "companyDetails") {
				if (this.companyDetails.invalid) {
					this.submitted = true;
					this.Formvalid = false;
					return false;
				}
				else {
					this.Formvalid = true;
				}
			}
			else if (Formname == "contact") {
				if (this.ContactDetails.invalid) {
					this.submitted = true;
					this.Formvalid = false;
					return false;
				}
				else {
					this.Formvalid = true;
				}
			}
			else if (Formname == "company") {
				if (this.Company.invalid) {
					this.Formvalid = false;
					this.submitted = true;
					return false;
				}
				else {
					this.Formvalid = true;
				}
			}
			else if (Formname == "companyContact") {
				if (this.companyDetails.invalid || this.ContactDetails.invalid) {
					this.submitted = true;
					this.Formvalid = false;
					return false;
				}
				else {
					this.Formvalid = true;
				}
			}
		}
		if (this.Formvalid == true) {
			this.data.editBrand(payLoad).subscribe(res => {
				if (res.status == 201) {
					this.responseMessage = res.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
					this.submitted = false;
					this.ngOnInit();
				} else {
					this.errMessage = res.message;
					this.CompanyDetails();
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
				document.getElementById("companyContact").click();
				document.getElementById("closeCompanyDetails").click();
				document.getElementById("exampleModalCenter").click();
				document.getElementById("exampleCenter").click();
			})
		}
	}


	addClick(ID: any) {
		$('#' + this.brandrel).css('border', '');
		if (ID) {
			this.brandrel = ID;
			if (this.getOldID != "") {
				$('#' + this.getOldID).css('border', '');
			}
			$('#' + ID).css('border', '2px solid #1269db');
			this.getOldID = ID;
		}

	}

	clickBrandRel() {
		this.brandrel = this.brandData.brand_relation
		$('#' + this.brandrel).css('border', '2px solid #1269db', 'width', '50px');
		$('#' + this.getOldID).css('border', '');
	}

	updateBrandTRelationship() {
		this.mainForm = this.fb.group({
			brandRelationship: this.brandrel,
		});
		let payLoad: any = JSON.stringify({
			brandId: this.brandId,
			iduser: this.iduser,
			mainData: this.mainForm.value
		});
		this.data.editBrand(payLoad).subscribe(res => {
			if (res.status == 201) {
				this.responseMessage = res.message;
				this.brandsDetail();
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			} else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		})
	}

	setContact() {
		this.ContactDetails.get('email').setValue(this.brandData.email);
		this.ContactDetails.get('phone').setValue(this.brandData.phone.replace(/[+]/g, ''));
	}
	setcmpny() {
		this.Company.get('companyName').setValue(this.brandData.company_name);
	}
	/** Vetting Functionality start */
	setData(brandId, iduser) {
		this.brandsVetting = [];
		this.brandId = brandId;
		this.iduser = iduser;
		let payLoad: any = JSON.stringify({
			brandId: this.brandId,
			iduser: this.iduser
		});
		this.brandsVettingList(payLoad);
		this.applyVettingForm.patchValue({
			brandId: brandId,
			price: '',
			evpId: '',
			vettingClass: ''
		})
		this.submittedaply = false;
		this.importVettingForm.patchValue({
			brandId: brandId,
			evpId: '',
			vettingId: '',
			vettingToken: ''
		})
		this.submittedimp = false;
		return true;
	}

	refreshVettingList() {
		let payLoad: any = JSON.stringify({
			brandId: this.brandId,
			iduser: this.iduser
		});
		this.brandVettingUpdateStatus(payLoad);
	}

	brandVettingUpdateStatus(payLoad) {
		this.data.updateVetting(payLoad).subscribe(result => {
			this.brandsVetting = [];
			if (result.status = 200) {
				this.brandsVettingList(payLoad);
			} else {
				this.brandsVettingList(payLoad);
			}

		});
	}

	brandsVettingList(payLoad) {
		this.data.getBrandVetting(payLoad).subscribe(result => {
			if (result.status == 200) {
				$('#basic-datatables16').DataTable().clear();
				$('#basic-datatables16').DataTable().destroy();
				$.getScript('./assets/table.js');
				this.brandsVetting = result.data;
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	getVettingCondition(entityType: any): any {

		this.entityType = entityType;
		let payLoad = JSON.stringify({
			entityType: entityType
		})
		this.data.getVettingClass(payLoad).subscribe(res => {
			if (res.status == 200) {
				this.vettingData = res.data;
				this.vettingData.forEach((element ,index) => {
					if(element.evpId == 'WMC' && this.brandData.country == 'CA'){
						this.vettingData.splice(index, 1);
					}
					if(element.vettingClass == "POLITICAL" && this.brandData.entityType == 'NON_PROFIT' && this.brandData.country == 'CA'){
						this.vettingData.splice(index, 1);
					}
				});
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}
	/**
	* It will apply a new vetting
	*/
	closeVericalForm() {
		this.applyVettingForm.get('vettingClass').reset();
		this.applyVettingForm.get('evpId').reset();
		this.submittedaply = false;
		this.vettingProviderOrPartner = [];
		this.vettingText = "";
		this.poli = '2';
		this.singleVetClass = "";
		this.singleVetProvider = "";
		this.showForm = false;
		setTimeout(() => this.showForm = true);
	}
	submitApplyVetting() {
		if ((this.brandData.entityType == 'NON_PROFIT' && this.brandData.einIssuingCountry == 'US' && this.singleVetClass == 'POLITICAL' && this.singleVetProvider == "AEGIS") || (this.brandData.entityType == 'SOLE_PROPRIETOR' && this.brandData.einIssuingCountry == 'US' &&
			this.singleVetClass == 'POLITICAL' && this.singleVetProvider == "AEGIS")) {

			let polVal = "{\"requestorFirstName\":\"" + this.applyVettingFormPolitical.value.requestorFirstName + "\",\"requestorLastName\":\"" + this.applyVettingFormPolitical.value.requestorLastName + "\",\"locale\":\"" + this.applyVettingFormPolitical.value.locale + "\",\"fecCommitteeTypeCode\":\"" + this.applyVettingFormPolitical.value.fecCommitteeTypeCode + "\",\"committeeId\":\"" + this.applyVettingFormPolitical.value.committeeId + "\",\"candidateType\":\"" + this.applyVettingFormPolitical.value.candidateType + "\",\"stateLocalCommitteeType\":\"" + this.applyVettingFormPolitical.value.stateLocalCommitteeType + "\",\"localCommitteeState\":\"" + this.applyVettingFormPolitical.value.localCommitteeState + "\",\"localCommitteeMunicipality\":\"" + this.applyVettingFormPolitical.value.localCommitteeMunicipality + "\",\"tribalLocation\":\"" + this.applyVettingFormPolitical.value.tribalLocation + "\",\"filingUrl\":\"" + this.applyVettingFormPolitical.value.filingUrl + "\",\"filingRecordUrlInstructions\":\"" + this.applyVettingFormPolitical.value.filingRecordUrlInstructions + "\",\"filingEmail\":\"" + this.applyVettingFormPolitical.value.filingemail + "\",\"electionDate\":\"" + this.applyVettingFormPolitical.value.electionDate + "\",\"pinPreference\":\"" + this.applyVettingFormPolitical.value.pinPreference.split('-')[0] + "\"}"
			this.applyVettingForm.patchValue({
				additionalRequestPayload: polVal
			});

			setTimeout(() => {
				$('#politicalmodal').modal('show');
			}, 2000);
			this.applayVetting();
			return true;
		} else {
			this.applayVetting();
			if(this.brandData.entityType == 'SOLE_PROPRIETOR'){
				this.openModal();
			}
		}
	}
	openModal(){
		if(this.applyVettingForm.valid){
			setTimeout(()=>{
				$('#vettCenter').modal('hide');
			    $('#solevetting').modal('show');
			},3000)
			this.applayVetting();
			return true;
		}
	}
	applayVetting(): any {
		if (this.applyVettingForm.invalid) {
			this.submittedaply = true;
			return false;
		}
		else {
			if ((this.brandData.entityType == 'NON_PROFIT' && this.brandData.einIssuingCountry == 'US' && this.singleVetClass == 'POLITICAL' && this.singleVetProvider == "AEGIS") || (this.brandData.entityType == 'SOLE_PROPRIETOR' && this.brandData.einIssuingCountry == 'US' &&
				this.singleVetClass == 'POLITICAL' && this.singleVetProvider == "AEGIS")) {
				this.applyVettingForm.patchValue({
					price: this.applyVettingFormPolitical.value.pinPreference.split('-')[1]
				});
			}

			this.data.applyNewVetting(this.applyVettingForm.value).subscribe(res => {
				if (res.status == 200) {
					this.applyVettingForm.reset();
					this.submittedaply = false
					this.responseMessage = res.message;
					document.getElementById("vettCenter").click();
					document.getElementById("politicalmodal").click();
					window.location.reload();
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, err => {
				this.errMessage = err.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			});
		}
	}
	getVettingProvider(event) {
		this.vetProvider.splice(0);
		this.vetProvider = [];
		this.applyVettingForm.patchValue({
			evpId: ''
		});
		this.entityType = this.entityType;
		this.singleVetClass = event.value;
		let payLoad = JSON.stringify({
			entityType: this.entityType,
			vettingClass: event.value
		})
		this.data.getVettingPartner(payLoad).subscribe(res => {
			if (res.status == 200) {
				this.vettingProviderOrPartner = res.data;
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
		this.vettingText = '';

		// this.vettingProvider.forEach(element => {
		// 	let VIN:string = element.vettingInstruction;
		// 	element.vettingClasses.find(res => {
		// 		if(event.value.toLowerCase() == res.toLowerCase()){
		// 			this.vetProvider.push({"evpId":element.evpId, "displayName":element.displayName, "tcrBillable":element.tcrBillable,"vettingInstruction":JSON.parse(VIN)});
		// 		}
		// 		if(event.value.toLowerCase() == 'political'){
		// 			this.applyVettingForm.patchValue({
		// 				additionalRequestPayload : "{\"requestorFirstName\":\"John\",\"requestorLastName\":\"Doe\",\"locale\":\"Federal\",\"fecCommitteeTypeCode\":\"Y\",\"committeeId\":\"00000\",\"candidateType\":\"City Mayor\",\"stateLocalCommitteeType\":\"State\",\"localCommitteeState\":\"NC\",\"localCommitteeMunicipality\":\"Some Locality\",\"tribalLocation\":\"US\",\"filingUrl\":\"https://sample.com\",\"filingRecordUrlInstructions\":\"Sample Instructions\",\"filingEmail\":\"contact@example.com\",\"electionDate\":\"2022-12-26\",\"pinPreference\":\"Express\"}"
		// 			});
		// 		}
		// 	});
		// 	this.vettingText = '';
		// });
	}

	getVettingPDetail(event) {
		this.vettingProviderOrPartner.find(element => {
			if (element.evpId.toLowerCase() == event.value.toLowerCase()) {

				this.applyVettingForm.patchValue({
					price: this.vettingText.price
				});
				this.singleVetProvider = event.value;
				let pp: any;
				if ((this.brandData.entityType == 'NON_PROFIT' && this.brandData.einIssuingCountry == 'US' &&
					this.singleVetClass == 'POLITICAL' && this.singleVetProvider == "AEGIS") || (this.brandData.entityType == 'SOLE_PROPRIETOR' && this.brandData.einIssuingCountry == 'US' &&
						this.singleVetClass == 'POLITICAL' && this.singleVetProvider == "AEGIS")) {
					this.poli = '1';
					pp = "$64 - $91.95";
				} else {
					this.poli = '2';
					pp = "$" + element.price
				}
				this.vettingText = { "price": pp, "time": element.waitTime };


			}
		});
		/*this.vettingProvider.find(element => {
			if(element.evpId.toLowerCase() == event.value.toLowerCase()){
				let VIN:string = element.vettingInstruction;
				let vin = JSON.parse(VIN);
				this.vettingText ={"price":vin.newVet.price.STANDARD,"time":vin.newVet.waitTime};
				this.applyVettingForm.patchValue({
					price:this.vettingText.price
				});
			}
		});*/
	}
	/**
	 * It will import a vetting
	 */
	closeForm() {
		document.getElementById("imovettCenter").click();
	}

	closeForm1() {
		this.submittedimp=false
		this.importVettingForm.get('evpId').reset();
		this.importVettingForm.get('vettingId').reset();
		this.importVettingForm.get('vettingToken').reset();
	}

	importVetting(): any {
		if (this.importVettingForm.invalid) {
			this.submittedimp = true;
			return false;
		}
		else {
			this.data.importVetting(this.importVettingForm.value).subscribe(res => {
				if (res.status == 200) {
					document.getElementById("imovettCenter").click();
					this.importVettingForm.reset();
					this.submittedimp = false
					this.responseMessage = res.message;
					setTimeout(() => {
						this.responseMessage = "";
						window.location.reload();
					}, 5000);

				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, err => {
				this.errMessage = err.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			});
		}
	}
	/** Vetting Functionality end */
	// vetting details list copy msg
	textMessageFunc(msgText) {
		navigator.clipboard.writeText(msgText);
		this.responseMessage = "Copied to Clipboard";
		setTimeout(() => {
			this.responseMessage = "";
		}, 5000);
	}
	showvettdetail(id: any, token: any, reasons: any) {
		this.vettingID = id;
		this.vettingTOKEN = token;
		if(reasons.endsWith("]") == true){
			this.vettingDesc = JSON.parse(reasons.split(','));
		}
		else{
			this.vettingDesc = reasons.split(',');
		}
	}

	showvettdetail1(id: any, token: any) {
		this.vettingID = id;
		this.vettingevpId = token;
	}
	/** delete new brand */
	DeleteNewBrand() {
		this.data.DeleteNewBrand(this.brandId).subscribe(res => {
			if (res.status == 201) {
				this.bDstatus = 1;
				this.responseMessage = res.message;
				setTimeout(() => {
					document.getElementById("closeBrandModal").click();
					this.responseMessage = "";
					this.router.navigate(['new-campaign/brand']);
				}, 3000);
			}
			else {
				this.bDstatus = 0;
				this.errMessage = res.message;
				setTimeout(() => {
					document.getElementById("closeBrandModal").click();
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	resubmitBrand() {
		let resubmitBrandId = JSON.stringify({
			brandId: this.brandId,
			iduser: this.iduser
		});
		this.data.resubmitBrand(resubmitBrandId).subscribe(res => {
			if (res.status == 200) {
				this.bResStatus = 1;
				this.responseMessage = res.message;
				setTimeout(() => {
					document.getElementById("closeBrandResubmitModal").click();
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.bResStatus = 0;
				this.errMessage = res.message;
				setTimeout(() => {
					document.getElementById("closeBrandResubmitModal").click();
					this.errMessage = "";
				}, 5000);
			}
		})
	}

	campaignFiter() {
			const { usecase, description, campaignId } = this.campaignFilter.value;
			if (usecase || description !== null || campaignId !== null) {
				let payload: any = JSON.stringify({
					brandId: this.brandId,
					iduser: this.iduser,
					companyFilter: this.campaignFilter.value
				});	  
				this.data.campaignFilter(payload).subscribe(res => {
					if (res.status == 200) {
					$('#basic-datatables15').DataTable().clear();
					$('#basic-datatables15').DataTable().destroy();
					$.getScript('./assets/table.js');
					this.campaign = res.data;
					} else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
					}
				});
		
			} else {
				this.errMessage="Please Enter atleast 1 field!"
				setTimeout(() => {
				this.errMessage=''
				}, 3000);
			}
		}

	clearFilter() {
			const { usecase, description, campaignId } = this.campaignFilter.value;
			if (usecase || description !== null || campaignId !== null){
				this.brandsCampaign();
			}
		}

	displayErr() {
		this.errMessage = "Brand Identity Status is Pending";
		setTimeout(() => {
			this.errMessage = "";
		}, 3000);
	}

	changeCat(event: any) {
		if (event.target.checked == true) {
			this.checkcount = this.checkcount + 1;
			if (event.target.id == 'taxid') {
				this.appealCategory.push('VERIFY_TAX_ID');
			}
			if (event.target.id == 'nonProfit') {
				this.appealCategory.push('VERIFY_NON_PROFIT');
			}
			if (event.target.id == 'government') {
				this.appealCategory.push('VERIFY_GOVERNMENT');
			}
		}
		else {
			this.checkcount = this.checkcount - 1;
			if (event.target.id == 'taxid') {
				let index = this.appealCategory.indexOf('VERIFY_TAX_ID');
				this.appealCategory.splice(index, 1);
			}
			if (event.target.id == 'nonProfit') {
				let index = this.appealCategory.indexOf('VERIFY_NON_PROFIT');
				this.appealCategory.splice(index, 1);
			}
			if (event.target.id == 'government') {
				let index = this.appealCategory.indexOf('VERIFY_GOVERNMENT');
				this.appealCategory.splice(index, 1);
			}

		}
	}

	savedDownloadFile(e) {
		fetch(e.path).then(resp => resp.arrayBuffer()).then(resp => {
			const file = new Blob([resp], { type: 'application/pdf' });
			const fileURL = URL.createObjectURL(file);
			const link = document.createElement('a');
			link.href = fileURL;
			link.download = e.path.split('appealAttachment/')[1];
			link.click();
		});
	}

	objectToFile(obj: any, fileName: string, mimeType: string): File {
		const blob = new Blob([JSON.stringify(obj, null, 2)], { type: mimeType });
		return new File([blob], fileName, { type: mimeType, lastModified: Date.now() });
	}

	viewsavedFile(data: any, type: any) {
		if (type == 'pdf') {
			const pdfModal = document.getElementById('modalPdfAppeal');
			let modalPdf = document.getElementById('modalPdf') as HTMLIFrameElement;
			modalPdf.src = data.path;
			$(pdfModal).modal('show');
		}
		if (type == 'image') {
			const imageModal = document.getElementById('modalImageAppeal');
			let modalImage = document.getElementById('modalImage') as HTMLImageElement;
			modalImage.src = data.path;
			$(imageModal).modal('show');
		}
		if (type == 'other') {
			this.savedDownloadFile(data);
		}
	}
	downloadFile(file: File) {
		if (file) {
			const a = document.createElement('a');
			a.href = URL.createObjectURL(file);
			a.download = file.name;
			a.click();
		}
	}

	viewFile(data: File) {
		const pdfModal = document.getElementById('modalPdfAppeal');
		const imageModal = document.getElementById('modalImageAppeal');
		const docxModal = document.getElementById('modalDocxAppeal');
		const modalImage = document.getElementById('modalImage') as HTMLImageElement;
		const modalImage123 = document.getElementById('modalPdf') as HTMLIFrameElement;

		if (data.type.startsWith('image/')) {
			const imageData = data;
			modalImage.src = URL.createObjectURL(imageData);
			// Open the modal for images
			$(imageModal).modal('show');
		} else if (data.type === 'application/pdf') {
			const pdfData = data
			modalImage123.src = URL.createObjectURL(pdfData);
			// Open the modal for non-image files
			$(pdfModal).modal('show');
		} else {
			if (data) {
				const a = document.createElement('a');
				a.href = URL.createObjectURL(data);
				a.download = data.name;
				a.click();
				$(docxModal).modal('show');
			}
		}
	}
	removeFile(fileToRemove: File): void {
		this.selectedFile = this.selectedFile.filter(file => file !== fileToRemove);
	}

	Onexplanation(event: any) {
		//this.appealExplanation = event.target.value;
		this.appealExplanation = (event.target as HTMLInputElement).value;
		if (event.target.value.length > 1024) {
			this.explanation = true;
		}
		else {
			this.explanation = false;
		}
	}

	Onvettexplanation(event: any) {
		if (event.target.value.length > 1024) {
			this.explanationvett = true;
		}
		else {
			this.explanationvett = false;
		}
	}

	get f() { return this.formcheck.controls; }
	onSubmit() {
		this.submitted = true;
		if (this.formcheck.invalid) {
			return;
		}

	}

	onFileChange(event: Event) {
		const fileInput = event.target as HTMLInputElement;
		if (fileInput.files && fileInput.files.length > 0) {
			const file: File = fileInput.files[0];
			//   this.appealRequest.get('fileInput').setErrors(null);
			const fileSize = file.size;
			const maxSizePerFile = 10 * 1024 * 1024;
			if (fileSize > maxSizePerFile) {
				this.errMessage = "Individual file size limit exceeded";
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
				fileInput.value = '';
				return;
			}

			const totalFileSize = this.selectedFile.reduce((total, selectedFile) => total + selectedFile.size, 0);
			const maxTotalSize = 30 * 1024 * 1024;
			if (totalFileSize + fileSize > maxTotalSize) {
				this.errMessage = "Total files size limit exceeded";
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
				fileInput.value = '';
				return;
			}
			const reader = new FileReader();
			reader.readAsDataURL(file);
			this.selectedFile.push(file);
			fileInput.value = '';
		}
	}

	resetForm2() {
		this.appealRequest.reset();
		this.submitted = false;
		this.selectedFile = [];
		this.appealCategory = [];
		this.appealExplanation = "";
		this.checkcount = 0;
	}

	viewDetails(data: any) {
		this.brandAppealFileList = [];
		this.appealData = '';
		this.Category = '';
		this.appealData = data;
		this.Category = this.appealData.appealCategories.split(',');

		if (data.key) {
			let payLoad = JSON.stringify({
				brandId: data.brandID,
				key: data.key,
				iduser: this.iduser
			});

			this.data.getBranAppealFiles(payLoad).subscribe(res => {
				if (res.status == 200) {
					this.brandAppealFileList = res.data;
				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 2000);
				}
			});
		}
	}

	submitAppeal() {
		this.isLoading = true;
		const target = environment.SERVER + "appealRequest";
		const formData = new FormData();
		var _http = this._http
		const payLoad = {
			category: this.appealCategory,
			explanation: this.appealExplanation,
			brandId: this.brandId
		};

		formData.append('payload', JSON.stringify(payLoad));

		for (let i = 0; i < this.selectedFile.length; i++) {
			formData.append("ATTACHMENTS", this.selectedFile[i], this.selectedFile[i].name);
		}

		const req = new HttpRequest('POST', target, formData, {
			reportProgress: true
		});

		_http.request(req).subscribe(
			(res: any) => {
				if (res.body) {
					if (res.body.status == 200) {
						this.responseMessage = res.body.message;
						this.isLoading = false;
						this.sendMessage();
					} else {
						this.errMessage = res.body.message;
						this.isLoading = false;
					}
					this.requestModalClose();
					setTimeout(() => {
						this.getBrandAppeals();
						this.responseMessage = "";
						this.errMessage = "";
					}, 5000);
				}
			},
			(error: any) => {
				this.isLoading = false;
			}
		);
	}

	private requestModalClose() {
		const modal = document.getElementById('brandAppealModal');
		if (modal) {
			modal.click()
		}
	}
	/* -------Vetting appeal section ------------*/
	onVettingFileChange(event: Event) {
		const fileInput = event.target as HTMLInputElement;
		if (fileInput.files && fileInput.files.length > 0) {
			const file: File = fileInput.files[0];
			const fileSize = file.size;
			const maxSizePerFile = 10 * 1024 * 1024;
			if (fileSize > maxSizePerFile) {
				this.errMessage = "Individual file size limit exceeded";
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
				fileInput.value = '';
				return;
			}

			const totalFileSize = this.chooseFile.reduce((total, chooseFile) => total + chooseFile.size, 0);
			const maxTotalSize = 30 * 1024 * 1024;
			if (totalFileSize + fileSize > maxTotalSize) {
				this.errMessage = "Total files size limit exceeded";
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
				fileInput.value = '';
				return;
			}
			const reader = new FileReader();
			reader.readAsDataURL(file);
			this.chooseFile.push(file);
			fileInput.value = '';
		}
	}

	dismissFile(fileToRemove: File): void {
		this.chooseFile = this.chooseFile.filter(file => file !== fileToRemove);
	}

	showFile(data: File): void {
		const vpdfModal = document.getElementById('vPdfAppeal');
		const vimageModal = document.getElementById('vImageAppeal');
		const docxModal = document.getElementById('vDocxAppeal');
		const vmodalImage = document.getElementById('vmodalImage') as HTMLImageElement;
		const modalImageVetting = document.getElementById('vmodalPdf') as HTMLIFrameElement;

		if (data.type.startsWith('image/')) {
			const imageData = data
			vmodalImage.src = URL.createObjectURL(imageData);
			// Open the modal for images	
			$(vimageModal).modal('show');
		} else if (data.type === 'application/pdf') {
			const pdfData = data
			modalImageVetting.src = URL.createObjectURL(pdfData);
			// Open the modal for non-image files	
			$(vpdfModal).modal('show');
		} else {
			this.downloadFile(data);
			//$(docxModal).modal('show');	
		}
	}

	/*Reset vetting appeal model*/
	resetAppeal() {
		this.submitted = false;
		this.formcheck.reset();
		this.chooseFile = [];
		this.vettingAppealCategory = [];
	}
	/* for getting vetting category ID */
	changeVettingCat(event: any) {
		const id = event.target.id;
		if (event.target.checked == true) {
			this.vettingAppealCategory.push(`${id}`);
		} else {
			const index = this.vettingAppealCategory.indexOf(`${id}`);
			this.vettingAppealCategory.splice(index, 1);
		}
	}
	/*get all info of appeal vetting*/
	getBrandVettingAppealsInfo() {
		let payLoad = JSON.stringify({
			brandId: this.brandId,
			iduser: this.iduser
		});
		this.data.getVettingAppealDetails(payLoad).subscribe(res => {
			this.brandVettingAppeal = [];
			this.brandVetting_category = '';
			this.brandVettingAppealDetails = '';
			this.brandVettingAppealFiles = [];
			if (res.status == 200) {
				this.brandVettingAppeal = res.data;
				this.brandVettingAppealDetails = this.brandVettingAppeal[0];
				this.brandVetting_category = this.brandVettingAppeal[0].appealCategories.split(/[.,!,?]/, 4);
				if (this.brandVettingAppealDetails.key) {
					this.brandVettingAppealKey = this.brandVettingAppealDetails.key;
					this.brandVettingAppeal.forEach(element => {
						if (element.key == this.brandVettingAppealKey) {
							this.brandVettingAppealFiles.push(element)
						}
					});
				}
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				});
			}
		});
	}

	sendMessage(): void {
		this.userSerive.sendUpdate('Message from Brand Appeal To Deduct Wallet!');
	}

	submitVettingAppeal() {
		this.isLoading = true;
		const vettingExpanation = (document.getElementById('emailInput') as HTMLInputElement)?.value;
		const target = environment.SERVER + "appealVettingRequest";
		var _http = this._http

		let payLoad: any = JSON.stringify({
			category: this.vettingAppealCategory,
			explanation: vettingExpanation,
			brandId: this.brandId,
			evpId: this.vettingevpId,
			vettingId: this.vettingID
		})

		let formData = new FormData();
		for (let i = 0; i < this.chooseFile.length; i++) {
			formData.append("ATTACHMENTS", this.chooseFile[i], this.chooseFile[i].name);
		}

		formData.append('payload', payLoad);
		const req = new HttpRequest('POST', target, formData, {
			reportProgress: true
		});

		_http.request(req).subscribe(
			(res: any) => {
				if (res.body) {
					if (res.body.status == 200) {
						this.responseMessage = res.body.message;
						this.isLoading = false;
						this.sendMessage();
					} else {
						this.errMessage = res.body.message;
						this.isLoading = false;
					}
					this.standardModalClose();
					setTimeout(() => {
						this.getBrandVettingAppealsInfo();
						this.responseMessage = "";
						this.errMessage = "";
					}, 5000);
				}
			},
			(error: any) => {
				this.isLoading = false;

			}
		);
	}

	private standardModalClose() {
		const modal = document.getElementById('submitAppealvtting');
		if (modal) {
			modal.click()
		}
	}
	scrollToTop(el) {
		const duration = 10;
		const interval = 5;
		const move = el.scrollTop * interval / duration;
		observableInterval(interval).pipe(
			scan((acc, curr) => acc - move, el.scrollTop),
			tap(position => el.scrollTop = position),
			takeWhile(val => val > 0)).subscribe();
	}

	ngOnDestroy(){
		this.closeLegalName.nativeElement.click();
		this.closeBrand.nativeElement.click();
		this.deleteBrand.nativeElement.click();
		this.resubmitBrands.nativeElement.click();
		this.companyDetail.nativeElement.click();
	}
}