import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { HttpClient } from '@angular/common/http'
import { NotificationService } from '../notification.service'
declare var $: any;

@Component({
  selector: 'app-notification-email',
  templateUrl: './notification-email.component.html',
  styleUrls: ['./notification-email.component.css']
})
export class NotificationEmailComponent implements OnInit {
  @ViewChild('modalImageAppeal') modalImageAppeal: ElementRef;
  @ViewChild('modalPdfAppeal') modalPdfAppeal: ElementRef;
  @ViewChild('modalVideoForFile') modalVideoForFile: ElementRef;
  @ViewChild('modalForaudio') modalForaudio: ElementRef;
  composeEmail: any;
  headings: any;
  backbtn: any;
  composeMailtext: any;
  htmlContent = '';
  inputfields: any;
  inputfields1: any;
  inputfields2: any;
  inputfields3: any;
  inputfields4: any;
  inputfields5: any;
  emailnotify: any = [];
  emailData:  any = [];
  userType: any;
  iduser: any;
  idaccount: any;
  key: any;
  responseMessage: any = "";
  errMessage: any = "";
  files: any;
  email: string;
  view: string;
  viewStatus: string;
  filenames: any;

  constructor(public router: Router, private http: HttpClient, private route: ActivatedRoute, public data: NotificationService) {}

  ngOnInit(): void {
    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;
    this.iduser = session.iduser;
    this.idaccount = session.idaccount;

    this.data.get_systemnotification().subscribe((result) => {
      this.composeEmail = result[1].composeMail
      this.backbtn = this.composeEmail[0].back
      this.inputfields = this.composeEmail[0].inputfield
      this.inputfields2 = this.composeEmail[0].inputfield2
      this.inputfields4 = this.composeEmail[0].inputfield4
     
    })

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.key = params.get('key');
      this.email = params.get('to');
      this.viewStatus = params.get('view_status');
    });
    this.ShowEMailDAta()
    if(this.userType !=1 && this.viewStatus!='1'){
      this.Updatestatus(this.key,this.email)
    }
  }

  ShowEMailDAta(){
    this.data.getemail_notify(this.key).subscribe((res) => {
      if(res.status == 201){
      this.emailData = this.groupEmail(res.data);
      this.emailnotify = this.emailData[0];
      this.responseMessage = res.message
      if(this.emailnotify.file){
        const filepaths = this.emailnotify.file.split(';');
        this.files = filepaths.map(filepath => {
          const filename = filepath.substring(filepath.lastIndexOf('/') + 1);
          const name  = filename.split('.').pop();
          return {
            filepath,
            filename,
            name
          };
        });
      }
      setTimeout(() => {
        this.responseMessage = ''
      }, 5000);
      }else{
        this.errMessage = res.message
        setTimeout(() => {
          this.errMessage = ''
        }, 5000);
      }
    })
  }

  groupEmail(data) {
    const groupedData = {};
    data.forEach(entry => {
      const email = entry.to;
      if (!groupedData[entry.key]) {
        groupedData[entry.key] = { ...entry, emails: email };
      } else {
        groupedData[entry.key].emails += ';' + email;
      }
    });
    return Object.values(groupedData);
  }
  
  Updatestatus(key:any,to:any){
    let payLoad: any = JSON.stringify({
      key:key,
      email: to,
    });
    this.data.update_status(payLoad).subscribe((res) => {
        this.data.NotificationCount().subscribe((res1)=>{
          this.data.updateCount(res1.data.length,res1.data);
        });
      if (res.status == 201) {
        this.responseMessage = '';
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
    
  }
  

  SaveFile(filepath:any,name:any){
    if (filepath) {
      const a = document.createElement('a');
      a.href = filepath;
      a.download = name;
      a.click();
    }
  }

  viewFile(filepath:any,name:any) {
    const fileExtension = name.split('.').pop();

    const pdfModal = document.getElementById('modalPdfAppeal');
    const imageModal = document.getElementById('modalImageAppeal');
    const docxModal = document.getElementById('modalDocxAppeal');
    const videoModal = document.getElementById('modalVideoForFile');
    const audioModal = document.getElementById('modalForaudio');
    const modalImage = document.getElementById('modalImage') as HTMLImageElement;
    const modalImage123 = document.getElementById('modalPdf') as HTMLIFrameElement;
    const videoModal12 = document.getElementById('videoModal') as HTMLVideoElement;
    const audioModal13 = document.getElementById('audioModal') as HTMLVideoElement;
    if (fileExtension === "png" || fileExtension === "jpg" || fileExtension === "jpeg" || fileExtension === "svg" || fileExtension === "heic" || fileExtension === "webp" || fileExtension === "gif" || fileExtension === "avif" || fileExtension === "bmp" || fileExtension === "dib" || fileExtension === "ico" || fileExtension === "pjpeg") {
      modalImage.src = filepath
      $(imageModal).modal('show');
    } else if (fileExtension === 'pdf') {
      modalImage123.src = filepath
      $(pdfModal).modal('show');
    } else if (fileExtension === 'mp4' || fileExtension === "mpeg" || fileExtension === "webm" || fileExtension === "3gp" || fileExtension === "avi" || fileExtension === "flv" || fileExtension === "m1v" || fileExtension === "mpg" || fileExtension === "qt" || fileExtension === "wmv" || fileExtension === "h263" || fileExtension === "h264" || fileExtension === "jpgv" || fileExtension === "3g2") {
      videoModal12.src = filepath
      $(videoModal).modal('show');
      $(videoModal).on('hidden.bs.modal', function () {
        videoModal12.pause();
      });
    }else if (fileExtension === 'mp3' || fileExtension === "weba" || fileExtension === "wav" || fileExtension === "3ga" || fileExtension === "amr" || fileExtension === "wav" || fileExtension === "flac" || fileExtension === "mp3" || fileExtension === "mp3" || fileExtension === "m2a" || fileExtension === "m4a" || fileExtension === "m4b" || fileExtension === "mpa" || fileExtension === "qcelp" || fileExtension === "qcp" || fileExtension === "midi" || fileExtension === "mid" || fileExtension === "aacp" || fileExtension === "aac") {
      audioModal13.src = filepath;
      $(audioModal).modal('show');
      $(audioModal).on('shown.bs.modal', function () {
        audioModal13.play();
      });
      $(audioModal).on('hidden.bs.modal', function () {
        audioModal13.pause();
      });
    }
    else {
      if (filepath) {
        const a = document.createElement('a');
        a.href = filepath;
        a.download = name;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        $(docxModal).modal('show');
      }
    }
  }

  ngOnDestroy() {
    this.modalForaudio.nativeElement.click();
    this.modalVideoForFile.nativeElement.click();
    this.modalPdfAppeal.nativeElement.click();
    this.modalImageAppeal.nativeElement.click();
  }

}
