import { FormBuilder, FormGroup, Validators } from "@angular/forms";

// outbound : routingprofile
export interface routing {
    profile_name: string,
    trunks: string,
    carriers: string,
    routing_option: string,
    pdo_timer: string,
    max_rates: string
}

export interface HTTProuting {
    profile_name: string,
    trunks: string,
    carriers: string,
    routing_option: string,
    pdo_timer: string,
    max_rates: string
}

export class routingForm implements HTTProuting {
    profile_name: string;
    trunks: string;
    carriers: string;
    routing_option: string;
    pdo_timer: string;
    max_rates: string

    constructor(data: routing) {
        if (data == null) {
            this.profile_name = "";
            this.trunks = "";
            this.carriers = "";
            this.routing_option = "";
            this.pdo_timer = "";
            this.max_rates = "";
        }
        else {
            this.profile_name = data.profile_name;
            this.trunks = data.trunks;
            this.carriers = data.carriers;
            this.routing_option = data.routing_option;
            this.pdo_timer = data.pdo_timer;
            this.max_rates = data.max_rates;
        }
    }

    public makeform(fb: FormBuilder): FormGroup {
        return fb.group({
            profile_name: [this.profile_name, [Validators.required]],
            trunks: [this.trunks, [Validators.required]],
            carriers: [this.carriers, [Validators.required]],
            routing_option: [this.routing_option, [Validators.required]],
            pdo_timer: [this.pdo_timer, [Validators.required]],
            max_rates: [this.max_rates, [Validators.required]]
        });
    }

    public saveForm(fg: FormGroup): boolean {
        if (fg.valid) {
            this.profile_name = fg.get("profile_name").value;
            this.trunks = fg.get("trunks").value;
            this.carriers = fg.get("carriers").value;
            this.routing_option = fg.get("routing_option").value;
            this.pdo_timer = fg.get("pdo_timer").value;
            this.max_rates = fg.get("max_rates").value;
            return true;
        }
        else {
            return false;
        }
    }
}

// outnound : trunks 

export interface trunks {
    name: string,
    routing_profile: string,
    ip_address: string,
    prefix: string,
    token: string,
    channel_limit: string
}

export interface HTTPtrunks {
    name: string,
    routing_profile: string,
    ip_address: string,
    prefix: string,
    token: string,
    channel_limit: string
}

export class trunksForm implements HTTPtrunks {
    name: string;
    routing_profile: string;
    ip_address: string;
    prefix: string;
    token: string;
    channel_limit: string

    constructor(data: trunks) {
        if (data == null) {
            this.name = "";
            this.routing_profile = "";
            this.ip_address = "";
            this.prefix = "";
            this.token = "";
            this.channel_limit = "";
        }
        else {
            this.name = data.name;
            this.routing_profile = data.routing_profile;
            this.ip_address = data.ip_address;
            this.prefix = data.prefix;
            this.token = data.token;
            this.channel_limit = data.channel_limit;
        }
    }

    public makeform(fb: FormBuilder): FormGroup {
        return fb.group({
            name: [this.name, [Validators.required]],
            routing_profile: [this.routing_profile, [Validators.required]],
            ip_address: [this.ip_address, [Validators.required]],
            prefix: [this.prefix, [Validators.required]],
            token: [this.token, [Validators.required]],
            channel_limit: [this.channel_limit, [Validators.required]]
        });
    }

    public saveForm(fg: FormGroup): boolean {
        if (fg.valid) {
            this.name = fg.get("name").value;
            this.routing_profile = fg.get("routing_profile").value;
            this.ip_address = fg.get("ip_address").value;
            this.prefix = fg.get("prefix").value;
            this.token = fg.get("token").value;
            this.channel_limit = fg.get("channel_limit").value;
            return true;
        }
        else {
            return false;
        }
    }
}

// outnound : cdrs 

export interface cdrs {
    status: string,
    call_id: string,
    from_number: string,
    to_number: string
}

export interface HTTPcdrs {
    status: string,
    call_id: string,
    from_number: string,
    to_number: string
}

export class callForm implements HTTPcdrs {
    status: string;
    call_id: string;
    from_number: string;
    to_number: string

    constructor(data: cdrs) {
        if (data == null) {
            this.status = "";
            this.call_id = "";
            this.from_number = "";
            this.to_number = "";
        }
        else {
            this.status = data.status;
            this.call_id = data.call_id;
            this.from_number = data.from_number;
            this.to_number = data.to_number;
        }
    }

    public makeform(fb: FormBuilder): FormGroup {
        return fb.group({
            status: [this.status, [Validators.required]],
            call_id: [this.call_id, [Validators.required]],
            from_number: [this.from_number, [Validators.required]],
            to_number: [this.to_number, [Validators.required]]
        });
    }

    public saveForm(fg: FormGroup): boolean {
        if (fg.valid) {
            this.status = fg.get("status").value;
            this.call_id = fg.get("call_id").value;
            this.from_number = fg.get("from_number").value;
            this.to_number = fg.get("to_number").value;
            return true;
        }
        else {
            return false;
        }
    }
}





// outbound : testcallForm
export interface testcall {
    searchformnumber: string,
    to_number: string,
    test_call: string,
   
}

export interface HTTtestcall {
    searchformnumber: string,
    to_number: string,
    test_call: string,
   
}

export class testcallForm implements HTTtestcall {
    searchformnumber: string;
    to_number: string;
    test_call: string;
   

    constructor(data: testcall) {
        if (data == null) {
            this.searchformnumber = "";
            this.to_number = "";
            this.test_call = "";
            
        }
        else {
            this.searchformnumber = data.searchformnumber;
            this.to_number = data.to_number;
            this.test_call = data.test_call;
           
        }
    }

    public makeform(fb: FormBuilder): FormGroup {
        return fb.group({
            searchformnumber: [this.searchformnumber, [Validators.required]],
            to_number: [this.to_number, [Validators.required]],
            test_call: [this.test_call, [Validators.required]],
            
        });
    }

    public saveForm(fg: FormGroup): boolean {
        if (fg.valid) {
            this.to_number = fg.get("to_number").value;
            this.test_call = fg.get("test_call").value;
            
            return true;
        }
        else {
            return false;
        }
    }
}