import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { AbstractControl, FormBuilder, FormControl, FormGroup, ValidatorFn, Validators } from '@angular/forms';
import { trigger, transition, style, animate, state } from '@angular/animations';
import { ResellerService } from '../reseller.service';
import { ActivatedRoute, Router } from '@angular/router';
import { formatDate } from '@angular/common';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';
// import { Observable } from 'rxjs';
declare var $: any;

@Component({
  selector: 'app-commission-details',
  templateUrl: './commission-details.component.html',
  styleUrls: ['./commission-details.component.css'],
  animations: [
    trigger('widthGrow', [
      state(
        'closed',
        style({
          border: "0px",
          height: "0px",
          margin: "0px 0px 20px 0px",
        })
      ),
      state(
        'open',
        style({

          margin: "0px 0px 20px 0px",
        })
      ),
      transition('* => *', animate(500)),
    ]),
  ],
})
export class CommissionDetailsComponent implements OnInit {
  @ViewChild('payID') payID: ElementRef;
  public CommPayForm: FormGroup;
  responseMessage: any = "";
  errMessage: any = "";
  searchText = { count: 0 };
  count = 0;
  tableSize = 25;
  tableSizes = [25, 50, 100];
  show: boolean = false;

  cdetailfilter: any = [];
  public filterCDetails: FormGroup;
  submitted: boolean = false;
  filterIconVal: any;
  state: any;
  Reseller: any = [];
  Camount: any;
  IdUser: any;
  totalSum: number;
  CommissionDate: any;
  formattedDate: any;
  cdetailfilterCSV: any = [];
  EXCEL_TYPE = 'application/csv';
  EXCEL_EXTENSION = '.csv';
  id: any;

  constructor(private data: ResellerService, public fb: FormBuilder, private route: ActivatedRoute, public router: Router) { }
  ngOnInit(): void {
    this.state = 'closed';
    this.filterIconVal = "1";

    this.filterCDetails = this.fb.group({
      selectedUser: new FormControl(''),
      transaction_id: [],
      fromDate: new FormControl(''),
      toDate: new FormControl(''),
      status: new FormControl('')
    });

    this.CommPayForm = this.fb.group({
      transitionId: new FormControl('', [Validators.required]),
      amount: new FormControl(''),
      comment: new FormControl('', [Validators.required])
    })

    // this.getcdetaillist(); 
    this.getReseller();
    /*add filter for commission details */
    this.getCommDetails();

  }

  getCommDetails() {
    this.totalSum = 0;
    this.data.applyCommDetailsFilter(JSON.stringify(this.filterCDetails.value)).subscribe(response => {
      if (response.data) {
        this.cdetailfilter = response.data.filter((item) => item.formatted_date != 'N/A');
        this.cdetailfilter.forEach(item => {
          if (item.status === 'Pending') {
            if (item.commission_amount) {
              this.totalSum += parseFloat(item.commission_amount);
            }
          }
        });
        $('#basic-datatabless').DataTable().clear();
        $('#basic-datatabless').DataTable().destroy();
        $.getScript('./assets/tollfree.js');
      }
    });
  }

  getReseller() {
    this.data.getReseller().subscribe(res => {
      if (res.status == 200) {
        this.Reseller = res.data;
        this.Reseller.sort((a, b) => {
          return a.iduser - b.iduser;
        });
      }
    });
  }

  filterByUser(e) {
    this.filterCDetails.patchValue({
      selectedUser: e.target.value
    });
  }

  /**Function for filter hide open**/
  showField() {
    if (this.show == false) {
      this.show = true;
    }
    else {
      this.show = false;
    }
  }


  /*change value of filter button*/
  changeState(val): void {
    this.state == 'closed' ? (this.state = 'open') : (this.state = 'closed');
    val == '1' ? (this.filterIconVal = '2') : (this.filterIconVal = '1');
  }

  resetFilter() {
    this.submitted = false;
    this.filterCDetails.reset();
    this.getCommDetails();
  }

  onReset() {
    this.submitted = false;
    this.CommPayForm.reset();
    this.CommPayForm.patchValue({
      amount: this.Camount,
    });
  }


  getAmount(amount: any, cs_id: any) {
    this.Camount = amount;
    //this.IdUser = id;
    this.id = cs_id
    // this.CommissionDate = date;
    // this.formattedDate = formatDate(this.CommissionDate, 'yyyy-MM-dd HH:mm:ss', 'en-US');
  }

  applycDetailsFilter() {
    this.totalSum = 0;
    this.submitted = true
    if (this.filterCDetails.invalid) {
      return false;
    } else {
      let ddata = JSON.stringify(this.filterCDetails.value);
      this.data.applyCommDetailsFilter(ddata).subscribe(res => {
        if (res.status == 200) {
          this.cdetailfilter = res.data.filter((item) => item.formatted_date != 'N/A');
          this.cdetailfilterCSV = res.data.filter((item) => item.formatted_date != 'N/A');
          this.cdetailfilter.forEach(item => {
            if (item.status === 'Pending') {
              if (item.commission_amount) {
                this.totalSum += parseFloat(item.commission_amount);
              }
            }
          });
          $('#basic-datatabless').DataTable().clear();
          $('#basic-datatabless').DataTable().destroy();
          $.getScript('./assets/tollfree.js');
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      })
    }
  }

  messageshow() {
    const fromDate = this.filterCDetails.get('fromDate').value;
    const toDate = this.filterCDetails.get('toDate').value;
    const currentDate = new Date();
    if ((!fromDate && !toDate)) {
    } else if ((fromDate == null || !fromDate) && (toDate != null)) {
      this.filterCDetails.get('fromDate').setErrors({ 'dateRange': 'Please select From Date' });
    } else if ((fromDate != null) && (toDate == null || !toDate)) {
      this.filterCDetails.get('toDate').setErrors({ 'dateRange': 'Please select To Date' });
    } else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
      this.filterCDetails.get('toDate').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
      return;
    } else if (toDate && new Date(toDate) > currentDate) {
      this.filterCDetails.get('toDate').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
      return;
    } else if (fromDate && new Date(fromDate) > currentDate) {
      this.filterCDetails.get('fromDate').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
      return;
    } else {
      this.filterCDetails.get('fromDate').setErrors(null);
      this.filterCDetails.get('toDate').setErrors(null);
    }

  }

  onPay() {
    this.submitted = true;
    if (this.CommPayForm.invalid) {
      return false;
    } else {
      let payLoad: any = JSON.stringify({
        //id: this.IdUser,
        amount: this.Camount,
        cs_id: this.id,
        // date: this.formattedDate,
        value: this.CommPayForm.value
      });
      this.data.PayTransaction(payLoad).subscribe(res => {
        if (res.status == 200) {
          this.responseMessage = res.message;
          this.getCommDetails();
          setTimeout(() => {
            this.responseMessage = "";
          }, 3000);
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 3000);
        }
        this.payID.nativeElement.click();
      })
    }
  }

  // selectedFromDate(e) {
  //   this.submitted = true;
  //   if (e.target.value) {
  //     this.filterCDetails.get("toDate").setValidators(Validators.required);
  //     this.filterCDetails.get("toDate").updateValueAndValidity();
  //   }
  // }

  // selectedToDate(e) {
  //   this.submitted = true;
  //   if (e.target.value) {
  //     this.filterCDetails.get("fromDate").setValidators(Validators.required);
  //     this.filterCDetails.get("fromDate").updateValueAndValidity();
  //   }
  // }

  // for date compare in the from and to date...
  // static dateLessThan(fromDate: string, toDate: string, validatorField: { [key: string]: boolean }): ValidatorFn {
  //   return (c: AbstractControl): { [key: string]: boolean } | null => {
  //     const date1 = c.get(fromDate).value;
  //     const date2 = c.get(toDate).value;
  //     if ((date1 !== null && date2 !== null) && date1 > date2) {
  //       return validatorField;
  //     }
  //     return null;
  //   };
  // }

  downloadCSVFile() {
    this.applycDetailsFilter();
    setTimeout(() => {
      if (this.cdetailfilterCSV.length > 0) {
        //let serialNumber = 1;
        let NewFilteredRes = this.cdetailfilterCSV.map((item) => {
          const { date, iduser, reseller_name, total_invoice_amount, commissinable_revenue, non_commissinable_revenue, commission_amount, status, transaction_id } = item;
          const formattedDate = date ? new Date(date).toLocaleDateString('en-US') : 'N/A';
          return {
            //'Sr No': serialNumber++,
            'Date': formattedDate,
            'Reseller ID': iduser,
            'Reseller Name': reseller_name,
            'Total Invoice Amount': total_invoice_amount,
            'Commissionable Revenue Amount': commissinable_revenue,
            'Non Commissionable Revenue Amount': non_commissinable_revenue,
            'Commission Amount': commission_amount,
            'Status': status,
            'Transaction ID': transaction_id
          };
        });

        const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(NewFilteredRes);
        const workbook: XLSX.WorkBook = { Sheets: { Commission_Summary: worksheet }, SheetNames: ['Commission_Summary'] };
        const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
        this.saveAsExcelFile(excelBuffer, 'Commission_Summary');
      } else {
        this.errMessage = 'No Record Available!';
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    }, 1000);
  }

  private saveAsExcelFile(buffer: any, fileName: string): void {
    const data: Blob = new Blob([buffer], {
      type: this.EXCEL_TYPE
    });
    saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
  }

  ngOnDestroy() {
    this.payID.nativeElement.click();
  }



}
