import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { AbstractControl, FormBuilder, FormControl, FormGroup, ValidatorFn, Validators } from '@angular/forms';
import { ActivatedRoute, Router } from '@angular/router';
import { ResellerService } from '../reseller.service';
declare var $: any;

@Component({
  selector: 'app-commission-plan',
  templateUrl: './commission-plan.component.html',
  styleUrls: ['./commission-plan.component.css']
})
export class CommissionPlanComponent implements OnInit {
  constructor(public data: ResellerService, public fb: FormBuilder, private route: ActivatedRoute, public router: Router) { }
  public cPlanForm: FormGroup;
  submitted: boolean = false;
  responseMessage: any = "";
  errMessage: any = "";
  show: boolean = false;
  modeltext: string = '';
  show_filter: boolean = false;
  commissionfilter: any = [];
  public filterCommission: FormGroup;
  savePlan :any = 'Submit';
  Cplan: any;
  // @ViewChild('closebutton') closebutton: any;
  @ViewChild('closeModal') private closeModal: ElementRef;


  ngOnInit(): void {

    this.cPlanForm = this.fb.group({
      plan_name: ['', [Validators.required]], 
      description: ['', [Validators.required]],
      id_plan: ['']
    })

    // this.filterCommission = this.fb.group({
    //   fType: [''],
    //   plan_name: [],
    //   fromDate: new FormControl(''),
    //   toDate: new FormControl(''),
    // }, {
    //   validator: Validators.compose([
    //     CommissionPlanComponent.dateLessThan('fromDate', 'toDate', { 'fromDate': true })
    //   ])
    // });

    // this.filterCommission.patchValue({
		// 	fType:""
		// })

    	/*add filter commission plan */
		// this.data.applycommissionFilter().subscribe(response => {      
		// 	if (response.data) {
		// 		this.commissionfilter = response.data; 
    //     console.log("CHECK RESULT FOR PLAN",this.commissionfilter)
    //     $('#basic-datatables').DataTable().clear();
    //     $('#basic-datatables').DataTable().destroy();    
		// 		$.getScript('./assets/table.js');
		// 	}
		// });
 
    this.getCommisssionplan();
  }


  getCommisssionplan(){
  this.data.getCommissionPlan().subscribe(response => {   
    if (response.data) {
      this.Cplan = response.data;
      this.Cplan.forEach(element => {
        element.plan_n = btoa(element.plan_name)
      });
      $('#basic-datatables15').DataTable().clear();
      $('#basic-datatables15').DataTable().destroy();    
      $.getScript('./assets/table.js');
    }
  });
}

  setAsDefault(id_plan, iduser) {
		let data = id_plan + '-' + iduser;
		this.data.setDefault(data).subscribe(res => {
			if (res.status == 201) {
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
				this.ngOnInit();
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}

  showdata(data: any) {
    this.modeltext = 'Add Commission Plan',
    this.savePlan='Submit';
    if (data.id_plan) {
      this.modeltext = 'Edit Commission Plan'
      this.savePlan='Update';
      this.cPlanForm.patchValue({
        plan_name: data.plan_name,
        description: data.description,
        id_plan: data.id_plan
      });
    }
    else {
      //reset form
    }
  }

  onsubmit() {
    if (this.cPlanForm.invalid) {
      this.submitted = true;
      return;
    }
    else {
      if (this.cPlanForm.value.id_plan) {
        this.data.updateCommissionPlan(this.cPlanForm.value).subscribe(res => {
          if (res.status == 200) {
            this.responseMessage = res.message;
            this.getCommisssionplan();
            this.cPlanForm.reset();
            this.closeModal.nativeElement.click();
            setTimeout(() => {
              this.responseMessage = "";
            }, 3000);
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 3000);
          }
        })
      }
      else {
        this.savePlan='Submit';
        this.data.saveCommissionPlan(this.cPlanForm.value).subscribe(res => {
          if (res.status == 200) {
            this.responseMessage = res.message;
            this.getCommisssionplan();
            this.cPlanForm.reset();
            this.closeModal.nativeElement.click();
            setTimeout(() => {
              this.responseMessage = "";
            }, 3000);
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 3000);
          }
        })
      }
    }
  }
  
  onClose() {
    const commitionId = this.cPlanForm.value.id_plan;
      this.submitted =false;
      this.cPlanForm.reset();
      this.cPlanForm.get('id_plan').setValue(commitionId);
    }

  deleteplan(id: any) {
    if (confirm("Are you sure you want delete plan!")) {
      this.data.ondeleteCommissionPlan(id).subscribe(res => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          this.getCommisssionplan();
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          });
        }
      }, error => {
        this.responseMessage = error.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      });
    }
    else {
      return
    }
  }

  /**Function for filter hide open**/
  showField() {
    if (this.show == false) {
      this.show = true;
    }
    else {
      this.show = false;
    }
  }

  // applyCommissionFilter() {      
  //   this.filterCommission.patchValue({
	// 		fType:""
	// 	})
  //   if (this.filterCommission.invalid) {
  //     this.submitted = true; 
  //     $('#basic-datatables').DataTable().clear();
  //     $('#basic-datatables').DataTable().destroy();
  //     return
  //   }
  //   else{
  //     this.submitted = false; 
  //     // this.commissionfilter = [];
  //     let data1 = JSON.stringify(this.filterCommission.value);
  //     this.data.applycommissionFilter(data1).subscribe(res => {
  //       if (res.status == 200) {
  //         this.commissionfilter = res.data;
  //         $('#basic-datatables').DataTable().clear();
  //         $('#basic-datatables').DataTable().destroy();
  //         $.getScript('./assets/table.js');
  //       }
  //       else {
  //         this.errMessage = res.message;
  //         setTimeout(() => {
  //           this.errMessage = "";
  //         }, 5000);
  //       }
  //     })
  //   }
    
  // }

  // resetFilter() {
  //   this.submitted = false;
	// 	this.ngOnInit();
  // }

  // selectedFromDate(e) {
	// 	this.submitted = true;
	// 	if (e.target.value) {
	// 		this.filterCommission.get("toDate").setValidators(Validators.required);
	// 		this.filterCommission.get("toDate").updateValueAndValidity();
	// 	}
	// }

	// selectedToDate(e) {
	// 	this.submitted = true;
	// 	if (e.target.value) {
	// 		this.filterCommission.get("fromDate").setValidators(Validators.required);
	// 		this.filterCommission.get("fromDate").updateValueAndValidity();
	// 	}
	// }

  // static dateLessThan(fromDate: string, toDate: string, validatorField: { [key: string]: boolean }): ValidatorFn {
  //   return (c: AbstractControl): { [key: string]: boolean } | null => {
  //     const date1 = c.get(fromDate).value;
  //     const date2 = c.get(toDate).value;
  //     if ((date1 !== null && date2 !== null) && date1 > date2) {
  //       return validatorField;
  //     }
  //     return null;
  //   };
  // }


}
