import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { BehaviorSubject, Observable } from 'rxjs';
import { ResellerService } from '../reseller.service';
import { FormBuilder, FormControl, FormGroup, Validators, ValidatorFn, AbstractControl } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { TariffService } from 'src/app/tariff/tariff.service';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
// import { DatePipe, formatDate } from '@angular/common';
import { ActivatedRoute, Router } from '@angular/router';

declare var $: any;
@Component({
  selector: 'app-reseller',
  templateUrl: './reseller.component.html',
  styleUrls: ['./reseller.component.css']
})
export class ResellerComponent extends AppComponentClass<any, any> {
  @ViewChild('resellerModalCenter') resellerModalCenter: ElementRef
  pShow = false;
  isDisableAdd: boolean;
  // isDesMob: boolean;
  // isDesEmail: boolean = false;
  isAddChecked: boolean;
  // isMobChecked: boolean;
  // isEmailChecked: boolean = false;
  listdata: any;
  public resellerForm: FormGroup;
  public submitted: boolean = false;
  responseMessage: any = "";
  errMessage: any = "";
  regTariffs: any = [];
  selectedItems: any = [];
  selectedItems1: any = [];
  selectedItems2: any = [];
  dropdownSettings: IDropdownSettings = {};
  dropdownSettings1: IDropdownSettings = {};
  dropdownSettings2: IDropdownSettings = {};
  closeDropdownSelection = true;
  closeDropdownSelection1 = true;
  addessdetail: any;
  newArr: any = [];
  preferenceServices: any = [];
  resellerPlan: any = [];
  tarifList: any = [];
  planList: any = [];
  serviceList: any = [];
  Resaller: any = [];
  updateReseller: void;
  country: any;
  zipLength: any;
  public submitTypeData: boolean = false;
  userTariff: any = [];
  selectedTariff: any = [];
  modeltext: string = '';
  idUser: any;
  com_plan: any;
  show: boolean = false;
  public resellerFilter: FormGroup;
  resellerfilter: any = [];
  monthNameList: { name: string; value: string; }[];
  IdToUpdate: any
  Reseller: any = [];


  constructor(public data: ResellerService, private tariffService: TariffService, public fb: FormBuilder, private route: ActivatedRoute, public router: Router) {
    super(data, router, fb);
  }

  ngOnInit(): void {
    this.submitTypeData = false;
    this.isDisableAdd = true;
    // this.isDesEmail = true;
    // this.isDesMob = false;
    this.isAddChecked = false;
    // this.isMobChecked = false;
    // this.isEmailChecked = false;

    this.resellerForm = this.fb.group({
      iduser: [''],
      idaccount: [''],
      email: ['', [Validators.required,
      Validators.pattern("^([A-Za-z0-9._%+-]+)@([A-Za-z0-9-]+\\.[A-Za-z]{2,4})(\\.[A-Za-z]{2,4})?$")]],
      password: ['', [Validators.required, Validators.minLength(8)]],
      first_name: ['', [Validators.required, Validators.pattern(/^([a-zA-Z!@#$%^&*().,<>{}[\]<>?_`~=+\-|;:\'\"\/])*[^\s]\1*$/)]],
      last_name: ['', [Validators.required, Validators.pattern(/^([a-zA-Z!@#$%^&*().,<>{}[\]<>?_`~=+\-|;:\'\"\/])*[^\s]\1*$/)]],
      user_name: ['', [Validators.required]],
      contact_number: ['', [Validators.required, Validators.minLength(10)]],
      tariff: ['', [Validators.required]],
      tariffList: [''],
      service: ['', [Validators.required]],
      serviceLisT: [''],
      plan_name: ['', [Validators.required]],
      planLisT: [''],
      // address1: ['', [Validators.required]],
      // address2: ['', [Validators.required]],
      // postal_code: ['', [Validators.required]],
      // country: ['', [Validators.required]],
      // city: ['', [Validators.required]],
      // state: ['', [Validators.required]],
      // isEmailVerify: [''],
      // isMobileVerify: [''],
      isAddress: [''],
      isPlan: [''],
      isCard: ['']
    });

    this.data.getsuppiler().subscribe((result) => {
      this.listdata = result[0].personal_details;
      this.addessdetail = result[1].address_details;
    });

    // Get tariffs
    this.tariffService.getTariffs().subscribe(res => {
      this.regTariffs = res.data;
      // this.selectedItems=res.data;
      // [{day_num:res.data[0].day_num,description:res.data[0].description,idaccount:res.data[0].idaccount,proration:res.data[0].proration,type:res.data[0].type,idtariff:res.data[0].idtariff,name:res.data[0].name}];

    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });

    this.dropdownSettings = {
      singleSelection: false,
      idField: 'idtariff',
      textField: 'name',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };

    this.tariffService.getPreferenceService().subscribe(res => {
      this.preferenceServices = res.data;
    }, err => {
      console.log(err.message);
    });

    this.dropdownSettings2 = {
      singleSelection: true,
      idField: 'idservice',
      textField: 'name',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection1
    };

    this.dropdownSettings1 = {
      singleSelection: true,
      idField: 'id_plan',
      textField: 'plan_name',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection1
    };

    this.data.getCommissionPlan().subscribe(res => {
      this.resellerPlan = res.data;
    }, err => {
      console.log(err.message);
    });

    this.resellerFilter = this.fb.group({
      selectedUser: new FormControl(''),
      fType: [''],
      email: ['', [Validators.pattern("^[a-zA-Z0-9._%+-]+@[a-z0-9.-]+\\.[a-z]{2,4}$")]],
      username: [''],
      //resellername: ['', [Validators.pattern("^[a-zA-Z][a-zA-Z '-]*$")]],
      // firstname: ['', [Validators.pattern("^[a-zA-Z][a-zA-Z '-]*$")]],
      // lastname: ['', [Validators.pattern("^[a-zA-Z][a-zA-Z '-]*$")]],	
      fromDate: new FormControl(''),
      toDate: new FormControl(''),
    });

    this.getReseller();

    this.resellerFilter.patchValue({
      fType: ""
    })

    /*Reseller filter */
    this.getListReseller();
  }

  getListReseller() {
    this.data.applyresellerFilter(JSON.stringify(this.resellerFilter.value)).subscribe(response => {
      if (response.data) {
        this.resellerfilter = response.data;
        this.Resaller = response.data;
        $('#basic-datatables05').DataTable().clear();
        $('#basic-datatables05').DataTable().destroy();
        $.getScript('./assets/table.js');
      }
    });
  }

  getReseller() {
    this.data.getReseller(JSON.stringify(this.resellerFilter.value)).subscribe(res => {
      if (res.status == 200) {
        this.Reseller = res.data;
        this.Reseller.sort((a, b) => {
          return a.iduser - b.iduser;
        });
      }
    });
  }

  filterByUser(e) {
    this.resellerFilter.patchValue({
      selectedUser: e.target.value
    });
  }


  setResellerData(data: any) {
    this.idUser = data.iduser;
    this.modeltext = 'Add Reseller Details'
    if (data.length === 0) {
      this.resellerForm.get('password').enable();
      this.resellerForm.reset();
      this.isDisableAdd = true;
      // this.isDesEmail = true;
      // this.isDesMob = true;
      this.isAddChecked = false;
      // this.isMobChecked = false;
      // this.isEmailChecked = false;
      this.submitTypeData = false;
      this.selectedItems = [];
      this.selectedItems1 = [];
      this.selectedItems2 = [];

      this.resellerPlan.forEach(element => {
        if (element.is_default == 'true') {
          this.selectedItems1 = [{ id_plan: element.id_plan, plan_name: element.plan_name }]
          this.resellerForm.patchValue({
            plan_name: this.selectedItems1
          });
        }
      });

      this.preferenceServices.forEach(element => {
        if (element.is_default == 'true') {
          this.selectedItems2 = [{ idservice: element.idservice, name: element.name }]
          this.resellerForm.patchValue({
            name: this.selectedItems2
          });
        }
      });

    } else {
      this.modeltext = 'Edit Reseller Details'
      this.submitTypeData = true;
      this.resellerForm.get('password').enable();
      let Password: any = this.resellerForm.get("password");
      Password.setValidators([]);
      Password.updateValueAndValidity();

      this.data.getsingleReseller(data.iduser).subscribe(res => {
        if (res.status == 200) {
          this.userTariff = res.data;
          this.com_plan = res.dataComPlan[0];

          this.selectedItems = [];
          this.selectedItems1 = [];
          this.selectedItems2 = [];
          this.selectedTariff = [];
          for (let utarif of this.userTariff) {
            for (let tarif of this.regTariffs) {
              if (tarif.idtariff == utarif.idtariff) {
                this.selectedTariff.push(tarif)
              }
            }
          }
          this.selectedItems = this.selectedTariff;
          // this.selectedItems1 = [{id_plan: this.com_plan.id_plan, plan_name: this.com_plan.plan_name}]    
          this.resellerPlan.forEach(element => {
            if (element.plan_name == this.com_plan.plan_name) {
              this.selectedItems1 = [{ id_plan: element.id_plan, plan_name: element.plan_name }]
            }
          });

          this.preferenceServices.forEach(element => {
            if (element.idservice == data.idservice) {
              this.selectedItems2 = [{ idservice: element.idservice, name: element.name }]
            }
          });
        }
      });
    }
    // if (data.isMobileVerify === "true") {
    //   this.isDesMob = false;
    //   this.isMobChecked = true;
    // }
    // if (data.isEmailVerify === "true") {
    //   this.isDesEmail = false;
    //   this.isEmailChecked = true;
    // }
    if (data.isAddress === "true") {
      this.isDisableAdd = false;
      this.isAddChecked = true;
    }

    this.resellerForm.patchValue({
      iduser: data.iduser,
      idaccount: data.idaccount,
      email: data.email,
      password: data.password,
      first_name: data.firstname,
      last_name: data.lastname,
      user_name: data.username,
      contact_number: data.phone,
      tariff: this.selectedItems,
      plan_name: this.selectedItems1,
      tariffList: this.selectedItems,
      planLisT: this.selectedItems1,
      // service: data.idservice,
      service: this.selectedItems2,
      serviceLisT: this.selectedItems2,
      // address1: data.address1,
      // address2: data.address2,
      // postal_code: data.postal_code,
      // country: data.country,
      // city: data.city,
      // state: data.state,
      // isEmailVerify: data.isEmailVerify,
      // isMobileVerify: data.isMobileVerify,
      // isAddress: data.isAddress,
      invalid: 'true'
    });
    this.IdToUpdate = data.iduser;
  }

  onSubmit() {
    if (this.resellerForm.invalid) {
      this.submitted = true;
      return;
    }
    else {
      this.submitted = false;
      this.resellerForm.patchValue({
        isAddress: 'true',
        isPlan: 'true',
        isCard: 'true',
        // isEmailVerify: this.isEmailChecked ? 'true' : 'false',
        // isMobileVerify: this.isMobChecked ? 'true' : 'false',
      });

      if (this.submitTypeData || this.IdToUpdate) {
        // this.resellerForm.patchValue({
        //   isEmailVerify: this.isEmailChecked ? 'true' : 'false',
        //   isMobileVerify: this.isMobChecked ? 'true' : 'false',
        // });
        this.resellerForm.value.iduser = this.IdToUpdate
        this.data.updateResellerbyID(this.resellerForm.value).subscribe(res => {
          if (res.status == 200) {
            this.responseMessage = res.message;
            document.getElementById("close").click();
            // this.getReseller();
            this.getListReseller();
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        })
        return false;
      }
      else {

        this.data.saveReseller(this.resellerForm.value).subscribe(res => {
          if (res.status == 200) {
            this.responseMessage = res.message;
            this.submitted = false;
            document.getElementById("resellerModalCenter").click();
            // this.getReseller();
            this.getListReseller();
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        }, err => {
          this.errMessage = err.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        })
      }
    }
  }
  /*delete resaller function*/
  deleteResaller(id: any) {
    if (confirm("Are you sure you want delete Reseller!")) {
      this.data.onDeleteReseller(id).subscribe(res => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          // this.getReseller();
          this.getListReseller();
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          });
        }
      }, error => {
        this.responseMessage = error.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      });
    }
    else {
      return
    }
  }


  onClose() {
    this.submitted = false;
    this.resellerForm.reset();
  }

  addTariff(e) {
    this.tarifList = [];
    let trf: any = this.resellerForm.value.tariff;
    for (let i = 0; i < trf.length; i++) {
      this.tarifList.push(trf[i].idtariff);
    }
    this.resellerForm.patchValue({
      tariffList: this.tarifList
    });
  }

  addPlan(e) {
    this.planList = [];
    let planL: any = this.resellerForm.value.plan_name;
    for (let i = 0; i < planL.length; i++) {
      this.planList.push(planL[i].id_plan);
    }

    this.resellerForm.patchValue({
      planLisT: this.planList
    });
  }

  addservice(e: any) {
    this.serviceList = [];
    let serviceL: any = this.resellerForm.value.service;
    for (let i = 0; i < serviceL.length; i++) {
      this.serviceList.push(serviceL[i].idservice);
    }

    this.resellerForm.patchValue({
      serviceLisT: this.serviceList
    });
  }

  // isCheckedFun(event, type) {
  //   if (event.target.checked) {
  //     if (type == 'address') {
  //       this.resellerForm.patchValue({
  //         isAddress: event.target.checked
  //       })
  //     }
  //     if (type == 'phone') {
  //       if (!this.resellerForm.controls['contact_number'].errors) {
  //         this.resellerForm.patchValue({
  //           isMobileVerify: event.target.checked
  //         })
  //       }
  //       this.isMobChecked = true;
  //     }
  //     if (type == 'email') {
  //       if (!this.resellerForm.controls['email'].errors) {
  //         this.resellerForm.patchValue({
  //           isEmailVerify: event.target.checked
  //         })
  //       }
  //       this.isEmailChecked = true;
  //     }
  //   }
  //   else {
  //     if (type == 'address') {
  //       this.resellerForm.patchValue({
  //         isAddress: event.target.checked
  //       })
  //     }
  //     if (type == 'phone') {
  //       if (!this.resellerForm.controls['contact_number'].errors) {
  //         this.resellerForm.patchValue({
  //           isMobileVerify: event.target.checked
  //         })
  //       }
  //       this.isMobChecked = false;
  //     }
  //     if (type == 'email') {
  //       if (!this.resellerForm.controls['email'].errors) {
  //         this.resellerForm.patchValue({
  //           isEmailVerify: event.target.checked
  //         })
  //       }
  //       this.isEmailChecked = false;
  //     }
  //   }
  // }

  isField(type) {
    if (type == 'address') {
      if (this.resellerForm.value.address1 && this.resellerForm.value.city && this.resellerForm.value.state && this.resellerForm.value.country && this.resellerForm.value.postal_code) {
        this.isAddChecked = false;
        this.isDisableAdd = false;
      }
      else {
        this.isAddChecked = false;
        this.isDisableAdd = true;
      }
    }
    // if (type == 'phone') {
    //   if (this.resellerForm.value.contact_number && !this.resellerForm.controls['contact_number'].errors) {
    //     this.isDesMob = false;
    //     this.isMobChecked = false;
    //     this.resellerForm.patchValue({
    //       isMobileVerify: "false"
    //     })
    //   }
    //   else {
    //     // this.isMobChecked = false;
    //     // this.isDesMob = true;
    //     if (this.resellerForm.value.isMobileVerify == "true") {
    //       this.isMobChecked = true;
    //       this.isDesMob = true;
    //       this.resellerForm.patchValue({
    //         isMobileVerify: "true"
    //       })
    //     }
    //   }
    // }
    // if (type == 'email') {
    //   if (this.resellerForm.value.email && !this.resellerForm.controls['email'].errors) {
    //     this.isDesEmail = false;
    //     this.isEmailChecked = false;
    //     this.resellerForm.patchValue({
    //       isEmailVerify: "false"
    //     })
    //   }
    //   else {
    //     if (this.resellerForm.value.isEmailVerify == "true") {
    //       this.isEmailChecked = true;
    //       this.isDesEmail = true;
    //       this.resellerForm.patchValue({
    //         isEmailVerify: "true"
    //       })
    //     }

    //   }
    // }

  }

  onTypeEmail(event) {
    this.resellerForm.patchValue({
      email: event.target.value
    });
  }

  onReset() {
    this.submitted = false
    this.resellerForm.patchValue({
      first_name: '',
      last_name: '',
      email: '',
      contact_number: '',
      password: '',
      plan_name: '',
      tariff: '',
      tariffList: '',
      planLisT: '',
      service: '',
      serviceLisT: '',
    });
  }

  onReset1() {
    this.submitted = false;
    this.resellerForm.reset();
  }


  PostalCode(event: any): boolean {
    if (this.country == 'CA') {
      this.zipLength = 7;
      let Post: any = this.resellerForm.get("postal_code");
      Post.setValidators([Validators.required, Validators.minLength(this.zipLength), Validators.maxLength(this.zipLength)]);
      Post.updateValueAndValidity();

      var regex = new RegExp("^[0-9a-zA-Z \b]+$");
      var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
      if (!regex.test(key)) {
        event.preventDefault();
        return false;
      }
    }
    else {
      this.zipLength = 5;
      let Post: any = this.resellerForm.get("postal_code");
      Post.setValidators([Validators.required, Validators.minLength(this.zipLength), Validators.maxLength(this.zipLength)]);
      Post.updateValueAndValidity();
      const charCode = (event.which) ? event.which : event.keyCode;
      if (charCode > 31 && (charCode < 48 || charCode > 57)) {
        return false;
      }
      return true;
    }
  }

  passwordToggle1(id) {
    this.Resaller.forEach(element => {
      if (element == id) {
        if (element.pswd == 'password') {
          element.pswd = 'text';
          element.pShow = true;
        } else {
          element.pswd = 'password';
          element.pShow = false;
        }
      }
    });
  }


  /**Function for filter hide open**/
  showField() {
    if (this.show == false) {
      this.show = true;
    }
    else {
      this.show = false;
    }
  }

  applyResellerFilter() {
    this.resellerFilter.patchValue({
      fType: ""
    })
    if (this.resellerFilter.invalid) {
      this.submitted = true;
      return
    }
    else {
      this.submitted = false;
      let data1 = JSON.stringify(this.resellerFilter.value);
      this.data.applyresellerFilter(data1).subscribe(res => {
        if (res.status == 200) {
          this.resellerfilter = res.data;
          this.Resaller = this.resellerfilter;
          $('#basic-datatables05').DataTable().clear();
          $('#basic-datatables05').DataTable().destroy();
          $.getScript('./assets/table.js');
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      })
    }
  }

  messageshow() {
    const fromDate = this.resellerFilter.get('fromDate').value;
    const toDate = this.resellerFilter.get('toDate').value;
    const currentDate = new Date();
    if ((!fromDate && !toDate)) {
    } else if ((fromDate == null || !fromDate) && (toDate != null)) {
      this.resellerFilter.get('fromDate').setErrors({ 'dateRange': 'Please select From Date' });
    } else if ((fromDate != null) && (toDate == null || !toDate)) {
      this.resellerFilter.get('toDate').setErrors({ 'dateRange': 'Please select To Date' });
    } else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
      this.resellerFilter.get('toDate').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
      return;
    } else if (toDate && new Date(toDate) > currentDate) {
      this.resellerFilter.get('toDate').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
      return;
    } else if (fromDate && new Date(fromDate) > currentDate) {
      this.resellerFilter.get('fromDate').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
      return;
    } else {
      this.resellerFilter.get('fromDate').setErrors(null);
      this.resellerFilter.get('toDate').setErrors(null);
    }
  }

  resetFilter() {
    this.submitted = false;
    this.resellerFilter.reset();
    // this.applyResellerFilter();
    this.getListReseller()
  }

  resetmodal() {
    this.submitted = false;
    this.resellerForm.patchValue({
      first_name: '',
      last_name: '',
      email: '',
      user_name: '',
      contact_number: '',
      password: '',
    });
  }

  ngOnDestroy() {
    this.resellerModalCenter.nativeElement.click();
    this.onClose();
  }

}
