import { OnInit, ViewChild, AfterViewInit } from "@angular/core";
import { Router, ActivatedRoute, ChildActivationEnd } from "@angular/router";
import { filter, take } from 'rxjs/operators';
import { BehaviorSubject, Observable } from "rxjs";

export class AppData implements OnInit {

    //////@for role permissions//////
    permissions?: any = {}
    userData: any = {}
    //////@for role permissions//////

    constructor(protected router: Router) {

        //////@for role permissions//////
        this.router.events.pipe(
            filter(event => event instanceof ChildActivationEnd),
            take(1),
        ).subscribe((e: ChildActivationEnd) => {
            if (typeof e.snapshot?.data?.permissions != 'undefined' && Array.isArray(e.snapshot?.data?.permissions)) {
                let modules: any = e.snapshot?.data?.permissions
                for (let x of modules) [
                    this.permissions[x.mod_short_key] = {
                        exec_w: x.exec_w,
                        exec_r: x.exec_r,
                        exec_x: x.exec_x
                    }
                ]
            }
        })
        //////@for role permissions//////

        this.userData = this?.router?.config[1]?.data?.sessdata.gSDt
    }
    ngOnInit(): void {
        throw new Error("Method not implemented.");
    }

    getRouteData(): Observable<any> {
        let tmp = new BehaviorSubject<any>(null);
        this?.router?.config[1]?.data?.gvdata?.getData().subscribe(res => {
            tmp.next(res);
        });
        return tmp;
    }

    setRouteData(data: any) {
        this?.router?.config[1]?.data?.gvdata?.setData(data);
    }

    // @unsubscribe observable behaviour on ngDestroy
    onDestroy() { }
}