import { Component, OnInit, Input } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import * as $ from "jquery";
import { MenuService } from './menu.service';
import { Theme } from '../service/AutoTheme';
import { AuthenticationService } from 'src/app/authentication/authentication.service';
import { ProfileService } from 'src/app/profile/profile.service';
import { NgRedux } from 'ng2-redux';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';


@Component({
  selector: 'ap-sidebar',
  templateUrl: './sidebar.component.html'
})
export class SidebarComponent implements OnInit {

  @Input() sidebar = "black";
  @Input() text = "white";
  step: any;
  dySidebar: number;
  isClicked: boolean = false;
  // @select(s=>s) profile$;

  // @select(s=>s.email) accemail;
  // @select(s=>s.username) accusername;
  // @select(s=>s.image) accimage;
  // @select(s=>s.balance) accbal;


  showSubMenu: string = '';
  showMenu: string = '';
  public menu: any;
  public userlist: any;
  public username: string
  public showMobileMenu = false;
  public menus: any[];
  showHide: boolean = true;
  userType: string;
  profile_pic: any;
  // "/assets/img/profile.jpg"
  disabled: boolean = false;
  sesiduser: any;
  idaccount: any;
  iduser: any;
  san: any;
  newUserStatus: any;
  kycHeader: any;
  kycRes: any;
  userData: any;
  kyc_verify_status: any;
  currentRoute: any;

  addExpandClass(element: any) {
    if (element === this.showMenu) {
      this.showMenu = '0';

    } else {
      this.showMenu = element;
    }
  }

  addActiveClass(element: any) {
    if (element === this.showSubMenu) {
      this.showSubMenu = '0';
    } else {
      this.showSubMenu = element;
    }
  }

  constructor(protected authService: AuthenticationService, protected profile: ProfileService,
    private modalService: NgbModal, private router: Router,
    private route: ActivatedRoute, private data: MenuService,
    protected userSerive: UsermanagementService,
    public theme: Theme
  ) {
    this.currentRoute = router.url;
    this.userType = sessionStorage.getItem('type');
    let isLoggedIn = JSON.parse(sessionStorage.getItem('isLoggedIn'));
    if (isLoggedIn.isEmailVerify == 'true' && isLoggedIn.isMobileVerify == 'true', isLoggedIn.isAddress == "true" && isLoggedIn.isEmailVerify == "true") {
      this.disabled = true;
    }
    else {
      this.disabled = false;
    }
    // isLoggedIn.type

  }
  // End open close
  ngOnInit() {

    let isLoggedIn = sessionStorage.getItem("isLoggedIn");
    this.sesiduser = JSON.parse(isLoggedIn);
    this.idaccount = this.sesiduser.idaccount;
    this.iduser = this.sesiduser.iduser;
    this.newUserStatus = this.sesiduser.newUser_status;

    this.userSerive.getSingleUsers().subscribe(res => {
      this.userData = res.data1[0];
      this.kyc_verify_status = res.data1[0].kyc_verify_status;
      if (this.userType == "2" && this.sesiduser.newUser_status == 1 && this.kyc_verify_status == 1) {
        this.data.getCustomersideMenuForVerifykyc().subscribe(res => {
          this.menus = res;
        });
      }

      if (this.kyc_verify_status == 0) {
        this.kyc_verify_status = "Unverified"
      }
      if (this.kyc_verify_status == 1) {
        this.kyc_verify_status = "Verified"
      }
      if (this.kyc_verify_status == 2) {
        this.kyc_verify_status = "Verification Pending"
      }
      if (this.kyc_verify_status == 3) {
        this.kyc_verify_status = "Reject"
      }
      if (this.kyc_verify_status == 4) {
        this.kyc_verify_status = "Cancel"
      }
    })
    $("#demo").focus(() => {
      $(this).parent().css('background', 'yellow',);

    }).blur(() => {
      $(this).parent().css('background', /*color*/);
    })


    this.profile.getUsers("detail").subscribe(res => {
      if (res.data.length > 0) {
        this.userlist = res.data[0];
        this.san = this.userlist[0].san;
        this.username = this.userlist[0].first_name + ' ' + this.userlist[0].last_name;
        this.profile_pic = this.userlist[0].profile_pic;
        if (this.profile_pic == undefined) {
          this.profile_pic = './assets/img/profile.jpg';
        }
      }
    }, error => {
      console.log(error);
    });

    if (this.userType == "1") {
      this.data.getAdminMenu().subscribe(res => {
        this.menus = res;
      });
    }
    else if (this.userType == "2" && (this.idaccount == '202' || this.idaccount == '201' || this.idaccount == '856') && this.newUserStatus == 0) {
      this.data.getCustomersideMenu().subscribe(res => {
        this.menus = res;
      });
    }
    else if (this.userType == "2" && this.newUserStatus == 0) {
      this.data.getCustomerMenu().subscribe(res => {
        this.menus = res;
      });
    }
    else if (this.userType == "22") {
      this.data.getSubCustomer().subscribe(res => {
        this.menus = res;
      }, err => {
        console.log(err.message);
      });
    }
    else if (this.userType == "3") {
      this.data.getSupplierMenu().subscribe(res => {
        this.menus = res;
      }, err => {
        console.log(err.message);
      });
    }
    else if (this.userType == "0") {
      this.data.getCustomerMenu().subscribe(res => {
        this.menus = res;
      }, err => {
        console.log(err.message);
      });
    }
    else if (!this.userType) {
      this.data.getSignupMenu().subscribe(res => {
        this.menus = res;
      }, err => {
        console.log(err.message);
      });
    }
    // this.data.getAdminMenu().subscribe(res => {
    //   this.menus = res
    // });
    if (this.userType == "2" && this.sesiduser.newUser_status == 1) {
      this.data.getCustomersideMenuForKyc().subscribe(res => {
        this.menus = res;
      });
    }


    /*Service for kyc response*/
    //  this.userSerive.getKycHeader().subscribe(res => {
    //   if (res.status == 200) {
    //     this.kycHeader = res.data;
    //     this.kycRes = res.data[0].kyc_verify_status;
    //     if(this.kycRes == 0)
    //     {
    //       this.kycRes = "Unverified"
    //     }
    //     if(this.kycRes == 1)
    //     {
    //       this.kycRes = "Verified"
    //     }
    //     if(this.kycRes == 2)
    //     {
    //       this.kycRes = "Verification Pending"
    //     }
    //   }
    //   else {
    //     this.errMessage = res.message;
    //     setTimeout(() => {
    //       this.errMessage = "";
    //     }, 5000);
    //   }
    // }, err => {
    //   this.errMessage = err.message;
    //   setTimeout(() => {
    //     this.errMessage = "";
    //   }, 5000);
    //  });


  }

  onLogout() {
    this.authService.logout();
  }

  onToogle(e) {
    this.isClicked = !this.isClicked
    this.dySidebar = e;
    $("ul li a").css("background-color", "");
    $("ul li a").css("color", "");
    $("ul li a").css("font-weight", "");
  }
}