import { Component, ElementRef, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { AngularEditorConfig } from '@kolkov/angular-editor';
import { Editor, Toolbar } from 'ngx-editor';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { SignuptemplateService } from '../signuptemplate.service';


@Component({
  selector: 'app-emailtemplate',
  templateUrl: './emailtemplate.component.html',
  styleUrls: ['./emailtemplate.component.css']
})
export class EmailtemplateComponent extends AppComponentClass<any, any> {
  editor: Editor;
  htmlContent: '';
  listdata: any = '';
  errMessage: any = '';
  responseMessage: any = '';
  response: any;
  message = '';
  emailTemplateForm: FormGroup;
  submitted: boolean = false;
  idEmailTemplate: any;
  emailTemplate: any = {};
  show: boolean = false;
  items: any;

  // toolbar: Toolbar = [
  //   ["bold", "italic"],
  //   ["underline", "strike"],
  //   ["code", "blockquote"],
  //   ["ordered_list", "bullet_list"],
  //   [{ heading: ["h1", "h2", "h3", "h4", "h5", "h6"] }],
  //   ["link", "image"],
  //   ["text_color", "background_color"],
  //   ["align_left", "align_center", "align_right", "align_justify"]
  // ];

  config: AngularEditorConfig = {
    editable: true,
    spellcheck: true,
    height: '15rem',
    minHeight: '5rem',
    translate: 'no',
    sanitize: false,
    defaultParagraphSeparator: 'p',
    defaultFontName: 'Arial',
    defaultFontSize: '6',
    toolbarHiddenButtons: [
      [
        'bold'

      ]
    ],
    customClasses: [
      {
        name: "quote",
        class: "quote",
      },
      {
        name: 'redText',
        class: 'redText'
      },
      {
        name: "titleText",
        class: "titleText",
        tag: "h1",
      },
    ]
  };

  @ViewChild("template") template: ElementRef;

  constructor(public data: SignuptemplateService,
    public router: Router, public fb: FormBuilder,
    private route: ActivatedRoute) {

    super(data, router, fb);

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.idEmailTemplate = params.get('id');
      if (this.idEmailTemplate) {
        this.data.getEmailTemplate(this.idEmailTemplate).subscribe(res => {
          if (res.status == 200) {
            if (res.data.length > 0) {
              this.emailTemplate = res.data[0];
              this.emailTemplateForm.patchValue({
                idemail_template: this.emailTemplate.idemail_template,
                subject: this.emailTemplate.subject,
                type: this.emailTemplate.type,
                template: this.emailTemplate.template,
              });
            }
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        });
      }
    });
  }


  ngOnInit(): void {
    this.editor = new Editor();

    this.emailTemplateForm = this.fb.group({
      idemail_template: [''],
      subject: ['', [Validators.required]],
      type: ['', [Validators.required]],
      template: ['', [Validators.required]],
    });
  }

  onSubmit(): void {
    if (this.emailTemplateForm.invalid) {
      this.submitted = true;
      return
    } else {
      if (this.emailTemplateForm.value.idemail_template) {
        this.data.updateEmailTemplate(this.emailTemplateForm.value).subscribe(res => {
          if (res.status == 201) {
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
              this.router.navigateByUrl('/signup-template/email-template-details');
            }, 5000);
          } else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            },5000);
          }
        });
      }
      else {
        this.data.emailTemplate(this.emailTemplateForm.value).subscribe(response => {
          if (response.status == 201) {
            this.responseMessage = response.message;
            setTimeout(() => {
              this.responseMessage = "";
              this.router.navigateByUrl('/signup-template/email-template-details');
            }, 5000);
          } else {
            this.errMessage = response.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        });
      }
    }

  }

  resetTemplete(){
    this.emailTemplateForm.reset({
      idemail_template: this.emailTemplateForm.value.idemail_template,
      type:this.emailTemplateForm.value.type
    });
    this.submitted=false;
  }

  onEdit(data: any) {

  }

  icon() {
    this.show = !this.show;
  }
  addVariable(event: any) {
    var sel, curspos;
    sel = window.getSelection();
    curspos = sel.getRangeAt(0);
    // console.log(curspos);
    this.template = curspos.insertNode(document.createTextNode(event.target.value.toUpperCase()));
  }

  ngOnDestroy(): void {
    this.editor.destroy();
  }
}
