import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, NavigationStart, Router } from '@angular/router';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { FormBuilder } from '@angular/forms';
import { SignuptemplateService } from '../signuptemplate.service';
@Component({
  selector: 'app-factorauthenticationdetails',
  templateUrl: './factorauthenticationdetails.component.html',
  styleUrls: ['./factorauthenticationdetails.component.css']
})
export class FactorauthenticationdetailsComponent extends AppComponentClass<any, any> {
  page = 1;
	field : any;
	header : any;
	count = 0;
	tableSize = 25;
	tableSizes = [ 25,50 , 100];
	searchText = { count: 0 };
	filtre: string;
  errMessage: any = "";
  listdata: any;
  responseMessage: any;
  constructor(public data: SignuptemplateService, 
    
    public router: Router, public fb: FormBuilder, 
    private route: ActivatedRoute) {

    super(data, router, fb);

    }

  ngOnInit(): void {
    this.data.get2FATemplates().subscribe(res =>{
      if(res.status == 200){
        
        if(res.data[0]){
          this.listdata = res.data;
          $.getScript('./assets/table.js');
        }
       
      }else{
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = ""; 
        }, 5000);
      }
    },err =>{
      this.errMessage = err.message; 
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    })
  }

  onTableSizeChange(event): void {
		this.tableSize = event.target.value;
		this.page = 1;
    } 
	  
	onTableDataChange(event){
		this.page = event.length;	
	} 
  onDelete(id2fa_template){
    if(confirm("Are you sure you want to delete data!")){
      this.data.delete2FATemplate(id2fa_template).subscribe(response =>{
        if(response.status == 201){
          this.responseMessage = response.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          this.ngOnInit();
        }else{
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      },err=>{
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      })
    }else{
      "Cancel!"
    }
  }
}
