import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { SignuptemplateService } from '../signuptemplate.service';
declare var $: any;

@Component({
  selector: 'app-mmstemplate',
  templateUrl: './mmstemplate.component.html',
  styleUrls: ['./mmstemplate.component.css']
})
export class MmstemplateComponent implements OnInit {

  mmsTemplateForm: FormGroup;
  submitted: boolean = false;
  errMessage: any = '';
  responseMessage: any = '';
  idMMStemplate: any;
  mmsTemplate: any = {};
  type: string;
  file: File | any;
  distext: string;
  distype: string;
  actvt: any;
  actvf: any;
  imagePreview: any;
  listdata: any;
  textfile: string;
  mediaFiles: any = [];
  userType: any

  constructor(public data: SignuptemplateService, public fb: FormBuilder, private route: ActivatedRoute, public router: Router) {

  }

  ngOnInit(): void {

    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.idMMStemplate = params.get('id');
      if (this.idMMStemplate) {
        this.data.getmms_id(this.idMMStemplate).subscribe(res => {
          if (res.status == 200) {
            if (res.data.length > 0) {
              this.mmsTemplate = res.data[0];
              this.imagePreview = this.mmsTemplate.file_path;
              this.mmsTemplateForm.patchValue({
                idmms_template: this.mmsTemplate.idmms_template,
                name: this.mmsTemplate.name,
                type: this.mmsTemplate.type,
                body: this.mmsTemplate.body,
                file_path: this.mmsTemplate.file_path

              });
            }
          } else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        })
      }
    })
    this.mmsTemplateForm = this.fb.group({
      FROM: ['', [Validators.required]],
      TO: ['', [Validators.required]],
      //BODY: ['',[Validators.required, Validators.pattern(/^[^\s].*$/)]],
      BODY: [''],
      mediaID: ['', [Validators.required]],
    });

    if (this.userType != 1) {
      this.mediaFilesDrop()
    } else {
      this.adminmediaFilesDrop()
    }
  }

  adminmediaFilesDrop() {
    this.data.getAllMmsMediaFiles().subscribe(res => {
      if (res.status == 200) {
        this.mediaFiles = res.data.sort((a, b) => a.mediaID.localeCompare(b.mediaID));
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  mediaFilesDrop() {
    this.data.getMmsMediaFiles().subscribe(res => {
      if (res.status == 200) {
        // this.mediaFiles = res.data
        this.mediaFiles = res.data.sort((a, b) => a.mediaID.localeCompare(b.mediaID));
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  onFilePicked(event: Event) {
    const file: File = (event.target as HTMLInputElement).files[0];
    this.file = file;
    const reader = new FileReader();
    reader.readAsDataURL(file)
  }

  onSubmit() {
    this.submitted = true;
    if (this.mmsTemplateForm.invalid) {
      // if (this.file == null || this.file == undefined) {
      //   this.errMessage = "File is required";
      //   setTimeout(() => {
      //     this.errMessage = "";
      //   }, 5000);
      // }
      return false;
    }
    else {
      //this.data.postmms(this.mmsTemplateForm.value, this.file).subscribe(response => {
      this.data.postmms(this.mmsTemplateForm.value).subscribe(response => {
        if (response.status == 201) {
          this.onReset();
          this.responseMessage = response.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          this.router.navigateByUrl("/signup-template/mms-template");
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    }
  }

  onReset() {
    this.submitted = false;
    this.mmsTemplateForm.reset();
    this.mmsTemplateForm.get('mediaID').setValue('')

  }
  truncatenotification(subject: string, maxLength: number): string {
    return subject.length > maxLength
      ? subject.substring(0, maxLength) + '..'
      : subject;
  }
}
