import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Router } from '@angular/router';
import { SmsService } from '../sms.service';
import { textmessage, testmessageForm } from '../sms.class';
import { InboundService } from 'src/app/inbound/inbound.service';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';


@Component({
	selector: 'app-testmessage',
	templateUrl: './testmessage.component.html',
	styleUrls: ['./testmessage.component.css']
})
export class TestmessageComponent extends AppComponentClass<textmessage, testmessageForm> {

	label: any;
	content: any;
	testmessageForm: FormGroup;
	public submitted: boolean = false;
	responseMessage: any = "";
	errMessage: any = "";
	dids: any = [];
	dropdownSettings: IDropdownSettings = {};
	disabled: boolean;
	featureServiceData: any;
	isDisabledServiceStatus: boolean;
	userType: any;
	serviceMessage:any='SMS service has been suspended. More information please contact support';

	constructor(public data: SmsService, public router: Router, public fb: FormBuilder, private inboundService: InboundService,private userService: UsermanagementService) {
		super(data, router, fb);
	}

	ngOnInit(): void {
		this.userService.getfeatureServiceStatus().subscribe(res => {
			 this.featureServiceData = res.data.find(x => x.fs_id == '1');
			 if(this.featureServiceData!==undefined && this.featureServiceData.as_status=='1')
			 {
				this.isDisabledServiceStatus=false;
			    
			 }else{
				this.isDisabledServiceStatus=true;
				this.showMsg();
			 }
		   });
		

		this.dropdownSettings = {
			singleSelection: true,
			idField: 'did',
			textField: 'did',
			itemsShowLimit: 3,
			allowSearchFilter: true,
			closeDropDownOnSelection: true
		};

		this.inboundService.onGetBuySMSDids().subscribe(res => {
			this.dids = res.data;
		}, err => {
			console.log(err);
		})

		this.data.get_testmessage().subscribe((result) => {
			this.content = result[0];
			this.label = result[1];
		});


		// @subscribing form group
		this.data.solution.subscribe(res => {
			if (res != null) {
				this.cdata = new testmessageForm(res);
				this.keyfield = res.id;
				this.testmessageForm = this.cdata.makeform(this.fb);
			} else {
				this.cdata = new testmessageForm(null);
				this.keyfield = -1;
				this.testmessageForm = this.cdata.makeform(this.fb);
			}
		});

		// this.testmessageForm.patchValue({
		// 	FROM: '82345678900'
		// })
	}

	// onNumber(e: any): void {
	// 	this.testmessageForm.patchValue({
	// 		FROM: e.did
	// 	});
	// 	this.dids = '';
	// }



	onReset() {
		this.submitted = false;
		this.testmessageForm.reset();
	}

	// @to save/update form data
	onTestMessage() {
		if (this.testmessageForm.invalid) {
			this.submitted = true;
			return false;
		} else {
			if (this.cdata.saveForm(this.testmessageForm)) {

				if (this.keyfield == -1) {
					this.data.sendSMS({ FROM: this.testmessageForm.value.FROM[0].did, TO: this.testmessageForm.value.TO, BODY: this.testmessageForm.value.BODY }).subscribe(res => {
						if (res.status == 201) {
							this.responseMessage = res.message;
							this.submitted = false;
							setTimeout(() => {
								this.responseMessage = "";
							}, 5000);
							this.ngOnInit();
						}
						else {
							this.errMessage = res.message;
							setTimeout(() => {
								this.errMessage = "";
							}, 5000);
						}
					}, err => {
						this.responseMessage = err.message;
						setTimeout(() => {
							this.responseMessage = "";
						}, 5000);
					});
				}
			}
		}
	}
	showMsg()
	{
		this.errMessage = this.serviceMessage;
		setTimeout(() => {
			this.errMessage = "";
		}, 5000);
	}

	// allowNumbersOnly(e) {
	// 	var code = (e.which) ? e.which : e.keyCode;
	// 	if (code > 31 && (code < 48 || code > 57)) {
	// 		e.preventDefault();
	// 	}
	// }

}