import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { SmsService } from '../sms.service';
import { ActivatedRoute, Router } from '@angular/router';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
declare var $: any;

@Component({
  selector: 'app-uploadmediaviamms',
  templateUrl: './uploadmediaviamms.component.html',
  styleUrls: ['./uploadmediaviamms.component.css']
})
export class UploadmediaviammsComponent implements OnInit {
  @ViewChild('closeModal') closeModal: ElementRef;
  @ViewChild('modalImageAppeal') modalImageAppeal: ElementRef;
  @ViewChild('modalPdfAppeal') modalPdfAppeal: ElementRef;
  @ViewChild('modalVideoForFile') modalVideoForFile: ElementRef;
  @ViewChild('modalForaudio') modalForaudio: ElementRef;
  header: any[];
  uploadForm: FormGroup;
  submitted: boolean = false;
  errMessage: any = "";
  responseMessage: any = "";
  file: File;
  mediaFiles: any;
  files: any;
  fileErr: string;
  userType: number;
  mediaMMSFiles: any;

  constructor(public data: SmsService, public router: Router, public fb: FormBuilder, private route: ActivatedRoute) { }

  ngOnInit(): void {
    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;

    this.uploadForm = this.fb.group({
      name: ['', [Validators.required, Validators.pattern(/^[^\s].*$/)]],
      uploadFile: ['', [Validators.required]]
    })

    this.getMMSMedia();
    this.getAllMMSMedia();

  }

  getMMSMedia() {
    this.data.getMmsMediaFiles().subscribe(res => {
      if (res.status == 200) {
        this.mediaFiles = res.data;
        $('#basic-datatables9').dataTable().fnClearTable();
        $('#basic-datatables9').dataTable().fnDraw();
        $('#basic-datatables9').dataTable().fnDestroy();
        $.getScript('./assets/tollfree.js');
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 2000);
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }


  getAllMMSMedia() {
    this.data.getAllMmsMediaFiles().subscribe(res => {
      if (res.status == 200) {
        this.mediaMMSFiles = res.data;
        $('#basic-datatables10').dataTable().fnClearTable();
        $('#basic-datatables10').dataTable().fnDraw();
        $('#basic-datatables10').dataTable().fnDestroy();
        $.getScript('./assets/tollfree.js');
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 2000);
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  onFilePicked(event: Event) {
    const fileInput = event.target as HTMLInputElement;
    const file: File = fileInput.files[0];
    if (!file) {
      return;
    }
    const allowedTypes = ['audio/mpeg', 'audio/mp3', 'audio/wav', 'audio/weba', 'image/jpeg', 'image/jpg', 'image/gif', 'image/png', 'application/pdf', 'video/mp4', 'image/bmp', 'audio/qcelp', 'audio/QCELP', 'audio/x-wav', 'audio/midi', 'audio/mid', 'audio/amr', 'audio/aac', 'audio/aacp', 'text/x-vcard', 'video/h263', 'video/h264', 'video/jpeg', 'video/3gpp', 'video/3gpp2', 'video/mp4v-es', 'video/mp4-es', 'video/mp4-es', 'application/gzip', 'application/rtf','video/quicktime','application/x-gzip','application/msword','application/x-zip-compressed','audio/vnd.dlna.adts','image/webp'];
    if (!allowedTypes.includes(file.type)) {
      this.errMessage = "Invalid file type !";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
      fileInput.value = '';
      return;
    }
    this.file = file;
    const reader = new FileReader();
    reader.readAsDataURL(file);
    this.fileErr = '';
  }

  submitform() {
    if (this.uploadForm.invalid) {
      this.submitted = true;
      return;
    } else {
      let filename = $('#upload').val();
      if (filename) {
        this.data.uploadMmsMediaFile(this.uploadForm.value, this.file).subscribe(
          (res) => {
            if (res.status == 200) {
              this.responseMessage = res.message;
              setTimeout(() => {
                this.responseMessage = "";
                this.closeModal.nativeElement.click();
                this.getMMSMedia();
              }, 3000);
            } else {
              this.errMessage = res.message;
              setTimeout(() => {
                this.errMessage = "";
              }, 5000);
            }
          },
          (err) => {
            let errorMessage = 'An unknown error occurred';
            if (err.error && err.error.error) {
              errorMessage = err.error.error;
            }
            this.errMessage = errorMessage;
            setTimeout(() => {
              this.errMessage = "";
            }, 3000);
          }
        );
      } else {
        this.fileErr = "File is required";
      }
    }
  }


  resetForm() {
    this.submitted = false;
  }

  onDelete(mediaID) {
    if (confirm("Are you sure you want to delete this data!")) {
      this.data.deleteMmsMedia(mediaID).subscribe(response => {
        if (response.status == 201) {
          this.responseMessage = response.message;
          setTimeout(() => {
            this.responseMessage = "";
            this.getMMSMedia();
          }, 3000);
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      });
    } else {
      "Cancel!"
    }
  }

  closepop() {
    this.submitted = false;
    this.uploadForm.reset();
    this.closeModal.nativeElement.click();
    $('#upload').val("");
  }

  viewFile(item: any) {
    const fileExtension = item.file_ext;
    const pdfModal = document.getElementById('modalPdfAppeal');
    const imageModal = document.getElementById('modalImageAppeal');
    const docxModal = document.getElementById('modalDocxAppeal');
    const videoModal = document.getElementById('modalVideoForFile');
    const audioModal = document.getElementById('modalForaudio');
    const modalImage = document.getElementById('modalImage') as HTMLImageElement;
    const modalImage123 = document.getElementById('modalPdf') as HTMLIFrameElement;
    const videoModal12 = document.getElementById('videoModal') as HTMLVideoElement;
    const audioModal13 = document.getElementById('audioModal') as HTMLVideoElement;
    if (fileExtension === "png" || fileExtension === "jpg" || fileExtension === "jpeg" || fileExtension === "webp" || fileExtension === "gif"  || fileExtension === "bmp") {
      modalImage.src = item.file;
      $(imageModal).modal('show');
    } else if (fileExtension === 'pdf') {
      modalImage123.src = item.file
      $(pdfModal).modal('show');

    } else if (fileExtension === 'mp4' || fileExtension === "mpeg" || fileExtension === "webm" || fileExtension === "h263" || fileExtension === "h264" || fileExtension === "jpgv" || fileExtension === "3gp" || fileExtension === "3g2" || fileExtension === "mov") {
      videoModal12.src = item.file;
      $(videoModal).modal('show');
      $(videoModal).on('shown.bs.modal', function () {
        videoModal12.play();
      });
      $(videoModal).on('hidden.bs.modal', function () {
        videoModal12.pause();
      });
    } else if (fileExtension === 'mp3' || fileExtension === "weba" || fileExtension === "wav" || fileExtension === "qcelp" || fileExtension === "qcp" || fileExtension === "xwav" || fileExtension === "midi" || fileExtension === "mid" || fileExtension === "amr" || fileExtension === "aacp" || fileExtension === "aac") {
      audioModal13.src = item.file;
      $(audioModal).modal('show');
      $(audioModal).on('shown.bs.modal', function () {
        audioModal13.play();
      });
      $(audioModal).on('hidden.bs.modal', function () {
        audioModal13.pause();
      });
    }  else {
      if (item.file_ext) {
        const a = document.createElement('a');
        a.href = item.file;
        a.download = item.name;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        $(docxModal).modal('show');
      }
    }
  }


  ngOnDestroy() {
    this.modalForaudio.nativeElement.click();
    this.modalVideoForFile.nativeElement.click();
    this.modalPdfAppeal.nativeElement.click();
    this.modalImageAppeal.nativeElement.click();
    this.closepop();
  }
}
