import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormControl, FormGroup } from '@angular/forms';
import { TariffService } from '../tariff.service';
declare var $: any;

@Component({
  selector: 'app-lerginfo',
  templateUrl: './lerginfo.component.html',
  styleUrls: ['./lerginfo.component.css']
})

export class LerginfoComponent implements OnInit {

  @ViewChild("takeInput", {static: false})
  InputVar: ElementRef;

  public show: boolean = false;
  public buttonName: any = "Add";
  page = 1;
	count = 0;
	tableSize = 50;
	tableSizes = [ 50, 100, 200];
  filterTerm: string

  lerg_file: File;
  responseMessage = "";
  errMessage: any = "";
  header: any;
  listdata: any;

  constructor(private formBuilder: FormBuilder, private tariffSevice: TariffService) { }

  ngOnInit(): void {

    this.tariffSevice.get_lerginfo().subscribe((result) => {
      this.header = result[0].headers_details; 
    });
    this.getLead();
    
  }
  getLead(){
    this.tariffSevice.getleadinfo().subscribe((result) =>{
      $('#basic-datatables').DataTable().clear();
      $('#basic-datatables').DataTable().destroy();
      this.listdata = result.data;
      $.getScript('./assets/table.js');
    });
  }

  resetLerg(){
    this.InputVar.nativeElement.value = "";
  }

  pickedFile(event: Event){
    const file:File = (event.target as HTMLInputElement).files[0];
    this.lerg_file = file;
    const reader = new FileReader();
    reader.readAsDataURL(file);
  }

  uploadLerg(){
    if(this.lerg_file){
      this.tariffSevice.uploadLergFile(this.lerg_file).subscribe(res => {
        if(res.status == 201){
          // $("#exampleModal").hide();
          // $(".modal-backdrop").remove();
          this.getLead();
          document.getElementById("closeLergeModal").click();
          this.responseMessage = res.message;
          setTimeout(()=>{
            this.responseMessage= "";
          }, 5000);
        }
        else{
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    }
    else{
      this.errMessage = "File is required!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    }
  }

  toggle() {
    this.show = !this.show;
    if (this.show) this.buttonName = "Close";
    else this.buttonName = "Add";
  }
}
