import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { TariffService } from '../tariff.service';
declare var $:any;

@Component({
  selector: 'app-list',
  templateUrl: './list.component.html',
  styleUrls: ['./list.component.css']
})

export class ListComponent implements OnInit {
  searchText = { count: 0 };
	filtre: string;
  hide:boolean=true;
  tariffs: any;
  page = 1;
	count = 0;
	tableSize = 50;
	tableSizes = [50, 100, 150];
  filterTerm: string;
	row: any;
	idtariff: any;
  tariffForm: FormGroup;
  responseMessage = "";
  errMessage = "";
  editTariffRate: any;
  tariffsName: any;
  tariffLength: any;
  submitted: boolean;

  constructor(private data: UsermanagementService,
              private tariffService: TariffService,
              private fb: FormBuilder) { }

  ngOnInit(): void {

    this.tariffForm=this.fb.group({
      id: [],
			name:['', [Validators.required]],
			description: ['', [Validators.required, Validators.minLength(10)]],
      //day_num: new FormControl("", [Validators.required])    
		});

    this.tariffService.getTariffs().subscribe(res => {
      this.tariffs = res.data;
      $('#basic-datatables').DataTable().clear();
				$('#basic-datatables').DataTable().destroy();
      $.getScript('./assets/table.js');
      this.tariffLength = this.tariffs.length;
    });
  }

  editModal(data){
    this.tariffForm.setValue({
      id: data.idtariff,
      name: data.name,
      description: data.description,
      //day_num: data.day_num
    });
  }


  editTariff(){
    if (this.tariffForm.invalid) {
      this.submitted = true;
      return;
    }
    else{ 
      this.tariffService.updateTariff(this.tariffForm.value).subscribe(res => {
        if(res.status == 201){
          $("#exampleModal").hide();
          $(".modal-backdrop").remove();
          this.responseMessage = res.message;
          setTimeout(()=>{
            this.responseMessage= "";
          }, 5000);
         window.location.reload();
        }
        else{
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
        }
      }, err => {
        this.responseMessage = err.message;
        setTimeout(()=>{
          this.responseMessage= "";
        }, 5000);
      });
    }
  }

  deleteTariff(idtariff){
    if(confirm("Are you sure you want delete data!")){
      this.tariffService.deleteTariff(idtariff).subscribe(res => {
          if(res.status == 201){
            this.responseMessage = res.message;
            setTimeout(()=>{
              this.responseMessage= "";
            }, 5000);
            window.location.reload();
          }
          else{
              this.errMessage = res.message;
              setTimeout(() => {
                this.errMessage = "";
              }, 5000);
          }
      }, err => {
        this.responseMessage = err.message;
        setTimeout( () => {
          this.responseMessage = "";
        }, 5000)
      })
    }else{
      "Cancel!";
    }
  }
  onClose() {
    this.submitted =false;
    this.tariffForm.reset();
  }


}
