import { Component, OnInit } from '@angular/core';
import { FormBuilder } from '@angular/forms';
import { TariffService } from '../tariff.service';

@Component({
  selector: 'app-zone',
  templateUrl: './zone.component.html',
  styleUrls: ['./zone.component.css']
})
export class ZoneComponent implements OnInit {
  public show: boolean = false;
  public buttonName: any = "Add";
  page = 1;
	count = 0;
	tableSize = 50;
	tableSizes = [ 50, 100, 200];
  filterTerm: string
  zone_file: File;
  responseMessage: any = "";
  errMessage: any = "";
  header: any;
  listdata: any;
  rowdata: any;
  filePath: any;

  constructor(private formBuilder: FormBuilder, private tariffSevice: TariffService) { }

  ngOnInit(): void {
    // $.getScript('./assets/table.js');
    this.tariffSevice.getZones().subscribe(res => {
      if(res.status == 200){
        if(res.data[0]){
          $.getScript('./assets/table.js');
         
        }   
      }
      else{
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
      }
    })

    this.tariffSevice.get_zone().subscribe((result) => {
      this.header = result[0].headers_details; 
      // this.rowdata = result[0].zoneinfo; 
    });

   
  }




  toggle() {
    this.show = !this.show;
    if (this.show) this.buttonName = "Close";
    else this.buttonName = "Add";
  }

  pickedFile(event: Event){
    console.log(event, this.filePath);
    const file:File = (event.target as HTMLInputElement).files[0];
    this.zone_file = file;
    const reader = new FileReader();
    reader.readAsDataURL(file);
  }


  uploadZone(){
    this.tariffSevice.uploadZoneFile(this.zone_file).subscribe(res => {
        if(res.status == 201){
          $("#exampleModal").hide();
          $(".modal-backdrop").remove();
          this.responseMessage = res.message;
          setTimeout(()=>{
            this.responseMessage= "";
          }, 3000);
        }
        else{
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
    }, err => {
      this.errMessage = err.message;
				setTimeout(()=>{
				  this.errMessage= "";
				}, 3000);
    });
  }
}