import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { TollfreesmsComponent } from './tollfreesms/tollfreesms.component';
import { VerifysenderdetailComponent } from './verifysenderdetail/verifysenderdetail.component';
import { AddverifysenderComponent } from './addverifysender/addverifysender.component';
import { AssignTollFreeNumberComponent } from './assign-toll-free-number/assign-toll-free-number.component';
import { ViewComponent } from './view/view.component';


const routes: Routes = [
    {
        path: '',
        children: [
            {
                path: 'Verified-Sender',
                component: TollfreesmsComponent,
                data: {
                    title: 'Toll Free SMS',
                    urls: [
                        {
                            title: 'Toll Free SMS',
                            // url: '/toll-free-sms'
                        },
                        {
                            title: 'Create Profile'
                        }
                    ]
                }
            },
            {
                path: 'toll-free-sms',
                component: TollfreesmsComponent,
                data: {
                    title: 'Toll Free SMS',
                    urls: [
                        {
                            title: 'Toll Free SMS',
                            // url: '/toll-free-sms'
                        },
                        {
                            title: 'Toll Free SMS'
                        }
                    ]
                }
            },
            {
                path: 'assign-toll-free-number',
                component: AssignTollFreeNumberComponent,
                data: {
                    title: 'Assign Toll Free Number',
                    urls: [
                        {
                            title: 'Toll Free SMS'
                        },
                        {
                            title: 'Assign Toll Free Number'
                        }
                    ]
                }
            },
            {
                path: 'view-details',
                component: VerifysenderdetailComponent,
                data: {
                    title: 'Toll Free SMS',
                    urls: [
                        {
                            title: 'Toll Free SMS'
                        },
                        {
                            title: 'View Details'
                        }
                    ]
                }
            },
            {
                path: 'view-details/:unique_request_id',
                component: VerifysenderdetailComponent,
                data: {
                    title: 'Toll Free SMS',
                    urls: [
                        {
                            title: 'Toll Free SMS'
                        },
                        {
                            title: 'View Details'
                        }
                    ]
                }
            },
            {
                path: 'addverifysender',
                component: AddverifysenderComponent,
                data: {
                    title: 'Toll Free SMS',
                    urls: [
                        {
                            title: 'Toll Free SMS'
                        },
                        {
                            title: 'Verify Sender'
                        }
                    ]
                }
            },
            {
                path: 'edit-verifysender/:unique_request_id',
                component: AddverifysenderComponent,
                data: {
                    title: 'Edit Verify Sender',
                    urls: [
                        {
                            title: 'Verify Sender',
                        },
                        {
                            title: 'Edit Verify Sender'
                        }
                    ]
                }
            },
            {
                path: 'view',
                component: ViewComponent,
                data: {
                    title: 'Toll Free SMS',
                    urls: [
                        {
                            title: 'Toll Free SMS'
                        },
                        {
                            title: 'View'
                        }
                    ]
                }
            },
            {
                path: 'view/:batch_id',
                component: ViewComponent,
                data: {
                    title: 'Toll Free SMS',
                    urls: [
                        {
                            title: 'Toll Free SMS'
                        },
                        {
                            title: 'View Details'
                        }
                    ]
                }
            },
            {
                path: 'view/:batch_id/view-details/:unique_request_id',
                component: VerifysenderdetailComponent,
                data: {
                    title: 'Toll Free SMS',
                    urls: [
                        { title: 'Toll Free SMS' },
                        { title: 'View Details' }
                    ]
                }
            }


        ]
    }
];

@NgModule({
    imports: [RouterModule.forChild(routes)],
    exports: [RouterModule]
})
export class TollfreesmsRoutingModule { }
