import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { TollfreesmsService } from '../tollfreesms.service';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { HttpClient } from '@angular/common/http';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
declare var $: any;

@Component({
  selector: 'app-verifysenderdetail',
  templateUrl: './verifysenderdetail.component.html',
  styleUrls: ['./verifysenderdetail.component.css']
})
export class VerifysenderdetailComponent implements OnInit {
  @ViewChild('closeIcon') closeIcon: ElementRef;
  @ViewChild('reject') reject: ElementRef;
  @ViewChild('modalImageAppeal') modalImageAppeal: ElementRef;
  @ViewChild('modalPdfAppeal') modalPdfAppeal: ElementRef;
  @ViewChild('modalVideoForFile') modalVideoForFile: ElementRef;
  public userdetail: any;
  header_detail: any;
  verified: any = [];
  id: string;
  view_data: any;
  Vstatus: any;
  responseMessage = "";
  errMessage: any;
  userType: any;
  iduser: any;
  idaccount: any;
  public rejectForm: FormGroup;
  eventDetails: any;
  submitted: boolean = false;
  number: any = [];
  selectedFile: File[] = [];
  files: any;
  key: any;
  constructor(public router: Router, private http: HttpClient, public data: TollfreesmsService, private route: ActivatedRoute, public fb: FormBuilder) { }

  ngOnInit(): void {

    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;
    this.iduser = session.iduser;
    this.idaccount = session.idaccount;



    this.data.get_tollfree_detail().subscribe((result) => {
      this.userdetail = result;
      this.header_detail = this.userdetail[1].viewDetails
    })

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.id = params.get('unique_request_id');  
      this.viewdetailsdata();    
    });

    this.rejectForm = this.fb.group({
      reject_text: ['', [Validators.required, Validators.pattern(/^[^\s].*$/)]],
    });

  }

  viewdetailsdata() {
    let payLoad: any = JSON.stringify({
      id: this.id,
    });
    this.data.view_VerifySender(payLoad).subscribe((result) => {
      if (result.status == 200) {
        this.view_data = result.data[0];        
        this.eventDetails = result.data;
        this.Vstatus = this.view_data.status;
        this.key = this.view_data.file_upload_key
        if (!this.key) {
          this.files = [];
        } if (this.key) {
          const filePaths = this.view_data.file_paths.split(',');
          this.files = [];
          filePaths.forEach((filePath, index) => {
            const fileName = filePath.substring(filePath.lastIndexOf('/') + 1);
            const fileObject = {
              file: filePath.trim(),
              name: fileName,
            };
            this.files.push(fileObject);
          });
        }
        $('#basic-datatables3').dataTable().fnClearTable();
        $('#basic-datatables3').dataTable().fnDraw();
        $('#basic-datatables3').dataTable().fnDestroy();
        $.getScript('./assets/tollfree.js');
      }
    });
  }

  verifySender() {
    let data = {
      idaccount: this.view_data.idaccount,
      iduser: this.view_data.iduser,
      id: this.view_data.unique_request_id
    }
    this.data.approveSender(data).subscribe((res) => {
      if (res.status == 201) {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
          this.router.navigate(['./toll-free-sms']);
        }, 5000);
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }

    })
  }

  rejectSender() {
    this.submitted = true;
    if (this.rejectForm.invalid) {
      return false;
    }
    const data = {
      idaccount: this.view_data.idaccount,
      iduser: this.view_data.iduser,
      id: this.view_data.unique_request_id,
      reject_text: this.rejectForm.get('reject_text').value,
    };
    this.data.rejectSenderStatus(data).subscribe((res) => {
      if (res.status === 201) {
        this.responseMessage = res.message;
        this.closeIcon.nativeElement.click();
        setTimeout(() => {
          this.responseMessage = '';
          this.router.navigate(['./toll-free-sms']);
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }



  OnReset() {
    this.submitted = false
    this.rejectForm.reset()
  }

  toggleDescription(data: any) {
    data.moreShown = !data.moreShown;
  }

  downloadFile(data) {
    if (data.file) {
      const a = document.createElement('a');
      a.href = data.file;
      a.download = data.name;
      a.click();
    }
  }

  viewFile(data: any) {
    const fileExtension = data.name.split('.').pop();

    const pdfModal = document.getElementById('modalPdfAppeal');
    const imageModal = document.getElementById('modalImageAppeal');
    const docxModal = document.getElementById('modalDocxAppeal');
    const videoModal = document.getElementById('modalVideoForFile');
    const modalImage = document.getElementById('modalImage') as HTMLImageElement;
    const modalImage123 = document.getElementById('modalPdf') as HTMLIFrameElement;
    const videoModal12 = document.getElementById('videoModal') as HTMLVideoElement;
    if (fileExtension === "png" || fileExtension === "jpg" || fileExtension === "jpeg") {
      const imageData = data.file;
      modalImage.src = data.file
      // Open the modal for images
      $(imageModal).modal('show');
    } else if (fileExtension === 'pdf') {
      // const pdfData = data.file
      modalImage123.src = data.file
      // Open the modal for non-image files
      $(pdfModal).modal('show');
    } else if (fileExtension === 'mp4') {
      // const videoData = data.file;
      videoModal12.src = data.file
      // Open Modal for Video
      $(videoModal).modal('show');
      $(videoModal).on('hidden.bs.modal', function () {
        videoModal12.pause();
      });
    }
    else {
      if (data.file) {
        const a = document.createElement('a');
        a.href = data.file;
        a.download = data.name;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        $(docxModal).modal('show');
      }
    }
  }

  ngOnDestroy() {
    this.reject.nativeElement.click();
    this.modalVideoForFile.nativeElement.click();
    this.modalPdfAppeal.nativeElement.click();
    this.modalImageAppeal.nativeElement.click();
  }
}
