import { Component, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { MatAccordion } from '@angular/material/expansion';
import { ActivatedRoute, ParamMap } from '@angular/router';
import { TariffService } from 'src/app/tariff/tariff.service';

@Component({
  selector: 'app-customerrate',
  templateUrl: './customerrate.component.html',
  styleUrls: ['./customerrate.component.css']
})
export class CustomerrateComponent implements OnInit {

  @ViewChild(MatAccordion) accordion: MatAccordion;
  rowdata: any;
  data: any;
  filterTerm: string
  count = 0;
  tableSize: any;
  page: number;
  headerdetails: any;
  tariffForm: FormGroup;
  resAlertMessage = "";
  responseMessage: any = "";
  submitted: boolean = false;
  status: boolean = false;
  idtariff: any;
  voiceApiForm: FormGroup;
  headerApi: any;
  voiceApiFields: any;
  iVoiceHeader: any;
  iVoiceFields: any;
  iVoiceForm: any;
  numberPriceForm: FormGroup;
  numberFields: any;
  numberHeader: any;
  depthFields: any;
  depthHeader: any;
  depthForm: FormGroup;
  sipForm: FormGroup;
  sipFields: any;
  sipHeader: any;
  iSipHeader: any;
  iSipFields: any;
  iSipForm: FormGroup;
  sipNumberForm: FormGroup;
  sipNumberFields: any;
  sipNumberHeader: any;
  depthSipForm: FormGroup;
  depthSipHeader: any;
  depthSipFields: any;
  msgActForm: FormGroup;
  campaignRateForm: FormGroup;
  msgFields: any;
  msgHeader: any;
  smsHeader: any;
  smsFields: any;
  campaignFields: any;
  smsRateForm: FormGroup;
  tariffName: any;
  userData: any = [];
  lookupForm: FormGroup;
  lookupHeader: any;
  lookupFields: any;
  campaignReviewForm: FormGroup;
  campaignReviewFields: any = [];
  campaignReviewHeader: any;
  activatemsgForm: FormGroup;
  rateType: Boolean = false;
  activateheader: any;
  activateFields: any;

  constructor(private fb: FormBuilder,
    private tariffService: TariffService, private route: ActivatedRoute) { }

  ngOnInit(): void {

    let session: any = JSON.parse(sessionStorage.getItem("isLoggedIn"));
    this.tariffService.getSingleUsers().subscribe(res => {
      this.userData = res.data1[0];
      this.idtariff = this.userData.idtariff;

      if (this.idtariff) {
        this.tariffService.getTariff(this.idtariff).subscribe(res => {
          this.tariffName = res.data[0].name;
        });
      }

      this.tariffService.get_voiceapi().subscribe(res => {
        this.headerApi = res[0].header;
        this.voiceApiFields = res[0].fields;
        let voiceApiField = [];
        this.voiceApiFields.forEach(element => {
          voiceApiField["priority_" + element.priority] = [element.priority],
            voiceApiField["idtariff_" + element.priority] = [this.idtariff],
            voiceApiField["type_" + element.priority] = ["voice"],
            voiceApiField["subtype_" + element.priority] = ["voice_api"],
            voiceApiField["category_" + element.priority] = [element.categoryValue],
            voiceApiField["mo_" + element.priority] = [0],
            voiceApiField["mt_" + element.priority] = [0]

        });
        this.voiceApiForm = this.fb.group(voiceApiField);

        this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "voice", subtype: "voice_api" }).subscribe(res => {
          // this.voiceApiFields = res.data;
          let tmp = [];
          res.data.forEach(element => {
            tmp["idrates_" + element.priority] = [element.idrates],
              tmp["category_" + element.priority] = [element.category],
              tmp["mo_" + element.priority] = [element.mo],
              tmp["mt_" + element.priority] = [element.mt]
          });

          this.voiceApiForm = this.fb.group(tmp);
        });


        this.iVoiceHeader = res[1].header1;
        this.iVoiceFields = res[1].fields1;
        let iVoiceFields1$ = [];
        this.iVoiceFields.forEach(element => {
          iVoiceFields1$["priority_" + element.priority] = [element.priority],
            iVoiceFields1$["idtariff_" + element.priority] = [this.idtariff],
            iVoiceFields1$["type_" + element.priority] = ["voice"],
            iVoiceFields1$["subtype_" + element.priority] = ["inteligent"],
            iVoiceFields1$["category_" + element.priority] = [element.categoryValue],
            iVoiceFields1$["price_" + element.priority] = [0]
        });
        this.iVoiceForm = this.fb.group(iVoiceFields1$);

        this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "voice", subtype: "inteligent" }).subscribe(res => {
          // this.voiceApiFields = res.data;
          let tmp = [];
          res.data.forEach(element => {
            tmp["idrates_" + element.priority] = [element.idrates],
              tmp["category_" + element.priority] = [element.category],
              tmp["price_" + element.priority] = [element.rate]
            // tmp["mt_"+element.priority]=[element.mt]
          });

          this.iVoiceForm = this.fb.group(tmp);

        });

        this.numberHeader = res[2].header2;
        this.numberFields = res[2].fields2;
        let numberFields$ = [];
        this.numberFields.forEach(element => {
          numberFields$["priority_" + element.priority] = [element.priority],
            numberFields$["idtariff_" + element.priority] = [this.idtariff],
            numberFields$["type_" + element.priority] = ["voice"],
            numberFields$["subtype_" + element.priority] = ["number"],
            numberFields$["category_" + element.priority] = [element.categoryValue],
            numberFields$["price_" + element.priority] = [0]
        });
        this.numberPriceForm = this.fb.group(numberFields$);

        this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "voice", subtype: "number" }).subscribe(res => {
          let tmp = [];
          res.data.forEach(element => {
            tmp["idratesnew_" + element.priority] = undefined,
              tmp["idrates_" + element.priority] = [element.idrates],
              tmp["category_" + element.priority] = [element.category],
              tmp["price_" + element.priority] = [element.rate]
          });

          this.numberPriceForm = this.fb.group(tmp);
        })

        this.depthHeader = res[3].header3;
        this.depthFields = res[3].fields3;
        let depthFields$ = [];
        this.depthFields.forEach(element => {
          depthFields$["priority_" + element.priority] = [element.priority],
            depthFields$["idtariff_" + element.priority] = [this.idtariff],
            depthFields$["type_" + element.priority] = ["voice"],
            depthFields$["subtype_" + element.priority] = ["depth_voice"],
            depthFields$["category_" + element.priority] = [element.categoryValue],
            depthFields$["mo_" + element.priority] = [0],
            depthFields$["mt_" + element.priority] = [0]
        });
        this.depthForm = this.fb.group(depthFields$);

        this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "voice", subtype: "depth_voice" }).subscribe(res => {
          let tmp = [];
          res.data.forEach(element => {
            tmp["idratesnew_" + element.priority] = undefined,
              tmp["idrates_" + element.priority] = [element.idrates],
              tmp["category_" + element.priority] = [element.category],
              tmp["mo_" + element.priority] = [element.mo],
              tmp["mt_" + element.priority] = [element.mt]
          });

          this.depthForm = this.fb.group(tmp);
        })
      });

      this.tariffService.get_elasticSip().subscribe(res => {
        this.sipFields = res[0].fields;
        this.sipHeader = res[0].header;
        let sipFields$ = [];
        this.sipFields.forEach(element => {
          sipFields$["priority_" + element.priority] = [element.priority],
            sipFields$["idtariff_" + element.priority] = [this.idtariff],
            sipFields$["type_" + element.priority] = ["elastic"],
            sipFields$["subtype_" + element.priority] = ["sip_trunking"],
            sipFields$["category_" + element.priority] = [element.categoryValue],
            sipFields$["mo_" + element.priority] = [0],
            sipFields$["mt_" + element.priority] = [0]
        });
        this.sipForm = this.fb.group(sipFields$);

        this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "elastic", subtype: "sip_trunking" }).subscribe(res => {
          let tmp = [];
          res.data.forEach(element => {
            tmp["idrates_" + element.priority] = [element.idrates],
              tmp["category_" + element.priority] = [element.category],
              tmp["mo_" + element.priority] = [element.mo],
              tmp["mt_" + element.priority] = [element.mt]
          });

          this.sipForm = this.fb.group(tmp);
        })

        this.iSipFields = res[1].fields1;
        this.iSipHeader = res[1].header1;
        let iSipFields$ = [];
        this.iSipFields.forEach(element => {
          iSipFields$["priority_" + element.priority] = [element.priority],
            iSipFields$["idtariff_" + element.priority] = [this.idtariff],
            iSipFields$["type_" + element.priority] = ["elastic"],
            iSipFields$["subtype_" + element.priority] = ["inteligent"],
            iSipFields$["category_" + element.priority] = [element.categoryValue],
            iSipFields$["price_" + element.priority] = [0]
        });
        this.iSipForm = this.fb.group(iSipFields$);

        this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "elastic", subtype: "inteligent" }).subscribe(res => {
          let tmp = [];
          res.data.forEach(element => {
            tmp["idrates_" + element.priority] = [element.idrates],
              tmp["category_" + element.priority] = [element.category],
              tmp["price_" + element.priority] = [element.rate]
          });

          this.iSipForm = this.fb.group(tmp);
        })

        this.sipNumberFields = res[2].fields2;
        this.sipNumberHeader = res[2].header2;
        let sipNumberFields$ = [];
        this.sipNumberFields.forEach(element => {
          sipNumberFields$["priority_" + element.priority] = [element.priority],
            sipNumberFields$["idtariff_" + element.priority] = [this.idtariff],
            sipNumberFields$["type_" + element.priority] = ["elastic"],
            sipNumberFields$["subtype_" + element.priority] = ["number"],
            sipNumberFields$["category_" + element.priority] = [element.categoryValue],
            sipNumberFields$["price_" + element.priority] = [0]
        });
        this.sipNumberForm = this.fb.group(sipNumberFields$);

        this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "elastic", subtype: "number" }).subscribe(res => {
          let tmp = [];
          res.data.forEach(element => {
            tmp["idrates_" + element.priority] = [element.idrates],
              tmp["category_" + element.priority] = [element.category],
              tmp["price_" + element.priority] = [element.rate]
          });

          this.sipNumberForm = this.fb.group(tmp);
        })

        this.depthSipFields = res[3].fields3;
        this.depthSipHeader = res[3].header3;
        let depthSipFields$ = [];
        this.depthSipFields.forEach(element => {
          depthSipFields$["priority_" + element.priority] = [element.priority],
            depthSipFields$["idtariff_" + element.priority] = [this.idtariff],
            depthSipFields$["type_" + element.priority] = ["elastic"],
            depthSipFields$["subtype_" + element.priority] = ["depth_voice"],
            depthSipFields$["category_" + element.priority] = [element.categoryValue],
            depthSipFields$["mo_" + element.priority] = [0],
            depthSipFields$["mt_" + element.priority] = [0]
        });
        this.depthSipForm = this.fb.group(depthSipFields$);

        this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "elastic", subtype: "depth_voice" }).subscribe(res => {
          let tmp = [];
          res.data.forEach(element => {
            tmp["idrates_" + element.priority] = [element.idrates],
              tmp["category_" + element.priority] = [element.category],
              tmp["mo_" + element.priority] = [element.mo],
              tmp["mt_" + element.priority] = [element.mt]
          });

          this.depthSipForm = this.fb.group(tmp);
        });
      });

      this.tariffService.get_MessagePricing().subscribe(res => {

        this.smsHeader = res[5].header5;
        this.smsFields = res[5].fields5;

        let tmp = [];
        this.smsFields.forEach(element => {
          tmp["priority_" + element.priority] = [element.priority],
            tmp["idtariff_" + element.priority] = [this.idtariff],
            tmp["category_" + element.priority] = [element.categoryValue],
            tmp["categoryValue_" + element.priority] = [element.category],
            tmp["subCategory_" + element.priority] = [element.SubCategory],
            tmp["type_" + element.priority] = ["unregistered"],
            tmp["MO_" + element.priority] = [0],
            tmp["MT_" + element.priority] = [0]
        });
        this.smsRateForm = this.fb.group(tmp);

        this.tariffService.GetSmsRate({ idtariff: this.idtariff, type: "unregistered" }).subscribe(res => {
          let tmp = [];
          res.data.forEach(element => {
            tmp["idsmsrate_" + element.priority] = [element.idsmsrate],
              tmp["category_" + element.priority] = [element.category],
              tmp["MO_" + element.priority] = [element.MO_rates],
              tmp["MT_" + element.priority] = [element.MT_rates]
          });
          this.smsRateForm = this.fb.group(tmp);
        });

        /*ACTIVATION MSG*/
        this.tariffService.get_activateMsg().subscribe(res => {
          this.activateheader = res[0].header;
          this.activateFields = res[0].fields;
          let activateField = [];
          this.activateFields.forEach(element => {
            activateField["priority_" + element.priority] = [element.priority],
              activateField["idtariff_" + element.priority] = [this.idtariff],
              activateField["type_" + element.priority] = ["message_activation"],
              activateField["category_" + element.priority] = [element.categoryValue],
              activateField["mrc_" + element.priority] = [0],
              activateField["nrc_" + element.priority] = [0]
          });
          this.activatemsgForm = this.fb.group(activateField);
    
          this.tariffService.getactivate_msg({ idtariff: this.idtariff, type: "message_activation" }).subscribe(res => {
            let tmp = [];
            res.data.forEach(element => {
              tmp["idratesnew_" + element.priority] = undefined,
                tmp["idrates_" + element.priority] = [element.idrates],
                tmp["category_" + element.priority] = [element.category],
                tmp["mrc_" + element.priority] = [element.mrc],
                tmp["nrc_" + element.priority] = [element.nrc]
            });
            this.activatemsgForm = this.fb.group(tmp);
          });
    
        });

        this.msgHeader = res[1].header1;
        this.msgFields = res[1].fields1;
        let msgFields$ = [];
        this.msgFields.forEach(element => {
          msgFields$["priority_" + element.priority] = [element.priority],
            msgFields$["idtariff_" + element.priority] = [this.idtariff],
            msgFields$["type_" + element.priority] = ["message"],
            msgFields$["subtype_" + element.priority] = ["message_activation"],
            msgFields$["category_" + element.priority] = [element.categoryValue],
            msgFields$["price_" + element.priority] = [0],
            msgFields$["mo_" + element.priority] = [0],
            msgFields$["mt_" + element.priority] = [0]
        });
        this.msgActForm = this.fb.group(msgFields$);
      });

      this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "message", subtype: "message_activation" }).subscribe(res => {
        let tmp = [];
        res.data.forEach(element => {
          tmp["idrates_" + element.priority] = [element.idrates],
            tmp["category_" + element.priority] = [element.category],
            tmp["price_" + element.priority] = [element.rate],
            tmp["mo_" + element.priority] = [element.mo],
            tmp["mt_" + element.priority] = [element.mt]
        });
        this.msgActForm = this.fb.group(tmp);
      })

      // For Lookup API
      this.tariffService.get_lookuprates().subscribe(res => {
        this.lookupHeader = res[0].header;
        this.lookupFields = res[0].fields;
        let lookuptmp = [];
        this.lookupFields.forEach(element => {
          lookuptmp["priority_" + element.priority] = [element.priority],
            lookuptmp["idtariff_" + element.priority] = [this.idtariff],
            lookuptmp["category_" + element.priority] = [element.category],
            lookuptmp["categoryValue_" + element.priority] = [element.categoryValue],
            lookuptmp["type_" + element.priority] = ["lookup"],
            lookuptmp["price_" + element.priority] = [0]
        });

        this.lookupForm = this.fb.group(lookuptmp);
        // campaign review rates 
        this.campaignReviewHeader = res[1].headers1;
        this.campaignReviewFields = res[1].fields1;
        let campaignReviewtmp = [];
        this.campaignReviewFields.forEach(element => {
          campaignReviewtmp["priority_" + element.priority] = [element.priority],
            campaignReviewtmp["idtariff_" + element.priority] = [this.idtariff],
            campaignReviewtmp["category_" + element.priority] = [element.category],
            campaignReviewtmp["type_" + element.priority] = ["campaign"],
            campaignReviewtmp["price_" + element.priority] = [0]
        });
        this.campaignReviewForm = this.fb.group(campaignReviewtmp);

      });

      this.tariffService.lookupRates({ idtariff: this.idtariff, type: "lookup" }).subscribe(res => {
        let tmp = [];
        res.data.forEach(element => {
          tmp["idrates_" + element.priority] = [element.idrates],
            tmp["category_" + element.priority] = [element.category],
            tmp["price_" + element.priority] = [element.rate]
        });

        this.lookupForm = this.fb.group(tmp);
      });
      this.tariffService.campaignReviewRates({ idtariff: this.idtariff, type: "campaign" }).subscribe(res => {
        let tmp = [];
        res.data.forEach(element => {
          tmp["idrates_" + element.priority] = [element.campaign_rate_id],
            tmp["category_" + element.priority] = [element.category],
            tmp["price_" + element.priority] = [element.rate]
        });
        this.campaignReviewForm = this.fb.group(tmp);
      });

    });
    /* Added here function for showing campagnrate values*/
    this.tariffService.GetCampaignRate().subscribe((res) => {
      this.campaignFields = res.data;
      this.campaignRateForm = this.fb.group(this.campaignFields);
    });
  }


  onVoiceApi() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];
    response[4] = [];

    for (let key of Object.keys(this.voiceApiForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.voiceApiForm.value[key] });
    }
    let temp = response.slice(1, 4);
    this.tariffService.updateVoiceRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  oniVoice() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];
    response[4] = [];
    response[5] = [];
    response[6] = [];

    for (let key of Object.keys(this.iVoiceForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.iVoiceForm.value[key] });
    }
    let temp = response.slice(1, 6);
    this.tariffService.updateVoiceRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  onNumberPrice() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];

    for (let key of Object.keys(this.numberPriceForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.numberPriceForm.value[key] });
    }
    let temp = response.slice(1, 3);
    this.tariffService.updateVoiceRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  onDepthRate() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];
    response[4] = [];
    response[5] = [];

    for (let key of Object.keys(this.depthForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.depthForm.value[key] });
    }
    let temp = response.slice(1, 5);
    this.tariffService.updateVoiceRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  onSipPrice() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];

    for (let key of Object.keys(this.sipForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.sipForm.value[key] });
    }
    let temp = response.slice(1, 3);
    this.tariffService.updateVoiceRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  oniSipPrice() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];
    response[4] = [];
    response[5] = [];
    response[6] = [];
    response[7] = [];

    for (let key of Object.keys(this.iSipForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.iSipForm.value[key] });
    }
    let temp = response.slice(1, 7);
    this.tariffService.updateVoiceRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  onSipNumber() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];

    for (let key of Object.keys(this.sipNumberForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.sipNumberForm.value[key] });
    }
    let temp = response.slice(1, 3);
    this.tariffService.updateVoiceRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  onDepthSipRate() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];
    response[4] = [];
    response[5] = [];

    for (let key of Object.keys(this.depthSipForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.depthSipForm.value[key] });
    }
    let temp = response.slice(1, 5);
    this.tariffService.updateVoiceRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  onSmsRates() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];
    response[4] = [];
    response[5] = [];
    response[6] = [];
    response[7] = [];

    for (let key of Object.keys(this.smsRateForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.smsRateForm.value[key] });
    }
    let temp = response.slice(1, 7);
    this.tariffService.updateSMSRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }


  msgActivationRates() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];
    response[4] = [];
    response[5] = [];

    for (let key of Object.keys(this.msgActForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.msgActForm.value[key] });
    }
    let temp = response.slice(1, 5);
    this.tariffService.updateVoiceRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  //   activatemessage(){
//     let response: any = [];
//     response[0] = [];
//     response[1] = [];
//     response[2] = [];
//     response[3] = [];
//     response[4] = [];
// ;
//     for (let key of Object.keys(this.activatemsgForm.value)) {
//       let tmp = key.split('_');
//       response[tmp[1]].push({ field: tmp[0], value: this.activatemsgForm.value[key] });
//       console.log(this.activatemsgForm.value[key])
//     }
//     let temp = response.slice(1,4);
//     this.tariffService.updateactivatemessage(temp).subscribe(resp => {
//       this.responseMessage = resp.message;
//       setTimeout(() => {
//         this.responseMessage = "";
//       }, 5000);
//     }, err => {
//       this.responseMessage = err.message;
//       setTimeout(() => {
//         this.responseMessage = "";
//       }, 5000);
//     });
//   }

}
