import { Component, Input, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { Observable } from 'rxjs';
import { TariffService } from 'src/app/tariff/tariff.service';
import { UsermanagementService } from '../usermanagement.service';
import { ResellerService } from 'src/app/reseller/reseller.service';


@Component({
  selector: 'app-edituser',
  templateUrl: './edituser.component.html',
  styleUrls: ['./edituser.component.css']
})
export class EdituserComponent implements OnInit {

  @Input() usertype: Observable<boolean>;
  @Input() curuserid?: number = -1;
  step = 0;
  userProfile: any[];
  zipLength: any;
  user: any = [];
  verifiedData: any = [];
  resellerFilter: FormGroup;
  resllerlist: any =[];
  newUserStatus: any ='';
  setStep(index: number) {
    this.step = index;
  }

  showMsg: boolean = false;
  p: number = 1;
  rowdata: any;
  details: any;
  listdata: any;
  record: any;
  list: any;
  // defaultSelect : any = 1;
  page = 1;
  count = 0;
  tableSize = 5;
  tableSizes = [5, 9, 12];
  modelform: any;
  public show: boolean = false;
  public package: any;
  public supplieruserForm: FormGroup;
  responseMessage = "";
  submitted: boolean = false;
  filterTerm: string;
  file: any;
  imagePreview: any;
  regTariffs: any = [];
  unregTariffs: any;
  dangMessage = "";
  fullName: String;

  preferenceForm: FormGroup
  smsForm: FormGroup
  voiceForm: FormGroup;
  suppliers: any;
  preferenceDID: any = [];
  preferenceSMS: any = [];
  preferenceVoice: any = [];
  voiceSupplier = [];
  smsSupplier = [];
  didSupplier = [];
  status: boolean = false;
  preferenceControls: any;
  didPreference: any = [];
  smsPreference: any = [];
  voicePreference: any = [];
  iduser: string;
  idaccount: string;
  idpreference: string;
  isEditDid: boolean = false;
  isEditSms: boolean = false;
  isEditVoice: boolean = false;
  preference: any;
  preferenceServices: any = [];
  errMessage: any = "";
  subCustomer: any;
  USA: boolean = false;
  Canada: boolean = false;
  countryVal: any;

  isDisableAdd: boolean;
  isDesMob: boolean;
  isDesEmail: boolean;
  isAddChecked: boolean;
  isMobChecked: boolean;
  isEmailChecked: boolean = false;
  inputvalue: any = '';
  Addresslist: any;
  custType: string;
  UsaState: any;
  corporationLimitedCountry: any =[];
	solePropCountry: any[];
	internationalBusiCountry: any =[];
	noneProfitCountry: any =[];
	allCountry: any =[];
	Country:any;
  constructor(public data: UsermanagementService,
    public router: Router, public fb: FormBuilder,
    private tariffService: TariffService,private resellerService:ResellerService, private route: ActivatedRoute) {
  }

  ngOnInit(): void {

    this.supplieruserForm = this.fb.group({
      idaccount: ['', Validators.required],
      iduser: ['', [Validators.required]],
      first_name: ['', [Validators.required, Validators.pattern("^[a-zA-Z][a-zA-Z '-]*$")]],
      last_name: ['', [Validators.required, Validators.pattern("^[a-zA-Z][a-zA-Z '-]*$")]],
      email: ['', [Validators.required,
        Validators.pattern("^([A-Za-z0-9._%+-]+)@([A-Za-z0-9-]+\\.[A-Za-z]{2,4})(\\.[A-Za-z]{2,4})?$")]],
      user_name: ['', [Validators.required,Validators.pattern(/^([A-z0-9!@#$%^&*().,<>{}[\]<>?_`~=+\-|;:\'\"\/])*[^\s]\1*$/)]],
      contact_number: ['', [Validators.required]],
      password: ['', [Validators.required, Validators.minLength(5)]],
      type: [''],
      profile_pic: [''],
      tariff1: ['', [Validators.required]],
      tariff2: [],
      status: [],
      service: ['', [Validators.required]],
      credit_limit: ['', [Validators.required, Validators.min(0), Validators.max(500000)]],
      isEmailVerify: [''],
      isMobileVerify: [''],
      isAddress: [''],
      customerType: [''],
      address1: [''],
      address2: [''],
      city: [''],
      state: [''],
      postal_code: [''],
      country: [''],
      title: [''],
      businessName: [''],
      ein: [''],
      website: [''],
      groupExmpt_number: [''],
      reseller_id:['']
    });

    this.preferenceForm = this.fb.group({
      preference1: ['', [Validators.required]],
      preference2: [''],
      preference3: [''],
    });

    this.smsForm = this.fb.group({
      preference1: ['', [Validators.required]],
    });

    this.voiceForm = this.fb.group({
      preference1: ['', [Validators.required]],
    });
    this.resellerFilter = this.fb.group({
      fType: [''],
      email: [''],
			firstname: [''],
			lastname: [''],	
      fromDate: [''],
      toDate: [''],				
		 })
    
    this.tariffService.getPreferenceService().subscribe(res => {
      this.preferenceServices = res.data;
    }, err => {
      console.log(err.message);
    });


    this.route.paramMap.subscribe((params: ParamMap) => {
      let userData = params.get('id');
      let splitUser = userData.split('-');
      this.iduser = splitUser[0];
      this.idaccount = splitUser[1];
      this.subCustomer = splitUser[2];
      if (this.subCustomer == '22') {
        this.supplieruserForm.get('tariff1').disable();
        this.supplieruserForm.get('service').disable();
        this.supplieruserForm.get('credit_limit').disable();
      }


      this.supplieruserForm.patchValue({
        iduser: this.iduser
      });
      // this.getUserAddress(this.supplieruserForm.value.iduser);
      if (this.iduser) {
        this.data.getUser({ iduser: this.iduser, idaccount: this.idaccount, type: "edit" }).subscribe(result => {

          let users = result.data[0];
          this.user = users[0];          
          this.fullName = this.user.user_name;
          this.supplieruserForm.patchValue({
            idaccount: this.user.idaccount,
            first_name: this.user.first_name,
            last_name: this.user.last_name,
            email: this.user.email,
            type: this.user.type,
            user_name: this.user.user_name,
            contact_number: this.user.contact_number.replace(/\s/g, ""),
            password: this.user.password,
            profile_pic: this.user.profile_pic,
            tariff1: this.user.idtariff1,
            tariff2: this.user.idtariff2,
            service: this.user.idservice,
            credit_limit: this.user.credit_amount,
            reseller_id:this.user.reseller_iduser,
          });
          // if(this.user.reseller_iduser =='0' || this.user.reseller_iduser =='' || this.user.reseller_iduser ==null || this.user.reseller_iduser ==undefined || this.user.reseller_iduser =='null' || this.user.reseller_iduser =='undefined'){
          //   this.supplieruserForm.get("reseller_id").enable();
          // }else{
          //    this.supplieruserForm.get("reseller_id").disable();
          // }
        });
         this.getCountry();
      }
    });


    this.data.getSuppliers().subscribe(supplier => {
      this.suppliers = supplier.data;
      supplier.data.forEach(element => {
        if (element.sms == "yes") {
          this.smsSupplier.push(element);
        }
        if (element.voice == "yes") {
          this.voiceSupplier.push(element);
        }
        if (element.did == "yes") {
          this.didSupplier.push(element);
        }
      });
    });

    this.data.getpreference().subscribe((result) => {
      this.preferenceControls = result;
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });

    this.data.getsuppiler().subscribe((result) => {
      this.listdata = result[1];
      this.record = result[0].headers_details;
      this.list = result[0].profile_details;
      this.Addresslist = result[0].address_details;
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });

    this.data.US_State().subscribe(res => {
			this.UsaState = res[0].US_State;
		});

    // Get tariffs
    this.tariffService.getTypesTariff("Registered").subscribe(res => {
      this.regTariffs = res.data;


    });

    this.tariffService.getTypesTariff("Unregistered").subscribe(res => {
      this.unregTariffs = res.data;
    })

    // let sessData = JSON.parse(sessionStorage.getItem("isLoggedIn"));
    // let iduser = sessData.iduser;
    // this.getUserAddress(this.supplieruserForm.value.iduser);
    this.resellerService.getReseller(JSON.stringify(this.resellerFilter.value)).subscribe(res => {
      if (res.status == 200) {
        this.resllerlist=res.data;
      }
    })
  }

  close() {
    this.submitted = false;
    this.supplieruserForm.reset({
      user_name:this.user.user_name,
        idaccount: this.user.idaccount,
        iduser: this.user.iduser,
        password: this.user.password
    });
  }

  isCheckedFun(event, type) {
    if (type == 'address') {
      if(this.supplieruserForm.value.address1 && this.supplieruserForm.value.city && this.supplieruserForm.value.state && this.supplieruserForm.value.country && this.supplieruserForm.value.postal_code && this.supplieruserForm.value.website && this.supplieruserForm.controls['website'].valid && this.supplieruserForm.controls['postal_code'].valid){
        
        this.supplieruserForm.patchValue({
          isAddress: event.target.checked
        })
        this.isAddChecked = true;
      } 
    }
    if (type == 'phone') {
      if (!this.supplieruserForm.controls['contact_number'].errors) {
        this.supplieruserForm.patchValue({
          isMobileVerify: event.target.checked
        });
        this.isMobChecked = true;
      }
    }
    if (type == 'email') {
      if (!this.supplieruserForm.controls['email'].errors) {
        this.supplieruserForm.patchValue({
          isEmailVerify: event.target.checked
        });
        this.isEmailChecked = true;
      }
    }
  }

  isField(type) {
    if (type == 'address') {
      if (this.supplieruserForm.value.address1 && this.supplieruserForm.value.city && this.supplieruserForm.value.state && this.supplieruserForm.value.country && this.supplieruserForm.value.postal_code && this.supplieruserForm.value.website && this.supplieruserForm.controls['website'].valid && this.supplieruserForm.controls['postal_code'].valid) {
        if(this.custType == 'Corporation' || this.custType == 'International_business'){
					if(this.supplieruserForm.value.businessName && this.supplieruserForm.value.ein && this.supplieruserForm.value.title && this.supplieruserForm.controls['ein'].valid){
						this.isAddChecked = false;
						this.isDisableAdd = false;
					}
					else{
						this.isAddChecked = false;
						this.isDisableAdd = true;
					}
				}
        else if(this.custType == 'Non_Profit'){
					if(this.supplieruserForm.value.groupExmpt_number && this.supplieruserForm.value.title && this.supplieruserForm.value.ein && this.supplieruserForm.controls['ein'].valid){
						this.isAddChecked = false;
						this.isDisableAdd = false;
					}
					else{
						this.isAddChecked = false;
						this.isDisableAdd = true;
					}
				}
        else if(this.custType == 'Sole_Proprietor'){
					if(this.supplieruserForm.value.businessName){
						this.isAddChecked = false;
						this.isDisableAdd = false;
					}
					else{
						this.isAddChecked = false;
						this.isDisableAdd = true;
					}
				}
        if(this.verifiedData.isAddress== "true"){
          this.supplieruserForm.patchValue({
            isAddress:true
          })
          this.isAddChecked = true;
        }
        else{
          this.supplieruserForm.patchValue({
            isAddress:false
          })
          this.isAddChecked = false;
        }
      }
      else {
        this.isAddChecked = false;
        this.isDisableAdd = true;
      }
    }
    if (type == 'phone') {
      if (this.supplieruserForm.value.contact_number && !this.supplieruserForm.controls['contact_number'].errors) {
        if(this.user.contact_number !== this.supplieruserForm.value.contact_number){
          this.isMobChecked = false;
          this.isDesMob = false;
          this.supplieruserForm.patchValue({
            isMobileVerify:false
          })
        }
        else{
          if(this.verifiedData.isMobileVerify == "true"){
            this.isMobChecked = true;
            this.isDesMob = false;
            this.supplieruserForm.patchValue({
              isMobileVerify:true
            })
          }
          else{
            this.isMobChecked = false;
            this.isDesMob = false;
            this.supplieruserForm.patchValue({
              isMobileVerify:false
            });
          }
        }
      }
      else {
        this.isMobChecked = false;
        this.isDesMob = true;
      }
    }
    if (type == 'email') {
      if (this.supplieruserForm.value.email && !this.supplieruserForm.controls['email'].errors) {
        if(this.user.email!== this.supplieruserForm.value.email){
          this.isEmailChecked = false;
          this.isDesEmail = false;
          this.supplieruserForm.patchValue({
            isEmailVerify:false
          })
        }
        else{
          if(this.verifiedData.isEmailVerify=="true"){
            this.isEmailChecked = true;
            this.isDesEmail = false;
            this.supplieruserForm.patchValue({
              isEmailVerify:true
            })
          }
          else{
            this.isEmailChecked = false;
            this.isDesEmail = false;
            this.supplieruserForm.patchValue({
              isEmailVerify:false
            })
          }
        }
      }
      else {
        this.isEmailChecked = false;
        this.isDesEmail = true;
      }
    }

  }



  ValidateAddress() {
    if (this.countryVal == 'US') {
      this.data.getGeoCodeAdd(this.supplieruserForm.value).subscribe(res => {
        if (res.status == 200) {
          this.onEditUser();
        }
        else {
          this.errMessage = "Address Validation Failed!";
          setTimeout(() => {
            this.errMessage = "";
          }, 3000);
          return false;
        }
      }, err => {
        this.responseMessage = err.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 3000);
      });
      return false
    }
    else {
      this.onEditUser();
    }
  }

  
  onEditUser() { 
    this.supplieruserForm.get("reseller_id").enable();
    this.submitted = true;
    if (this.supplieruserForm.invalid) {
      return;
    } else {
      this.data.SaveUserData(JSON.stringify(this.supplieruserForm.value)).subscribe(res => {
        if (res.status == 201) {
          this.submitted = false;
          this.responseMessage = res.message;
          //this.ngOnInit();
          setTimeout(() => {
            this.responseMessage = "";
            window.location.reload();
          }, 5000);
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    }
  }

  onTypeEmail(event) {
    this.supplieruserForm.patchValue({
      email: event.target.value
    });
  }

  onInputChange(event)
	{   
	  var k;  
	  k = event.charCode;  
	  const targetValue: string = (event.target as HTMLInputElement).value;
	  if ((k >= 33 && k <= 126) || k === 8 || (k === 32 && /[^\s]$/.test(targetValue))){
		return true;
	  }
	  return false
	}


  getCountry(){
		this.data.getCountry().subscribe(res => {
			this.corporationLimitedCountry = [];
			this.solePropCountry = [];
			this.internationalBusiCountry = [];
			this.noneProfitCountry = [];
			if (res.status == 200) {			
				this.allCountry = res.data;
			  this.allCountry.forEach(element => {
					// To get Corporation / Limited Liability Company (USA Only)
					if(element.corporation_or_limited_liability_company_only_us == '1')
						this.corporationLimitedCountry.push(element);

					// To get Sole Proprietor / Individual
					if(element.sole_proprietor_or_individual == '1')
						this.solePropCountry.push(element);

					// To get International Business (non-US)
					if(element.international_business_none_us == '1')
						this.internationalBusiCountry.push(element);

					// To get Non-Profit, 501C
					if(element.none_profit_501c == '1')
						this.noneProfitCountry.push(element);
				});	
        this.getUserAddress(this.supplieruserForm.value.iduser);		
			}
			else{
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = "Something went wrong with country list!";
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}
  onCountry(e: any) {
		if (e.target.value == 'US') {
			this.USA = true;
			this.Canada = false;
			this.countryVal = 'US';
			this.zipLength = '';
			let post = this.supplieruserForm.get('postal_code').value;
			this.supplieruserForm.get('state').setValue('');
			if (post.length != 5) {
				this.supplieruserForm.get('postal_code').setValue('');
			}
		}
		else if (e.target.value == 'CA') {
			this.Canada = true;
			this.USA = false;
			this.countryVal = 'CA';
			let post = this.supplieruserForm.get('postal_code').value;
			this.supplieruserForm.get('state').setValue('');
			if (post.length != 10) {
				this.supplieruserForm.get('postal_code').setValue('');
			}
		}
		else {
			this.Canada = false;
			this.USA = false;
			this.countryVal = '';
		}
	}
  Oncustomer(change) {
		this.Addresslist.forEach(element => {
			if (this.custType == 'Corporation' || this.custType == 'International_business') {
        // if(this.custType == 'International_business'){
				// 	this.supplieruserForm.get('country').setValue('CA');
				// }
				if (element.id == "groupExmpt_number") {
					this.supplieruserForm.get('groupExmpt_number').setValue('');
					element.hide = true;
				}
				else{
					element.hide = false;
				}
				if (element.id == "businessName" || element.id == "ein") {
					this.supplieruserForm.get('businessName').enable();
					this.supplieruserForm.get('ein').enable();
				}
				if(element.id == "businessName" || element.id == "ein" || element.id == "title" || element.id == "groupExmpt_number"){
					if(element.id == "businessName"){
						element.label = "Legal Business Name";
						element.placeholder = "Legal Business Name"
					}
					else if(element.id == "ein" && this.custType == 'Corporation'){
						let ein: any = this.supplieruserForm.get(element.formControl);
						ein.setValidators([Validators.minLength(9)]);
						ein.updateValueAndValidity();
					}
					else{
						let other: any = this.supplieruserForm.get(element.formControl);
						other.setValidators([]);
						other.updateValueAndValidity();
					}
				}
        if(this.custType == 'Corporation'){
					this.Country = this.corporationLimitedCountry;
				}
				else{
					this.Country = this.internationalBusiCountry;
				}
			}
			else if (this.custType == 'Non_Profit') {
				if (element.id == "title" || element.id == "groupExmpt_number") {
					element.hide = false;
				}
				if (element.id == "businessName" || element.id == "ein") {
					this.supplieruserForm.get('ein').enable();
					if(element.id == "businessName"){
						element.label = "Legal Name";
						element.placeholder = "Legal Name"
					}
				}

				if(element.id == "businessName" || element.id == "ein" || element.id == "title" || element.id == "groupExmpt_number"){
					if(element.id == "ein"){
						let ein: any = this.supplieruserForm.get(element.formControl);
						ein.setValidators([Validators.minLength(9)]);
						ein.updateValueAndValidity();
					}
					else{
						let other: any = this.supplieruserForm.get(element.formControl);
						other.setValidators([]);
						other.updateValueAndValidity();
					}
				}
        this.Country = this.noneProfitCountry;
			}
			else if(this.custType == 'Sole_Proprietor') {
				if (element.id == "title" || element.id == "groupExmpt_number") {
					element.hide = true;
					this.supplieruserForm.get('groupExmpt_number').setValue('');
					this.supplieruserForm.get('title').setValue('');
				}
				else{
					element.hide = false;
				}
				if(element.id == 'ein' || element.id == 'businessName'){
					this.supplieruserForm.get('businessName').enable();
					this.supplieruserForm.get('ein').disable();
					this.supplieruserForm.get('ein').setValue('');
				}

				if(element.id == "businessName" || element.id == "ein" || element.id == "title" || element.id == "groupExmpt_number"){
					if(element.id == "businessName"){
						element.label = "Fictitious Business Name";
						element.placeholder = "Fictitious Business Name"
					}
					else{
						let other: any = this.supplieruserForm.get(element.formControl);
						other.setValidators([]);
						other.updateValueAndValidity();
					}
				}
        this.Country = this.solePropCountry;
			}
		});
    if(change== 'change'){
			this.isAddChecked = false;
			this.isDisableAdd = true;
      if(this.custType== 'Corporation'){
				this.countryVal="US";
				this.supplieruserForm.get('country').setValue('US');
        this.USA = true;
			  this.Canada = false;
			}
			else{
				this.supplieruserForm.get('country').setValue('');
        this.USA = false;
			}
      this.supplieruserForm.get('ein').setValue('');
		}
    else{
      if(this.custType== 'Corporation'){
        this.USA = true;
      }
    }
	}

  taxeinID(evt: any) {
    if(this.custType=='International_business'){
			// var regex = new RegExp("^[0-9a-zA-Z \b]+$");
			// var key = String.fromCharCode(!evt.charCode ? evt.which : evt.charCode);
			// if (!regex.test(key)) {
			// 	evt.preventDefault();
			// 	return false;
			// }
      return true;
		}
		else{
			var charCode = (evt.which) ? evt.which : evt.keyCode;
			if (charCode != 45 && charCode > 31 && (charCode < 48 || charCode > 57))
				return false;
			return true;
		}
	}

  specialNumber(event: any): boolean {
    this.inputvalue = this.inputvalue.toUpperCase();
    if (this.Canada == true) {
      this.zipLength = 10;
      let Post: any = this.supplieruserForm.get("postal_code");
      Post.setValidators([Validators.minLength(0), Validators.maxLength(this.zipLength)]);
      Post.updateValueAndValidity();
      var regex = new RegExp("^[0-9a-zA-Z \b]+$");
      var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
      if (!regex.test(key)) {
        event.preventDefault();
        return false;
      }
    }
    if(this.USA == true) {
      this.zipLength = 5;
      let Post: any = this.supplieruserForm.get("postal_code");
      Post.setValidators([Validators.minLength(this.zipLength), Validators.maxLength(this.zipLength)]);
      Post.updateValueAndValidity();
      const charCode = (event.which) ? event.which : event.keyCode;
      if (charCode > 31 && (charCode < 48 || charCode > 57)) {
        event.preventDefault();
        return false;
      }
      return true;
    }
  }

  onPaste(){
    return false
  }


  getUserAddress(iduser) {
    this.data.getSingleUsersForAdmin(iduser).subscribe(res => {
      this.verifiedData=res.data1[0];
      this.newUserStatus = res.data1[0].newUser_status;
      if (res.status == 200) {
        if(res.data[0]){
          this.custType = res.data[0].customerType ? res.data[0].customerType: '';
          if(!this.custType){
            this.Country = this.solePropCountry;
          }
          this.supplieruserForm.patchValue({
            address1: res.data[0].address1,
            address2: res.data[0].address2,
            city: res.data[0].city,
            state: res.data[0].state,
            postal_code: res.data[0].postal_code,
            country: res.data[0].country && res.data[0].country!=='undefined' ? res.data[0].country : '',
            businessName: res.data[0].businessName ? res.data[0].businessName : '',
            ein: res.data[0].ein ? res.data[0].ein : '',
            website: res.data[0].website ? res.data[0].website : '',
            title: res.data[0].title ? res.data[0].title: '',
            groupExmpt_number: res.data[0].groupExmpt_number ? res.data[0].groupExmpt_number: ''
          });
          if(res.data[0].country == 'CA'){
            this.Canada = true;
          }
          else{
            if(res.data[0].country == 'US'){
              this.USA = true; 
            }
          }
        }
        if(res.data1[0]){
          this.supplieruserForm.patchValue({
            isAddress: res.data1[0].isAddress,
            isMobileVerify: res.data1[0].isMobileVerify,
            isEmailVerify: res.data1[0].isEmailVerify,
            ipAddress: res.data1[0].ipAddress
          });
          this.isAddChecked = res.data1[0].isAddress === "true" ? true : false;
          this.isMobChecked = res.data1[0].isMobileVerify === "true" ? true : false;
          this.isEmailChecked = res.data1[0].isEmailVerify === "true" ? true : false;
          this.OnblankData();
        }
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  OnblankData(){
    if(this.verifiedData.isAddress == "true"){
      if(this.supplieruserForm.value.address1 && this.supplieruserForm.value.city && this.supplieruserForm.value.state && this.supplieruserForm.value.country && this.supplieruserForm.value.postal_code){
        this.isDisableAdd = false;
        this.isAddChecked = true; 
      }
      else{
        this.isDisableAdd = true;
        this.isAddChecked = false;
        this.supplieruserForm.patchValue({
          isAddress: false
        })
      }
      if(this.newUserStatus=='0'){
        this.isDisableAdd = true;
      }
    }
    if(this.verifiedData.isAddress == "false"){
      if(this.supplieruserForm.value.address1 && this.supplieruserForm.value.city && this.supplieruserForm.value.state && this.supplieruserForm.value.country && this.supplieruserForm.value.postal_code){
        this.isDisableAdd = false;
      }
      else{
        this.isDisableAdd = true;
      }
    }
    if(this.verifiedData.isMobileVerify == "true" || this.verifiedData.isMobileVerify == "false"){
      if(this.verifiedData.isMobileVerify == "true"){
        if(!this.supplieruserForm.value.contact_number){
          this.supplieruserForm.patchValue({
            isMobileVerify: false
          });
          this.isMobChecked = false;
          this.isDesMob = true;
        }
      }
      else{
        if(!this.supplieruserForm.value.contact_number){
          this.isDesMob = true;
        }
      }
    }
    if(this.verifiedData.isEmailVerify == "true" || this.verifiedData.isEmailVerify == "false"){
      if(this.verifiedData.isEmailVerify == "true"){
        if(!this.supplieruserForm.value.email){
          this.supplieruserForm.patchValue({
            isEmailVerify: false
          });
          this.isEmailChecked = false;
          this.isDesEmail = true;
        }
      }
      else{
        if(!this.supplieruserForm.value.email){
          this.isDesEmail = true;
        }
      }
    }
    this.Oncustomer('');
  }

  // Preference 
  // onPreference(e, type){
  //   this.didSupplier.forEach(element => {
  //   if(e.target[e.target.options.selectedIndex].value == element.key){
  //      element.selected = "true";
  //     }
  //   });

  //   let index = e.target.id;
  //   let idpreference = null;
  //   if(this.didPreference.length > 0){
  //     idpreference = this.didPreference[index].idpreference;
  //   }
  //   this.preferenceDID[index] = { index: index, "idsupplier": e.target.value, "idcustomer": this.idaccount, "priority": index, type: type, idpreference: idpreference }; 
  // }

  // onSMS(e, type){
  //   this.didSupplier.forEach(element => {
  //     if(e.target[e.target.options.selectedIndex].value == element.key){
  //       element.selected = "true";
  //     }
  //   });
  //     let index = e.target.id;
  //     let idSmsPreference = null;
  //     if(this.didPreference.length > 0){
  //       idSmsPreference = this.didPreference[index].idpreference;
  //     }
  //     this.preferenceSMS[index] = { index: index, "idsupplier": e.target.value,"idcustomer": this.idaccount, "priority": index, type: type, idpreference: idSmsPreference };
  // }

  // onVoice(e, type){
  //   this.didSupplier.forEach(element => {
  //     if(e.target[e.target.options.selectedIndex].value == element.key){
  //       element.selected = "true";
  //     }
  //   });
  //   let index = e.target.id;
  //   let idVoicePreference = null;
  //     if(this.didPreference.length > 0){
  //       idVoicePreference = this.didPreference[index].idpreference;
  //     }

  //   this.preferenceVoice[index] = { index: index, "idsupplier": e.target.value,"idcustomer": this.idaccount, "priority": index, type: type, idpreference: idVoicePreference };
  // }

  resetOptions() {
    $('select').prop('selectedIndex', 0);
    this.didSupplier.forEach(element => {
      element.selected = "false";
    });
  }

  // @to save/update form data
  // onSetPreference() {
  //   this.submitted = true;
  //   if(this.preferenceForm.invalid){
  //     return false;
  //   }
  //   else{
  //     if(!this.isEditDid){
  //       this.data.savePreference(JSON.stringify(this.preferenceDID)).subscribe(res => {
  //         this.responseMessage=res.message;
  //         setTimeout(()=>{
  //           this.responseMessage= "";
  //           }, 5000);
  //       }, err => {
  //         this.responseMessage = err.message;
  //         setTimeout(()=>{
  //           this.responseMessage= "";
  //           }, 5000);
  //       });
  //     }
  //     else{
  //       this.data.updatePreference(JSON.stringify(this.preferenceDID)).subscribe(res => {
  //         this.responseMessage=res.message;
  //         setTimeout(()=>{
  //           this.responseMessage= "";
  //           }, 5000);
  //       }, err => {
  //         this.responseMessage = err.message;
  //         setTimeout(()=>{
  //           this.responseMessage= "";
  //           }, 5000);
  //       });
  //     }
  //   }
  // }

  // onSetSMS(){
  //   this.submitted = true
  //   if(this.smsForm.invalid){
  //     return false;
  //   }
  //   else{
  //     if(!this.isEditSms){
  //       this.data.savePreference(JSON.stringify(this.preferenceSMS)).subscribe(res => {
  //         this.responseMessage=res.message;
  //         setTimeout(()=>{
  //           this.responseMessage= "";
  //           }, 5000);
  //       }, err => {
  //         this.responseMessage=err.message;
  //         setTimeout(()=>{
  //           this.responseMessage= "";
  //           }, 5000);
  //       });
  //     }
  //     else{
  //       this.data.updatePreference(JSON.stringify(this.preferenceSMS)).subscribe(res => {
  //         this.responseMessage=res.message;
  //         setTimeout(()=>{
  //           this.responseMessage= "";
  //           }, 5000);
  //       }, err => {
  //         this.responseMessage=err.message;
  //         setTimeout(()=>{
  //           this.responseMessage= "";
  //           }, 5000);
  //       });
  //     }
  //   }
  // }

  // onSetVoice(){
  //   this.submitted = true;
  //   if(this.voiceForm.invalid){
  //     return false;
  //   }
  //   else{
  //     if(!this.isEditVoice){
  //       this.data.savePreference(JSON.stringify(this.preferenceVoice)).subscribe(res => {
  //         this.responseMessage=res.message;
  //         setTimeout(()=>{
  //           this.responseMessage= "";
  //           }, 5000);
  //       }, err => {
  //         this.responseMessage = err.message;
  //         setTimeout(()=>{
  //           this.responseMessage= "";
  //           }, 5000);
  //       });
  //     }
  //     else{
  //       this.data.updatePreference(JSON.stringify(this.preferenceVoice)).subscribe(res => {
  //         this.responseMessage=res.message;
  //         setTimeout(()=>{
  //           this.responseMessage= "";
  //           }, 5000);
  //       }, err => {
  //         this.responseMessage = err.message;
  //         setTimeout(()=>{
  //           this.responseMessage= "";
  //           }, 5000);
  //       });
  //     }
  //   }
  // }

  onTableSizeChange(event): void {
    this.tableSize = event.target.value;
    this.page = 1;
  }

  onTableDataChange(event) {
    this.page = event;
  }
}
