import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, ParamMap } from '@angular/router';
import { UsermanagementService } from '../usermanagement.service';
declare var $: any;
@Component({
  selector: 'app-subusers',
  templateUrl: './subusers.component.html',
  styleUrls: ['./subusers.component.css']
})
export class SubusersComponent implements OnInit {
  page = 1;
  count = 0;
	tableSize = 25;
	tableSizes = [ 25,50 , 100];
	searchText = { count: 0 };
	filtre: string;
  responseMessage = "";
  userlistheader: any = [];
  userlist: any = [];
  iduser: string;
  idaccount: string;

  constructor(private data: UsermanagementService, private route: ActivatedRoute) { }

  ngOnInit(): void {
    this.data.getuserheader().subscribe((result) => {
			this.userlistheader = result.headers_details1;
		});

    this.route.paramMap.subscribe((params: ParamMap) => {
        let userData = params.get('id');
        let splitUser = userData.split('-');
        this.iduser = splitUser[0];
        this.idaccount = splitUser[1];
        this.data.getSubListUsers({idaccount: this.idaccount, iduser: this.iduser, type: "profile"}).subscribe((result: any) => {
          this.userlist = result.data[0];
          $('#basic-datatablesRs').dataTable().fnClearTable();
          $('#basic-datatablesRs').dataTable().fnDraw();
          $('#basic-datatablesRs').dataTable().fnDestroy();
          $.getScript('./assets/table.js');
        }, err => {
          console.log(err.message);
        });
      });
  }

  deleteUser(iduser, idaccount){
		let sdata = {"iduser": iduser, "idaccount": idaccount}
		if (confirm("Are you sure you want delete data!")) {
			this.data.deleteUser(JSON.stringify(sdata)).subscribe(result =>{
				this.responseMessage = result.message;
				setTimeout(()=>{
					this.responseMessage= "";
				}, 5000);
				 this.ngOnInit();
			})
		} else {
			"Cancel!";
		}	
	}

}
