import { Component, OnInit } from '@angular/core';
import { SuspendedServicesComponent } from '../suspended-services/suspended-services.component';
import { MatDialog } from '@angular/material/dialog';
import { UsermanagementService } from '../usermanagement.service';
import { Subscription } from 'rxjs';
declare var $: any;

@Component({
  selector: 'app-suspended-user',
  templateUrl: './suspended-user.component.html',
  styleUrls: ['./suspended-user.component.css']
})
export class SuspendedUserComponent implements OnInit {
  featureServiceData : any;
  suspendedUserList: any;
  userlist: any;
  countUser: any;
  suspendedUsers: any = [];
  responseMessage: any ="";
  errMessage: any ="";
  private subscriptionName: Subscription
  constructor(public data: UsermanagementService,public dialog: MatDialog) {
      this.subscriptionName= this.data.getUpdate().subscribe
      (message => {
        if(message.text){
          this.ngOnInit();
        }
      });
   }

  ngOnInit(): void {
    this.data.getfeatureService().subscribe((res) => {
			this.featureServiceData = res.data;
		});
    this.getUsers();
    this.data.getSuspendedService().subscribe((res) => {
      this.suspendedUserList = res.data;
    });
  }
  getUsers(): void {
    this.data.getUsers('main').subscribe((res) => {
      this.userlist = res.data[0];
      this.countUser = res.data[0];
      $('#basic-datatablessSus').dataTable().fnClearTable();
			$('#basic-datatablessSus').dataTable().fnDraw();
			$('#basic-datatablessSus').dataTable().fnDestroy();
      $.getScript('./assets/table.js');
      this.suspendedUserList.forEach((suspendedUser) => {
        const suspendSame = this.userlist.find((user) => user.idaccount === suspendedUser.idaccount);
        if (suspendSame) {
          this.suspendedUsers.push(suspendSame);
        }
      });
    });
  }
  
  suspendedDialog(featureServiceData,idaccount): void {
		const dialogRef = this.dialog.open(SuspendedServicesComponent, {
      width: '50px',
      data: {serviceData:featureServiceData,idaccount:idaccount}
	  });

    dialogRef.afterClosed().subscribe(res => {
			if (res.status == 200) {
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else{
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}


}
