import { Component, OnInit } from '@angular/core';
import { AgentserviceService } from '../agentservice.service'
import { ActivatedRoute, NavigationStart, Router } from '@angular/router';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
// import { confignumber, confignumberForm } from '../inbound.class';
import { FormBuilder } from '@angular/forms';
import { filter, map } from 'rxjs/operators';
import { Observable } from 'rxjs';
declare var $:any;
@Component({
	selector: 'app-group',
	templateUrl: './group.component.html',
	styleUrls: ['./group.component.css']
})
export class GroupComponent extends AppComponentClass<any, any> {
	searchText = { count: 0 };
	filtre: string;
	rowdata: any;
	page = 1;
	field: any;
	header: any;
	count = 0;
	tableSize = 50;
	tableSizes = [50, 100, 150];
	filterTerm: string
	responseMessage: any = "";
	public inbound: any;
	groupData: any = [];
	errMessage: any = "";
	state$: Observable<any>;

	constructor(public data: AgentserviceService, public router: Router,
		public fb: FormBuilder,
	) {
		super(data, router, fb);

		this.state$ = this.router.events.pipe(
			filter(e => e instanceof NavigationStart),
			map(() => this.router.getCurrentNavigation().extras.state)
		)

		this.state$.subscribe(res => {
			if (res) {
				if (res.status == true) {
					this.responseMessage = res.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
				}
			}
		});
		
	}

	ngOnInit(): void {	

		this.data.get_group().subscribe((result) => {
			this.header = result[0].headers_details;
			this.rowdata = result[0].list_data;
		});

		this.getGroup();
	}

	getGroup(){
		this.data.getGroups().subscribe(res => {
			if (res.status == 200) {				
				this.groupData = res.data;
				$('#basic-datatables').DataTable().clear();
				$('#basic-datatables').DataTable().destroy();
				$.getScript('./assets/table.js');
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}
	
	deleteGroup(id) {
		if (confirm("Are you sure you want delete data!")) {
			this.data.deleteGroup(id).subscribe(res => {
				if (res.status == 201) {
					this.responseMessage = res.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
					
					this.ngOnInit();
				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, error => {
				this.errMessage = error.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			});
		}
		else {
			return
		}
	}


}
