import { Component } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { FormBuilder, FormGroup, Validators, FormControl } from '@angular/forms';
import { AuthenticationService } from '../authentication.service';
import { Authentication, AuthenticationForm } from '../model/model.class';
import { AppComponentClass } from '../../shared/service/AppComponent.class';
import { Option } from '../../shared/model/model.class';
/* import { NgRedux } from 'ng2-redux'; */
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';

declare var $: any;

@Component({
  selector: 'app-login',
  templateUrl: './login.component.html',
  styleUrls: ['./login.component.css']
})
export class LoginComponent extends AppComponentClass<Authentication, AuthenticationForm> {

  firstFormGroup: FormGroup;
  secondFormGroup: FormGroup;
  isEditable = false;
  public loginForm: FormGroup;
  returnUrl: string;
  public state = false;
  animal: string;
  name: string;
  public camplist: Option[];
  public currdomain = [];
  routerChanged: boolean;
  loginform = true;
  recoverform = false;
  protected appPermissions: any = []
  error = '';
  isLoading = false;
  submitted = false;
  role: string;
  token: string;
  userlist: any;

  errMessage: string = ""
  responseMessage: string = ""
 // kyc_verify_status: any;

  constructor(protected data: AuthenticationService, protected router: Router, protected fb: FormBuilder, private activatedroute: ActivatedRoute,public userService: UsermanagementService) {
    super(data, router, fb);
  }

  ngOnInit() {
    this.invokeErr()

    if (this.data.currentUserValue) {
      this.router.navigate(['/']);
    }

    let currhost = window.location.host;
    localStorage.setItem("host", currhost);
    this.currdomain = currhost.split(".");

    this.loginForm = this.fb.group({
      username: ['', { validators: [Validators.required] }],
      password: ['', { validators: [Validators.required, Validators.minLength(8)] }],
      sessionType: ['PANEL']
    });
    this.returnUrl = this.activatedroute.snapshot.queryParams['returnUrl'] || '/';

    $(document).ready(() => {
      $(".username").focus(() => {
        $(".user-icon").css("left", "-48px");
      });
      $(".username").blur(() => {
        $(".user-icon").css("left", "0px");
      });

      $(".password").focus(() => {
        $(".pass-icon").css("left", "-48px");
      });
      $(".password").blur(() => {
        $(".pass-icon").css("left", "0px");
      });
    });
  }

  get errMsg(): any {
    return sessionStorage.getItem("errMsg")
  }

  invokeErr(): void {
    this.errMessage = this.errMsg
    setTimeout(() => {
      sessionStorage.removeItem("errMsg")
      this.errMessage='';
    }, 5000)
  }

  showRecoverForm() {
    this.loginform = !this.loginform;
    this.recoverform = !this.recoverform;
  }

  async wait(ms: number): Promise<void> {
    return new Promise<void>(resolve => setTimeout(resolve, ms));
  }

  onSubmit() {
    this.router.navigate(['/dashboards']);
  }

  forgotpwd() {
    this.router.navigate(['/forgot']);
  }

  get f() { return this.loginForm.controls; };

  get username() { return this.loginForm.get('username'); }

  get password() { return this.loginForm.get('password'); }

  /**
   * To authenticate the user
   */
  onLogin() {
    this.submitted = true;

    if (this.loginForm.invalid) {
      return;
    }
    sessionStorage.clear();

    this.isLoading = true;

    this.data.saveService(this.loginForm.value).subscribe(data => {
      this.isLoading = false;
      if (data.authkey) {        
        sessionStorage.clear();
        let newData = data;        
        sessionStorage.setItem('isLoggedIn', JSON.stringify(newData));
        sessionStorage.setItem('authkey', newData.authkey);
        sessionStorage.setItem('type', newData.type);
        sessionStorage.setItem('iduser', newData.iduser);
        sessionStorage.setItem('username', newData.username);
        sessionStorage.setItem('idaccount', newData.idaccount);
        sessionStorage.setItem('client_time', newData.client_time);

        if(newData.isPlan != "true" || newData.isAddress != "true" || newData.isEmailVerify != "true" || newData.isMobileVerify != "true")
        {
          this.router.navigate(['/user/verify-profile']);
        }else if(newData.resetPassword == 0){
          this.router.navigate(['/reset-password']);              
        }          
        else if(newData.newUser_status==1 && newData.isCard!="true")
        {
          this.router.navigate(['/user/credit-card-authorization']);
        }else if(newData.newUser_status==1 && newData.type==2 && (newData.kyc_verify_status== 0 || newData.kyc_verify_status== 2 || newData.kyc_verify_status== 3 ))
        {
          this.router.navigate(['/user/account-action']);
        }else if(newData.newUser_status==1 && newData.type==2 && newData.kyc_verify_status== 1 )
        {
          this.router.navigate(['/dashboards']);
        }
        else
        {
          this.router.navigate(['/dashboards']);
        }
        
      }
      else {
        if(data.error && (data.error == "DelInProcess" || data.error == "Deleted")){
          this.router.navigate(['/restore-account']);
        }else{
          this.error = data.message;
          $('.alert').show();
          setTimeout(() => {
            $('.alert').hide();
          }, 5000);
          this.isLoading = false;
        }
      }
    }, error => {
      this.error = error.message;
      $('.alert').show();
      setTimeout(function () {
        $('.alert').hide();
      }, 5000);
      this.isLoading = false;
    });
  }
}