import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { AuthenticationService } from '../authentication.service';
import { MatDialog } from '@angular/material/dialog';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { ZohoSalesIQService } from '../zoho-salesiq.service';
import { environment } from 'src/environments/environment';
@Component({
  selector: 'app-signup',
  templateUrl: './signup.component.html',
  styleUrls: ['./signup.component.css']
})

export class SignupComponent implements OnInit {
  public signupForm: FormGroup;
  billingForm: FormGroup;
  responseMessage = "";
  isEditable = false;
  submitted: boolean = false;
  public_key: any;
  paymentHandler: any;
  globalListener: any;
  isPlan: Boolean = false;
  errMessage: any = "";
  url: string;
  activatedRoute: any;

  resultMessage = '';
  resultClass = '';

  constructor(private data: AuthenticationService,
    protected router: Router, protected fb: FormBuilder, public dialog: MatDialog,
    private route: ActivatedRoute,
    private userService: UsermanagementService, private zohoSalesIQService: ZohoSalesIQService) {
      this.zohoSalesIQService.initialize({
        widgetCode: environment.ZohoWidgetCode,
        disabledPaths: ['/signup']
      });
  }

  ngOnInit(): void {    
    this.signupForm = this.fb.group({
      firstName: new FormControl('', [Validators.required, Validators.minLength(3), Validators.maxLength(100),Validators.pattern(/^(?!\s*$).+$/)]),
      lastName: new FormControl('', [Validators.required, Validators.minLength(3), Validators.maxLength(100),Validators.pattern(/^(?!\s*$).+$/)]),
      email: new FormControl('', [Validators.required, Validators.pattern("^([A-Za-z0-9._%+-]+)@([A-Za-z0-9-]+\\.[A-Za-z]{2,10})(\\.[A-Za-z]{2,10})?$")]),
      password: new FormControl('', [Validators.required, Validators.minLength(8)]),
      policy: new FormControl('', [Validators.required]),
      tariff1: new FormControl(-1),
      imgUrl: new FormControl(''),
    });

    this.route.paramMap.subscribe((params: ParamMap) => {
      var id = params.get('id');
      if (id == "LP") {
        this.signupForm.patchValue({
          tariff1: 142
        });
      }
      else if (id == "GP") {
        this.signupForm.patchValue({
          tariff1: 143
        });
      }
      else if (id == "SP") {
        this.signupForm.patchValue({
          tariff1: 145
        });
      }
      else {
        this.signupForm.patchValue({
          tariff1: -1
        });
      }
     if(params.get('url')){
        let url = params.get('url');
      }
      
    });
    this.getUrl();
  }
  
  getUrl() {
    this.url= window.location.origin + '/#' + this.router.url;
    let url1 = this.url.split('/signup')[1];
    let url2 = url1.split('url=')[1];    
    if(url2 && url2 !== undefined) {
      this.data.verifyUrl(this.url).subscribe(response => {
        if (response.status == 200) {
            /* this.responseMessage = response.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 3000); */
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
            this.router.navigate(['/404']);
          }, 5000);
        }
      });
    }   
  }

  onTermsCondiation(event) {
    if (event.target.checked) {
      return
    }
    else {
      this.signupForm.get("policy").setValue("");
      this.signupForm.get("policy").setValidators([Validators.required]);
      this.signupForm.get("policy").updateValueAndValidity();
    }
  } 

  onSignup() {
    this.submitted = true;
    if (this.signupForm.invalid) {
      return false;
    }
    else {
      const url = window.location.origin + '/#' + this.router.url;
      this.data.Signup(this.signupForm.value, url).subscribe(response => {
        let result = response.result;
        if (response.status == 201) {
          this.responseMessage = response.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 3000);
          setTimeout(() => {
            this.userService.emailVerify({ key: response.key, result: result, isEmailVerify: false }).subscribe(res => {
              if (res.data) {
                sessionStorage.clear();
                let newData = res.data;
                sessionStorage.setItem('isLoggedIn', JSON.stringify(newData));
                sessionStorage.setItem('authkey', newData.authkey);
                sessionStorage.setItem('type', newData.type);
                sessionStorage.setItem('iduser', newData.iduser);
                sessionStorage.setItem('email', result.email);
                sessionStorage.setItem('username', newData.username);
                sessionStorage.setItem('idaccount', newData.idaccount);
                sessionStorage.setItem("disabled", "true");

                this.ZohoVisitors(this.signupForm.value.firstName + ' ' + this.signupForm.value.lastName, this.signupForm.value.email, (100000000+newData.idaccount));
                
                if (sessionStorage.getItem('isLoggedIn')) {
                  this.router.navigate([`/user/verify-profile/${response.key}`]);                  
                }
              }
              else {
                this.errMessage = res.message;
                setTimeout(() => {
                  this.errMessage = "";
                  this.router.navigate(['/']);
                }, 3000);
              }
            });
          }, 4000);
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      });
    }
  }



  // signUpWithGoogle(): void {
  //     this.authService.signIn(GoogleLoginProvider.PROVIDER_ID);
  //     this.googleProfile;
  // }

  // signInWithFB(): void {
  //   this.authService.signIn(FacebookLoginProvider.PROVIDER_ID).then(x => console.log(x));
  // }

  //  get googleProfile(){
  //     var chars = "0123456789abcdefghijklmnopqrstuvwxyz@#$%&*ABCDEFGHIJKLMNOPQRSTUVWXYZ";
  //     var passwordLength = 5;
  //     var password = "";
  //     for (var i = 0; i <= passwordLength; i++) {
  //       var randomNumber = Math.floor(Math.random() * chars.length);
  //       password += chars.substring(randomNumber-1, randomNumber +1);
  //     }
  //      return this.authService.authState.subscribe((user) => {
  //         if(user.authToken){
  //           this.signupForm.patchValue({
  //             email: user.email,
  //             firstName: user.firstName,
  //             lastName: user.lastName,  
  //             password: password,
  //             policy: 'true',
  //             imgUrl: user.photoUrl
  //           })
  //           console.log(this.signupForm.value);
  //           this.onSignup();
  //        }
  //        else{
  //          this.errMessage = "Something Went Wrong With Connection";
  //          setTimeout(() => {
  //            this.errMessage = "";
  //          }, 5000);
  //        }
  //     }, err => {
  //     console.log(err);
  //     });
  //   }

  current_datetime() {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second;
  }
  async ZohoVisitors(name, email, san){
    const visitorDetails = {
      name: name,
      email: email,
      SAN: san
    };

    try {
      await this.zohoSalesIQService.setVisitorDetails(visitorDetails);
      this.resultMessage = 'Visitor details sent successfully!';
      this.resultClass = 'success';
    } catch (error) {
      this.resultMessage = 'Error: ' + error.message;
      this.resultClass = 'error';
    }
  }

  ngOnDestroy(): void {
    console.log('Component is being destroyed, unloading Zoho SalesIQ');
    this.zohoSalesIQService.unload();
  }

}
