import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { DownloadreportService } from '../downloadreport.service';
import { ActivatedRoute, Router } from '@angular/router';


declare var $: any;

@Component({
  selector: 'app-downloadreport',
  templateUrl: './downloadreport.component.html',
  styleUrls: ['./downloadreport.component.css']
})

export class DownloadreportComponent implements OnInit {
  userType: any;
  show_filter: boolean = false;
  public filterForm: FormGroup;
  responseMessage: any = "";
  errMessage: any = "";
  public submitted: boolean = false;
  downloadreport: any[];
  heading: any[] = [];
  type1: any[] = [];
  filteredTypes: any[] = [];
  status1: any[] = [];
  userlist: any = [];
  reportType: any;
  type: any;
  currentUrl: string;


  constructor(public fb: FormBuilder, public data: DownloadreportService, private route: ActivatedRoute, private router: Router
  ) { }

  ngOnInit(): void {
    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;
    this.currentUrl = this.router.url;
    if (this.currentUrl.includes('/downloadreport/cdr')) {
      this.type = 'cdr';
    } else {
      this.type = 'sms';
    }
    this.route.url.subscribe(segments => {
      const lastSegment = segments[segments.length - 1].path;
      this.reportType = lastSegment;
      this.getreportdownload(this.reportType);
    });



    this.filterForm = this.fb.group({
      from_date: [''],
      to_date: [''],
      requestid: ['', [Validators.pattern(/^\s*\S.*$/)]],
      type: [''],
      status: [''],
      san: [''],
      reporttype: [this.type]
    });

    // this.data.get_typestatus().subscribe(result => {
    //   this.heading = result;
    //   this.type1 = this.heading[0].subheading1.options;
    //   this.status1 = this.heading[0].subheading2.options;
    // });

    this.data.get_typestatus().subscribe(result => {
      const heading = result[0];
      this.type1 = heading.subheading1.options;
      this.status1 = heading.subheading2.options;
      const currentUrl = this.router.url;
      if (currentUrl === '/downloadreport/cdr') {
        this.filteredTypes = this.type1.filter(t => t.value === 'CDR');
      } else if (currentUrl === '/downloadreport/sms') {
        this.filteredTypes = this.type1.filter(t => t.value === 'SMS MDR' || t.value === 'MMS MDR');
      } else {
        this.filteredTypes = this.type1;
      }
    });

    

    this.data.getUsers("main").subscribe(res => {
      this.userlist = res.data[0];
    }, err => {
      console.log(err.message);
    });

  }

  getreportdownload(type: any) {
    const reporttype = type

    this.data.get_downloadetails(reporttype).subscribe(res => {
      if (res.status == 201) {
        this.downloadreport = res.data;
        $('#basic-datatablesesG').dataTable().fnClearTable();
        $('#basic-datatablesesG').dataTable().fnDraw();
        $('#basic-datatablesesG').dataTable().fnDestroy();
        $.getScript('./assets/table.js');
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = '';
        }, 3000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    })

  }

  showfilter() {
    if (this.show_filter == false) {
      this.show_filter = true;
    }
    else {
      this.show_filter = false;
    }
  }

  messageshow() {
    const fromDate = this.filterForm.get('from_date').value;
    const toDate = this.filterForm.get('to_date').value;
    const currentDate = new Date();
    if ((!fromDate && !toDate)) {
    } else if ((fromDate == null || !fromDate) && (toDate != null)) {
      this.filterForm.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
    } else if ((fromDate != null) && (toDate == null || !toDate)) {
      this.filterForm.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
    } else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
      this.filterForm.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
      return;
    } else if (toDate && new Date(toDate) > currentDate) {
      this.filterForm.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
      return;
    } else if (fromDate && new Date(fromDate) > currentDate) {
      this.filterForm.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
      return;
    } else {
      this.filterForm.get('from_date').setErrors(null);
      this.filterForm.get('to_date').setErrors(null);
    }
  }

  resetfilter() {
    this.submitted = false;
    this.filterForm.reset();
    Object.keys(this.filterForm.controls).forEach(key => {
      this.filterForm.get(key).setValue('');
    });
    this.getreportdownload(this.reportType);
    this.filterForm.patchValue({
      reporttype: this.type
    })
  }

  onSubmitfilter() {
    this.submitted = true;
    if (this.filterForm.invalid) {
      return false;
    } else {
      this.data.applyFilter(this.filterForm.value).subscribe((res) => {
        if (res.status == 201) {
          this.downloadreport = res.data;
          $('#basic-datatablesesG').dataTable().fnClearTable();
          $('#basic-datatablesesG').dataTable().fnDraw();
          $('#basic-datatablesesG').dataTable().fnDestroy();
          $.getScript('./assets/table.js');
          // this.responseMessage = res.message;
          // setTimeout(() => {
          //   this.responseMessage = '';
          // }, 3000);
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      });
    }
  }

  downloadFile(data) {
    const fileName = data.download_file_link.substring(data.download_file_link.lastIndexOf('/') + 1);
    const docxModal = document.getElementById('modalDocxAppeal');
    if (data.download_file_link) {
      const a = document.createElement('a');
      a.href = data.download_file_link;
      a.download = fileName;
      document.body.appendChild(a);
      a.click();
      document.body.removeChild(a);
      $(docxModal).modal('show');
    }
  }
}
