import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable } from 'rxjs';
import { HttpClient, HttpHeaders, HttpParams } from '@angular/common/http';
import { AppService } from '../shared/service/AppService.class';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { environment } from 'src/environments/environment';

@Injectable({
  providedIn: 'root'
})
export class FederalService extends AppService<any>{
  constructor(public http:HttpClient) {
    super(http);
    this.appmod = "usermanagement";
  }

  @LoaderEnabled()
  getFedrlQuestion(): Observable<any> {
    this.appmod = 'getfedQuestion';
    let result = super.getService();
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  saveFederal(data: any): Observable<any> {
    this.appmod = 'save_federal';
    let result = super.saveService(data);
    this.appmod = "usermanagement";
    return result;
  }

  // @LoaderEnabled()
  // getFederalPdf(): Observable<any> {
  //   this.appmod = 'get_FederalPdf';
  //   let result = super.getService();
  //   this.appmod = "usermanagement";
  //   return result;
  // }

  @LoaderEnabled()
  getFederalPdf(type: any): Observable<any> {
    const apiURL = environment.SERVER + 'get_FederalPdf';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders, params: type });
  }

   /*KYC verification update function*/
   @LoaderEnabled()
   federalVerify(data: any) {
     this.appmod = "verifyfederalStatus";
     let result = super.updateService(data);
     this.appmod = "usermanagement";
     return result;
   }
 
   @LoaderEnabled()
   rejectFederalStatus(data: any) {
     this.appmod = "rejectfederalStatus";
     let result = super.updateService(data);
     this.appmod = "";
     return result;
   }

   @LoaderEnabled()
   cancelFederalStatus(data: any) {
     this.appmod = "cancelFederalStatus";
     let result = super.updateService(data);
     this.appmod = "";
     return result;
   }

}
