import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { AbstractControl, FormBuilder, FormGroup, ValidatorFn, Validators } from '@angular/forms';
import { InboundService } from '../inbound.service';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { calldetails, calldetailsForm } from '../inbound.class';
import { Router } from '@angular/router';
import { Observable } from 'rxjs';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';
import { formatDate } from '@angular/common';

declare var $: any;

@Component({
	selector: 'app-calldetailsrecord',
	templateUrl: './calldetailsrecord.component.html',
	styleUrls: ['./calldetailsrecord.component.css']

})

export class CalldetailsrecordComponent extends AppComponentClass<calldetails, calldetailsForm> {
	@ViewChild('viewdetails') viewdetails: ElementRef;
	@ViewChild('downloadreportmodal') downloadreportmodal: ElementRef;
	public show_filter: boolean = false;
	filter_2: boolean = false;
	editData?: Observable<any>;
	searchText = { count: 0 };
	filtre: string;
	label: Observable<any>;
	header: any;
	rowdata: any;
	p: number = 1;
	page = 1;
	count = 0;
	tableSize = 50;
	tableSizes = [50, 100, 150];
	filterTerm: string
	snackBar: any;
	public cdrForm: FormGroup;
	public summeryCdrForm: FormGroup;
	public submitted: boolean = false;
	filterCdr: any = [];
	singleCdr: any = [];
	username: any;
	userlist: any = [];
	isAdmin: Boolean = false;
	errMessage: any = "";
	responseMessage: any = "";
	EXCEL_TYPE = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8';
	EXCEL_EXTENSION = '.xlsx';
	userType: any;
	currentDate: Date;
	startdate: any;
	lastdate: any;
	filterSummaryCdr: any = [];
	exportfile: any = [];
	public downloadreport: FormGroup;
	submitteddownload: boolean;

	constructor(public data: InboundService, public router: Router, public fb: FormBuilder, private userService: UsermanagementService) {
		super(data, router, fb);

		let session = JSON.parse(sessionStorage.getItem("isLoggedIn"));
		this.userType = session.type;

	}

	ngOnInit(): void {
		this.currentDate = new Date();
		this.currentDate = new Date(this.currentDate.setDate(this.currentDate.getDate() - 1));
		const sValue = formatDate(this.currentDate, 'yyyy-MM-dd', 'en-US');
		this.startdate = sValue;

		this.lastdate = new Date(this.currentDate.setDate(this.currentDate.getDate() - 6));
		const lValue = formatDate(this.currentDate, 'yyyy-MM-dd', 'en-US');
		this.lastdate = lValue;

		this.userService.getUsers("main").subscribe(res => {
			this.userlist = res.data[0];
		}, err => {
			console.log(err.message);
		});

		let isLoggedIn = sessionStorage.getItem("isLoggedIn");
		let user = JSON.parse(isLoggedIn);
		this.username = user.username;
		if (user.type == '1') {
			this.isAdmin = true;
		}
		else {
			this.isAdmin = false;
		}

		this.cdrForm = this.fb.group({
			to_date: [this.current_datetime()],
			from_date: [this.startDate()],
			from_number: ['',],
			to_number: ['',],
			direction: [''],
			iduser: [''],
			fType: [''],
			// }, {
			// 	validator: Validators.compose([
			// 		CalldetailsrecordComponent.dateLessThan('from_date', 'to_date', { 'from_date': true })
			// 	])
		});
		this.summeryCdrForm = this.fb.group({
			to_date: [this.current_datetime(), [Validators.required]],
			from_date: [this.startDate(), [Validators.required]],
			directionSummery: ['Both'],
			fType: [''],
			iduser: ['']
			// Status: [''],
			// }, {
			// 	validator: Validators.compose([
			// 		CalldetailsrecordComponent.dateLessThan('from_date', 'to_date', { 'from_date': true })
			// 	])
		});

		this.summeryCdrForm.patchValue({
			to_date: this.startdate,
			from_date: this.lastdate
		})

		this.data.getCdr().subscribe((result) => {
			this.label = result[1];
			if (this.userType === 1) {
				this.header = result[0].headers_details;
			} else {
				this.header = result[0].headers_details.filter(column => column !== 'SAN');
			}
			this.rowdata = result[0].product_details;
			if (this.userType == 1 || this.userType == 2 || this.userType == 22 || this.userType == 201 || this.userType == 202 || this.userType == 203) {
				return this.header;
			}
			else {
				let idx = this.header.indexOf("Customer Name");
				this.header.splice(idx, 1);
			}
		});
		this.cdrForm.patchValue({
			fType: ""
		})
		this.data.callDetailRecord(JSON.stringify(this.cdrForm.value)).subscribe(response => {
			if (response.status == 201) {
				// this.filterCdr = response.data;
				let filterCDR1 = response.data
				this.filterCdr = filterCDR1.data;
				$('#basic-datatableses').DataTable().clear();
				$('#basic-datatableses').DataTable().destroy();
				$.getScript('./assets/table.js');
			}
			else {
				this.errMessage = "";
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});

		this.SummeryCdr();

		this.downloadreport = this.fb.group({
			from_date: [[this.startDate()]],
			to_date: [[this.current_datetime()]],
			directions: [''],
			// status: [''],
			fromnumber: [''],
			tonumber: [''],
			type: [0]
		})
	}
	

	onCdrFilter() {
		this.filterCdr = [];
		this.cdrForm.patchValue({
			fType: ""
		})
		this.submitted = true;
		if (this.cdrForm.invalid) {
			return;
		}
		else {
			this.filterCdr = [];
			this.data.callDetailRecord(JSON.stringify(this.cdrForm.value)).subscribe(response => {
				if (response.status == 201) {
					this.filterCdr = response.data;
					let filterCDR1 = response.data
					this.filterCdr = filterCDR1.data;
					$('#basic-datatableses').DataTable().clear();
					$('#basic-datatableses').DataTable().destroy();
					$.getScript('./assets/table.js');
				}
				else {
					this.errMessage = "";
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	// callDetailRec() {
	// 	this.data.callDetailRecord(JSON.stringify(this.cdrForm.value)).subscribe(response => {
	// 		if (response.status == 200) {
	// 			this.filterCdr = response.data;
	// 			$('#basic-datatables1').DataTable().clear();
	// 			$('#basic-datatables1').DataTable().destroy();
	// 			$.getScript('./assets/table.js');
	// 		}
	// 		else {
	// 			this.errMessage = response.message;
	// 			setTimeout(() => {
	// 				this.errMessage = "";
	// 			}, 5000);
	// 		}
	// 	});
	// }

	getSingleCdr(data) {
		this.singleCdr = [];
		// this.singleCdr = this.filterCdr.find(el => el.idcdr == idcdr);
		this.singleCdr = data;
	}

	// exportFile(e: any) {
	// 	this.exportfile = [];
	// 	let fType = "filter";
	// 	this.cdrForm.patchValue({
	// 		fType: fType
	// 	})
	// 	this.summeryCdrForm.patchValue({
	// 		fType: fType
	// 	})
	// 	if (e == 'message') {
	// 		this.data.callDetailRecord(JSON.stringify(this.cdrForm.value)).subscribe(response => {
	// 			if (response.status == 200) {
	// 				this.exportfile = response.data.map(item => {
	// 					delete item.idmdr;
	// 					let transformedItem = {}
	// 					if (this.userType == 1) {
	// 						transformedItem = {
	// 							"SAN": item.san,
	// 							"Cost": item.cost,
	// 							"Dialed Number": item.dialed_number,
	// 							"Caller Id Number": item.caller_id_number,
	// 							"Direction": item.direction,
	// 							"Duration": item.duration,
	// 							"Billsec": item.billsec,
	// 							"Hangup Cause": item.hangup_cause,
	// 							"Progress Mediamsec": item.progress_mediamsec,
	// 							"Start Stamp": item.start_stamp,
	// 							"Answer Stamp": item.answer_stamp,
	// 							"End Stamp": item.end_stamp,
	// 							"Progress Media Stamp": item.progress_media_stamp,

	// 						};
	// 					} else {
	// 						transformedItem = {
	// 							"Cost": item.cost,
	// 							"Dialed Number": item.dialed_number,
	// 							"Caller Id Number": item.caller_id_number,
	// 							"Direction": item.direction,
	// 							"Duration": item.duration,
	// 							"Billsec": item.billsec,
	// 							"Hangup Cause": item.hangup_cause,
	// 							"Progress Mediamsec": item.progress_mediamsec,
	// 							"Start Stamp": item.start_stamp,
	// 							"Answer Stamp": item.answer_stamp,
	// 							"End Stamp": item.end_stamp,
	// 							"Progress Media Stamp": item.progress_media_stamp,

	// 						};
	// 					}
	// 					return transformedItem;
	// 				});
	// 				if (this.exportfile.length > 0) {

	// 					const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
	// 					const workbook: XLSX.WorkBook = { Sheets: { 'CDR': worksheet }, SheetNames: ['CDR'] };
	// 					const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
	// 					this.saveAsExcelFile(excelBuffer, "CDR");
	// 				}
	// 				else {
	// 					this.errMessage = "Record Not Found !";
	// 					setTimeout(() => {
	// 						this.errMessage = ""
	// 					}, 5000);
	// 				}
	// 			}
	// 			else {
	// 				this.errMessage = response.message;
	// 				setTimeout(() => {
	// 					this.errMessage = "";
	// 				}, 5000);
	// 			}
	// 		});
	// 	}
	// 	if (e == 'summery') {
	// 		this.data.summeryCdrForm(JSON.stringify(this.summeryCdrForm.value)).subscribe(response => {
	// 			if (response.status == 200) {
	// 				// this.exportfile = response.data;
	// 				this.exportfile = response.data.map(item => {
	// 					delete item.idmdr;
	// 					let transformedItem = {}
	// 					if (this.userType == 1) {
	// 						transformedItem = {
	// 							"Date": new Date(item.date).toLocaleDateString('en-US'),
	// 							"SAN": item.san,
	// 							"Direction": item.direction,
	// 							"Total Calls": item.Total_calls,
	// 							"Success": item.success,
	// 							"Failed": item.failed,
	// 							"Total Cost": item.total_cost,
	// 							"Duration": item.duration,
	// 						};
	// 					} else {
	// 						transformedItem = {
	// 							"Date": new Date(item.date).toLocaleDateString('en-US'),
	// 							"Direction": item.direction,
	// 							"Total Calls": item.Total_calls,
	// 							"Success": item.success,
	// 							"Failed": item.failed,
	// 							"Total Cost": item.total_cost,
	// 							"Duration": item.duration,
	// 						};
	// 					}
	// 					return transformedItem;
	// 				});
	// 				if (this.exportfile.length > 0) {
	// 					const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
	// 					const workbook: XLSX.WorkBook = { Sheets: { 'CDR': worksheet }, SheetNames: ['CDR'] };
	// 					const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
	// 					this.saveAsExcelFile(excelBuffer, "CDR");
	// 				}
	// 				else {
	// 					this.errMessage = "Record Not Found !";
	// 					setTimeout(() => {
	// 						this.errMessage = ""
	// 					}, 5000);
	// 				}
	// 			}
	// 			else {
	// 				this.errMessage = response.message;
	// 				setTimeout(() => {
	// 					this.errMessage = "";
	// 				}, 5000);
	// 			}
	// 		});
	// 	}
	// }

	exportFile(e: any) {
		this.exportfile = [];
		let fType = "filter";
		this.cdrForm.patchValue({
			fType: fType
		})
		this.summeryCdrForm.patchValue({
			fType: fType
		})
		if (e == 'message') {
			this.data.callDetailRecord(JSON.stringify(this.cdrForm.value)).subscribe(response => {
				if (response.status == 201) {
					let data =response.data
					this.exportfile = data.data.map(item => {
						delete item.idmdr;
						let transformedItem = {}
						if (this.userType == 1) {
							transformedItem = {
								"SAN": item.SAN,
								"Cost": item.COST,
								"Dialed Number": item["Dialed Number"],
								"Caller Id Number": item["Caller Id Number"],
								"Direction": item.Direction,
								"Duration": item.Duration,
								"Billsec": item.Billsec,
								"Hangup Case": item["Hangup Case"],
								"Progress Mediamsec": item["Progress Mediamsec"] == 'null' ? '' : item["Progress Mediamsec"] ,
								"Start Stamp": item["Start Stamp"],
								"Answer Stamp": item["Answer Stamp"],
								"End Stamp": item["End Stamp"],
								"Progress Media Stamp": item["Progress Media Stamp"],

							};
						} else {
							transformedItem = {
								"Cost": item.COST,
								"Dialed Number": item["Dialed Number"],
								"Caller Id Number": item["Caller Id Number"],
								"Direction": item.Direction,
								"Duration": item.Duration,
								"Billsec": item.Billsec,
								"Hangup Case": item["Hangup Case"],
								"Progress Mediamsec": item["Progress Mediamsec"] == 'null' ? '' : item["Progress Mediamsec"] ,
								"Start Stamp": item["Start Stamp"],
								"Answer Stamp": item["Answer Stamp"],
								"End Stamp": item["End Stamp"],
								"Progress Media Stamp": item["Progress Media Stamp"],

							};
						}
						return transformedItem;
					});
					if (this.exportfile.length > 0) {

						const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
						const workbook: XLSX.WorkBook = { Sheets: { 'CDR': worksheet }, SheetNames: ['CDR'] };
						const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
						this.saveAsExcelFile(excelBuffer, "CDR");
					}
					else {
						this.errMessage = "Record Not Found !";
						setTimeout(() => {
							this.errMessage = ""
						}, 5000);
					}
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
		if (e == 'summery') {
			this.data.summeryCdrForm(JSON.stringify(this.summeryCdrForm.value)).subscribe(response => {
				if (response.status == 200) {
					// this.exportfile = response.data;
					this.exportfile = response.data.map(item => {
						delete item.idmdr;
						let transformedItem = {}
						if (this.userType == 1) {
							transformedItem = {
								"Date": new Date(item.date).toLocaleDateString('en-US'),
								"SAN": item.san,
								"Direction": item.direction,
								"Total Calls": item.Total_calls,
								"Success": item.success,
								"Failed": item.failed,
								"Total Cost": item.total_cost,
								"Duration": item.duration,
							};
						} else {
							transformedItem = {
								"Date": new Date(item.date).toLocaleDateString('en-US'),
								"Direction": item.direction,
								"Total Calls": item.Total_calls,
								"Success": item.success,
								"Failed": item.failed,
								"Total Cost": item.total_cost,
								"Duration": item.duration,
							};
						}
						return transformedItem;
					});
					if (this.exportfile.length > 0) {
						const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
						const workbook: XLSX.WorkBook = { Sheets: { 'CDR': worksheet }, SheetNames: ['CDR'] };
						const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
						this.saveAsExcelFile(excelBuffer, "CDR");
					}
					else {
						this.errMessage = "Record Not Found !";
						setTimeout(() => {
							this.errMessage = ""
						}, 5000);
					}
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	private saveAsExcelFile(buffer: any, fileName: string): void {
		const data: Blob = new Blob([buffer], {
			type: this.EXCEL_TYPE
		});
		saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
	}


	// startDate() {
	// 	let now = new Date();
	// 	let year = "" + now.getFullYear();
	// 	let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
	// 	let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
	// 	let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
	// 	let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
	// 	let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
	// 	return year + '-' + month + "-" + "01";
	// }

	// startDate() {
	// 	let now = new Date();
	// 	now.setDate(now.getDate() - 90);
	// 	let year = "" + now.getFullYear();
	// 	let month = "" + (now.getMonth() + 1);
	// 	if (month.length == 1) {
	// 		month = "0" + month;
	// 	}

	// 	let day = "" + now.getDate();
	// 	if (day.length == 1) {
	// 		day = "0" + day;
	// 	}

	// 	return year + '-' + month + "-" + day;
	// }

	startDate() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1);
		if (month.length == 1) {
			month = "0" + month;
		}	
		let day = "01";	
		return year + '-' + month + "-" + day;
	}

	current_datetime() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
		let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
		let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
		let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
		let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
		return year + '-' + month + "-" + day;
	}


	// static dateLessThan(from_date: string, to_date: string, validatorField: { [key: string]: boolean }): ValidatorFn {
	// 	return (c: AbstractControl): { [key: string]: boolean } | null => {
	// 		const date1 = c.get(from_date).value;
	// 		const date2 = c.get(to_date).value;
	// 		if ((date1 !== null && date2 !== null) && date1 > date2) {
	// 			return validatorField;
	// 		}
	// 		return null;
	// 	};
	// }
	showfilter() {
		if (this.show_filter == false) {
			this.show_filter = true;
		}
		else {
			this.show_filter = false;
		}

	}
	filter() {
		if (this.filter_2 == false) {
			this.filter_2 = true;
		}
		else {
			this.filter_2 = false;
		}

	}

	SummeryCdr() {
		this.summeryCdrForm.patchValue({
			fType: ""
		})
		if (this.summeryCdrForm.invalid) {
			return false
		}
		else {
			this.data.summeryCdrForm(JSON.stringify(this.summeryCdrForm.value)).subscribe(response => {
				if (response.status == 200) {
					this.filterSummaryCdr = response.data;
					$('#basic-datatables1').DataTable().clear();
					$('#basic-datatables1').DataTable().destroy();
					$.getScript('./assets/table.js');
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	resetCdr() {
		this.submitted = false;
		// this.cdrForm.reset();
		this.ngOnInit();
		this.cdrForm.patchValue({
			from_date: this.startDate(),
			to_date: this.current_datetime(),
		})
		this.onCdrFilter();
	}

	OnRequest() {
		this.submitteddownload = true;
		if (this.downloadreport.invalid) {
			return false;
		} else {
			this.data.SMSrequest(this.downloadreport.value).subscribe((res => {
				if (res.status == 201) {
					this.responseMessage = res.message;
					this.downloadreportmodal.nativeElement.click();
					setTimeout(() => {
						this.responseMessage = '';
						this.router.navigate(['./downloadreport/cdr']);
					}, 5000);
				} else {
					this.errMessage = res.message;
					this.downloadreportmodal.nativeElement.click();
					setTimeout(() => {
						this.errMessage = '';
						this.router.navigate(['./downloadreport/cdr']);
					}, 5000);
				}
			}));
		}
	}

	minDate() {
		const now = new Date();
		now.setMonth(now.getMonth() - 18); // Subtract 18 months
		return now.toISOString().slice(0, 10);
	}


	ResetRequest() {
		this.submitteddownload = false
		this.downloadreport.reset()
		this.downloadreport.get('directions').setValue("")
		this.downloadreport.get('type').setValue(0)
		this.downloadreport.patchValue({
			from_date: this.startDate(),
			to_date: this.current_datetime(),
		})

	}

	resetSum() {
		this.submitted = false;
		this.summeryCdrForm.reset();
		this.summeryCdrForm.patchValue({
			from_date: this.lastdate,
			to_date: this.startdate
		})
		this.summeryCdrForm.get('iduser').setValue('');
		this.SummeryCdr();
	}

	messageshow() {
		this.validateDateRange(this.cdrForm, 1);
		this.validateDateRange(this.summeryCdrForm, 2);
		this.validateDateRange(this.downloadreport, 3);

	}

	validateDateRange(form: FormGroup, type: any) {
		const fromDate = form.get('from_date').value;
		const toDate = form.get('to_date').value;
		const currentDate = new Date();
		const threeMonthsAgo = new Date();
		threeMonthsAgo.setMonth(currentDate.getMonth() - 3);
		const oneAndHalfYearsAgo = new Date();
		oneAndHalfYearsAgo.setMonth(currentDate.getMonth() - 18);


		if ((!fromDate && !toDate)) {
			// No date range selected, do nothing
		} else if ((fromDate == null || !fromDate) && (toDate != null)) {
			form.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
		} else if ((fromDate != null) && (toDate == null || !toDate)) {
			form.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
		} else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
			form.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
			return;
		} else if (toDate && new Date(toDate) > currentDate) {
			form.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
			return;
		} else if (fromDate && new Date(fromDate) > currentDate) {
			form.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
			return;
		}
		else if (new Date(fromDate) < threeMonthsAgo && type == 1) {
			form.get('from_date').setErrors({ 'dateRange': 'We can only provide data for the last three months' });
			return;
		}
		else if (new Date(fromDate) < oneAndHalfYearsAgo && type == 3) {
			form.get('from_date').setErrors({ 'dateRange': 'We can only provide data for the last 1.5 years' });
			return;
		}
		else {
			form.get('from_date').setErrors(null);
			form.get('to_date').setErrors(null);
		}
	}

	truncatenotification(subject: string, maxLength: number): string {
		if (subject && subject.length > maxLength) {
			return subject.substring(0, maxLength) + '...';
		} else {
			return subject;
		}
	}
	ngOnDestroy() {
		this.viewdetails.nativeElement.click();
		this.downloadreportmodal.nativeElement.click();

	}
}