import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { STEPPER_GLOBAL_OPTIONS } from '@angular/cdk/stepper';
import { Router } from '@angular/router';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { KycService } from '../kyc.service';
import { async } from '@angular/core/testing';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';


@Component({
  selector: 'app-kyc',
  templateUrl: './kyc.component.html',
  styleUrls: ['./kyc.component.css'],
  providers: [{
    provide: STEPPER_GLOBAL_OPTIONS, useValue: { displayDefaultIndicatorType: false }
  }]
})
export class KycComponent extends AppComponentClass<any, any> {
  @ViewChild('signatureClose') signatureClose : ElementRef;
  @ViewChild('canvas') canvas: ElementRef;
  @ViewChild('sweetalert') sweetalert: ElementRef;
  Questions: any = [];
  Description: any;
  Description1: any;
  VoiceService: any = [];
  MessageSevice: any = [];
  YourInformation: FormGroup;
  yourContact: FormGroup;
  voiceService: FormGroup;
  messageService: FormGroup;
  mainForm: any = [];
  SignatureForm: FormGroup;
  app: any;
  // canvas: any;
  urlData: any;
  showImage: any;
  responseMessage: any;
  errMessage: any;
  submitted: boolean;
  subbmitted: boolean = false;
  stripeCards: any = [];
  isCard: Boolean = false;
  paymentHandler: any;
  isNewCard: Boolean = false;
  cardForm: FormGroup;
  isAgree: Boolean;
  hideCardBtn: boolean = true;
  cardDetails: any = [];
  nextButton: boolean = false;
  msgButton: boolean = false;
  idaccount: any;
  iduser: any;
  sesiduser: any;
  Profileinfo: any = [];
  submitted2: boolean = false;
  voiceDesc: any = '';
  messageDesc: any = '';
  DisableNextBtn: boolean = false;
  voicdesc: boolean = false;
  voiceDesChecked: boolean = false;
  messageDesChecked: boolean = false;
  voiceListChecked: boolean = false;
  messageListChecked: boolean = false;
  customerType: FormGroup;
  current_date: any;
  kycRes: any;
  kycHeader: any;
  pannelType: string = '';
  ResellerVoice: any = [];
  ResellerMessage: any = [];
  voiceExp: boolean = false;
  subList: boolean = false;
  pdfDetails: any=[];
  Customer_legal_name: any='';
  dba: any='';
  business_type: any='';
  Federal_tax_id: any='';
  Physical_headquarter_address: any='';
  Billing_address: any='';
  website_address: any='';
  Social_media: any='';
  billing_name: any='';
  billing_email: any='';
  Compliance_name: any='';
  Compliance_email: any='';
  Compliance_phone: any='';
  Operations_name: any='';
  Operations_email: any='';
  Operations_phone: any='';
  kycSignatureName: any='';
  kycSignatureTitle: any='';
  kycSignature: any='';
  billing_phone: any='';
  custmType: any='';
  alldisp: boolean = false;
  firstsmsQus: any='';
  changePanel: boolean = false;
  subcheck: boolean = false;
  custType: any;
  subqus4: boolean = false;
  subcheckboxQus: boolean = false;
  submitted3: boolean = false;
  private ctx: CanvasRenderingContext2D;
  private isDrawing: boolean = false;
  private lastX: number = 0;
  private lastY: number = 0;
  errorMessageDisplayed : boolean = false;
  constructor(public fb: FormBuilder, public router: Router, public data: KycService, protected userSerive: UsermanagementService,) {
    super(data, router, fb);
    let isLoggedIn = JSON.parse(sessionStorage.getItem('isLoggedIn'));
  }

  ngOnInit(): void {
    // if (window.HTMLCanvasElement) {
    //   this.init();
    // }

    // To get date
    this.current_datetime();

    let isLoggedIn = sessionStorage.getItem("isLoggedIn");
    this.sesiduser = JSON.parse(isLoggedIn);
    this.idaccount = this.sesiduser.idaccount;
    this.iduser = this.sesiduser.iduser;
    let payLoad = JSON.stringify({
      'iduser': this.iduser,
      'idaccount': this.idaccount
    })
    
    /*Service for kyc response*/ 
    this.userSerive.getKycHeader().subscribe(res => {
      if (res.status == 200) {
        this.kycHeader = res.data;
        this.kycRes = res.data[0].kyc_verify_status;
        if(this.kycRes !== 0 && this.kycRes !== 3  && this.kycRes !== 4){
          this.data.checkKycRoute().subscribe(res => {
           if(res.data.length > 0)
           {
            this.router.navigate(['kyc/kyc-details'])
              .then(() => {
                location.reload();
              })
           }
          });
        }
      }
    });
    const urlRegex = /^(?:http(s)?:\/\/)?[\w.-]+(?:\.[\w\.-]+)+[\w\-\._~:/?#[\]@!\$&'\(\)\*\+,;=.]+$/;
    this.YourInformation = this.fb.group({
      Customer_legal_name: ['', [Validators.required,this.noWhitespaceValidator]],
      Dba_trade_name: ['', [Validators.required,this.noWhitespaceValidator]],
      business_type: ['', [Validators.required,this.noWhitespaceValidator]],
      Federal_tax_id: ['', [Validators.required,Validators.minLength(9)]],
      Physical_headquarter_address: ['', [Validators.required,this.noWhitespaceValidator]],
      Billing_address: ['', [Validators.required,this.noWhitespaceValidator]],
      website_address: ['', [Validators.required, Validators.pattern(urlRegex)]],
      Social_media: [''],
      formType: ['YourInformation']
    });
    this.yourContact = this.fb.group({
      billing_name: ['', [Validators.required,this.noWhitespaceValidator]],
      billing_email: ['', [Validators.required, Validators.pattern("^([A-Za-z0-9._%+-]+)@([A-Za-z0-9-]+\\.[A-Za-z]{2,10})(\\.[A-Za-z]{2,10})?$")]],
      billing_phone: ['', [Validators.required, Validators.minLength(10)]],
      Compliance_name: ['', [Validators.required,this.noWhitespaceValidator]],
      Compliance_email: ['', [Validators.required, Validators.pattern("^([A-Za-z0-9._%+-]+)@([A-Za-z0-9-]+\\.[A-Za-z]{2,10})(\\.[A-Za-z]{2,10})?$")]],
      Compliance_phone: ['', [Validators.required, Validators.minLength(10)]],
      Operations_name: ['', [Validators.required,this.noWhitespaceValidator]],
      Operations_email: ['', [Validators.required, Validators.pattern("^([A-Za-z0-9._%+-]+)@([A-Za-z0-9-]+\\.[A-Za-z]{2,10})(\\.[A-Za-z]{2,10})?$")]],
      Operations_phone: ['', [Validators.required, Validators.minLength(10)]],
      formType: ['yourContact']
    });

    this.data.getQuestions().subscribe(res => {
      this.Questions = res.data;
      this.Questions.forEach(element => {
        if (element.question_type !== 5) {
          element.sub_question = JSON.parse(element.sub_question)
        }
      });
      this.divideData();
    });

    this.SignatureForm = this.fb.group({
      kyc_signature_name: ['', [Validators.required,this.noWhitespaceValidator,Validators.pattern(/^(?!\s*$).+$/)]],
      kyc_signature_title: ['', [Validators.required,this.noWhitespaceValidator,Validators.pattern(/^(?!\s*$).+$/)]],
      kyc_signature: ['', [Validators.required]],
      formType: ['kycSignature']
    });

    this.data.CustomerProfileInformation().subscribe(res => {
      this.Profileinfo = res.data[0];
      if (this.Profileinfo) {
        this.custType = this.Profileinfo.customerType;
        if(this.custType=='International_business'){
          let data: any = this.YourInformation.get('Federal_tax_id');
          data.setValidators([Validators.required]);
          data.updateValueAndValidity();
        }
        this.YourInformation.patchValue({
          //Customer_legal_name: this.Profileinfo.first_name + " "+ this.Profileinfo.last_name,
          Dba_trade_name: this.Profileinfo.businessName,
          // business_type: this.Profileinfo.businessName,
          Federal_tax_id: this.Profileinfo.ein,
          Billing_address: this.Profileinfo.address1 + ", " + this.Profileinfo.address2 + ", " + this.Profileinfo.city + ", " + this.Profileinfo.state + ", " + this.Profileinfo.country + ", " + this.Profileinfo.postal_code,
          Physical_headquarter_address: this.Profileinfo.address1 + ", " + this.Profileinfo.address2 + ", " + this.Profileinfo.city + ", " + this.Profileinfo.state + ", " + this.Profileinfo.country + ", " + this.Profileinfo.postal_code,
          website_address: this.Profileinfo.website
        });

        this.yourContact.patchValue({
          billing_phone: this.Profileinfo.phone && this.Profileinfo.phone !== " " ? this.Profileinfo.phone : '',
          billing_email: this.Profileinfo.email !== 'undefined' || this.Profileinfo.email !== " " ? this.Profileinfo.email : '',
          billing_name: this.Profileinfo.first_name + ' ' + this.Profileinfo.last_name
        })

        this.SignatureForm.patchValue({
          kyc_signature_name: this.Profileinfo.first_name + " " + this.Profileinfo.last_name,
          kyc_signature_title: this.Profileinfo.title,
        });
        if(this.custType=='Sole_Proprietor'){
          this.YourInformation.get('Federal_tax_id').disable();
          this.YourInformation.get('Federal_tax_id').setValue('');
        }
      }
    });

    this.getallData(this.iduser, this.idaccount);
  
  }
  formatPhoneNumber(phoneNumber: string, phone: string ) {
    const numericPhoneNumber = phoneNumber.replace(/\D/g, '');
    const minLength = 10;
    const maxLength = 15;
    const phoneControl = this.yourContact.get(phone);

    const startIndex = Math.max(0, numericPhoneNumber.length - maxLength);
    const formattedNumber = numericPhoneNumber.slice(startIndex);

    if (formattedNumber.length < minLength) {
        phoneControl.markAsDirty();
        phoneControl.updateValueAndValidity();
        return phoneNumber; // Return original value
    }

    // If the formatted number is between min and max length, update the control
    if (formattedNumber.length <= maxLength) {
        phoneControl.patchValue(formattedNumber);
        return formattedNumber;
    } else {
        // If it's longer than max length, update with the last maxLength digits
        const lastDigits = formattedNumber.slice(formattedNumber.length - maxLength);
        phoneControl.patchValue(lastDigits);
        return lastDigits;
    }
}
  validateEmailField(fieldName: string): void {
    const emailControl = this.yourContact.get(fieldName);
    if (emailControl) {
      emailControl.markAsDirty();
      emailControl.updateValueAndValidity();
    }
  }  
  getallData(iduser, idaccount) {
    this.data.getallData({ iduser: iduser, idaccount: idaccount }).subscribe(res => {
      this.pdfDetails = res.data;
      if(this.pdfDetails.length>0){
        this.pdfDetails.forEach((element) => {
          if (element.form_type == 'YourInformation') {
            if (element.key == 'Customer_legal_name') {
              this.Customer_legal_name = element.value;
            }
            if (element.key == 'Dba_trade_name') {
              this.dba = element.value;
            }
            if (element.key == 'business_type') {
              this.business_type = element.value;
            }
            if (element.key == 'Federal_tax_id') {
              this.Federal_tax_id = element.value;
            }
            if (element.key == 'Physical_headquarter_address') {
              this.Physical_headquarter_address = element.value;
            }
            if (element.key == 'Billing_address') {
              this.Billing_address = element.value;
            }
            if (element.key == 'website_address') {
              this.website_address = element.value;
            }
            if (element.key == 'Social_media') {
              this.Social_media = element.value;
            }
          }
        
          if (element.form_type == 'yourContact') {
            if (element.key == 'billing_name') {
              this.billing_name = element.value;
            }
            if (element.key == 'billing_email') {
              this.billing_email = element.value;
              this.validateEmailField('billing_email');
            }
            if (element.key == 'billing_phone') {
              this.billing_phone = element.value;
            }
            if (element.key == 'Compliance_name') {
              this.Compliance_name = element.value;
            }
            if (element.key == 'Compliance_email') {
              this.Compliance_email = element.value;
              this.validateEmailField('Compliance_email');
            }
            if (element.key == 'Compliance_phone') {
              this.Compliance_phone = element.value;
            }
            if (element.key == 'Operations_name') {
              this.Operations_name = element.value;
            }
            if (element.key == 'Operations_email') {
              this.Operations_email = element.value;
              this.validateEmailField('Operations_email');
            }
            if (element.key == 'Operations_phone') {
              this.Operations_phone = element.value;
            }
          }
          if(element.form_type == 'voiceService'){
            this.custmType = element.customer_type;
          }
        
          if (element.form_type == 'kycSignature') {
            if (element.key == 'kyc_signature_name') {
              this.kycSignatureName = element.value;
            }
            if (element.key == 'kyc_signature_title') {
              this.kycSignatureTitle = element.value;
            }
            if (element.key == 'kyc_signature') {
              this.kycSignature = element.value;
            }
          }
          // this.kycDate = element.kyc_date;
        });
        this.setValue();
      }
    });
  }
  setValue(){
    this.YourInformation.patchValue({
      Customer_legal_name: this.Customer_legal_name,
      Dba_trade_name: this.dba,
      business_type: this.business_type,
      Federal_tax_id: this.Federal_tax_id,
      Physical_headquarter_address: this.Physical_headquarter_address,
      Billing_address: this.Billing_address,
      website_address: this.website_address,
      Social_media: this.Social_media
    });

    this.yourContact.patchValue({
      billing_name: this.billing_name,
      billing_email: this.billing_email,
      billing_phone: this.formatPhoneNumber(this.billing_phone,'billing_phone'),
      Compliance_name: this.Compliance_name,
      Compliance_email: this.Compliance_email,
      Compliance_phone: this.formatPhoneNumber(this.Compliance_phone,'Compliance_phone'),
      Operations_name: this.Operations_name,
      Operations_email: this.Operations_email,
      Operations_phone:  this.formatPhoneNumber(this.Operations_phone, 'Operations_phone')
    })

    this.SignatureForm.patchValue({
      kyc_signature_name: this.kycSignatureName,
      kyc_signature_title: this.kycSignatureTitle,
      kyc_signature: this.kycSignature
    });
    this.urlData = this.kycSignature;
    //this.Selectcustomer(this.custmType,'add');
    if(this.custType=='Sole_Proprietor'){
      this.YourInformation.get('Federal_tax_id').disable();
      this.YourInformation.get('Federal_tax_id').setValue('');
    }
  }

  async init(){
    this.ctx = this.canvas.nativeElement.getContext('2d');
    this.ctx.strokeStyle = '#222';
    this.ctx.lineCap = 'round';
    this.ctx.lineJoin = 'round';
    this.ctx.lineWidth = 4;
    
    this.canvas.nativeElement.addEventListener('mousedown', (e) => {
      this.isDrawing = true;
      [this.lastX, this.lastY] = [e.offsetX, e.offsetY];
    });

    this.canvas.nativeElement.addEventListener('mousemove', (e) => {
      if (!this.isDrawing) return;
      this.draw(e.offsetX, e.offsetY);
      [this.lastX, this.lastY] = [e.offsetX, e.offsetY];
    });

    this.canvas.nativeElement.addEventListener('mouseup', () => this.isDrawing = false);
    this.canvas.nativeElement.addEventListener('mouseleave', () => this.isDrawing = false);
    let element:HTMLElement = document.getElementById('auto_trigger') as HTMLElement;
    element.click();
  }

  draw(x: number, y: number) {
    this.ctx.beginPath();
    this.ctx.moveTo(this.lastX, this.lastY);
    this.ctx.lineTo(x, y);
    this.ctx.stroke();
  }

  clearCanvas() {
    this.ctx.clearRect(0, 0, this.canvas.nativeElement.width, this.canvas.nativeElement.height);
    this.errorMessageDisplayed = false;
  }

  async saveSignature() {
    if (this.isCanvasEmpty()) {
      this.errorMessageDisplayed = true; 
    return;
    }
    const a = document.createElement('a');
    a.href = await this.canvas.nativeElement.toDataURL();
    this.urlData = a.href;
    await this.SignatureForm.patchValue({ 'kyc_signature': this.urlData });
    document.getElementById("myModal").click();
  }
  isCanvasEmpty() {
    const canvasData = this.ctx.getImageData(0, 0, this.canvas.nativeElement.width, this.canvas.nativeElement.height).data;
    for (let i = 0; i < canvasData.length; i += 4) {
      if (canvasData[i + 3] !== 0) {
        return false; 
      }
    }
    return true; 
  }
  showModel() {
    setTimeout(() => {
      this.init();
      this.errorMessageDisplayed = false;
    }, 500);

  }

  divideData() {
    this.VoiceService = [];
    this.MessageSevice = [];
    this.ResellerVoice = [];
    this.ResellerMessage = [];
    this.Questions.forEach((element, index) => {
      if (element.service_type == 'voice_services' && element.customer_type == 'end_user') {
        this.VoiceService.push(element);
      }
      else if (element.service_type == 'message_services' && element.customer_type == 'end_user') {
        this.MessageSevice.push(element);
      }
      else if (element.service_type == 'voice_services' && element.customer_type == 'reseller') {
        this.ResellerVoice.push(element);
      }
      else if (element.service_type == 'message_services' && element.customer_type == 'reseller') {
        this.ResellerMessage.push(element);
      }
      if(index == this.Questions.length-1){
       this.setformControl();
      }
    });
  }

  noWhitespaceValidator(control: any) {
    const isWhitespace = (control.value || '').trim().length === 0;
    const isValid = !isWhitespace;
    return isValid ? null : { 'whitespace': true };
  }

  setformControl() {
    let tmpform: any = {};
    let msgform: any = {};
    if (this.pannelType == 'endUser') {
      this.VoiceService.forEach((ele, ind) => {
        tmpform["voice_question" + (ind + 1) + ('_' + ele.id)] = [''];
        if (ele.question_type == '1') {
          ele.click_yes = 0;
          tmpform["sub_voice_question" + (ind + 1) + ('_' + ele.id)] = [''];
        }
        if (ele.question_type == '5') {
          tmpform["sub_desc_question" + (ind + 1) + ('_' + ele.id)] = [''];
        }
        if (ind == 0) {
          tmpform["formType"] = ['voiceService'];
        }
      });
      this.voiceService = this.fb.group(tmpform);
      this.MessageSevice.forEach((ele, ind) => {
        msgform["msg_question" + (ind + 1) + ('_' + ele.id)] = [''];
        if (ele.question_type == '1') {
          ele.click_yes = 0;
          msgform["sub_msg_question" + (ind + 1) + ('_' + ele.id)] = [''];
        }
        if (ele.question_type == '3') {
          msgform["sub_desc_question" + (ind + 1) + ('_' + ele.id)] = [''];
        }
        if (ind == 0) {
          msgform["formType"] = ['messageService']
        }
      });
      this.messageService = this.fb.group(msgform);
      this.disableCheckbox();
    }
    else if (this.pannelType == 'reseller') {
      this.ResellerVoice.forEach((ele, ind) => {
        tmpform["voice_question" + (ind + 1) + ('_' + ele.id)] = [''];
        if (ele.question_type == '1') {
          ele.click_yes = 0;
          tmpform["sub_list_question" + (ind + 1) + ('_' + ele.id)] = [''];
        }
        if (ele.question_type == '3') {
          tmpform["sub_desc_question" + (ind + 1) + ('_' + ele.id)] = [''];
        }
        if (ele.question_type == '4') {
          tmpform["sub_check_question" + (ind + 1) + ('_' + ele.id)] = [''];
        }
        if (ele.question_type == '5') {
          tmpform["sub_check_question" + (ind + 1) + ('_' + ele.id)] = [''];
          tmpform["sub_desc5_question" + (ind + 1) + ('_' + ele.id)] = [''];
        }
        if (ind == 0) {
          tmpform["formType"] = ['voiceService'];
        }
      });
      this.voiceService = this.fb.group(tmpform);
      this.ResellerMessage.forEach((ele, ind) => {
        msgform["msg_question" + (ind + 1) + ('_' + ele.id)] = [''];
        if (ele.question_type == '1') {
          ele.click_yes = 0;
          msgform["sub_msg_question" + (ind + 1) + ('_' + ele.id)] = [''];
        }
        if (ele.question_type == '3') {
          msgform["sub_desc_question" + (ind + 1) + ('_' + ele.id)] = [''];
        }
        if (ind == 0) {
          msgform["formType"] = ['messageService']
        }
      });
      this.messageService = this.fb.group(msgform);
      this.disableCheckbox();
    }
    if (this.custmType == 'end_user' || this.custmType == 'reseller') {
      // if(!this.changePanel){
      //   this.SetQusVal();
      // }
    }
  }

  disableCheckbox() {
    if (this.pannelType == 'endUser') {
      this.VoiceService.forEach((element, index) => {
        if (index == 0) {
          element['hide'] = false;
        }
        else {
          let formControl = 'voice_question' + (index + 1) + ('_' + element.id)
          this.voiceService.get(formControl).disable();
          element['hide'] = true;
        }
      });

      this.MessageSevice.forEach((element, index) => {
        if (index == 0) {
          element['hide'] = false;
        }
        else {
          let formControl = 'msg_question' + (index + 1) + ('_' + element.id)
          this.messageService.get(formControl).disable();
          element['hide'] = true;
        }
      });
    }
    else if (this.pannelType == 'reseller') {
      this.ResellerVoice.forEach((element, index) => {
        if (index == 0) {
          element['hide'] = false;
        }
        else {
          let formControl = 'voice_question' + (index + 1) + ('_' + element.id)
          this.voiceService.get(formControl).disable();
          element['hide'] = true;
        }
      });

      this.ResellerMessage.forEach((element, index) => {
        if (index == 0) {
          element['hide'] = false;
        }
        else {
          let formControl = 'msg_question' + (index + 1) + ('_' + element.id)
          this.messageService.get(formControl).disable();
          element['hide'] = true;
        }
      });
    }

  }

  // SetQusVal() {
  //   let FirstQus :any='';
  //   let secondQus :any='';
    
  //   this.pdfDetails.forEach((element) => {
  //     if (element.form_type == 'voiceService') {
  //       if (element.customer_type == 'end_user') {
  //         this.nextButton = true;
  //         this.VoiceService.forEach((ele,index) => { 
  //           if (ele.id == element.question_id) {
  //             if(element.value=='0' || element.value=='1'){
  //               let formControl = 'voice_question' + (index + 1) + ('_' + ele.id);
  //               this.voiceService.get(formControl).enable();
  //               this.voiceService.get(formControl).setValue(element.value);
  //               ele.hide = false;
  //               if(element.value == '1'){
  //                 ele.click_yes = 1;
  //               }else{
  //                 ele.click_yes = 2;
  //               }
  //               // Hide Question
  //               if(element.yes_to_continue == 'Continue' && index!==0 && element.value == 1){
  //                 this.alldisp = true;
  //                 ele.hide = false;
  //               }
  //               else{
  //                 if(index == 0){
  //                   ele.hide = false;
  //                   FirstQus = element.value;
  //                 }
  //                 else{
  //                   if(element.yes_to_continue== 'Continue' && FirstQus == 0)
  //                   ele.hide = true;
  //                   ele.click_yes = 0;
  //                 }
  //                 if(element.yes_to_continue!== 'Continue'){
  //                   ele.hide = true;
  //                   ele.click_yes = 0;
  //                 }
  //               }
  //               if(this.alldisp == true){
  //                 ele.hide = false;
  //               }

  //               if(ele.question_type =='5'){
  //                 let formControl = 'sub_desc_question' + (index + 1) + ('_' + ele.id);
  //                 this.voiceService.get(formControl).setValue(element.value);
  //                 ele.click_yes = 1;
  //               }
  //             }
  //             if(ele.question_type == 1 && (element.value!=='0' && element.value!=='1')){
  //               let formControl2 = 'sub_voice_question' + (index + 1) + ('_' + ele.id);
  //               this.voiceService.get(formControl2).setValue(element.value);
  //               setTimeout(() => {
  //                 if(element.value == 'Integrating into our application'){
  //                   $('#sub_voice_question1_1').prop("checked", true)
  //                   $('#sub_voice_question2_1').prop("checked", false)
  //                   $('#sub_voice_question3_1').prop("checked", false)
  //                   $('#sub_voice_question4_1').prop("checked", false)
  //                 }
  //                 else if(element.value == 'Internal PBX / calling'){
  //                   $('#sub_voice_question1_1').prop("checked", false)
  //                   $('#sub_voice_question2_1').prop("checked", true)
  //                   $('#sub_voice_question3_1').prop("checked", false)
  //                   $('#sub_voice_question4_1').prop("checked", false)
  //                 }
  //                 else if(element.value == 'Contact Center'){
  //                   $('#sub_voice_question1_1').prop("checked", false)
  //                   $('#sub_voice_question2_1').prop("checked", false)
  //                   $('#sub_voice_question3_1').prop("checked", true)
  //                   $('#sub_voice_question4_1').prop("checked", false)
  //                 }else{
  //                   $('#sub_voice_question1_1').prop("checked", false)
  //                   $('#sub_voice_question2_1').prop("checked", false)
  //                   $('#sub_voice_question3_1').prop("checked", false)
  //                   $('#sub_voice_question4_1').prop("checked", true)
  //                  this.Description='Other';
  //                 }
  //               }, 5000);
  //             }
  //           }
  //            // disable question
  //             if (element.hide == false && element.yes_to_continue !== 'Continue') {
  //               if (element.click_yes == 1 || element.click_yes == 2) {
  //                 this.nextButton = true;
  //               }
  //               else {
  //                 this.nextButton = false;
  //               }
  //             }
  //            if(element.question_type == 1 && element.value == 1){
  //              let voiceList = this.voiceService.get('sub_voice_question1_1').value;
  //               if (voiceList == '') {
  //                 this.nextButton = false;
  //               }
  //            }
  //           });
  //       }
  //       if (element.customer_type == 'reseller') {
  //         this.nextButton = true;
  //         this.ResellerVoice.forEach((ele, index) => {
  //           if (ele.id == element.question_id && ele.question_type!==2) {
  //             if(element.value=='0' || element.value=='1'){
  //               let formControl = 'voice_question' + (index + 1) + ('_' + ele.id);
  //               this.voiceService.get(formControl).enable();
  //               this.voiceService.get(formControl).setValue(element.value);
  //               ele.hide = false;
  //               if(element.value == '1'){
  //                 ele.click_yes = 1;
  //               }else{
  //                 ele.click_yes = 2;
  //               }
  //             }
                
  //             if(ele.question_type == 1 && (element.value!=='0' && element.value!=='1')){
  //               let formControl2 = 'sub_list_question' + (index + 1) + ('_' + ele.id);
  //               this.voiceService.get(formControl2).setValue(element.value);
  //               setTimeout(() => {
  //                 if(element.value == 'Integrating into our application'){
  //                   $('#sub_list_question1_12').prop("checked", true)
  //                   $('#sub_list_question2_12').prop("checked", false)
  //                   $('#sub_list_question3_12').prop("checked", false)
  //                   $('#sub_list_question4_12').prop("checked", false)
  //                 }
  //                 else if(element.value == 'Internal PBX / calling'){
  //                   $('#sub_list_question2_12').prop("checked", true)
  //                   $('#sub_list_question1_12').prop("checked", false)
  //                   $('#sub_list_question3_12').prop("checked", false)
  //                   $('#sub_list_question4_12').prop("checked", false)
  //                 }
  //                 else if(element.value == 'Contact Center'){
  //                   $('#sub_list_question2_12').prop("checked", false)
  //                   $('#sub_list_question1_12').prop("checked", false)
  //                   $('#sub_list_question3_12').prop("checked", true)
  //                   $('#sub_list_question4_12').prop("checked", false)
  //                 }
  //                 else{
  //                   $('#sub_list_question3_12').prop("checked", false)
  //                   $('#sub_list_question1_12').prop("checked", false)
  //                   $('#sub_list_question2_12').prop("checked", false)
  //                   $('#sub_list_question4_12').prop("checked", true)
  //                   this.Description='Other';
  //                 }
  //               }, 5000);
              
  //             }
  //             if(ele.question_type=='4'){
  //               let formControl = 'sub_check_question' + (index + 1) + ('_' + ele.id);
  //               this.voiceService.get(formControl).setValue(element.value);
  //               if(element.value == '1'){
  //                 ele.click_yes2 = 1;
  //               }else{
  //                 ele.click_yes2 = 2;
  //               }
  //             }
  //             if(ele.question_type=='5'){
  //               if(element.value=='0' || element.value=='1'){
  //                 let formControl = 'sub_check_question' + (index + 1) + ('_' + ele.id);
  //                 this.voiceService.get(formControl).setValue(element.value);
  //                 if(element.value == '1'){
  //                   ele.click_yes2 = 1;
  //                   this.voiceExp = true;
  //                 }else{
  //                   ele.click_yes2 = 2;
  //                   this.voiceExp = false;
  //                 }
  //               }
  //              if(ele.click_yes2 == 1 && (element.value!=='0' && element.value!=='1')){
  //               ele['click_yes3'] = 3;
  //               this.voiceDesc = element.value  
  //              }
  //             }
  //           }

  //           // hide Question
  //           if(ele.yes_to_continue== 'Continue'){
  //             if(element.question_id == 12 && (element.value=='0' || element.value=='1')){
  //               ele.hide = false;
  //               FirstQus=element.value; 
  //             }
  //             else{
  //               if(FirstQus == 1 && element.question_id == 14 && (element.value=='0' || element.value=='1')){
  //                 ele.hide = false;
  //                 secondQus = element.value;
  //               }
  //               else{
  //                 if(FirstQus == 0 && index!==0){
  //                   ele.hide = true;
  //                   ele.click_yes = 0;
  //                   // console.log("hhh",element);
  //                 } 
  //               }
  //             }
  //           }
  //           if(secondQus == 1){
  //             ele.hide = false;
  //           }
  //           else{
  //             if(ele.yes_to_continue!== 'Continue'){
  //               if(ele.question_type == 5){
  //                 ele.hide = false;
  //                 if(FirstQus == 0){
  //                   ele.hide = true;
  //                   ele.click_yes = 0;
  //                 }
  //               }else{
  //                 ele.hide = true;
  //                 ele.click_yes = 0;
  //               }
  //             }
  //           }

  //           // disable next button
  //           if(ele.hide == false && ele.yes_to_continue!== 'Continue' && ele.question_type!==2){
  //             if(ele.click_yes == 1 || ele.click_yes == 2){
  //               if(ele.click_yes == 2){
  //                 this.nextButton = true;
  //               }
  //               else{
  //                 let existtt= ele.hasOwnProperty('click_yes2');
  //                 if(existtt){
  //                   if(ele.click_yes2 == 0){
  //                     this.nextButton = false;
  //                   }
  //                 }
  //               }
  //             }
  //             else{
  //               this.nextButton = false;
  //             }
  //           }
  //           if(this.subList == true){
  //             let otherV = this.voiceService.get('sub_list_question1_12').value;
  //             if(otherV == ''){
  //               this.nextButton = false;
  //             }
  //           }
  //           if(this.voiceDesc.length <= 1 && index!==0 && this.voiceExp == true){
  //             this.nextButton = false;
  //           }
  //         });
  //       }
  //     }
  //     if(element.form_type == 'messageService'){
  //       if(element.customer_type == 'end_user'){
  //         this.MessageSevice.forEach((ele,index) => { 
  //           if (ele.id == element.question_id) {
  //             if(element.value=='0' || element.value=='1'){
  //               let formControl = 'msg_question' + (index + 1) + ('_' + ele.id);
  //               this.messageService.get(formControl).enable();
  //               this.messageService.get(formControl).setValue(element.value);
  //               ele.hide = false;
  //               if(element.value == '1'){
  //                 ele.click_yes = 1;
  //               }else{
  //                 ele.click_yes = 2;
  //               }
  //               // Hide Question
  //               if(element.yes_to_continue == 'Continue' && (element.value=='0' || element.value=='1')){
  //                 ele.hide = false;
  //                 this.firstsmsQus = element.value
  //               }
  //               else{
  //                 if(this.firstsmsQus == 1){
  //                   ele.hide = false;
  //                 }
  //                 else{
  //                   ele.hide = true;
  //                   ele.click_yes =0;
  //                 }
  //               }
               
  //               if(ele.question_type=='3' && element.value=='1'){
  //                 this.messageDesChecked = true;
  //               }
  //             }
  //             if(ele.question_type == 1 && (element.value!=='0' && element.value!=='1')){
  //               let formControl2 = 'sub_msg_question' + (index + 1) + ('_' + ele.id);
  //               this.messageService.get(formControl2).setValue(element.value);
  //               setTimeout(() => {
  //                 if(element.value == 'Integrating into our CRM application'){
  //                   $('#sub_msg_question1_8').prop("checked", true)
  //                   $('#sub_msg_question2_8').prop("checked", false)
  //                   $('#sub_msg_question3_8').prop("checked", false)  
  //                 }
  //                 else if(element.value == 'Integrating into our Contact Center application'){
  //                   $('#sub_msg_question1_8').prop("checked", false)
  //                   $('#sub_msg_question2_8').prop("checked", true)
  //                   $('#sub_msg_question3_8').prop("checked", false)
  //                 }
  //                else{
  //                   $('#sub_msg_question1_8').prop("checked", false)
  //                   $('#sub_msg_question2_8').prop("checked", false)
  //                   $('#sub_msg_question3_8').prop("checked", true)
                   
  //                  this.Description1='Integrating into another type of application / purpose (please specify)';
  //                 }
  //               }, 5000);
  //             }
  //             if(ele.question_type =='3' && (element.value!=='0' && element.value!=='1')){
  //               this.messageDesc = element.value == 'N/A' ? '' : element.value
  //             }
  //           }
  //           //  disable question
  //             if (ele.hide == false  && ele.question_type!==2) {
  //               if (ele.click_yes == 1 || ele.click_yes == 2) {
  //                 this.msgButton = true;
  //               }
  //               else {
  //                 this.msgButton = false;
  //               }
  //             }
  //             // disable desc
  //             if (this.messageDesc.length < 50 && this.messageDesChecked) {
  //               this.msgButton = false;
  //             }
  //             // disable List
  //             if (this.messageDesChecked) {
  //               let voiceList = this.messageService.get('sub_msg_question1_8').value;
  //               if (voiceList == '') {
  //                 this.msgButton = false;
  //               }
  //             }
  //           });
  //       }
  //       if(element.customer_type == 'reseller'){
  //         this.ResellerMessage.forEach((ele,index) => { 
  //           if (ele.id == element.question_id) {
  //             if(element.value=='0' || element.value=='1'){
  //               let formControl = 'msg_question' + (index + 1) + ('_' + ele.id);
  //               this.messageService.get(formControl).enable();
  //               this.messageService.get(formControl).setValue(element.value);
  //               ele.hide = false;
  //               if(element.value == '1'){
  //                 ele.click_yes = 1;
  //               }else{
  //                 ele.click_yes = 2;
  //               }
  //               // Hide Question
  //               if(element.yes_to_continue == 'Continue' && (element.value=='0' || element.value=='1')){
  //                 ele.hide = false;
  //                 this.firstsmsQus = element.value
  //               }
  //               else{
  //                 if(this.firstsmsQus == 1){
  //                   ele.hide = false;
  //                 }
  //                 else{
  //                   ele.hide = true;
  //                   ele.click_yes = 0;
  //                 }
  //               }
               
  //               if(ele.question_type=='3' && element.value=='1'){
  //                 this.messageDesChecked = true;
  //               }
  //             }
  //             if(ele.question_type == 1 && (element.value!=='0' && element.value!=='1')){
  //               let formControl2 = 'sub_msg_question' + (index + 1) + ('_' + ele.id);
  //               this.messageService.get(formControl2).setValue(element.value);
  //               setTimeout(() => {
  //                 if(element.value == 'Integrating into our CRM application'){
  //                   $('#sub_msg_question1_22').prop("checked", true)
  //                   $('#sub_msg_question2_22').prop("checked", false)
  //                   $('#sub_msg_question3_22').prop("checked", false)  
  //                 }
  //                 else if(element.value == 'Integrating into our Contact Center application'){
  //                   $('#sub_msg_question1_22').prop("checked", false)
  //                   $('#sub_msg_question2_22').prop("checked", true)
  //                   $('#sub_msg_question3_22').prop("checked", false)
  //                 }
  //                else{
  //                   $('#sub_msg_question1_22').prop("checked", false)
  //                   $('#sub_msg_question2_22').prop("checked", false)
  //                   $('#sub_msg_question3_22').prop("checked", true)
                   
  //                  this.Description1='Integrating into another type of application / purpose (please specify)';
  //                 }
  //               }, 5000);
  //             }
  //             if(ele.question_type =='3' && (element.value!=='0' && element.value!=='1')){
  //               this.messageDesc = element.value == 'N/A' ? '' : element.value
  //             }
  //           }
  //           //  disable question
  //             if (ele.hide == false  && ele.question_type!==2) {
  //               if (ele.click_yes == 1 || ele.click_yes == 2) {
  //                 this.msgButton = true;
  //               }
  //               else {
  //                 this.msgButton = false;
  //               }
  //             }
  //             // disable desc
  //             if (this.messageDesc.length < 50 && this.messageDesChecked) {
  //               this.msgButton = false;
  //             }
  //             // disable List
  //             if (this.messageDesChecked) {
  //               let voiceList = this.messageService.get('sub_msg_question1_22').value;
  //               if (voiceList == '') {
  //                 this.msgButton = false;
  //               }
  //             }
  //           });
  //       }
  //     }
  //   })
  // }
  informationErr() {
    this.submitted = true;
  }
  signErr() {
    this.submitted2 = true;
  }
  serviceErr() {
    this.errMessage = 'All Question Are Required';
    setTimeout(() => {
      this.errMessage = ''
    }, 3000);
  }

  onchangeOther(service: any, pannelType: any) {
    if (pannelType == 'end_user') {
      if (service == 'voice') {
        this.VoiceService.forEach((element, index) => {
          if (element.question_type == 1) {
            let listdata = this.voiceService.get('sub_voice_question' + (index + 1) + '_' + (element.id)).value
            if (listdata.length < 1 || this.voiceService.controls['sub_voice_question1_1'].invalid) {
              this.nextButton = false;
            }
            else {
              this.nextButton = true;
            }
          }
          if (element.click_yes == 0 && element.hide == false) {
            this.nextButton = false;
          }
          if (element.hide == false && element.question_type == 5 && element.click_yes == 1) {
            if(element.click_yes2 == 0){
              this.nextButton = false;
            }
          }
        });
      }
      if (service == 'message') {
        this.MessageSevice.forEach((element, index) => {
          if (element.question_type == 1) {
            let listdata = this.messageService.get('sub_msg_question' + (index + 1) + '_' + (element.id)).value;
            if (listdata.length < 50 || this.messageService.controls['sub_msg_question' + (index + 1) + '_' + (element.id)].invalid) {
              this.msgButton = false;
            }
            else {
              this.msgButton = true;
            }
          }
          if (element.click_yes == 0 && element.hide == false && element.question_type !== 2) {
            this.msgButton = false;
          }
        });
        if (this.messageDesChecked == true) {
          if (this.messageDesc.length < 50 || this.messageService.controls['sub_desc_question3_10'].invalid) {
            this.msgButton = false;
          }
        }
      }
    }
    if (pannelType == 'reseller') {
      if (service == 'voice') {
        this.nextButton = true;
        this.ResellerVoice.forEach((element, index) => {
          if (element.question_type == 1) {
            let listdata = this.voiceService.get('sub_list_question' + (index + 1) + '_' + (element.id)).value
            if (listdata.length < 50 || this.voiceService.controls['sub_list_question1_12'].invalid) {
              this.nextButton = false;
            }
          }
          if (element.click_yes == 0 && element.hide == false && element.yes_to_continue !== 'Continue' && element.question_type!==2) {
            this.nextButton = false;
          }
          if(element.hide == false && element.question_type == 4 && element.click_yes == 1){
            if(element.click_yes2 == 0){
              this.nextButton = false;
            }
          }
          if(element.hide == false && element.yes_to_continue!== 'Continue' && element.question_type!==2){
            if(element.click_yes == 1){
              let existtt= element.hasOwnProperty('click_yes2');
                if(existtt){
                  if(element.click_yes2 == 0){
                    this.nextButton = false;
                  }
                }
            }
            else{
              if(element.click_yes == 0){
                this.nextButton = false;
              }
            }
          }
        });
        if(this.voiceExp){
          if(this.voiceService.controls['sub_desc5_question2_13'].invalid){
            this.nextButton = false;
          }
        }
        // if(this.voiceDesChecked == true){
        //   if(this.voiceDesc.length < 50){
        //     this.nextButton = false;
        //   }
        // }
      }

      if (service == 'message') {
        this.ResellerMessage.forEach((element, index) => {
          if (element.question_type == 1) {
            let listdata = this.messageService.get('sub_msg_question' + (index + 1) + '_' + (element.id)).value;
            if (listdata.length < 50) {
              this.msgButton = false;
            }
            else {
              this.msgButton = true;
            }
          }
          if (element.click_yes == 0 && element.hide == false && element.question_type !== 2) {
            this.msgButton = false;
          }
        });
        // if (this.messageDesChecked == true) {
        //   if (this.messageDesc.length < 50) {
        //     this.msgButton = false;
        //   }
        // }
        let listdata = this.messageService.get('sub_desc_question3_24').value
        if((listdata.length < 50 || this.messageService.controls['sub_desc_question3_24'].invalid) && this.messageDesChecked){
          this.msgButton = false;
        }

        if(this.messageListChecked && this.subcheckboxQus== false){
          let messageList = this.messageService.get('sub_msg_question1_22').value;
            if(messageList == '' || this.messageService.controls['sub_msg_question1_22'].invalid || (messageList.length < 50)){
              this.msgButton = false;
            } 
        }
      }
    }
  }

  changevoiceDesc(service:any,custType:any){
    if(service == 'voice'){
      if(this.voiceDesc.length >= 1){
        this.nextButton = true;
      }
      else{
        this.nextButton = false;
      }
      if(custType == 'endUser'){
        this.VoiceService.forEach((element,index) => {
          if(element.click_yes == 0 && element.hide == false){
            this.nextButton = false;
          }
          if(element.question_type == 1){
            let listdata = this.voiceService.get('sub_voice_question' + (index + 1) + '_' + (element.id)).value;
            if(listdata==''){
             this.nextButton = false;
            }
          }
        });
      }
      if(custType == 'reseller'){
        this.ResellerVoice.forEach((element,index) => {
          if(element.click_yes == 0 && element.hide == false && element.question_type !== 2){
            this.nextButton = false;
          }
          if(element.question_type == 1){
            let listdata = this.voiceService.get('sub_list_question' + (index + 1) + '_' + (element.id)).value;
            if(this.Description =='Other' && (listdata=='' || listdata.length < 50) || this.voiceService.controls['sub_list_question1_12'].invalid){
              this.nextButton = false;
             }
          }
          if(element.hide == false && element.yes_to_continue!== 'Continue' && element.question_type!==2){
            if(element.click_yes == 1){
              let existtt= element.hasOwnProperty('click_yes2');
                if(existtt){
                  if(element.click_yes2 == 0){
                    this.nextButton = false;
                  }
                }
            }
            else{
              if(element.click_yes == 0){
                this.nextButton = false;
              }
            }
          }
        });
      }
    }
    if(service == 'message'){
      if(this.messageDesc.length >= 50 || this.messageService.controls['sub_desc_question3_10'].valid){
        this.msgButton = true;
      }
      else{
        this.msgButton = false;
      }
      if(custType == 'endUser'){
        this.MessageSevice.forEach((element,index) => {
          if(element.click_yes == 0 && element.hide == false){
            this.msgButton = false;
          }
          if(element.question_type == 1){
            let listdata = this.messageService.get('sub_msg_question' + (index + 1) + '_' + (element.id)).value;
            if(listdata=='' || (listdata.length < 50 && this.subcheckboxQus == false) || this.messageService.controls['sub_msg_question1_8'].invalid){
             this.msgButton = false;
            }
          }
        });
      }
      if(custType == 'reseller'){
        this.ResellerMessage.forEach((element,index) => {
          if(element.click_yes == 0 && element.hide == false && element.question_type!==2){
            this.msgButton = false;
          }
          // if(element.question_type == 1){
          //   let listdata = this.messageService.get('sub_msg_question' + (index + 1) + '_' + (element.id)).value;
          //   if(listdata=='' || (listdata.length < 50 && this.subcheckboxQus == false)){
          //    this.msgButton = false;
          //   }
          // }
          let listdata = this.messageService.get('sub_desc_question3_24').value
          if((listdata.length < 50 || this.messageService.controls['sub_desc_question3_24'].invalid) && this.messageDesChecked){
            this.msgButton = false;
          }

          if(this.messageListChecked && element.hide == false && this.subcheckboxQus== false){
            let messageList = this.messageService.get('sub_msg_question1_22').value;
              if(messageList == '' || this.messageService.controls['sub_msg_question1_22'].invalid || (messageList.length < 50)){
                this.msgButton = false;
              } 
          }
        });
      }
    
    }
  }

  setVoice() {
    if (this.pannelType == 'endUser') {
      this.VoiceService.forEach((element, index) => {
        let formControl = 'voice_question' + (index + 1) + ('_' + element.id);
        this.voiceService.get(formControl).enable();
        let Data = this.voiceService.get(formControl).value;
        if (Data == '') {
          this.voiceService.get(formControl).setValue('0');
        }
        if (element.id == '1') {
          let subVoice = this.voiceService.get('sub_voice_question' + (index + 1) + ('_' + element.id)).value;
          if (subVoice == '') {
            this.voiceService.get('sub_voice_question' + (index + 1) + ('_' + element.id)).setValue('N/A');
          }
        }
        if (element.question_type == '5') {
           let formControl = 'sub_desc_question' + (index + 1) + ('_' + element.id);
          let Data2 = this.voiceService.get(formControl).value;
          if (Data2 == '') {
            this.voiceService.get(formControl).setValue('0');
          }
        }
      });
    }

    if (this.pannelType == 'reseller') {
      this.ResellerVoice.forEach((element, index) => {
        let formControl = 'voice_question' + (index + 1) + ('_' + element.id);
        this.voiceService.get(formControl).enable();
        let Data = this.voiceService.get(formControl).value;
        if (Data == '') {
          this.voiceService.get(formControl).setValue('0');
        }
        if (element.question_type == '4' || element.question_type == '5') {
          let formCtrl = 'sub_check_question' + (index + 1) + ('_' + element.id);
          let DataVal = this.voiceService.get(formCtrl).value;
          if (DataVal == '') {
            this.voiceService.get(formCtrl).setValue('0');
          }
        }

        if (element.question_type == '1') {
          let subVoice = this.voiceService.get('sub_list_question' + (index + 1) + ('_' + element.id)).value;
          if (subVoice == '') {
            this.voiceService.get('sub_list_question' + (index + 1) + ('_' + element.id)).setValue('N/A');
          }
        }
        if (element.question_type == '5') {
          let voiceDesc = this.voiceService.get('sub_desc5_question' + (index + 1) + ('_' + element.id)).value;
          if (voiceDesc == '') {
            this.voiceService.get('sub_desc5_question' + (index + 1) + ('_' + element.id)).setValue('N/A');
          }
        }
      });
    }
  }
  setMessage() {
    if (this.pannelType == 'endUser') {
      this.MessageSevice.forEach((element, index) => {
        let formControl = 'msg_question' + (index + 1) + ('_' + element.id);
        this.messageService.get(formControl).enable();
        let Data = this.messageService.get(formControl).value;
        if (Data == '') {
          this.messageService.get(formControl).setValue('0');
        }
        if (element.id == '8') {
          let subData = this.messageService.get('sub_msg_question' + (index + 1) + ('_' + element.id)).value;
          if (subData == '') {
            this.messageService.get('sub_msg_question' + (index + 1) + ('_' + element.id)).setValue('N/A');
          }
        }
        if (element.id == '10') {
          let subDesc = this.messageService.get('sub_desc_question' + (index + 1) + ('_' + element.id)).value;
          if (subDesc == '') {
            this.messageService.get('sub_desc_question' + (index + 1) + ('_' + element.id)).setValue('N/A');
          }
        }
      });
    }
    if (this.pannelType == 'reseller') {
      this.ResellerMessage.forEach((element, index) => {
        let formControl = 'msg_question' + (index + 1) + ('_' + element.id);
        this.messageService.get(formControl).enable();
        let Data = this.messageService.get(formControl).value;
        if (Data == '') {
          this.messageService.get(formControl).setValue('0');
        }
        if (element.id == '22') {
          let subData = this.messageService.get('sub_msg_question' + (index + 1) + ('_' + element.id)).value;
          if (subData == '') {
            this.messageService.get('sub_msg_question' + (index + 1) + ('_' + element.id)).setValue('N/A');
          }
        }
        if (element.id == '24') {
          let subDesc = this.messageService.get('sub_desc_question' + (index + 1) + ('_' + element.id)).value;
          if (subDesc == '') {
            this.messageService.get('sub_desc_question' + (index + 1) + ('_' + element.id)).setValue('N/A');
          }
        }
      });
    }

  }

  changeStatus2(evt: any, Qus: any, service: any, custType: any) {
    this.nextButton = true;
    let IdS = evt.target.id.split("_");
    let QID = IdS[IdS.length - 1];
    if (service == 'voice') {
      if (evt.target.checked == true) {
        this.Description = Qus;
        let eId = evt.target.id;
        if (Qus == 'Other') {
          this.voiceService.get('sub_voice_question1_1').setValue('');
          let flname: any = this.voiceService.get('sub_voice_question1_1');
          flname.setValidators([this.noWhitespaceValidator]);
          flname.updateValueAndValidity();
        }
        else {
          this.voiceService.get('sub_voice_question1_1').setValue(this.Description);
        }
        for (let i = 1; i <= 4; i++) {
          let Id = 'sub_voice_question' + i + '_1'
          if (Id == eId) {
            $('#' + Id).prop("checked", true)
          }
          else {
            $('#' + Id).prop("checked", false)
          }
        }
      }
      else {
        this.Description = '';
      }
      this.VoiceService.forEach((element, index) => {
        if (element.question_type == 1) {
          let listdata = this.voiceService.get('sub_voice_question' + (index + 1) + '_' + (element.id)).value
          if (listdata == '') {
            this.nextButton = false;
          }
          else {
            this.nextButton = true;
          }
        }
        if (element.click_yes == 0 && element.hide == false) {
          this.nextButton = false;
        }
        if (element.hide == false && element.yes_to_continue !== 'Continue') {
          if (element.question_type == 5 && element.click_yes == 1) {
            if(element.click_yes2 == 0){
              this.nextButton = false;
            }
          }
        }
      });
    }
    if (service == 'message') {
      if (evt.target.checked == true) {
        this.Description1 = Qus;
        let eId = evt.target.id;
        let formCtrl = 'sub_msg_question1_' + Number(QID);
        if (Qus == 'Integrating into another type of application / purpose (please specify)') {
          this.messageService.get(formCtrl).setValue('');
          let flname: any = this.messageService.get(formCtrl);
          flname.setValidators([this.noWhitespaceValidator]);
          flname.updateValueAndValidity();
          this.msgButton = false;
          this.subcheckboxQus = false;
        }
        else {
          this.messageService.get(formCtrl).setValue(this.Description1);
          this.msgButton = true;
          this.subcheckboxQus = true;
        }
        for (let i = 1; i <= 3; i++) {
          let Id = 'sub_msg_question' + i + '_' + Number(QID);
          if (Id == eId) {
            $('#' + Id).prop("checked", true)
          }
          else {
            $('#' + Id).prop("checked", false)
          }
        }
      }
      else {
        this.Description1 = '';
        this.msgButton = false;
      }
      // disable button
      if (custType == 'endUser') {
        if (evt.target.checked) {
          this.MessageSevice.forEach((element, index) => {
            if (element.question_type == 3 && this.messageDesChecked == true) {
              let listdata = this.messageService.get('sub_desc_question' + (index + 1) + '_' + (element.id)).value
              if (listdata.length < 50) {
                this.msgButton = false;
              }
              else {
                this.msgButton = true;
              }
            }
            if (element.click_yes == 0 && element.hide == false) {
              this.msgButton = false;
            }
            if (this.messageListChecked && element.hide == false) {
              let messageList = this.messageService.get('sub_msg_question1_8').value;
              if (messageList == '') {
                this.msgButton = false;
              }
            }
          });
        }
        else {
          this.msgButton = false;
        }
      }

      if (custType == 'reseller') {
        if (evt.target.checked) {
          this.ResellerMessage.forEach((element, index) => {
            if (element.question_type == 3 && this.messageDesChecked == true) {
              let listdata = this.messageService.get('sub_desc_question' + (index + 1) + '_' + (element.id)).value
              if (listdata.length < 50 || this.messageService.controls['sub_desc_question3_24'].invalid) {
                this.msgButton = false;
              }
              else {
                this.msgButton = true;
              }
            }
            if (element.click_yes == 0 && element.hide == false && element.question_type !== 2) {
              this.msgButton = false;
            }
            // if(this.messageListChecked && element.hide == false){
            //   let messageList = this.messageService.get('sub_msg_question1_22').value;
            //     if(messageList == '' || (messageList.length< 50 && this.subcheckboxQus == false)){
            //       this.msgButton = false;
            //     }
            // }
            if(this.messageListChecked && element.hide == false && this.subcheckboxQus== false){
              let messageList = this.messageService.get('sub_msg_question1_22').value;
                if(messageList == '' || this.messageService.controls['sub_msg_question1_22'].invalid || (messageList.length < 50)){
                  this.msgButton = false;
                } 
            }
          });
        }
        else {
          this.msgButton = false;
        }
      }
    }
  }
  
  changeStatus(evt: any, Qid: any, forword: any, indx: any, check: any) {
    this.VoiceService.forEach((element, index) => {
      if (element.id == Qid) {
        if(element.id == 6){
          this.subqus4 = false;
        }
        if (evt.target.checked == true) {
          if (element.question_type == 1) {
            if (check == 'Yes') {
              this.voiceListChecked = true;
            }
            else {
              this.voiceListChecked = false;
            }
            this.voiceService.get('sub_voice_question' + (index + 1) + '_' + (element.id)).setValue('')
            this.Description = "";
          }
          if (element.question_type == 5) {
              element['click_yes2'] = 0;
              let formControl2 = 'sub_desc_question' + (index + 1) + ('_' + element.id)
              this.voiceService.get(formControl2).setValue('');
              this.voiceService.get(formControl2).enable();
          }
          if (check == 'Yes') {
            element.click_yes = 1;
            this.voiceService.get('voice_question' + (index + 1) + '_' + (element.id)).setValue('1')
          }
          else {
            element.click_yes = 2;
            this.voiceService.get('voice_question' + (index + 1) + '_' + (element.id)).setValue('2')
          }
          //enable code start
          if (index !== this.VoiceService.length - 1) {
            let formControl = 'voice_question' + Number(indx + 2) + '_' + Number(Qid + 1);
            this.voiceService.get(formControl).enable();
            if (Qid == 5 && check == 'No') {
              let formControl = 'voice_question' + Number(indx + 3) + '_' + Number(Qid + 2);
              this.voiceService.get(formControl).enable();
            }
            else if (Qid == 5 && check == 'Yes') {
              let formControl = 'voice_question' + Number(indx + 3) + '_' + Number(Qid + 2);
              let value = this.voiceService.get(formControl).value;
              if(value == ''){
                this.voiceService.get(formControl).disable();
              }
            }
          }
          // end enable code end
        }
        else {
          element.click_yes = 0;
        }
      }
      else {
        if (check == 'Yes') {
          if (forword == "Continue") {
            this.nextButton = false;
            if (indx == 0) {
              let formControl = 'voice_question' + (index + 1) + ('_' + element.id)
              this.voiceService.get(formControl).setValue('');
              if(element.question_type=='5'){
                element.click_yes = 0;
                let formControl2 = 'sub_desc_question' + (index + 1) + ('_' + element.id)
                this.voiceService.get(formControl2).setValue('');
                this.voiceService.get(formControl2).disable();
              }
              // if (element.yes_to_continue == 'Continue') {
              //   element['hide'] = false;
              // }
              if(element.id !== 6) {
                element['hide'] = false;
              }
              if(element.id == 7) {
                element.click_yes = 0;
              }
            }
            else {
              if(element.id !== 6) {
                element['hide'] = false;
              }
              // if(element.yes_to_continue!== 'Continue'){
              //   element['hide'] = false;
              //   if(element.question_type == 4){
              //     element['hide'] = true;
              //   }
              // }
              // if (element.yes_to_continue !== 'Continue') {
              //   element['hide'] = false;
              //   let formControl = 'voice_question' + (index + 1) + ('_' + element.id)
              //   this.voiceService.get(formControl).setValue('');
              //   if(element.question_type=='5'){
              //     let formControl2 = 'sub_desc_question' + (index + 1) + ('_' + element.id)
              //     this.voiceService.get(formControl2).setValue('');
              //     this.voiceService.get(formControl2).disable();
              //   }
              //   if (element.id == 3) {
              //     let formControl = 'voice_question' + (index + 1) + '_' + (element.id);
              //     this.voiceService.get(formControl).enable();
              //   }
              //   else {
              //     let formControl = 'voice_question' + (index + 1) + '_' + (element.id);
              //     this.voiceService.get(formControl).disable();
              //   }
              //   if (element.question_type == 4) {
              //     element['hide'] = true;
              //   }
              // }
            }
          }
          else {
            if (Qid == 5 && element.question_type == 4) {
              element['hide'] = false;
            }
          }
        }
        else {
          if (forword == "Continue" && indx !== 1) {
            this.nextButton = true;
            if (element.question_type == 5) {
              element.click_yes = 0;
              let formControl2 = 'sub_desc_question' + (index + 1) + ('_' + element.id)
              this.voiceService.get(formControl2).setValue('');
              this.voiceService.get(formControl2).enable();
            }
          }
          if (forword == "Continue" && index !== 0 && indx !== 1) {
            element['hide'] = true;
            let formControl = 'voice_question' + (index + 1) + ('_' + element.id)
            this.voiceService.get(formControl).setValue('');
            element.click_yes = '0';
            this.voiceService.get(formControl).disable();
          }
          if (Qid == 5 && element.question_type == 4) {
            element['hide'] = true;
          }
        }
        if(Qid == 5 && element.id == 6){
          if(check == 'Yes'){
            this.subqus4 = true;
          }
          else{
            this.subqus4 = false;
          }
          
          element.click_yes = 0;
          let formControl = 'voice_question' + (index + 1) + ('_' + element.id)
          this.voiceService.get(formControl).setValue('');
        }
        // disable question
        if (element.hide == false && element.yes_to_continue !== 'Continue') {
          if (element.click_yes == 1 || element.click_yes == 2) {
            this.nextButton = true;
          }
          else {
            this.nextButton = false;            
          }
        }
        // disable List
        if (this.voiceListChecked) {
          let voiceList = this.voiceService.get('sub_voice_question1_1').value;
          if (voiceList == '' || this.voiceService.controls['sub_voice_question1_1'].invalid) {
            this.nextButton = false;
          }
          // if(this.voiceService.controls['sub_voice_question1_1'].invalid){
          //   this.nextButton = false;
          // }
        }
        if(this.subqus4){
          this.nextButton = false;          
        }
      }
    });
    if(forword!== "Continue"){
      this.VoiceService.forEach((element, index) => {
        if(element.hide == false && element.question_type == 5 && element.click_yes == 1){
          if(element.click_yes2 == 0){
            this.nextButton = false;            
          }
        }
      });
    }
  }
  
  changemsgStatus(evt: any, Qid: any, forword: any, check: any) {
    this.MessageSevice.forEach((element, index) => {
      if (element.id == Qid) {
        if (evt.target.checked == true) {
          if (element.question_type == 1) {
            if (check == 'Yes') {
              this.messageListChecked = true;
            }
            else {
              this.messageListChecked = false;
            }
            this.messageService.get('sub_msg_question' + (index + 1) + '_' + (element.id)).setValue('')
            this.Description1="";
          }
          if (element.question_type == 3) {
            if (check == 'Yes') {
              this.messageDesChecked = true;
              let flname: any = this.messageService.get('sub_desc_question' + (index + 1) + '_' + (element.id));
              flname.setValidators([this.noWhitespaceValidator]);
              flname.updateValueAndValidity();
            }
            else {
              this.messageDesChecked = false;
              let flname: any = this.messageService.get('sub_desc_question' + (index + 1) + '_' + (element.id));
              flname.setValidators([]);
              flname.updateValueAndValidity();
            }
            this.messageService.get('sub_desc_question' + (index + 1) + '_' + (element.id)).setValue('')
            this.messageDesc ='';
          }
          if(index == 0 && this.messageDesChecked == true){
            this.messageDesChecked = false;
            let flname: any = this.messageService.get('sub_desc_question3_10');
            flname.setValidators([]);
            flname.updateValueAndValidity();
          }
          if (check == 'Yes') {
            element.click_yes = 1;
            this.messageService.get('msg_question' + (index + 1) + '_' + (element.id)).setValue('1')
          }
          else {
            element.click_yes = 2;
            this.messageService.get('msg_question' + (index + 1) + '_' + (element.id)).setValue('2')
          }
          //enable code start
          if (index !== this.MessageSevice.length - 1) {
            let formControl = 'msg_question' + Number(index + 2) + '_' + Number(Qid + 1);
            this.messageService.get(formControl).enable();
          }
          // end enable code end
        }
        else {
          element.click_yes = 0;
        }
      }
      else {
        if(forword == "Continue" && element.question_type== '3'){
          this.messageDesChecked= false;
          element.click_yes = 0;
          this.messageService.get('sub_desc_question' + (index + 1) + '_' + (element.id)).setValue('');
          this.messageDesc ='';
        }
        if (check == 'Yes') {
          if (forword == "Continue") {
            // element.click_yes = '0';
            element['hide'] = false;
            this.msgButton = false;
            let formControl = 'msg_question' + (index + 1) + ('_' + element.id);
            this.messageService.get(formControl).setValue('');
            if(element.id!==Number(Qid+1)){
              this.messageService.get(formControl).disable();
            }
            if(element.id == 11){
              element.click_yes = 0;
            }
          }
        }
        else {
          this.msgButton = true;
          
          if (forword == "Continue" && index !== 0) {
            element['hide'] = true;
            // element.click_yes = '0';
            let formControl = 'msg_question' + (index + 1) + ('_' + element.id);
            this.messageService.get(formControl).setValue('');
          }
        }
        // disable question
        if (element.hide == false) {
          if (element.click_yes == 1 || element.click_yes == 2) {
            this.msgButton = true;            
          }
          else {
            this.msgButton = false;
          }
        }
        // disable desc
        if (this.messageDesc.length < 50 && this.messageDesChecked || this.messageService.controls['sub_desc_question3_10'].invalid) {
          this.msgButton = false;          
        }
        // disable List
        if (this.messageListChecked && element.hide == false) {
          let messageList = this.messageService.get('sub_msg_question1_8').value;
          if (messageList == '' || (messageList.length < 50 && this.subcheckboxQus == false) || this.messageService.controls['sub_msg_question1_8'].invalid) {
            this.msgButton = false;            
          }
        }
      }
    });
  }

  finalSubmit() {
    if (this.SignatureForm.invalid) {
      this.submitted2 = true;
      return
    }
    else {
      if(this.custType=='Sole_Proprietor'){
        this.YourInformation.get('Federal_tax_id').enable();
      }
      this.mainForm.push(this.YourInformation.value)
      this.mainForm.push(this.yourContact.value)
      this.mainForm.push(this.voiceService.value)
      this.mainForm.push(this.messageService.value)
      this.mainForm.push(this.SignatureForm.value)
      this.data.onkycSubmit(this.mainForm).subscribe(res => {
        if (res.status == 200) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
            this.router.navigate(['/account-message'])
            .then(() => {
              location.reload();
            })
          }, 5000);
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
            this.mainForm = [];
          }, 5000);
        }
      });
    }

  }

  customerErr() {
    if (this.pannelType == '') {
      this.errMessage = "Please Select any customer Type!"
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    }
  }

  Selectcustomer(data: any, Update: any) {
    if(this.custmType== '' && Update!=="add"){
      this.msgButton = false;
      this.nextButton = false;
    }
   else if ((this.custmType == 'end_user' || this.custmType == 'reseller') && Update!=="add") {
      this.changePanel = true;
      this.msgButton = false;
      this.nextButton = false;
    }
    else{
      this.changePanel = false;
    }
    this.pannelType = '';
    if (data == 'endUser' || data == 'end_user') {
      this.pannelType = 'endUser';
    }
    if (data == 'reseller') {
      this.pannelType = 'reseller';
    }
    this.divideData();
    // this.setformControl();
  }
  
  resellerVoice(evt: any, Qid: any, forword: any, indx:any, check: any) {  
    this.ResellerVoice.forEach((element, index) => {
      if (element.id == Qid) {
        this.nextButton = true;
        if(element.question_type==4 || element.question_type==5){
          element['click_yes2'] = 0;
          if(element.question_type == 5){
            element['click_yes3'] = 0;
            if(check == 'No'){
              this.voiceExp = false;
              this.subcheck= false;
              this.voiceService.get('sub_check_question2_13').setValue('0');
              this.voiceService.get('sub_desc5_question2_13').setValue('');
            }
            else{
              this.subcheck= true;
            }
          }
          if(check == 'No'){
            let formControl3 = 'sub_check_question' + (index + 1) + ('_' + element.id)
            this.voiceService.get(formControl3).setValue('0');
          }
        }
        if (evt.target.checked == true) {
          if(element.question_type==1){
            this.voiceService.get('sub_list_question' + (index + 1) + '_' + (element.id)).setValue('');
            this.Description = "";
          }
          if (check == 'Yes') {
            element.click_yes = 1;
            this.voiceService.get('voice_question' + (index + 1) + '_' + (element.id)).setValue('1') 
          }
          else {
            element.click_yes = 2;
            this.voiceService.get('voice_question' + (index + 1) + '_' + (element.id)).setValue('2')
          }
          //enable code start
          if(index !== this.ResellerVoice.length-1){
            let formControl = 'voice_question'+ Number(indx+2)+'_'+ Number(Qid+1);
            this.voiceService.get(formControl).enable();
            if(Qid==18){
              let formControl = 'voice_question'+ Number(indx+3)+'_'+ Number(Qid+2);
              this.voiceService.get(formControl).enable();
            }
          }
          // end enable code end
        }
        else {
          element.click_yes = 0;
        }
      }
      else {
         // this if condition validation for customerType 5
         if(indx!== 0){
          if(element.hide == false && element.yes_to_continue== 'Continue'){
            if(element.click_yes==0){
              this.nextButton = false;
            }
          }
          if(this.subcheck == true){
            this.nextButton = false;
          }
        }
        if (check == 'Yes') {
          if (forword == "Continue") {
            if(indx == 0){
              element.click_yes = 0;
              element['hide'] = false;
              this.nextButton = false;
              let formControl = 'voice_question' + (index + 1) + ('_' + element.id)
              this.voiceService.get(formControl).setValue('');
              if(element.id!==Number(Qid+1)){
                let formControl2 = 'voice_question' + (index + 1) + ('_' + element.id)
                this.voiceService.get(formControl2).disable();
              }
              this.subList = true;
              if(element.yes_to_continue == 'Continue' || element.question_type == 5){
                element['hide'] = false;
                element.click_yes = 0;
                element.click_yes2 = 0;
                element.click_yes3 = 0;
              }
              if(element.question_type == 4){
                element.click_yes = 0;
                element.click_yes2 = 0;
              }
            }
            else{
              if(element.yes_to_continue!== 'Continue'){
                element['hide'] = false;
                // if(element.question_type!== 5){
                //   let formControl = 'voice_question' + (index + 1) + ('_' + element.id)
                //   this.voiceService.get(formControl).setValue('');
                //   if(element.id!==Number(Qid+1)){
                //     let formControl2 = 'voice_question' + (index + 1) + ('_' + element.id)
                //     this.voiceService.get(formControl2).disable();
                //   }
                // }
              }
            }
          }
        }
        else {
          if(forword == "Continue"){
            this.nextButton = true;
          }
          if (forword == "Continue" && index!== 0) {
            if(indx!== 0){
              if(element.question_type == 5){
                element['hide'] = false;
              }
              else{
                element['hide'] = false;
                // let formControl = 'voice_question' + (index + 1) + ('_' + element.id)
                // this.voiceService.get(formControl).setValue('');
                // element.click_yes = '0';
                // this.voiceService.get(formControl).disable();
              }
              if(element.question_type == 4){
                let formControl3 = 'sub_check_question' + (index + 1) + ('_' + element.id)
                this.voiceService.get(formControl3).setValue('0');
              }
            }
          }
          if(indx == 0){
            element['hide'] = true;
            this.subList = false;
            let formControl = 'voice_question' + (index + 1) + ('_' + element.id)
            this.voiceService.get(formControl).setValue('');
            element.click_yes = '0';
            element.click_yes3 = '0';
            this.voiceService.get(formControl).disable();
            if(element.question_type==5){
              this.subcheck = false;
              let formControl2 = 'sub_desc5_question' + (index + 1) + ('_' + element.id)
              this.voiceService.get(formControl2).setValue('');
              this.voiceDesc ='';
            }
            if(element.question_type == 4 || element.question_type == 5){
              let formControl3 = 'sub_check_question' + (index + 1) + ('_' + element.id)
              this.voiceService.get(formControl3).setValue('0');
            }
          }
        }
        
        // disable question
        if(element.hide == false && element.yes_to_continue!== 'Continue' && element.question_type!==2){
          if(element.click_yes == 1 || element.click_yes == 2){
            if(element.click_yes == 2){
              this.nextButton = true;
            }
            else{
              let existtt= element.hasOwnProperty('click_yes2');
              if(existtt){
                if(element.click_yes2 == 0){
                  this.nextButton = false;
                }
              }
            }
          }
          else{
            this.nextButton = false;
          }
        }
        if(this.subList == true){
          let otherV = this.voiceService.get('sub_list_question1_12').value;
          if(this.Description =='Other' && (otherV == '' || this.voiceService.controls['sub_list_question1_12'].invalid || (otherV.length < 50))){
            this.nextButton = false;
          }
        }
        if(this.subcheck == true){
          this.nextButton = false;
        }
       
        if(this.voiceService.controls['sub_desc5_question2_13'].invalid && this.voiceExp && indx!==0){
          this.nextButton = false;
        }
      }
    });
    if(forword!== "Continue"){
      this.ResellerVoice.forEach((element, index) => {
        if(element.hide == false && element.question_type == 4 && element.click_yes == 1){
          if(element.click_yes2 == 0){
            this.nextButton = false;
          }
        }
      });
    }
  }

  customerSubradio(evt, Qid, QusType, check){
    this.nextButton = true;
    this.VoiceService.forEach((element, index) => {
      if (element.id == Qid) {
        if (evt.target.checked == true) {
            if (check == 'Yes') {
              element.click_yes2 = 1;
              this.voiceService.get('sub_desc_question' + (index + 1) + '_' + (element.id)).setValue('1') 
            }
            else {
              element.click_yes2 = 2;
              this.voiceService.get('sub_desc_question' + (index + 1) + '_' + (element.id)).setValue('2')
            }
        }
      }
      else{
        if(element.hide == false && element.yes_to_continue== 'Continue'){
          if(element.click_yes == 0){
            this.nextButton = false;
          }
          if(element.question_type == 1){
            let listdata = this.voiceService.get('sub_voice_question' + (index + 1) + '_' + (element.id)).value
            if(listdata==''  || this.voiceService.controls['sub_voice_question' + (index + 1) + '_' + (element.id)].invalid){
             this.nextButton = false;
            }
          }
        }
        if(element.hide == false && element.yes_to_continue!== 'Continue'){
          if(element.click_yes == 1){
            let existtt= element.hasOwnProperty('click_yes2');
              if(existtt){
                if(element.click_yes2 == 0){
                  this.nextButton = false;
                }
              }
          }
          else{
            if(element.click_yes == 0){
              this.nextButton = false;
            }
          }
        }
      }
    })
  }

  resellerSubradio(evt, Qid, QusType, check){
    this.nextButton = true;
    this.ResellerVoice.forEach((element, index) => {
      if (element.id == Qid) {
        if (evt.target.checked == true) {
            if (check == 'Yes') {
              element.click_yes2 = 1;
              this.voiceService.get('sub_check_question' + (index + 1) + '_' + (element.id)).setValue('1') 
            }
            else {
              element.click_yes2 = 2;
              this.voiceService.get('sub_check_question' + (index + 1) + '_' + (element.id)).setValue('2')
            }
          if(QusType == 5){
            this.subcheck = false;
            if (check == 'Yes') {
              element['click_yes3'] = 3;
              this.voiceExp = true;
              this.voiceDesc='';
              this.voiceService.get('sub_desc5_question' + (index + 1) + '_' + (element.id)).setValue('');
              let flname: any = this.voiceService.get('sub_desc5_question2_13');
              flname.setValidators([this.noWhitespaceValidator]);
              flname.updateValueAndValidity();
            }
            else{
              element['click_yes3'] = 0;
              this.voiceExp = false;
              this.voiceDesc='';
              this.voiceService.get('sub_desc5_question' + (index + 1) + '_' + (element.id)).setValue('');
            }
           
          }
        }
      }
      else{
        if(element.hide == false && element.yes_to_continue== 'Continue'){
          if(element.click_yes == 0){
            this.nextButton = false;
          }
          if(element.question_type == 1){
            let listdata = this.voiceService.get('sub_list_question' + (index + 1) + '_' + (element.id)).value
            if(this.Description =='Other' && (listdata=='' || this.voiceService.controls['sub_list_question1_12'].invalid || listdata.length < 50)){
             this.nextButton = false;
            }
          }
        }
        if(element.hide == false && element.yes_to_continue!== 'Continue' && element.question_type!==2){
          if(element.click_yes == 1){
            let existtt= element.hasOwnProperty('click_yes2');
              if(existtt){
                if(element.click_yes2 == 0){
                  this.nextButton = false;
                }
              }
          }
          else{
            if(element.click_yes == 0){
              this.nextButton = false;
            }
          }
        }

        if(this.voiceDesc.length <= 1 && index!==0 && this.voiceExp){
          this.nextButton = false;
        }
      }
    })
  }

  changeResellerList(evt: any, Qus: any, service: any) {
    if (service == 'voice') {
      if (evt.target.checked == true) {
        this.Description = Qus;
        let eId = evt.target.id;
        if (Qus == 'Other') {
          this.voiceService.get('sub_list_question1_12').setValue('');
          let flname: any = this.voiceService.get('sub_list_question1_12');
          flname.setValidators([this.noWhitespaceValidator]);
          flname.updateValueAndValidity();
        }
        else {
          this.voiceService.get('sub_list_question1_12').setValue(this.Description);
        }
        for (let i = 1; i <= 4; i++) {
          let Id = 'sub_list_question' + i + '_12'
          if (Id == eId) {
            $('#' + Id).prop("checked", true)
          }
          else {
            $('#' + Id).prop("checked", false)
          }
        }
      }
      else {
        this.Description = '';
      }
      let otherV = this.voiceService.get('sub_list_question1_12').value;
      if(otherV == '' || this.voiceService.controls['sub_list_question1_12'].invalid){
        this.nextButton = false;
      }
      else{
        this.nextButton = true;
      }
      this.ResellerVoice.forEach((element, index) => {
        if(element.hide == false && element.yes_to_continue!== 'Continue' && element.question_type!==2){
          if(element.click_yes == 1){
            let existtt= element.hasOwnProperty('click_yes2');
              if(existtt){
                if(element.click_yes2 == 0){
                  this.nextButton = false;
                }
              }
          }
          else{
            if(element.click_yes == 0){
              this.nextButton = false;
            }
          }
        }

        if(this.voiceService.controls['sub_desc5_question2_13'].invalid  && index!==0 && this.voiceExp){
          this.nextButton = false;
        }
      });
    }
  }

  resellerMessage(evt: any, Qid: any, forword: any, check: any) {
    this.ResellerMessage.forEach((element, index) => {
      if (element.id == Qid) {
        if (evt.target.checked == true) {
          if (element.question_type == 1) {
            if(check == 'Yes'){
              this.messageListChecked = true;
            }
            else{
              this.messageListChecked = false;
            }
            this.messageService.get('sub_msg_question' + (index + 1) + '_' + (element.id)).setValue('') 
            this.Description1="";
          }
          if (element.question_type == 3) {
            if(check == 'Yes'){
              this.messageDesChecked = true;
              let flname: any = this.messageService.get('sub_desc_question3_24');
              flname.setValidators([this.noWhitespaceValidator]);
              flname.updateValueAndValidity();
            }
            else{
              this.messageDesChecked = false;
              let flname: any = this.messageService.get('sub_desc_question3_24');
              flname.setValidators([]);
              flname.updateValueAndValidity();
            }
            this.messageService.get('sub_desc_question' + (index + 1) + '_' + (element.id)).setValue('')
            this.messageDesc = "";
          }

          if (check == 'Yes') {
            element.click_yes = 1;
            this.messageService.get('msg_question' + (index + 1) + '_' + (element.id)).setValue('1')
          }
          else {
            element.click_yes = 2;
            this.messageService.get('msg_question' + (index + 1) + '_' + (element.id)).setValue('2')
          }
            //enable code start
            if(index !== this.ResellerMessage.length-1){
              let formControl = 'msg_question'+ Number(index+2)+'_'+ Number(Qid+1);
              this.messageService.get(formControl).enable();
              if(Qid == 25){
                let formControl = 'msg_question'+ Number(index+3)+'_'+ Number(Qid+2);
              this.messageService.get(formControl).enable();
              }
            }
            // end enable code end
        }
        else {
          element.click_yes = 0;
        }
      }
      else {
        if(forword == "Continue" && element.question_type=='3'){
          element.click_yes = 0;
          let formControl = 'sub_desc_question' + (index + 1) + ('_' + element.id);
          this.messageService.get(formControl).setValue('');
          this.messageDesChecked= false;
          this.messageDesc = "";
        }
        if (check == 'Yes') {
          if (forword == "Continue") {
            element.click_yes = '0';
            element['hide'] = false;
            this.msgButton = false;
            let formControl = 'msg_question' + (index + 1) + ('_' + element.id);
              this.messageService.get(formControl).setValue('');
            if (element.id!== Number(Qid+1)) {
              this.messageService.get(formControl).disable();
            }
          }
          else{
            if(element.question_type!==2){
              this.msgButton = true;
            }
          }
        }
        else {
          if(element.question_type!==2){
            this.msgButton = true;
          }
          if (forword == "Continue" && index !== 0) {
            element['hide'] = true;
            element.click_yes = '0';
            let formControl = 'msg_question' + (index + 1) + ('_' + element.id);
            this.messageService.get(formControl).setValue('');
            this.messageService.get(formControl).disable();
          }
        }
        // disable question
        if(element.click_yes == 0 && element.hide == false && element.question_type!==2){
          this.msgButton = false;
        }
       // disable desc
        if((this.messageDesc.length < 50 || this.messageService.controls['sub_desc_question3_24'].invalid) && this.messageDesChecked){
          this.msgButton = false;
        }
        // disable List
        // if(this.messageListChecked && element.hide == false){
        //   let messageList = this.messageService.get('sub_msg_question1_22').value;
        //     if(messageList == '' || (messageList.length < 50 && this.subcheckboxQus== false)){
        //       this.msgButton = false;
        //     }
        // }
        if(this.messageListChecked && element.hide == false && this.subcheckboxQus== false){
          let messageList = this.messageService.get('sub_msg_question1_22').value;
            if(messageList == '' || this.messageService.controls['sub_msg_question1_22'].invalid || (messageList.length < 50)){
              this.msgButton = false;
            } 
        }
      }
    });
  }

  current_datetime() {
    let now = new Date();
    this.current_date = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + '-' + month + "-" + day;

  }
  // onInputChange(event)
  // {   
  //   var k;  
  //   k = event.charCode;  
  //   return((k > 64 && k < 91) || (k > 96 && k < 123) || k == 8 || k == 32 || (k >= 48 && k <= 57)); 
  // }

  contactError() {
    if (this.yourContact.invalid) {
      this.errMessage = "All contact details are required!"
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    }
  }
  taxeinID(evt: any) {
		if(this.custType=='International_business'){
			// var regex = new RegExp("^[0-9a-zA-Z \b]+$");
			// var key = String.fromCharCode(!evt.charCode ? evt.which : evt.charCode);
			// if (!regex.test(key)) {
			// 	evt.preventDefault();
			// 	return false;
			// }
			return true;
		}
		else{
			var charCode = (evt.which) ? evt.which : evt.keyCode;
			if (charCode != 45 && charCode > 31 && (charCode < 48 || charCode > 57))
				return false;
			return true;
		}
	}
  ngOnDestroy(){
    this.signatureClose.nativeElement.click();
    this.sweetalert.nativeElement.click();
  }
}
