import { Component, OnInit } from '@angular/core';
import { NewCamapignService } from '../new-camapign.service';
import { ActivatedRoute } from '@angular/router';
import { FormBuilder, FormGroup } from '@angular/forms';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
declare var $: any;
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';

@Component({
  selector: 'app-redundant-campaign',
  templateUrl: './redundant-campaign.component.html',
  styleUrls: ['./redundant-campaign.component.css']
})
export class RedundantCampaignComponent implements OnInit {
  idaccount: any;
  iduser: any;
  campaigns: any=[];
  errMessage: any;
  redundant_campaign: any=[];
  userType: any;
  headingRedundant: any;
  responseMessage :any;
  public filterCampaign: FormGroup;
  campaignsfilter: any=[];
  show: boolean = false;
  campaign_key: string;
  sm_reference_no: string;
  parent_campaign_id: string;
  brandId: string;
  userlist: any=[];
  useCase: any=[];
  without_save: any=[];
  campaignsfilterCSV: any;
  EXCEL_TYPE = 'application/csv';
  EXCEL_EXTENSION = '.csv';
  constructor(public data: NewCamapignService, public userService: UsermanagementService,
		private route: ActivatedRoute,public fb: FormBuilder) {
	
	}

  ngOnInit(): void {
    let session$ = sessionStorage.getItem("isLoggedIn");
		let session = JSON.parse(session$);
		this.userType = session.type;
		this.iduser = session.iduser;   
		this.idaccount = session.idaccount;
    this.data.getcampaign().subscribe((result) => {
			$.getScript('./assets/table.js');
			this.headingRedundant = result[0].headersRedundant2
		});
    this.userService.getUsers("main").subscribe(res => {
			this.userlist = res.data[0];
			this.userlist.sort((a, b) => {
				return a.san - b.san;
			  });	
		});
    this.data.getuseCases().subscribe(res => {
			this.useCase = res.data;
		});
    this.redCampList();

    this.filterCampaign = this.fb.group({
			brandId: [],
			brand_name: [],
			usecase: [],
			campaign_key: [],
			sm_reference_no: [],
			parent_campaign_id: [],
			tcrStatus: [],
			provisioning_status: [],
			idaccount: []
		});
  

  }
  setStatus(list) {
		list.forEach(element => {
			if (element.provisioning_status == 0) {
				element.provisioning_status = 'Campaign Submission Pending'
			}
			if (element.provisioning_status == 1) {
				element.provisioning_status = 'Campaign Shared'
			}
			if (element.provisioning_status == 2) {
				element.provisioning_status = 'Provisioning Pending'
			}
			if (element.provisioning_status == 3) {
				element.provisioning_status = 'Campaign Provisioned'
			}
			if (element.provisioning_status == 4) {
				element.provisioning_status = 'Provisioning Failed'
			}
			if (element.provisioning_status == 5) {
				element.provisioning_status = 'Customer Action Required'
			}
			if (element.provisioning_status == 6) {
				element.provisioning_status = 'Save'
			}
			if (element.provisioning_status == 7) {
				element.provisioning_status = 'Pending for Profile Approval'
			} 
		})
	}

  redCampList(){
    let payLoad = JSON.stringify({
			idaccount: this.idaccount,
			iduser: this.iduser
		});
    this.data.GetCampaignsList(payLoad).subscribe(result => {
			if (result.status == 200) {
				this.campaigns = [];
        this.without_save =[];	
        this.redundant_campaign = [];	
				if (result.data.length > 0) {
					this.campaigns = result.data;
						this.campaigns.forEach(element => {					
							if(element.status==2){
								if (element) {
									if (element.parent_campaign_id) {
									  let matchingCampaign = this.campaigns.find(
										campaign => campaign.campaign_key === element.parent_campaign_id && campaign.status === 0
									  );
									  if (matchingCampaign) {
										element.parent_dca = matchingCampaign.upstreamCnpId; 
									  }
									}
								}
                this.redundant_campaign.push(element)
                this.setStatus(this.redundant_campaign);
							}
						})
            this.redundant_campaign.forEach((campaign)=>{
              if(campaign.provisioning_status !== 'Save'){
                this.without_save.push(campaign);
              }
            })	
					
					}
          $('#basic-datatableredtab').DataTable().clear();
          $('#basic-datatableredtab').DataTable().destroy();
					$.getScript('./assets/table.js');
				}
			
			else {
				this.errMessage = result.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
  }

  campaignID(event: Event) {
		this.campaign_key = (event.target as HTMLInputElement).value.toUpperCase();
	}

	smCampaignID(event: Event) {
		this.sm_reference_no = (event.target as HTMLInputElement).value.toUpperCase();
	}

	parentCampaignID(event: Event) {
		this.parent_campaign_id = (event.target as HTMLInputElement).value.toUpperCase();
	}

	brandID(event: Event) {
		this.brandId = (event.target as HTMLInputElement).value.toUpperCase();
	}

  showfilter() {
		if (this.show == false) {
			this.show = true;
		}
		else {
			this.show = false;
		}
	}

  resetFilter() {
		this.filterCampaign.reset();
		this.redCampList();
	}

  applyCamFilter() {
		this.data.applyRedCampaignFilter(this.filterCampaign.value).subscribe(res => {
			if (res.status == 200) {
				this.campaignsfilter = res.data;
				this.campaignsfilter.forEach(item => {
					if (item.parent_campaign_id === "null" || item.parent_campaign_id === null) {
						item.parent_campaign_id = "";
					}
				});
				 				
          $('#basic-datatableredtab').DataTable().clear();
          $('#basic-datatableredtab').DataTable().destroy();
						this.without_save = this.campaignsfilter.filter((camp)=>camp.status == 2);
						this.setStatus(this.without_save);
						this.campaignsfilterCSV =this.without_save;		
				$.getScript('./assets/table.js');
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		})
	}

	downloadCSVFile() {
		this.applyCamFilter();
		setTimeout(() => {
			let dataToDownload = [];   
			dataToDownload = this.campaignsfilterCSV.map(item => {
				const { idaccount, ...rest } = item;
				return { ...rest, 'SAN': 100000000 + idaccount , 'TCR Status': item.deleted === 0 ? 'Active' : 'Deactivate'};
			});
			if (dataToDownload.length > 0) {  
				let NewFilteredRes = dataToDownload.map(item => {
					const { iduser, idaccount, deleted, status , ...rest } = item; 
					Object.keys(rest).forEach(key => {
						if (key === 'brandId') {
							rest['Brand ID'] = rest[key];
							delete rest[key];
						} else if (key === 'usecase') {
							rest['Use Case'] = rest[key];
							delete rest[key];
						} else if (key === 'sm_reference_no') {
							rest['SM Reference No.'] = rest[key];
							delete rest[key];
						} 
						else if (key.includes('_')) {
							const newKey = key.replace(/_/g, ' ').replace(/\b\w/g, c => c.toUpperCase()); 
							rest[newKey] = rest[key]; 
							delete rest[key]; 
						}
					});
					if (rest['Start Date']) {
						rest['Start Date'] = new Date(rest['Start Date']).toLocaleDateString('en-US');
					}
					return rest;
				});
				const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(NewFilteredRes);
				const workbook: XLSX.WorkBook = { Sheets: { 'RedundantCampaign': worksheet }, SheetNames: ['RedundantCampaign'] };
				const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
				this.saveAsExcelFile(excelBuffer, "RedundantCampaign");
				// this.ngOnInit();
			}
			else {
				this.errMessage = "No Record Available!";
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, 5000);
	}
	private saveAsExcelFile(buffer: any, fileName: string): void {
		const data: Blob = new Blob([buffer], {
			type: this.EXCEL_TYPE
		});
		saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
	}
}
