import { Component, OnInit } from '@angular/core';
import { OutboundService } from '../outbound.service';
import { Router } from '@angular/router';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { log } from 'console';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
declare var $: any;

@Component({
  selector: 'app-test-call-by-media',
  templateUrl: './test-call-by-media.component.html',
  styleUrls: ['./test-call-by-media.component.css']
})
export class TestCallByMediaComponent extends AppComponentClass<any, any> {
  fieldform: any;
  testMediaForm: any;
  public testCallForm: FormGroup;
  public submitted: boolean = false;
  responseMessage = "";
  errMessage: any = "";
  mediaFiles: any;
  featureServiceData: any;
  isDisabledServiceStatus: boolean;
	serviceMessage:any='Call By Media service has been suspended. More information please contact support';
  dropdownSettings: IDropdownSettings = {};
  selectedItem: any = [];

  constructor(public data: OutboundService, public router: Router, public fb: FormBuilder,private userService: UsermanagementService) {
    super(data, router, fb);
    this.testMediaForm = this.fb.group({
      FROM: ['', [Validators.required,Validators.minLength(10)]],
      TO: ['', [Validators.required,Validators.minLength(10)]],
      mediaID: ['', [Validators.required]]

    });
  }

  ngOnInit(): void {
    this.userService.getfeatureServiceStatus().subscribe(res => {
      this.featureServiceData = res.data.find(x => x.fs_id == '3');
      if(this.featureServiceData!==undefined && this.featureServiceData.as_status=='1')
      {
       this.isDisabledServiceStatus=false;
      }else{
       this.isDisabledServiceStatus=true;
       this.showMsg();
      }
      });
    this.data.getmedia().subscribe((result) => {
      this.fieldform = result;
    })

    this.data.getMediaFiles().subscribe(res => {
      if (res.status == 200) {
        $('#basic-datatables').DataTable().clear();
        $('#basic-datatables').DataTable().destroy();
        // this.mediaFiles = res.data
        // console.log("fdsfsdfsdfsdfsfsdfsd",   this.mediaFiles);
        this.mediaFiles = res.data.map(item => ({
          ...item,
          nameMediaID: `${item.name}-${item.mediaID}`
      })
    )
        $.getScript('./assets/table.js');
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'name',
      textField: 'nameMediaID',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

  }

  // filterByUser(e) {
  //   console.log("dataaaaaa",e);
    
  //   this.testMediaForm.patchValue({
  //     mediaID: e.target.value
  //   });
  // }

  allowNumbersOnly(e) {
    var code = (e.which) ? e.which : e.keyCode;
    if (code > 31 && (code < 48 || code > 57)) {
        e.preventDefault();
    }
}

  onTestCall() {    
    this.submitted = true;
    if (this.testMediaForm.invalid) {
      return false;
    } else {
      this.data.testCallviaMedia(this.testMediaForm.value).subscribe(response => {
        if (response.status == 200) {
          this.responseMessage = response.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.responseMessage = err.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      });
    }
  }
  resetCall(){
    this.submitted = false;
  }
  onReset() {
    this.submitted = false;
    this.testMediaForm.reset();
    this.selectedItem = []
  }
  showMsg()
	{
		this.errMessage = this.serviceMessage;
		setTimeout(() => {
			this.errMessage = "";
		}, 5000);
	}

  truncatenotification(subject: string, maxLength: number): string {
		if (subject && subject.length > maxLength) {
			return subject.substring(0, maxLength) + '...';
		} else {
			return subject;
		}
	}
}
