import { Component, OnInit, Input, OnDestroy, ViewChild } from '@angular/core';
import { Router } from '@angular/router';
declare var $: any;
import { FormGroup } from '@angular/forms';
import { Observable, Subscription } from 'rxjs';
import { ProfileService } from '../../profile/profile.service';
import { AuthenticationService } from 'src/app/authentication/authentication.service';
import { Theme } from '../service/AutoTheme';
import { BillingService } from 'src/app/billing/billing.service';
import { InboundService } from 'src/app/inbound/inbound.service';
import { Store } from '@ngrx/store';
import * as fromInbound from '../../inbound/inbound.reducer';
import * as inboundAction from '../../inbound/inbound.action';
import { Cart } from 'src/app/inbound/inbound.class';
import { BalanceComponent } from 'src/app/usermanagement/profile/balance/balance.component';
import { MatDialog } from '@angular/material/dialog';
import { ImportantNoticeComponent } from '../important-notice/important-notice.component';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { NotificationService } from 'src/app/notification/notification.service';
import { SystemNotificationComponent } from 'src/app/notification/system-notification/system-notification.component';
// import * as io from 'socket.io-client';
// import { environment } from 'src/environments/environment';
import { ToastrService } from 'ngx-toastr';


@Component({
  selector: 'app-header-navigation',
  templateUrl: './header-navigation.component.html',
  styleUrls: ['./header-navigation.component.css']
})

export class HeaderNavigationComponent implements OnInit, OnDestroy {
  @ViewChild(SystemNotificationComponent) SystemNotification;
  /*  currDiv: string = 'A';
   layout: string = 'vertical'; */
  @Input() leftsetting: boolean;
  themeForm: FormGroup;
  submitted = false;
  /* sipstatus: Observable<string>; */
  private socket: any;
  sessionType: any;
  isAdmin: boolean = false;
  isCustomer: boolean = false;
  isSubCustomer: boolean = false;
  responseMessage: any = "";
  errMessage: any = "";
  balanceData: any;
  billingAddress: any;
  /*  active = 'call'; */
  /* currentJustify = 'justified';
  currentOrientation = 'horizontal'; */
  public calltype: any;
  tabStatus = 'justified';
  public isCollapsed = false;
  public userlist: any
  public username: string;
  public email: any;
  profile_pic: any;
  public innerWidth: any;
  public defaultSidebar: any;
  public showSettings = false;
  public showMobileMenu = false;
  /*  public expandLogo = false; */
  /* public showSettings1;
  public showSettings2; */
  balance: any;
  isSignUpLogin: Boolean = false;
  disabled: boolean = false;
  isMyRates: Boolean = false;

  @Input() atttheme = "black";
  @Input() header = "#1269DB";

  counter$: Observable<Cart[]>;
  /*  min_balance: any;
   current_balance: any; */
  errrrMessage: string;
  isalert: boolean = false;
  alrt: any;
  kycHeader: any;
  kycRes: any;
  newUserStatus: any;
  san: any;
  private subscriptionName: Subscription
  emailListData: any = [];
  notificationList: any = [];
  notificationCount: any;
  mergedNotificationList: any = [];
  totalNotificationCount: any;
  navigate: any = [];
  Emailcount: number;
  Customernotify: any;
  titleToDisplay: any;
  isActive: boolean = false;
  messageText1: string = 'Success';

  sessiondata:any;
  HideUserNonUs:boolean=true

  designation:any;
  kyc_verify_statu: number;

  //   ShowDiv(divVal: string) {
  //       this.currDiv = divVal;
  //     }


  constructor(protected inboundService: InboundService,
    protected billingService: BillingService,
    protected authService: AuthenticationService,
    protected data: ProfileService,
    public router: Router, public them: Theme,
    public dialog: MatDialog,
    private store: Store<fromInbound.inboundState>,
    private theme: Theme,
    protected userSerive: UsermanagementService,
    public notifydata: NotificationService,
    private toastr: ToastrService
  ) {   

    // this.socket = io(environment.SOCKETIOURL);       
    this.inboundService.getCart().subscribe(res => {
      let cartItems: any = [];
      res.data.forEach(element => {
        cartItems.push({ did: element.did })
      });
      this.store.dispatch(new inboundAction.Set(cartItems));
    });

    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.sessionType = session.type;
    this.newUserStatus = session.newUser_status;
    if (session.newUser_status == 0) {
      if (session.isEmailVerify == "true" && session.isMobileVerify == "true" && session.isAddress == "true" && session.isPlan == "true") {
        this.disabled = true;
      }
      else {
        this.disabled = false;
      }
    }
    if (session.newUser_status == 1) {
      if (session.isEmailVerify == "true" && session.isMobileVerify == "true" && session.isAddress == "true" && session.isPlan == "true" && session.isCard == "true") {
        this.disabled = true;
      }
      else {
        this.disabled = false;
      }
    }


    if (session.isPlan == "true") {
      this.isMyRates = true;
    }
    else {
      this.isMyRates = false;
    }

    if (session$) {
      this.isSignUpLogin = true;
    }
    this.subscriptionName = this.userSerive.getUpdate().subscribe
      (message => {
        if (message.text) {
          this.ngOnInit();
        }
      });
  }


  ngOnInit() {
    // this.socket.on('notificationCount', auth => {
    //   let authKey = auth.data.auth;
    //   this.titleToDisplay = auth.data.title;
    //   if(authKey.includes(sessionStorage.getItem('authkey'))){
    //     this.NotificationCountForCustomer();
    //     this.EmailNotificationCount();
    //     if (this.sessionType == 2) {
    //       this.showToast();
    //     }
    //   } 
    // });
    
    let sdata = sessionStorage.getItem("isLoggedIn");    
    this.sessiondata = JSON.parse(sdata);
    
    this.designation = this.sessionType == "2" ? "Account Super Admin" : this.sessionType == "201" ? "Account Admin" : this.sessionType == "202" ? "Account Full User" : this.sessionType == "203" ? "Account Base User" : this.sessionType == "231" ? "Accounting Admin User" : this.sessionType == "232" ? "Accounting Base User" : ""; 

    this.alrt = "2"
    this.counter$ = this.store.select(fromInbound.getCartItems);
    // this.data.getUsers("detail").subscribe(res => {
    //   if (res.data.length > 0) {
    //     this.userlist = res.data[0];
    //     this.username = this.userlist[0].user_name;
    //     this.san = this.userlist[0].san;
    //     this.email = this.userlist[0].email;
    //     this.profile_pic = this.userlist[0].profile_pic;
    //     this.kyc_verify_statu = this.userlist[0].kyc_verify_status;
    //     if (this.profile_pic == undefined) {
    //       this.profile_pic = './assets/img/profile.jpg';
    //     }
        
    //     const country = this.sessiondata.country || sessionStorage.getItem("country");
    //     const allowedCountries = ['US', 'CA', 'USA', 'United States', 'Canada', 'United States '];
    //     if (this.sessiondata.type === 2 && this.userlist[0].kyc_verify_status == 1) {
    //       this.HideUserNonUs = true;
    //       console.log("asdfsdfsdqeqw",this.userlist[0].kyc_verify_status);
    //     } else if (this.sessiondata.type === 2 && this.userlist[0].kyc_verify_status !== 0 &&!allowedCountries.includes(country)) {
    //       this.HideUserNonUs = false;
    //       console.log("asdfsdfsd",this.userlist[0].kyc_verify_status);
          
    //     } else {
    //       this.HideUserNonUs = true;
    //       // console.log("asdfsdfsdsdasd",this.userlist[0].kyc_verify_status);
    //     }
    //   }
    // }, error => {
    //   console.log(error.message);
    // });
    this.data.getUsers("detail").subscribe(res => {
      if (res.data.length > 0) {
        this.userlist = res.data[0];
        this.username = this.userlist[0].user_name;
        this.san = this.userlist[0].san;
        this.email = this.userlist[0].email;
        this.profile_pic = this.userlist[0].profile_pic;
        this.kyc_verify_statu = this.userlist[0].kyc_verify_status;
        this.newUserStatus = this.userlist[0].newUser_status;
        if (this.profile_pic == undefined) {
          this.profile_pic = './assets/img/profile.jpg';
        }
        const country = this.sessiondata.country || sessionStorage.getItem("country");
        const allowedCountries = ['US', 'CA', 'USA', 'United States', 'Canada', 'United States '];
        if (this.sessiondata.type == 2 && ((this.kyc_verify_statu == 1 && this.newUserStatus == 1) || this.newUserStatus == 0) ) {
          // New user with verified KYC or old user
          this.HideUserNonUs = true;
        } else if (this.sessiondata.type == 2 && this.kyc_verify_statu !== 1 &&  this.newUserStatus == 1 &&  !allowedCountries.includes(country)) {
          this.HideUserNonUs = false;
        } else {
          this.HideUserNonUs = true;
        }
      }
    }, error => {
      console.log(error.message);
    });
    this.NotificationCountForCustomer();
    /*Service for kyc response*/
    this.userSerive.getKycHeader().subscribe(res => {
      if (res.status == 200) {
        this.kycHeader = res.data;
        this.kycRes = res.data[0].kyc_verify_status;
        if (this.kycRes == 0) {
          this.kycRes = "Unverified"
        }
        if (this.kycRes == 1) {
          this.kycRes = "Verified"
        }
        if (this.kycRes == 2) {
          this.kycRes = "Verification Pending"
        }
      }
      //   else {
      //     this.errMessage = res.message;
      //     setTimeout(() => {
      //       this.errMessage = "";
      //     }, 5000);
      //   }
      // }, err => {
      //   this.errMessage = err.message;
      //   setTimeout(() => {
      //     this.errMessage = "";
      //   }, 5000);
    });

    this.billingService.getBillingAddress().subscribe(res => {
      if (res.status == 200) {
        this.billingAddress = res.data;
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });

    this.billingService.getBalance()
      .subscribe(response => {
        if (response.status = 200) {
          if (response.data.length > 0) {
            this.balance = response.data[0].balance;
            this.balanceData = response.data[0];
            if (!this.balance) {
              this.balance = 0;
            }

            // Low Balance Alert Grayout
            if (this.balance < this.balanceData.min_balance) {
              /*  this.isalert=true;  
               this.alrt = "1"  
               setTimeout(() => {
                 this.errrrMessage = "Your current balance is low!";
               }); */
            }

          }
          else {
            this.balance = 0;
          }
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });

    this.EmailNotificationCount()

    this.notifydata.email_notificationCount$.subscribe(notify => {
      this.Emailcount = notify.count;
      this.navigate = notify.data;
    });

    this.notifydata.notificationCount$.subscribe(notification => {
      this.notificationCount = notification.count;
      this.notificationList = notification.data;
    });


    /*  this.userManagement.getBalance().subscribe(response => {
       if (response.status == 200) {     
           this.min_balance = response.data[0].min_balance;
           this.current_balance = response.data[0].balance  
         if (this.current_balance < this.min_balance) {     
           setTimeout(() => {
             this.errrrMessage = "Your current balance is low!";
           });
         }  
       }
       
     }) */

  }
  NotificationCountForCustomer() {
    this.notifydata.NotificationCountForCustomer().subscribe((res) => {
      if (res.status == 200) {
        this.notificationList = res.data;
        this.notificationCount = this.notificationList.length;
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  navigateToSystemNotification(keys: any) {
    this.notifydata.UpdateViewNotificationStatus(keys).subscribe((res) => {
      if (res.status == 200) {
        this.NotificationCountForCustomer();
        this.router.navigate(['/system-notification'], {
          queryParams: {
            key: keys
          }
        });
        this.SystemNotification.notificationScrollIntoView();
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  makePayment() {
    let payLoad: any={
      type:'addbalance',
      balance: ''
    }

    const dialogRef = this.dialog.open(BalanceComponent, {
      data: { balance: this.balanceData, userProfile: this.userlist, address: this.billingAddress
        ,payLoad },
      disableClose: true
    });
    dialogRef.componentInstance.submitClicked.subscribe(result => {
      this.errMessage = result;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result.reload) {
        this.disabled = false;
        window.location.reload();
        this.responseMessage = result.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
      else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  UpdateCount(key: any, to: any, view_status: any) {
    let payLoad: any = JSON.stringify({
      key: key,
      email: to,
      view: view_status
    });
    this.notifydata.update_status(payLoad).subscribe((res) => {
      this.notifydata.NotificationCount().subscribe((res1) => {
        this.notifydata.updateCount(res1.data.length, res1.data);
      });
      if (res.status == 201) {
        const url = `/notification/${key}/${to}/${view_status}/${view_status}`;
        const url1 = `/notification/${key}/${to}/${view_status}`;
        const currentUrl = this.router.url;
        const slashesCount = currentUrl.split('/').length - 1;
        if (slashesCount === 4) {
          this.router.navigateByUrl(url);
        } else {
          this.router.navigateByUrl(url1);
        }
        this.responseMessage = '';
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });

  }

  EmailNotificationCount() {
    this.notifydata.getemail_notification().subscribe((res) => {
      if (res.status == 201) {
        this.Customernotify = res.data;
        let UnreadEmail = this.Customernotify.filter(notification => notification.view_status === 0);
        this.navigate = this.Customernotify
        this.Emailcount = UnreadEmail.length;
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

  importantNotice() {
    const dialogRef = this.dialog.open(ImportantNoticeComponent, {
      data: {},
      disableClose: true
    });
  }

  onClickAlr() {
    this.alrt = "2"
  }
  onLogout() {
    this.authService.logout();
  }
  showToast() {
    this.isActive = true;
    setTimeout(() => {
      this.isActive = false;
    }, 5000);
  }

  closeToast() {
    this.isActive = false;
  }
  ngOnDestroy() {
    this.leftsetting = false;
  }
  truncatenotification(subject: string, maxLength: number): string {
    return subject.length > maxLength ? subject.substring(0, maxLength) + '..' : subject;
  }
}