
import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, Validators, FormControl } from '@angular/forms';
import { ShortcodesmsService } from '../shortcodesms.service';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
declare var $: any;
@Component({
  selector: 'app-create-profile',
  templateUrl: './create-profile.component.html',
  styleUrls: ['./create-profile.component.css']
})
export class CreateProfileComponent implements OnInit {
  @ViewChild('createmodal') createmodal: ElementRef;
  @ViewChild('modalImageAppeal') modalImageAppeal: ElementRef;
  @ViewChild('modalPdfAppeal') modalPdfAppeal: ElementRef;
  @ViewChild('modalVideoForFile') modalVideoForFile: ElementRef;
  @ViewChild('closeModal') closeModal: ElementRef;
  @ViewChild('closeModal1') closeModal1: ElementRef;
  // @ViewChild('reject') reject: ElementRef;
  responseMessage: any = "";
  errMessage: any = "";
  public ShortCodeForm: FormGroup;
  public ContentForm: FormGroup;
  submitted: boolean = false;
  Contentsubmitted: boolean = false;
  selectedFile: File[] = [];
  files: any = [];
  previousfiles: any = [];
  ContentData: any[];
  Messagetype: any;
  ContentType: any;
  SubscriptionType: any;
  checked: boolean = false;
  carriers: any[]
  //checkedCarriers: any = [];
  migratedData: any;
  Viewdata: any;
  sc_id: any;
  selected_id: string;
  cancel: boolean = false;
  Edit: boolean = false;
  item: any;
  // totalRate: number = 0;


  constructor(private fb: FormBuilder, public data: ShortcodesmsService, public router: Router, private route: ActivatedRoute,) { }

  ngOnInit(): void {
    this.ContentData = []
    this.ShortCodeForm = this.fb.group({
      // campaignInfo: ['', [Validators.required, Validators.pattern(/^\s*[a-zA-Z0-9]+(\s+[a-zA-Z0-9]+)*\s*$/)]],
      campaignInfo: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/m)]],
      migrated: ['0', [Validators.required, this.noDefaultValueValidator]],
      campaignview: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/m)]],
      optout: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/)]],
      optoutmt: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/)]],
      helpmt: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/)]],
      email: ['', [Validators.required, Validators.pattern('^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,10}$')]],
      weburl: ['', [Validators.required, Validators.pattern('^(http(s)?://)?[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}(/\\S*)?$')]],
      phone: ['', [Validators.required, Validators.pattern('^[0-9]{10}$')]],
      tcurl: ['', [Validators.required, Validators.pattern('^(http(s)?://)?[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}(/\\S*)?$')]],
      tctxt: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/)]],
      contact: ['', [Validators.required, Validators.pattern("^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,10}(,\\s*[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,10})*$")]],
      comemail: ['', [Validators.required, Validators.pattern("^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,10}(,\\s*[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,10})*$")]],
      notes: ['', [Validators.pattern(/^\s*\S.*$/m)]]
    });

    this.ContentForm = this.fb.group({
      message_type: ['', [Validators.required, this.noDefaultValueValidator]],
      content_type: ['', [Validators.required, this.noDefaultValueValidator]],
      subscription_type: ['', [Validators.required, this.noDefaultValueValidator]],
      call_to_action: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/)]],
      opt_in_message: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/)]],
      example_message: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/)]],
      addcheck: [this.checked],

    });

    this.route.paramMap.subscribe((params: ParamMap) => {
      if (params.get('id_profile')) {
        this.sc_id = params.get('id_profile');
        this.ViewData();
      }
      if (params.get('selected_id')) {
        this.selected_id = params.get('selected_id');
        this.ViewData();
      }
    });

    this.data.migratedData().subscribe(result => {
      // this.carriers = result[1]
      if (result.status == 200) {
        this.migratedData = result.data;
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    })
    // this.data.getCarrier().subscribe(result => {
    //   this.carriers = result.data
    // })

    this.getmessageType()
    this.getContentType()
    this.getSubscriptionType()

    $('#basic-datatables7').dataTable().fnClearTable();
    $('#basic-datatables7').dataTable().fnDraw();
    $('#basic-datatables7').dataTable().fnDestroy();

    $('#basic-datatables').dataTable().fnClearTable();
    $('#basic-datatables').dataTable().fnDraw();
    $('#basic-datatables').dataTable().fnDestroy();
    $.getScript('./assets/tollfree.js');
  }

  getmessageType() {
    this.data.getMessage().subscribe((res) => {
      if (res.status == 201) {
        this.Messagetype = res.data;
        this.responseMessage = '';
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

  getContentType() {
    this.data.getcontent().subscribe((res) => {
      if (res.status == 201) {
        this.ContentType = res.data;
        this.responseMessage = '';
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

  getSubscriptionType() {
    this.data.getSubscription().subscribe((res) => {
      if (res.status == 201) {
        this.SubscriptionType = res.data;
        this.responseMessage = '';
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

  onFileChange(event: Event) {
    const fileInput = event.target as HTMLInputElement;
    if (fileInput.files && fileInput.files.length > 0) {
      const file: File = fileInput.files[0];
      const fileSize = file.size;
      const maxSizePerFile = 10 * 1024 * 1024;
      if (fileSize > maxSizePerFile) {
        this.errMessage = "Individual file size limit exceeded";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
        fileInput.value = '';
        return;
      }
      const totalFileSize = this.selectedFile.reduce((total, selectedFile) => total + selectedFile.size, 0);
      const maxTotalSize = 50 * 1024 * 1024;
      if (totalFileSize + fileSize > maxTotalSize) {
        this.errMessage = "Total files size limit exceeded";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
        fileInput.value = '';
        return;
      }
      // const allowedTypes = ["video/quicktime","application/vnd.ms-powerpoint","application/vnd.visio","image/jpeg","image/gif",'image/gif; version="87a"','image/gif; version="89a"','application/x-zip-compressed',"application/zip","application/vnd.ms-excel","text/csv", "image/png","application/msword","application/vnd.oasis.opendocument.text","application/pdf",'application/vnd.openxmlformats-officedocument.wordprocessingml.document'];

      const allowedTypes = ["video/quicktime", "application/vnd.ms-powerpoint", "application/vnd.visio", "text/plain", "application/rtf", "image/tiff", "image/jpg", "image/jpeg", "image/gif", "application/zip", "application/x-zip-compressed", "application/vnd.ms-excel", "text/csv", "image/png", "application/msword", "application/vnd.oasis.opendocument.text", "application/pdf", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.wordprocessingml.document"];
      if (!allowedTypes.includes(file.type)) {
        this.errMessage = "Invalid file type. Allowed types are: .mov,.ppt,.visio,.txt,.rtf,.tif,.jpg,.jpeg,.gif,.zip,.excel,.csv,.png,.doc,.odt,.pdf,.docx";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
        fileInput.value = '';
        return;
      }
      const reader = new FileReader();
      reader.readAsDataURL(file);
      if (this.sc_id) {
        this.selectedFile.push(file);
        this.files.push(file);
      } else {
        this.selectedFile.push(file);
        this.files.push(file);
      }
      fileInput.value = '';
    }
  }

  // handleCheckboxChange(event: any, carrier: any) {
  //   if (event.target.checked) {
  //     this.checkedCarriers.push(carrier);
  //     this.totalRate += carrier.rate; 
  //   } else {
  //     const index = this.checkedCarriers.findIndex((c: any) => c.display_name === carrier.display_name);
  //     if (index !== -1) {
  //       this.checkedCarriers.splice(index, 1);
  //       this.totalRate -= carrier.rate; 
  //     }
  //   }

  // }


  DeletRow(itemtoremove: any) {
    this.ContentData = this.ContentData.filter(item => item !== itemtoremove);
    $('#basic-datatables').dataTable().fnDraw();
    $('#basic-datatables').dataTable().fnDestroy();
    $.getScript('./assets/tollfree.js');
  }

  EditRow(itemtoedit: any) {
    this.cancel = false
    this.Edit = true
    this.item = itemtoedit
    this.ContentForm.patchValue({
      message_type: itemtoedit.message_type,
      content_type: itemtoedit.content_type,
      subscription_type: itemtoedit.subscription_type,
      call_to_action: itemtoedit.call_to_action,
      opt_in_message: itemtoedit.opt_in_message,
      example_message: itemtoedit.example_message,
    })
    this.ContentData = this.ContentData.filter(item => item !== itemtoedit);
    $('#basic-datatables').dataTable().fnDraw();
    $('#basic-datatables').dataTable().fnDestroy();
    $.getScript('./assets/tollfree.js');
  }

  cancel1() {
    this.cancel = true
    this.Contentsubmitted = false
    this.ContentForm.reset()
    this.ContentForm.get('subscription_type').setValue('0')
    this.ContentForm.get('content_type').setValue('0')
    this.ContentForm.get('message_type').setValue('0')
    this.ContentData.push(this.item)
    $('#basic-datatables').dataTable().fnDraw();
    $('#basic-datatables').dataTable().fnDestroy();
    $.getScript('./assets/tollfree.js');
    setTimeout(() => {
      this.closeModal1.nativeElement.click();
    }, 200);
    this.Edit = false

  }

  onSubmit() {
    this.submitted = true;
    if (this.ShortCodeForm.invalid || (!this.selectedFile || this.selectedFile.length === 0 || null) && (!this.files || this.files.length === 0 || null) || (this.ContentData.length === 0)) {
      return false;
    }
    else {
      let payLoad: any = JSON.stringify({
        //Carrier: this.checkedCarriers,
        Content: this.ContentData,
        previosFile: this.previousfiles,
        data: this.ShortCodeForm.value

      });
      this.data.submitShortcode(payLoad, this.selectedFile).subscribe((res) => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          const compModal = document.getElementById('createmodal');
          $(compModal).modal({ backdrop: 'static', keyboard: false });
          $(compModal).modal('show');
          setTimeout(() => {
            this.responseMessage = '';
            // this.router.navigateByUrl('/shortcode-campaign')
            this.onReset();
          }, 3000);
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 3000);
        }
      });
    }
  }

  noDefaultValueValidator(control) {
    return control.value === '0' || control.value === '' ? { default: true } : null;
  }

  ContentSubmit() {
    this.Contentsubmitted = true;
    if (this.ContentForm.invalid) {
      return false;
    }
    else {
      this.ContentData.push(this.ContentForm.value)
      if (this.ContentForm.value.addcheck === true) {
        this.Contentsubmitted = false
        this.ContentForm.reset()
        this.ContentForm.get('subscription_type').setValue('0')
        this.ContentForm.get('content_type').setValue('0')
        this.ContentForm.get('message_type').setValue('0')
      } else {
        this.Cancel()
      }
      $('#basic-datatables').dataTable().fnDraw();
      $('#basic-datatables').dataTable().fnDestroy();
      $.getScript('./assets/tollfree.js');

    }

  }

  onReset() {
    this.submitted = false
    this.ShortCodeForm.reset()
    this.selectedFile = []
    this.files = []
    this.previousfiles = []
    this.ContentData = []
    $('#basic-datatables').dataTable().fnDraw();
    $('#basic-datatables').dataTable().fnDestroy();
    $.getScript('./assets/tollfree.js');
    const checkboxes = document.querySelectorAll('input[type="checkbox"]');
    checkboxes.forEach((checkbox: HTMLInputElement) => {
      checkbox.checked = false;
    });
    //this.checkedCarriers = []
    this.ShortCodeForm.get('migrated').setValue('0');
    //this.totalRate = 0;
  }

  Cancel() {
    this.item = ''
    this.Edit = false
    this.cancel = false
    this.Contentsubmitted = false
    this.ContentForm.reset()
    this.ContentForm.get('subscription_type').setValue('0')
    this.ContentForm.get('content_type').setValue('0')
    this.ContentForm.get('message_type').setValue('0')
    this.closeModal.nativeElement.click();
  }

  closeIcon() {
    if (this.item.length != 0) {
      this.ContentData.push(this.item)
      $('#basic-datatables').dataTable().fnDraw();
      $('#basic-datatables').dataTable().fnDestroy();
      $.getScript('./assets/tollfree.js');
    } else {
      this.Contentsubmitted = false
      this.ContentForm.reset()
      this.closeModal.nativeElement.click();
      this.ContentForm.get('subscription_type').setValue('0')
      this.ContentForm.get('content_type').setValue('0')
      this.ContentForm.get('message_type').setValue('0')
    }
  }

  ViewData() {
    this.data.ViewSCdata(this.sc_id || this.selected_id).subscribe((res) => {
      if (res.status == 201) {
        this.Viewdata = res.data[0]
        this.ContentData = res.data1
        $('#basic-datatables').dataTable().fnDraw();
        $('#basic-datatables').dataTable().fnDestroy();
        $.getScript('./assets/tollfree.js');
        this.files = []
        this.previousfiles = []
        const modifiedDataArray = res.data2.map(item => {
          const { filename, ...rest } = item;
          return { name: filename, ...rest };
        });
        // const modifiedData = res.data4.map(item => {
        //   const { sc_carrier_coverage, ...rest } = item;
        //   return { display_name: sc_carrier_coverage, ...rest };
        // });
        //this.checkedCarriers = modifiedData
        // this.totalRate = this.checkedCarriers.reduce((total, carrier) => total + carrier.rate, 0);       
        this.previousfiles = this.previousfiles.concat(modifiedDataArray);
        this.files = this.files.concat(modifiedDataArray);
        this.ShortCodeForm.patchValue({
          campaignInfo: this.Viewdata.campaign_name,
          migrated: this.Viewdata.migrated_campaign,
          campaignview: this.Viewdata.campaign_overview,
          optout: this.Viewdata.opt_out_keyword,
          optoutmt: this.Viewdata.opt_out_mt,
          helpmt: this.Viewdata.help_mt,
          email: this.Viewdata.email,
          weburl: this.Viewdata.web_url,
          phone: this.Viewdata.phone_number,
          tcurl: this.Viewdata['t&c_web_url'],
          tctxt: this.Viewdata['t&c_text'],
          contact: this.Viewdata.contacts,
          comemail: this.Viewdata.compliance_poc_email,
          notes: this.Viewdata.notes
        })
        this.responseMessage = ''
        setTimeout(() => {
          this.responseMessage = ""
        }, 5000);
      } else {
        this.errMessage = res.message
        setTimeout(() => {
          this.errMessage = ''
        }, 5000);
      }
    });
  }


  // isChecked(carrierName: string): boolean {
  //   return this.checkedCarriers.some(carrier => carrier.display_name === carrierName);
  // }
  UpdateSC() {
    {
      this.submitted = true;
      if (this.ShortCodeForm.invalid || this.files.length === 0 || null || (this.ContentData.length === 0)) {
        return false;
      }
      else {
        let payLoad: any = JSON.stringify({
          id: this.sc_id,
          data: this.ShortCodeForm.value,
          previosFile: this.previousfiles,
          //Carrier: this.checkedCarriers,
          Content: this.ContentData,
        })

        this.data.UpdateCamapaign(payLoad, this.selectedFile).subscribe((res) => {
          if (res.status == 201) {
            this.responseMessage = res.message
            setTimeout(() => {
              this.responseMessage = '';
              this.router.navigateByUrl('/shortcode-campaign')
            }, 3000);
          } else {
            this.errMessage = res.message
            setTimeout(() => {
              this.errMessage = ''
            }, 3000);

          }
        })
      }
    }
  }


  downloadFile(file: File) {
    if (file) {
      const a = document.createElement('a');
      a.href = URL.createObjectURL(file);
      a.download = file.name;
      a.click();
    }
  }

  viewFile(data: File) {
    const pdfModal = document.getElementById('modalPdfAppeal');
    const imageModal = document.getElementById('modalImageAppeal');
    const docxModal = document.getElementById('modalDocxAppeal');
    const modalImage = document.getElementById('modalImage') as HTMLImageElement;
    const modalImage123 = document.getElementById('modalPdf') as HTMLIFrameElement;
    const videoModal = document.getElementById('modalVideoForFile');
    const videoModal12 = document.getElementById('videoModal') as HTMLVideoElement;
    if (data.type.startsWith('image/')) {
      const imageData = data;
      modalImage.src = URL.createObjectURL(imageData);
      // Open the modal for images
      $(imageModal).modal('show');
    } else if (data.type === 'application/pdf') {
      const pdfData = data
      modalImage123.src = URL.createObjectURL(pdfData);
      // Open the modal for non-image files
      $(pdfModal).modal('show');
    } else if (data.type.startsWith('video/')) {
      const videoData = data;
      videoModal12.src = URL.createObjectURL(videoData);
      // Open Modal for Video
      $(videoModal).modal('show');
      $(videoModal).on('hidden.bs.modal', function () {
        videoModal12.pause();
      });
    }
    else {
      if (data) {
        const a = document.createElement('a');
        a.href = URL.createObjectURL(data);
        a.download = data.name;
        a.click();
        $(docxModal).modal('show');
      }
    }
  }

  viewFile1(data: any) {
    const fileExtension = data.file_path.split('.').pop();

    const pdfModal = document.getElementById('modalPdfAppeal');
    const imageModal = document.getElementById('modalImageAppeal');
    const videoModal = document.getElementById('modalVideoForFile');
    const modalImage = document.getElementById('modalImage') as HTMLImageElement;
    const modalImage123 = document.getElementById('modalPdf') as HTMLIFrameElement;
    const videoModal12 = document.getElementById('videoModal') as HTMLVideoElement;
    if (fileExtension === "png" || fileExtension === "jpg" || fileExtension === "jpeg" || fileExtension === "gif") {
      modalImage.src = data.file_path
      // Open the modal for images
      $(imageModal).modal('show');
    } else if (fileExtension === 'pdf') {
      // const pdfData = data.file
      modalImage123.src = data.file_path
      // Open the modal for non-image file_paths
      $(pdfModal).modal('show');
    } else if (fileExtension === 'mov') {
      // const videoData = data.file;
      videoModal12.src = data.file_path
      // Open Modal for Video
      $(videoModal).modal('show');
      $(videoModal).on('hidden.bs.modal', function () {
        videoModal12.pause();
      });
    }
    else {
      if (data.file_path) {
        const a = document.createElement('a');
        a.href = data.file_path;
        a.download = data.name;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
      }
    }
  }

  removeFile(fileToRemove: File): void {
    this.selectedFile = this.selectedFile.filter(file => file !== fileToRemove);
    this.files = this.files.filter(file => file !== fileToRemove);
  }


  removeFile1(fileToRemove: File): void {
    this.selectedFile = this.selectedFile.filter(file => file !== fileToRemove);
    this.previousfiles = this.previousfiles.filter(file => file !== fileToRemove);
    this.previousfiles = this.previousfiles
    this.files = this.files.filter(file => file !== fileToRemove);
  }

  downloadFile1(data: any) {
    if (data.file_path) {
      const a = document.createElement('a');
      a.href = data.file_path;
      a.download = data.name;
      a.click();
    }
  }

  handledownload(file: any): void {
    if (file.file_path && file.name) {
      this.downloadFile1(file);
    } else {
      this.downloadFile(file);
    }
  }

  handleClick(file: any): void {
    if (file.file_path && file.name) {
      this.viewFile1(file);
    } else {
      this.viewFile(file);
    }
  }

  // ValidateModal(){
  //   this.submitted = true;
  //   if (this.ShortCodeForm.invalid || (!this.selectedFile || this.selectedFile.length === 0 || null) && (!this.files || this.files.length === 0 || null) || (this.checkedCarriers.length === 0) || (this.ContentData.length === 0)) {
  //     return false;
  //   }else{
  //     const Modal = document.getElementById('reject');
  //     $(Modal).modal('show');    }

  // }

  toggleDescription(item, property) {
    item[property] = !item[property];
  }


  ModalOPen() {
    const modal = document.getElementById('createmodal');
    if (modal) {
      $(modal).modal('hide');
      $('.modal-backdrop').remove();
    }
    this.router.navigateByUrl('/create-profile')
  }


  ngOnDestroy() {
    this.modalVideoForFile.nativeElement.click();
    this.modalPdfAppeal.nativeElement.click();
    this.modalImageAppeal.nativeElement.click();
    this.createmodal.nativeElement.click();
    //this.reject.nativeElement.click();
    if (this.cancel) {
      this.closeModal1.nativeElement.click();
    }
    if (!this.cancel)
      this.closeModal.nativeElement.click();
  }



}
