import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, Validators, FormControl } from '@angular/forms';
import { ShortcodesmsService } from '../shortcodesms.service';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
declare var $: any;

@Component({
  selector: 'app-shortcode-number',
  templateUrl: './shortcode-number.component.html',
  styleUrls: ['./shortcode-number.component.css']
})
export class ShortcodeNumberComponent implements OnInit {
  @ViewChild('connectionmodal') connectionmodal: ElementRef;
  userType: any;
  show_filter: boolean = false;
  public filterForm: FormGroup;
  submitted: boolean = false;
  userfilter: any;
  datafilter0: void;
  datafilter1: any;
  datafilter2: any;
  datafilter3: any;
  datafilter4: any;
  datafilter5: any;
  datafilter6: any;
  datafilter7: any;
  datafilter8: any;
  sc_number: any[];
  scNewRec: any[];
  EXCEL_TYPE = 'application/csv';
  EXCEL_EXTENSION = '.csv';

  responseMessage: any = '';
  errMessage: any = '';
  allconnection: any;
  filteredShortcode: any = [];
  did: string = "";
  connectionValue = "";
  inboundValue = "";
  outboundValue = "";
  iddid: any;
  dids: any = [];
  disButton: any;
  tab1Value = "";
  tab2Value = "";
  tab3Value = "";
  conn_key: any;
  AllKeyData: any;
  connectionList: any[] = [];
  iselectAll: boolean;
  selectedDIDCount: any;
  selectedDid: any = [];
  campaign = "";
  dropdownSetting: IDropdownSettings = {};
  closeDropdownSelection = true;

  constructor(private fb: FormBuilder, public data: ShortcodesmsService,) { }

  ngOnInit() {
    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;

    this.data.get_shortcodetype().subscribe((result) => {
      this.userfilter = result[4].Shortcodenumber;
      this.datafilter0 = this.userfilter.numbfilter1
      this.datafilter1 = this.userfilter.numbfilter2
      this.datafilter2 = this.userfilter.numbfilter3
      this.datafilter3 = this.userfilter.numbfilter4
      this.datafilter4 = this.userfilter.numbfilter5
      this.datafilter5 = this.userfilter.numbfilter6
      this.datafilter6 = this.userfilter.numbfilter7
      this.datafilter7 = this.userfilter.numbfilter9
    });

    this.filterForm = this.fb.group({
      from_date: [''],
      to_date: [''],
      batchid: [''],
      sc_request_id: [''],
      shortcode_number: [''],
      shortcode_type: [''],
      sc_campaign_unique_id: [''],
      san: ['']
    })

    $('#basic-datatables2').dataTable().fnClearTable();
    $('#basic-datatables2').dataTable().fnDraw();
    $('#basic-datatables2').dataTable().fnDestroy();

    $('#basic-datatablesscN').dataTable().fnClearTable();
    $('#basic-datatablesscN').dataTable().fnDraw();
    $('#basic-datatablesscN').dataTable().fnDestroy();
    $.getScript('./assets/tollfree.js');
    this.get_sc_number();

    // this.dropdownSetting = {
    // 	singleSelection: true,
    // 	idField: 'conne',   
    // 	textField: 'connectionList',  
    // 	itemsShowLimit: 1,
    // 	allowSearchFilter: true,
    // 	closeDropDownOnSelection: true
    //   };

  }


  get_sc_number() {
    this.data.allConnection().subscribe((res) => {
      this.allconnection = res.data;
      this.data.sc_number_list().subscribe(result => {
        if (result.status == 200) {
          this.scNewRec = result.data;
          this.scNewRec.forEach(item => {
            const matchingConnection = this.allconnection.find(conn => conn.connection_key === item.connection);
            if (matchingConnection) {
              item.name = matchingConnection.name;
            }
          });
          $('#basic-datatablesscN').dataTable().fnClearTable();
          $('#basic-datatablesscN').dataTable().fnDraw();
          $('#basic-datatablesscN').dataTable().fnDestroy();

          $('#basic-datatables2').dataTable().fnClearTable();
          $('#basic-datatables2').dataTable().fnDraw();
          $('#basic-datatables2').dataTable().fnDestroy();
          $.getScript('./assets/tollfree.js');
        }
        else {
          this.errMessage = result.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    });
  }

  showfilter() {
    if (this.show_filter == false) {
      this.show_filter = true;
    }
    else {
      this.show_filter = false;
    }
  }

  /* applyFilter(t) {
    if(t==1){
      this.submitted = true;
      const formValues = this.filterForm.value;
      const allFieldsEmpty = Object.values(formValues).every(value => value === '' || value === null);
      if (allFieldsEmpty) {
        this.errMessage = 'Please fill in at least one field to apply the filter.';
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
        return;
      }
    }
        
    this.data.filterForShortcodeNumber(this.filterForm.value).subscribe((filteredRes) => {
      if (filteredRes.status == 200) {
        this.scNewRec = filteredRes.data;
        this.scNewRec.forEach(item => {
          const matchingConnection = this.allconnection.find(conn => conn.connection_key === item.connection);
          if (matchingConnection) {
            item.name = matchingConnection.name;
          }
        });
        $('#basic-datatablesscN').dataTable().fnClearTable();
        $('#basic-datatablesscN').dataTable().fnDraw();
        $('#basic-datatablesscN').dataTable().fnDestroy();

        $('#basic-datatables2').dataTable().fnClearTable();
        $('#basic-datatables2').dataTable().fnDraw();
        $('#basic-datatables2').dataTable().fnDestroy();
        $.getScript('./assets/tollfree.js');
        this.responseMessage = filteredRes.message;
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000)
      }
      else {
        this.errMessage = filteredRes.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    })    
  } */
    
    applyFilter() {
      this.submitted = true;
      if (this.filterForm.invalid) {
        return
      }
      else {
        this.data.filterForShortcodeNumber(this.filterForm.value).subscribe((filteredRes) => {
          if (filteredRes.status == 200) {
            this.scNewRec = filteredRes.data;
            this.scNewRec.forEach(item => {
              const matchingConnection = this.allconnection.find(conn => conn.connection_key === item.connection);
              if (matchingConnection) {
                item.name = matchingConnection.name;
              }
            });
            $('#basic-datatables4').dataTable().fnClearTable();
            $('#basic-datatables4').dataTable().fnDraw();
            $('#basic-datatables4').dataTable().fnDestroy();
  
            $('#basic-datatables2').dataTable().fnClearTable();
            $('#basic-datatables2').dataTable().fnDraw();
            $('#basic-datatables2').dataTable().fnDestroy();
            $.getScript('./assets/tollfree.js');
            this.responseMessage = filteredRes.message;
            setTimeout(() => {
              this.responseMessage = '';
            }, 5000)
          }
          else {
            this.errMessage = filteredRes.message;
            setTimeout(() => {
              this.errMessage = '';
            }, 5000);
          }
        })
      }
    }
  downloadCSVFile() {
    this.submitted = true;
    if (this.filterForm.invalid) {
      return
    }
    else {
      this.applyFilter();
      setTimeout(() => {
        if (this.scNewRec.length > 0) {
          this.scNewRec.forEach(item => {
            const matchingConnection = this.allconnection.find(conn => conn.connection_key === item.connection);
            if (matchingConnection) {
              item.name = matchingConnection.name;
            }
          });
          let NewFilteredRes = this.scNewRec.map(item => {
            if (this.userType == 1) {
              const { name, batch_id_unique, idaccount, customer_name, sc_type, sc_campaign_unique_id, sc_request_id, shortcode_number, process_approved_date } = item;
              const SC_Campaign_Id = sc_campaign_unique_id;
              const SC_Request_Id = sc_request_id;
              const short_code_num = shortcode_number;
              const shortcode_type = sc_type === '2' ? "Customer Provided Migrated Shortcode" : sc_type === '0' ? "New Random Shortcode" : sc_type === '1' ? "New Vanity Shortcode" : sc_type === '3' ? "Customer Provided New Shortcode" : "";
              const customerName = customer_name;
              const SAN = 100000000 + Number(idaccount);
              const Batch_id = batch_id_unique;
              // const Status = status == 6 ? 'SMS fully provisioned' : 'Shortcode number approved & SMS service pending';
              const formattedDate = new Date(process_approved_date).toLocaleDateString('en-US', { month: '2-digit', day: '2-digit', year: 'numeric' }).split(/[-\/]/).join(process_approved_date.includes('-') ? '-' : '/');
              return { SAN, 'Customer Name': customerName, 'Batch ID': Batch_id, 'SC Campaign ID': SC_Campaign_Id, 'SC Request ID': SC_Request_Id, 'Shortcode': short_code_num, Date: formattedDate, 'SC Type': shortcode_type, 'Connection': name };
            }
            else if (this.userType != 1) { // userType == 2 || userType == 201 || userType == 202 || userType == 203"
              const { name, sc_type, sc_campaign_unique_id, sc_request_id, shortcode_number, process_approved_date } = item;
              const SC_Campaign_Id = sc_campaign_unique_id;
              const SC_Request_Id = sc_request_id;
              const short_code_num = shortcode_number;
              const shortcode_type = sc_type === '2' ? "Customer Provided Migrated Shortcode" : sc_type === '0' ? "New Random Shortcode" : sc_type === '1' ? "New Vanity Shortcode" : sc_type === '3' ? "Customer Provided New Shortcode" : "";
              // const Status = status == 6 ? 'SMS fully provisioned' : 'Shortcode number approved & SMS service pending';
              const formattedDate = new Date(process_approved_date).toLocaleDateString('en-US', { month: '2-digit', day: '2-digit', year: 'numeric' }).split(/[-\/]/).join(process_approved_date.includes('-') ? '-' : '/');
              return { 'SC Campaign ID': SC_Campaign_Id, 'SC Request ID': SC_Request_Id, 'Shortcode': short_code_num, Date: formattedDate, 'SC Type': shortcode_type, "Connection": name };
            }
          }, 2000);
            const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(NewFilteredRes);
            const workbook: XLSX.WorkBook = { Sheets: { 'Shortcode Number': worksheet }, SheetNames: ['Shortcode Number'] };
            const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
            this.saveAsExcelFile(excelBuffer, "Shortcode Number");
        } 
        else {
          this.errMessage = 'No Record Available!';
          setTimeout(() => {
            this.errMessage = '';
          }, 2000);
        }
      }, 4000);
    }
  }

  private saveAsExcelFile(buffer: any, fileName: string): void {
    const data: Blob = new Blob([buffer], {
      type: this.EXCEL_TYPE
    });
    saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
  }
  onReset() {
    this.submitted = false
    this.filterForm.reset();
    this.filterForm.get('shortcode_type').setValue('');
    this.get_sc_number();
  }

  toggleDescription(data, property) {
    data[property] = !data[property];
  }

  tabSetting(data: any) {
    if (data != "data") {
      this.did = "";
      this.connectionValue = "";
      this.inboundValue = "";
      this.outboundValue = "";
      this.iddid = data.iddid;
      let did = this.scNewRec.find(el => el.did == data.shortcode_number);
      this.did = data.shortcode_number;
      this.connectionValue = data.connection;
    }
    this.getconnectionkey(data.idaccount);
  }

  getconnectionkey(id: any) {
    this.data.getConnectionkey(id).subscribe(response => {
      if (response.status == 200) {
        if (response.data.length > 0) {
          this.connectionList = response.data;
          // this.connectionList = response.data.map(item => ({
          // 	conne: item.idendpoint,
          // 	connectionList: `${item.name}`
          //   }));	
        }
      }
      else {
        this.errMessage = response.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = "Something went wrong with get Connection!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  onConnectionKeyNew(e) {
    this.conn_key = e.target.value;
    this.disButton = '';
    this.data.onGetAllKeyByConnKey(this.conn_key).subscribe(res => {
      if (res.status == 200) {
        this.AllKeyData = res.data[0];
        this.inboundValue = this.AllKeyData.inbound_key;
        this.outboundValue = this.AllKeyData.outbound_key;
        this.connectionValue = this.AllKeyData.connection_key;
        this.disButton = 'true';

      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
        this.disButton = '';
      }

    }, err => {
      this.responseMessage = "Something went wrong with Connection Key!";
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });

  }

  onUpdateConnection() {
    let updateDID: any = {};
    updateDID = {
      iddid: this.iddid, connection_key: this.connectionValue, did: this.did,
      inboundKey: this.inboundValue, outboundKey: this.outboundValue, campaign: this.campaign
    };
    this.data.updateDID(updateDID).subscribe(res => {

      if (res.status == 201) {
        this.iselectAll = false;
        this.selectedDIDCount = '';
        this.selectedDid = [];
        this.responseMessage = res.message;
        window.location.reload();
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, error => {
      this.responseMessage = "Something went wrong with update connection!";
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  reload() {
    this.tab1Value = "";
    this.tab2Value = "";
    this.tab3Value = "";
  }

  reset() {
    this.connectionValue = '';
  }

  messageshow() {
    const fromDate = this.filterForm.get('from_date').value;
    const toDate = this.filterForm.get('to_date').value;
    const currentDate = new Date();
    if ((!fromDate && !toDate)) {
    } else if ((fromDate == null || !fromDate) && (toDate != null)) {
      this.filterForm.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
    } else if ((fromDate != null) && (toDate == null || !toDate)) {
      this.filterForm.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
    } else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
      this.filterForm.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
      return;
    } else if (toDate && new Date(toDate) > currentDate) {
      this.filterForm.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
      return;
    } else if (fromDate && new Date(fromDate) > currentDate) {
      this.filterForm.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
      return;
    } else {
      this.filterForm.get('from_date').setErrors(null);
      this.filterForm.get('to_date').setErrors(null);
    }
  }

  truncatenotification(subject: string, maxLength: number): string {
    if (subject && subject.length > maxLength) {
      return subject.substring(0, maxLength) + '...';
    } else {
      return subject;
    }
  }
  ngOnDestroy() {
    this.connectionmodal.nativeElement.click();
  }
}
