import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { SubscriptionService } from '../subscription.service';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { BillingService } from 'src/app/billing/billing.service';
declare var $: any;
@Component({
  selector: 'app-subscription-control',
  templateUrl: './subscription-control.component.html',
  styleUrls: ['./subscription-control.component.css']
})
export class SubscriptionControlComponent implements OnInit {
   @ViewChild('deletesubscription') deletesubscription: ElementRef;
  id1:any;
  tableheader: any;
  show_filter: boolean;
  dropdownSettings: IDropdownSettings = {};
  dropdownSettingsname: IDropdownSettings = {};
  closeDropdownSelection = true;
  mappingForm: FormGroup
  userdata: any = [];
  reloaduserlist: any = [];
  subscriptiondata: any = [];
  selectedname: any
  selectedsa: any
  submitted: boolean = false;
  subscription: any;
  errMessage: any;
  responseMessage: any ='';
  selectedItem: any = [];
  SUBSC: any = [];
  Subdata: any = [];
  selectedItems: any = [];
  id: string;
  getdata: any = [];
  sanid:any;
  subid:any;
  userbalance:any
  act_sub_id:any
  subsid:any
  quantity1:any
  quantity2:any;
  defquantity:any;
  changedquantity:any;
  userdata1:any=[];

  saveButton:string='Save';

  constructor(public data: SubscriptionService, public usermanagmentservice: UsermanagementService, public billingService:BillingService,public fb: FormBuilder) { }

  ngOnInit(): void {
    // ------------------table header--------------
    this.data.get_Subscription().subscribe((res) => {
      this.tableheader = res[1].SubscriptionControl
    })

    // ---------------------------san no list---------------------
    this.usermanagmentservice.getUsers("main").subscribe((res) => {
      this.userdata1= res.data[0]
      this.userdata = res.data[0]
      this.userdata = res.data[0].filter(item => item.is_deleted === 0).sort((a, b) => new Date(a.created).getTime() - new Date(b.created).getTime()).map(item => ({
        iduser: item.idaccount,
        san: `${item.san}`
      }));
    })

    this.mappingForm = this.fb.group({
      san: ['', [Validators.required]],
      name: ['', [Validators.required]],
      quantity: ['', [Validators.required, Validators.pattern(/^\d+$/),Validators.maxLength(7)]]
    })

    this.data.get_Subscriptiondata().subscribe((res)=>{
       this.getdata = res.data.map((item) => ({
        subscription:  `${item.subscription_id}-${item.quantity}-${item.type}-${item.mrc}-${item.proration}`,
        name: item.name || "Unknown"
      }));
      this.SUBSC = res.data.map(item => ({
        ...item,
        subscription_quantity: item.subscription_quantity == null || item.subscription_quantity === '' ?item.quantity
         : item.subscription_quantity
      }));
      this.Subdata = this.SUBSC.slice().reverse();
      
    })

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'iduser',
      textField: 'san', 
      selectAllText: 'Select All',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };
    this.dropdownSettingsname = {
      singleSelection: true,
      idField: 'subscription',
      textField: 'name',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };
    this.get_subscription()
  }

  // ---------get list --------------------
  get_subscription() {
    this.data.get_Subscriptionlist().subscribe((res) => {
      if (res.status == 200) {
        this.subscription = res.data
        $('#basic-datatablessub').DataTable().clear();
        $('#basic-datatablessub').DataTable().destroy();
        $.getScript('./assets/tollfree.js');
        this.subscriptiondata = res.data
      }
      else {
        this.errMessage = res.message
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    });
  }

  editsub(san: any, name: any, acct_sub_id: any, account_quantity: any, idaccount: any,  subscription_id: any) {
    this.defquantity=account_quantity
    this.saveButton='Update'
  

    this.id = idaccount;
    this.act_sub_id=acct_sub_id;
    this.subsid=subscription_id;
    this.data.get_Subscriptiondata().subscribe((res) => {
      const filteredData = res.data.filter(item => 
        item.subscription_id==subscription_id
      );
      const subscription = filteredData.length > 0 
      ? `${filteredData[0].subscription_id}-${filteredData[0].quantity}-${filteredData[0].type}-${filteredData[0].mrc}-${filteredData[0].proration}`
      : "Unknown";
      this.selectedItem = [{ name: name, subscription: subscription }];
      this.selectedItems = [{ san: san, iduser: idaccount }];

      this.mappingForm.patchValue({
        quantity: account_quantity,
        san: this.selectedItems,
      });
    });
  }
  onChangesubscription(event: any) {
    let subscriptionid = Number(event.subscription.split("-")[0]);
    this.sanid = Number(this.sanid);
    this.subid=subscriptionid
    let quantity = event.subscription.split("-")[1];
    this.quantity1=quantity
    let selecteditem1 = this.subscriptiondata.filter((item) =>  
      item.subscription_id == subscriptionid &&  item.idaccount == this.sanid
    );
    if (selecteditem1.length > 0) {
       this.id=this.sanid
      this.mappingForm.patchValue({
        quantity: selecteditem1[0].account_quantity, 
      });
      this.defquantity=selecteditem1[0].account_quantity
      this.act_sub_id=selecteditem1[0].act_sub_id
      this.saveButton='Update'
    } else {
      this.defquantity=quantity
      this.saveButton='Save'
      this.mappingForm.patchValue({
        quantity: quantity,
      });
      this.id=''
    }
  }
  onChange(event: any) {
    this.sanid = Number(event.iduser)
    let subscriptionid = Number(this.subid);
    if(subscriptionid) {
        let selecteditem1 = this.subscriptiondata.filter((item) =>  
            item.subscription_id == subscriptionid && item.idaccount == this.sanid
        );
        if (selecteditem1.length > 0) {
            this.saveButton = 'Update'
            this.id = this.sanid
            this.mappingForm.patchValue({
                quantity: selecteditem1[0].account_quantity,
            });
            this.act_sub_id = selecteditem1[0].act_sub_id
            this.defquantity=selecteditem1[0].account_quantity
        }
        this.saveButton = 'Save'
        this.defquantity=this.quantity1
        this.mappingForm.patchValue({
            quantity: this.quantity1,
        });
         this.id = ''
    }
    this.saveButton = 'Save'
    this.mappingForm.patchValue({
        quantity: this.quantity1,
    });
    this.id = ''
}
onChangesan(event:any){
  this.sanid=''
  this.saveButton='Save'
  this.mappingForm.patchValue({
    quantity: this.quantity1,
  });

}

  quantity(){
    if (this.mappingForm.invalid) {
      this.submitted = true;
      return;
    }else{
      if(this.defquantity<this.mappingForm.value.quantity){
        $('#deletesubscription').modal('show');
      }else{
        this.onsubmit()
      }
    }
   
  }


  // QuantityChange(event){
  //   if (this.id != "" && this.id != null) {
  //     this.actualQuantity = Number(event.target.value) - Number(this.Mapedquantity);
  //   }else{
  //     this.actualQuantity = Number(event.target.value) 
  //   }  
  // }

  cancelModal() {
    $('#deletesubscription').modal('hide'); 
  }

  
  onsubmit(){
    if (this.mappingForm.invalid) {
      this.submitted = true;
      return;
    } else {
      let filteredUsers = this.userdata1.filter((item) => 
        item.idaccount == this.mappingForm.value.san[0]?.iduser
    );
    console.log(filteredUsers)
        const formValues = this.mappingForm.value; 
        const subscription = formValues.name[0].subscription;  
        const [subscription_id, quantity, type, mrc,proration] = subscription.split('-').map(Number);  
        let payload={
          act_sub_id:this.act_sub_id,
          idaccount:this.mappingForm.value.san[0].iduser,
          subscription_id: this.mappingForm.value.name[0].subscription.split('-')[0],
          subscription_quantity:this.mappingForm.value.quantity,
          mrc: mrc,
          type:type,
          proration:proration,
          iduser:filteredUsers[0].iduser
        }
        if (this.id != "" && this.id != null) {
          this.data.UpdateSubscriptionmap(JSON.stringify(payload)).subscribe((res) => {
            if (res.status == 200) {
              this.get_subscription()
              this.resetForm()
              this.mappingForm.reset();
              $('#deletesubscription').modal('hide');
              this.responseMessage = res.message;
              setTimeout(() => {
                  this.responseMessage = ""; 
                  this.responseMessage = res.message1; 
                  setTimeout(() => {
                      this.responseMessage = ""; 
                  }, 3000);
              }, 3000);
            } else {
              this.errMessage = res.message
              setTimeout(() => {
                this.errMessage = ""
              }, 5000);
            }
          })
        }else{
          this.data.savesubscriptioncontrol(JSON.stringify(payload)).subscribe((res) => {
            if (res.status == 200) {
              this.responseMessage = res.message
              this.id = '';
              this.resetForm()
              $('#deletesubscription').modal('hide');
              this.get_subscription()
              this.submitted = false
              setTimeout(() => {
                this.responseMessage = ""
              }, 3000);
            } else {
              this.responseMessage = res.message
              setTimeout(() => {
                this.responseMessage = ""
              }, 3000);
            }
          })
        }
        this.subid='';
        this.quantity1=''
        this.id = '';
      }

      











     

  }

 
  // payment() { 
  //   const formValues = this.mappingForm.value; 
  //   const subscription = formValues.name[0].subscription;  
  //   const [subscription_id, quantity, type, mrc] = subscription.split('-').map(Number);  
  //   const amount = this.actualQuantity * mrc;
  //   const payload = {
  //     amount: amount,
  //     type: 'subscharge',
  //     idaccount: formValues.san[0].iduser,
  //   };
  //   this.billingService.paysubscription(JSON.stringify(payload)).subscribe((res) => {
  //     if (res.status == 200) {
  //       this.get_subscription()

  //       this.actualQuantity='';
  //       this.subid='';
  //       this.quantity1=''

  //       this.responseMessage = res.message;
  //       setTimeout(() => {
  //         this.responseMessage = "";
  //       }, 3000);
  //     } else {
  //       this.get_subscription()
  //       this.errMessage = res.message;
  //       setTimeout(() => {
  //         this.errMessage = "";
  //       }, 5000);
  //     }
  //   });
  //   setTimeout(() => {
  //     this.errMessage = "";
  //     this.responseMessage="";
  //   }, 5000);
  // }
  
 
  resetForm() {
    this.id='';
    this.submitted = false
    this.mappingForm.reset();
    this.selectedItem = 0
    this.selectedItem = [];
    this.saveButton='Save';
    this.subid='';
    this.quantity1=''
    this.sanid=''
  }

  ngOnDestroy() {
    this.deletesubscription.nativeElement.click();
  }

}
