import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import {SubscriptionService} from '../subscription.service'
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
declare var $: any;


@Component({
  selector: 'app-subscription-management',
  templateUrl: './subscription-management.component.html',
  styleUrls: ['./subscription-management.component.css']
})
export class SubscriptionManagementComponent implements OnInit {
  @ViewChild('dataModal')dataModal : ElementRef;
  @ViewChild('deletesubscription') deletesubscription: ElementRef;
  show_filter: boolean = false;
  tableheader: any;
  addSubscription: FormGroup;
  filterForm: FormGroup
  submitted: boolean = false;
  subscription: any = [];
  errMessage: any;
  responseMessage: any ='';
  id: any;
  idsd: any;
  savesubs :any = 'Save';
  modeltext: string = 'Create Subscription';
  showModal = false;
  types: any[] = [];
  subsfilter: any;
  isMonthlySelected: any=[];
  subscriptionconnection: any=[];
  sublen: any=0;
  sublanname:any;
  tspairsubscription:any=[];
  // sublanname:any;
  tspairdropdown: IDropdownSettings = {};
  closeDropdownSelection = true;
  tsselect:any=[];

  constructor(public fb: FormBuilder, private data: SubscriptionService, ) { }
 
  ngOnInit(): void {
    this.data.get_Subscription().subscribe((res)=>{
      this.tableheader = res[0].SubscriptionManagement;
      this.types = res[2].types;
      })

      this.data.gettsPair().subscribe((res)=>{
        this.tspairsubscription = res.data.map((item) => ({
         tspairservice:  `${item.ts_id}-${item.ts_transaction}-${item.ts_service}`,
         name: item.ts_description 
       }));
      })

    this.filterForm = this.fb.group({
      names:[''],
      rates:[''],
      typeselect:[''],
      quantitys:['',[Validators.pattern(/^\d+$/)]]
    })


    this.addSubscription = this.fb.group({
      name: ['', [Validators.required, Validators.pattern(/^(?!\s+$).+/), Validators.maxLength(251)]],
      billingfrequency: [1],
      rate: ['', [Validators.required, Validators.pattern('^\\d*(\\.\\d{1,2})?$'),Validators.maxLength(7)]],
      tspair: ['',[ Validators.required]],
      type: ['', [Validators.required]],
      quantity: ['', [Validators.required, Validators.pattern(/^(?!0$)\d+$/), Validators.maxLength(7)]],
      proration: [false],
      description: ['', [Validators.required,Validators.pattern(/^(?!\s+$).+/), Validators.minLength(10),Validators.maxLength(1024)]],
    });
    this.getsubscription()

    this.tspairdropdown = {
      singleSelection: true,
      idField: 'tspairservice',
      textField: 'name',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };
  }

  // onTypeChange(selectedType: string){
  //   this.isMonthlySelected = selectedType
  // }
  onTypeChange(selectedType: string) {
    this.isMonthlySelected = selectedType;
  
    const billingfrequencyControl = this.addSubscription.get('billingfrequency');
    if (selectedType === '1') {
      billingfrequencyControl?.setValidators([Validators.required]);
      billingfrequencyControl?.setValue('1'); // Automatically set value to 1
    } else {
      // Clear validators and reset value if selectedType isn't '1'
      billingfrequencyControl?.clearValidators();
      billingfrequencyControl?.reset();
    }
  
    billingfrequencyControl?.updateValueAndValidity(); // Re-evaluate validity
  }
  
  
 
// -----------filter section---------------

showfilter() {
  if (this.show_filter == false) {
    this.show_filter = true;
  }
  else {
    this.show_filter = false;
  }
}

  submitfilter(){
    this.submitted = false;
    if(this.filterForm.invalid){
      return;
    }else{
      this.data.applyFilter(this.filterForm.value).subscribe((res)=> {
       if(res.status == 201){
        this.subscription = [];
        $('#basic-datatabless2').DataTable().clear();
        $('#basic-datatabless2').DataTable().destroy();
        $.getScript('./assets/table.js');
        this.subscription = res.data;
        // this.filterForm.reset();
       } else{
        this.errMessage = res.message;
        setTimeout(()=>{
          this.errMessage = '';
        }, 5000);
       }
      
      })
    }
  }
  resetfilter(){
    this.submitted = false;
    this.getsubscription();
    this.filterForm.reset();
    // this.filterForm.get('typeselect').setValue('')
    this.filterForm.patchValue({ typeselect: '' });
  }

  // ---------get list --------------------

  getsubscription(){
    this.data.get_Subscriptiondata().subscribe((res) => {
      if (res.status == 200) {
        $('#basic-datatabless2').DataTable().clear();
        $('#basic-datatabless2').DataTable().destroy();
        $.getScript('./assets/table.js');
        this.subscription = res.data
        // console.log("dsfsdfdsfdsfds get",  this.subscription);
      }
      else{
        this.errMessage = res.message
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    });
  }

  // -------------add & Edit form section -----------------------
 

  showdata(data: any) {
    this.id=data.subscription_id;
    let tsname=data.ts_description
    if (data.subscription_id) {
        this.modeltext = 'Edit Subscription';
        this.savesubs = 'Update';
        this.isMonthlySelected= data.type
        this.data.get_Subscriptiondata().subscribe((res) => {
          const filteredData = res.data.filter(item => item.subscription_id == this.id);
          const tsinfo = filteredData.length > 0 
            ? `${filteredData[0].ts_id}-${filteredData[0].ts_transaction}-${filteredData[0].ts_service}`
            : "Unknown";
          this.tsselect = [{ name: tsname, tspairservice: tsinfo }];
          this.addSubscription.patchValue({
            tspair: this.tsselect,
          });
        });
        this.addSubscription.patchValue({
            name: data.name,
            description: data.description,
            billingfrequency: data.billing_frequency,
            rate: data.mrc,
            tspair: data.ts_service,
            type: data.type,
            quantity: data.quantity,
            proration: data.proration,
        });
        if (data.type === '1') {
          this.onTypeChange('1');  
        }
  
    } else {
        this.modeltext = 'Create Subscription';
        this.savesubs = 'Save';
        this.addSubscription.reset();
    }
    
  }

cancelModal() {
  this.idsd='';
  this.sublen = null;
  this.sublanname = null;
  $('#deletesubscription').modal('hide'); // Hide modal properly
}


closeModal() {
this.id=''
  this.showModal = false; 
  this.submitted = false;
  this.addSubscription.reset();
  this.modeltext = 'Create Subscription';
  this.savesubs = 'Submit';
  if (this.addSubscription.get('type')) {
    this.addSubscription.get('type').setValue('');
}
if (this.addSubscription.get('billingfrequency')) {
    this.addSubscription.get('billingfrequency').setValue('1');
}
this.isMonthlySelected = '';
}

onsubmit() {
  if (this.addSubscription.invalid) {
    this.submitted = true;
    this.showModal = false;
    return;
  }
  else {
    const formValues = this.addSubscription.value; 

    const tspairsubscription = formValues?.tspair?.[0]?.tspairservice; 

    const [tsid, tstransaction, tsservice] = tspairsubscription.split('-').map(Number);

    const payload = {
      ...this.addSubscription.value,
      proration: this.addSubscription.get('proration').value === true ? 1 : 0,
      ts_id: tsid,
      ts_transaction: tstransaction,
      ts_service: tsservice

    };

    if (this.id && this.id !== null ) {
      this.data.editSubscription(payload,this.id).subscribe(res => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          this.dataModal.nativeElement.click();
          this.addSubscription.reset();
          this.addSubscription.get('type').setValue('')
          this.addSubscription.get('tspair').setValue('')
          this.addSubscription.get('billingfrequency').setValue('0')
          this.isMonthlySelected = '';
          this.id=''
          setTimeout(() => {
            this.responseMessage = "";
            this.getsubscription();
          }, 3000);
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 3000);
        }
      })
    }
    else {
      this.data.save_Subscription(payload).subscribe(res => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          this.dataModal.nativeElement.click();
          this.addSubscription.reset();
          this.addSubscription.get('type').setValue('')
          this.addSubscription.get('tspair').setValue('')
          this.addSubscription.get('billingfrequency').setValue('0')
          this.id=''
          setTimeout(() => {
            this.responseMessage = "";
            this.getsubscription();
          }, 3000);
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 3000);
        }
      })
    }
  }
}

  getSubscriptionconnection(subscription_id:any,name:any) {
    this.data.getSubscriptionconnection(subscription_id).subscribe(res => {
        if (res.status === 200) {
            this.subscriptionconnection = res.data
            this.sublanname=name
            this.sublen = this.subscriptionconnection.length;
        }
    });
}
  
  resetForm() {
    this.isMonthlySelected = '';
    this.addSubscription.reset();
    this.submitted = false;
    this.addSubscription.get('type').setValue('')
    this.addSubscription.get('billingfrequency').setValue('')
    this.tsselect=[];
  }

  // ----------------Delete section -------------------
  deletedata(data:any){
    this.idsd = data.subscription_id
  }

  Deletesub(){
    this.data.deleteSubscription(this.idsd).subscribe(res => {
      if (res.status == 200) {
        this.idsd='';
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
          this.ngOnInit()
          this.deletesubscription.nativeElement.click();
        }, 5000);
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000)
    })

  }
  
  ngOnDestroy() {
    this.dataModal.nativeElement.click();
    this.deletesubscription.nativeElement.click();
  }
}
