import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { SubscriptionManagementComponent } from './subscription-management/subscription-management.component';
import { title } from 'node:process';
import { SubscriptionControlComponent } from './subscription-control/subscription-control.component';


const routes: Routes = [
  {
    path:'',
    component:SubscriptionManagementComponent,
    data: {
      title: 'Dashboard',
      urls: [
          {
              title: 'Dashboard',
              url: '/dashboards/dashboard'
          },
          {
              title: 'Dashboard'
          }
      ]
  }
  },
  {
    path:'subscription-management',
    component: SubscriptionManagementComponent,
    data: {
      title: 'Subscription',
      urls:[
       {
        title:'Subscription'
       },
       {
        title:'Subscription Management'
       }
      ]
    }
  },
  {
    path:'subscription-control',
    component: SubscriptionControlComponent,
    data: {
      title: 'Subscription',
      urls:[
       {
        title:'Subscription'
       },
       {
        title:'Subscription Control'
       }
      ]
    }
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class SubscriptionRoutingModule { }
